package lu.tudor.santec.gecamed.patient.utils;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: EntryDeletedException.java,v $
 */

public class EntryDeletedException extends Exception
{
	private static final long	serialVersionUID	= 1L;
	
	private IncidentEntry entry;
	
	public EntryDeletedException (IncidentEntry deletedEntry)
	{
		super("IncidentEntry with ID "+deletedEntry.getId()+" could not be found in the DB.");
		this.entry = deletedEntry;
	}
	
	
	public IncidentEntry getEntry ()
	{
		return entry;
	}
}
