package lu.tudor.santec.gecamed.patient.utils;

import java.io.Serializable;
import java.util.Date;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;


public class CertificateData implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private Date 		accidentDate;
	
	private String 		accidentNo;
	
	private Date 		certificateDate;
	
	private Incident 	incident;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public CertificateData() {}

	public CertificateData(Date date, Incident incident)
	{
		this.certificateDate 	= date;
		this.incident 			= incident;
		this.accidentNo 		= incident.getAccidentNr();
		this.accidentDate 		= incident.getAccidentDate();
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public Date getAccidentDate()
	{
		return accidentDate;
	}
	
	
	public void setAccidentDate(Date accidentDate)
	{
		this.accidentDate = accidentDate;
	}
	
	
	public String getAccidentNo()
	{
		return accidentNo;
	}
	
	
	public void setAccidentNo(String accidentNo)
	{
		this.accidentNo = accidentNo;
	}
	
	
	public Date getCertificateDate()
	{
		return certificateDate;
	}
	
	
	public void setCertificateDate(Date certificateDate)
	{
		this.certificateDate = certificateDate;
	}

	public Incident getIncident()
	{
		return incident;
	}

	public void setIncident(Incident incident)
	{
		this.incident = incident;
	}
}
