
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym) 	values ( 0,E'-'      	,E'None','false','true','true','false',1.0,'-');

insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 1,E'CNAMO'  	,E'Caisse Nationale d''Assurance Maladie des Ouvriers','true','true','false','false',1.0,'CNAM');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 2,E'CMFEP'  	,E'Caisse de Maladie des Fonctionnaires et Employés Publics','true','true','true','false',1.0,'CMFEP');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 3,E'CMFEC'  	,E'Caisse de Maladie des Fonctionnaires et Employés Communaux','true','true','true','false',1.0,'CMFEC');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 4,E'CMEP'   	,E'Caisse de Maladie des Employés Privés','true','true','false','false',1.0,'CMEP');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 5,E'CMPI'   	,E'Caisse de Maladie des Professions Indépendantes','true','true','false','false',1.0,'CMPI');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 6,E'CMOA'   	,E'Caisse de Maladie des Ouvriers de l''Arbed','true','true','false','false',1.0,'CMOA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 7,E'CMEA'   	,E'Caisse de Maladie des Employés de l''Arbed','true','true','false','false',1.0,'CMEA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 8,E'CMA'    	,E'Caisse de maladie agricole','true','true','false','false',1.0,'CMA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values ( 9,E'EM-CFL' 	,E'Entraide Médicale des CFL','true','true','true','false',1.0,'EMCFL');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (10,E'MAMMO'  	,E'Dépistage Mammo','true','true','true','false',1.0,'MAMMO');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (11,E'ARMEE'  	,E'Armée Luxembourgeoise','true','true','false','false',1.0,'ARMEE');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (12,E'GUERRE' 	,E'Dommage de Guerre','true','false','true','false',1.0,'DG');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (13,E'SIST-EHL'  ,E'Service Inter-Entreprise de Santé au travail','true','false', 'true','false',1.0,'SIST EHL');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (14,E'CNS'       ,E'Caisse National de Santé','true','true','true','false',1.0,'CNS');

insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (20,E'RCAM'   ,E'Régime Commun d''Assurance Maladie des Communautés Européenes','false','true','false','true',1.15,'RCAM');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (21,E'BEI'    ,E'Banque Européenne d''Investissement','false','true','false','true',1.15,'BEI');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (22,E'EUCTRL' ,E'Eurocontrol','false','true','false','true',1.66,'EUROCONTROL');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (23,E'NAMSA'  ,E'Agence OTAN d''Entretien et d''Approvis','false','true','false','true',1.66,'VAN BREDA-NAMSA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (24,E'BREDA'  ,E'Van Breda','false','true','false','true',1.15,'BREDA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (25,E'PRIV'   ,E'Privé ou Particulier','false','true','false','true',1.0,'PARTIC');

insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (30,E'POLICE' ,E'Direction de la Police','false','false','true','false',1.0,'POLICE');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (31,E'PARQUET',E'Parquet Tribunal','false','false','true','false',1.0,'PT');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (32,E'EPL'    ,E'Etablissement Pénitentiaire Luxembourgeois','false','false','true','false',1.0,'EPI');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (33,E'CGE'    ,E'Commission du Gouvernement aux Etrangers','false','false','true','false',1.0,'COGOET');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (34,E'STA'    ,E'Santé au Travail Arcelor','false','false','true','false',1.0,'STA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (35,E'SMA'    ,E'Service Médical Arcelor','false','false','true','false',1.0,'SMA');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (36,E'MEPS'   ,E'Ministère de l''Education Physique et des Sports','false','false','true','false',1.0,'MEPS');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (37,E'SANTE'  ,E'Santé Publique','false','false','true','false',1.0,'SANTE');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (38,E'STM'    ,E'Service de Santé au Travail Multisectoriel','false','false','true','false',1.0,'STM');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (39,E'STI'    ,E'Service de Santé au Travail de l''Industrie','false','false','true','false',1.0,'STI');

UPDATE patient.insurance
SET disbanded = TRUE
WHERE acronym IN ('CNAMO', 'CMEP', 'CMPI', 'CMOA', 'CMEA', 'CMA', 'UCM');

--- insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (40,E'MT-CFL' ,E'Médecin du Travail CFL','true','false','false','false',1.0,'MTCFL');
--- insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (41,E'CAS'    ,E'Conseil Arbitral des Assurances Sociales','true','false','false','false',1.0,'CAS');

insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (50,E'UCM'    ,E'Union des Caisses de Maladie','false','false','true','false',1.0,'UCM');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (51,E'AAA'    ,E'Association Assurance Accidents','true','true','true','false',1.0,'AAI');
insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (52,E'E111'   ,E'E111','false','true','false','false',1.0,'E111');

insert into patient.insurance (id,acronym,name,ucm_affiliated,is_primary,is_third_party,is_private,majoration,hl7_acronym)  values (100,E'CMCM'  ,E'Caisse Medico Chirurgicale Mutualiste','false','false','false','true',1.0,'CMCM');

INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (101, 'ASTF', 'ASTF', E'A.S.T.F. - HOPITAL KIRCHBERG', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (102, 'ADMAERO', 'ADMAERO', E'ADMINISTRATION DE L''AEROPORT', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (103, 'ADMDESBIENS', 'ADMDESBIENS', E'ADMINISTRATION DES BIENS DU GRAND-DUC', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (104, 'LAR', 'LAR', E'Luxembourg Air Rescue', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (105, 'ALLIANZ', 'ALLIANZ', E'ALLIANZ', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (106, 'AMELIFE', 'AMELIFE', E'AME LIFE LUXEMBOURG S.A.', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (107, 'AXA', 'AXA', E'AXA ASSURANCES', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (108, 'AXAVIE', 'AXAVIE', E'AXA ASSURANCES VIE LUXEMBOURG', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (109, 'BALOISE', 'BALOISE', E'BALOISE ASSURANCES', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (110, 'CAEAVIATION', 'CAEAVIATION', E'CAE AVIATION', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (111, 'CARGOLUX', 'CARGOLUX', E'CARGOLUX', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (112, 'CNS-AAGR', 'CNS-AAGR', E'CNS - ACCIDENT AGRICOLE', true, true, false, false, 1, true);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (113, 'CNS-AAIN', 'CNS-AAIN', E'CNS - ACCIDENT DE TRAVAIL', true, true, false, false, 1, true);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (114, 'CONSARBITRAL', 'CONSARBITRAL', E'CONSEIL ARBITRAL', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (115, 'DKVLUX', 'DKVLUX', E'D.K.V.', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (116, 'DKV', 'DKV', E'DKV KOELN AG', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (117, 'FORTIS', 'FORTIS', E'FORTIS ASSURANCES LUXEMBOURG', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (118, 'FOYERSANTE', 'FOYERSANTE', E'FOYER SANTE S.A.', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (119, 'LUXAIR', 'LUXAIR', E'LUXAIR', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (120, 'LUXAVIATION', 'LUXAVIATION', E'LUXAVIATION', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (121, 'OLAI', 'OLAI', E'OFFICE LUXEMBOURGEOIS DE L''ACCUEIL ET DE L''INTEGRATION', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (122, 'PARLEMENT', 'PARLEMENT', E'PARLEMENT EUROPEEN', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (123, 'RAIFFEISEN', 'RAIFFEISEN', E'RAIFFEISEN VIE', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (124, 'VIVIUM', 'VIVIUM', E'VIVIUM ASSURANCES', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (125, 'VLM', 'VLM', E'VLM AIRLINES', false, true, false, true, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (126, E'MISAN' ,E'MISAN' ,E'Ministère de Santé', true, false, true, false, 1, false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (127, E'MIJUS',E'MIJUS', E'Ministère de la Justice',true,false,true,false,1.0,false);
INSERT INTO patient.insurance (id, acronym, hl7_acronym, name, ucm_affiliated, is_primary, is_third_party, is_private, majoration, disbanded) VALUES (128, E'CNS-Social',E'CNS-Social', E'CNS-Social',true,false,true,false,1.0,false);

select setval(E'patient.insurance_id_seq', 1000);

insert into patient.insurance_plan (name,insurance_id) values (E'-',0);
insert into patient.insurance_plan (name,insurance_id) values (E'NORMAL',100);
insert into patient.insurance_plan (name,insurance_id) values (E'PRESTAPLUS',100);
insert into patient.insurance_plan (name,insurance_id) values (E'DENTAPLUS',100);
insert into patient.insurance_plan (name,insurance_id) values (E'OPTIPLUS',100);

insert into patient.hospitalisation_class (acronym, name) values (E'A'  ,E'Ambulatory');
insert into patient.hospitalisation_class (acronym, name) values (E'1'  ,E'First Class');
insert into patient.hospitalisation_class (acronym, name) values (E'2'  ,E'Second Class');
insert into patient.hospitalisation_class (acronym, name) values ('1C'	,'First Class [CNS]');
insert into patient.hospitalisation_class (acronym, name) values ('1P'	,'First Class [PRIV]');


--hospital_department
INSERT INTO patient.hospital_department (name) VALUES (E'Radiology');


--states
INSERT INTO patient.hospitalisation_status (name) VALUES (E'canceled');
INSERT INTO patient.hospitalisation_status (name) VALUES (E'running');
INSERT INTO patient.hospitalisation_status (name) VALUES (E'closed');

insert into usermanagement.permission (name, description) values (E'PatientModule.viewPatients',E'User is allowed to View Patient Data');
insert into usermanagement.permission (name, description) values (E'PatientModule.createPatients',E'User is allowed to create new Patients');
insert into usermanagement.permission (name, description) values (E'PatientModule.deletePatients',E'User is allowed to delete Patients');

insert into usermanagement.permission (name, description) values (E'PatientModule.editHospitalisations', E'User is allowed to edit all hospitalisations');

-- history
insert into usermanagement.permission (name, description) values (E'PatientModule.viewHistory',E'User is allowed to view the medical history of a patient');
insert into usermanagement.permission (name, description) values (E'PatientModule.editHistory',E'User is allowed to edit the medical history of a patient');
-- consultation
insert into usermanagement.permission (name, description) values (E'PatientModule.viewConsultation',E'User is allowed to view single consultations');
insert into usermanagement.permission (name, description) values (E'PatientModule.editConsultation',E'User is allowed to modify existing consultations');
insert into usermanagement.permission (name, description) values (E'PatientModule.createConsultation',E'User is allowed to create new consultations');
-- adminstrative
insert into usermanagement.permission (name, description) values (E'PatientModule.viewAdministrative',E'User is allowed to view the administrative data of a patient');
insert into usermanagement.permission (name, description) values (E'PatientModule.editAdministrative',E'User is allowed to edit adminstrative datas');
-- anamnesis -> obsolete in future releases
insert into usermanagement.permission (name, description) values (E'PatientModule.viewAnamnesis',E'User is allowed to view the anamnesis of patients');
insert into usermanagement.permission (name, description) values (E'PatientModule.editAnamnesis',E'User is allowed to edit the anamnesis data of patients');
-- memo
insert into usermanagement.permission (name, description) values (E'PatientModule.viewOwnMemos',E'User is allowed to view his own memos for a patient');
insert into usermanagement.permission (name, description) values (E'PatientModule.editOwnMemos',E'User is allowed to edit his own memos');
insert into usermanagement.permission (name, description) values (E'PatientModule.viewAllMemos',E'User is allowed to view all memos of a patient');
insert into usermanagement.permission (name, description) values (E'PatientModule.editAllMemos',E'User is allowed to edit all memos of a patient');
-- prescription
insert into usermanagement.permission (name, description) values (E'PatientModule.createPrescription',E'User is allowed to create prescriptions');



-- admin
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewPatients'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.createPatients'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.deletePatients'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editHospitalisations'));

insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewHistory'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editHistory'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewConsultation'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editConsultation'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.createConsultation'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewAdministrative'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editAdministrative'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewAnamnesis'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editAnamnesis'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewOwnMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editOwnMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.viewAllMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.editAllMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.admin'),(select id from usermanagement.permission where name='PatientModule.createPrescription'));


-- physician
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewPatients'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.createPatients'));

insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.editHospitalisations'));

insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewHistory'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.editHistory'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewConsultation'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.editConsultation'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.createConsultation'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewAdministrative'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.editAdministrative'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewAnamnesis'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.editAnamnesis'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewOwnMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.editOwnMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.viewAllMemos'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.physician'),(select id from usermanagement.permission where name='PatientModule.createPrescription'));


-- add new patient delete role
insert into usermanagement.role (name, description) values ('PatientModule.Patientadministrator','Users who are allowed to Delete Patients');
insert into usermanagement.rel_role_permission (role_id, permission_id) values (
	(select id from usermanagement.role where name='PatientModule.Patientadministrator'), 
	(select id from usermanagement.permission where name='PatientModule.deletePatients')
);



-- secretary
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.secretary'),(select id from usermanagement.permission where name='PatientModule.createPatients'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.secretary'),(select id from usermanagement.permission where name='PatientModule.viewAdministrative'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.secretary'),(select id from usermanagement.permission where name='PatientModule.editAdministrative'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.secretary'),(select id from usermanagement.permission where name='PatientModule.viewPatients'));
insert into usermanagement.rel_role_permission (role_id,permission_id) values ((select id from usermanagement.role where name='PatientModule.secretary'),(select id from usermanagement.permission where name='PatientModule.createPrescription'));



--measurement_types
INSERT INTO patient.measurement_types (id,name,alias,unit,numeric_type,is_default) VALUES (0 ,E'SYS',E'SYS',E'mmHg','true','true');
INSERT INTO patient.measurement_types (id,name,alias,unit,numeric_type,is_default) VALUES (1 ,E'DIA',E'DIA',E'mmHg','true','true');
INSERT INTO patient.measurement_types (id,name,alias,unit,numeric_type,is_default) VALUES (2 ,E'POULSE',E'POU',E'bpm','true','true');
INSERT INTO patient.measurement_types (id,name,alias,unit,numeric_type,is_default) VALUES (3 ,E'HEIGHT',E'HEI',E'm','true','true');
INSERT INTO patient.measurement_types (id,name,alias,unit,numeric_type,is_default) VALUES (4 ,E'WEIGHT',E'WEI',E'kg','true','true');
SELECT setval(E'patient.measurement_types_id_seq', (select id from patient.measurement_types order by id desc limit 1));


-- allergens


INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (14,2,E't 20',E'Privet, common',E'Rainweide;',E'Reaching a height up to 4 m, this is a mostly evergreen bush with opposite, entire and elliptic shiny leathery leaves; the remarkably fragrant small white flowers are arranged in upright panicles; bee pasture; entomogamous; flowering season : VI - VIII (late bloomer); fruit: black, poisonous berries;',E'Inhalative (June - August); only when there is direct contact to the plant;',E'Pollen, 30 - 45 µm;',E'Liguster, gewöhnlicher',E'Rainweide;',E'Bis 4 m hoher überwiegend immergrüner Strauch mit gegenständigen, ganzrandigen, elliptischen und glänzenden ledrigen Blättern; die stark duftenden kleinen weißen Blüten sind in aufrechten Rispen angeordnet; Bienenweide; entomogam; Blütezeit: VI - VIII (Spätblüher); Früchte: schwarze giftige Beeren;',E'Inhalativ (Juni - August);\nnur bei direktem Kontakt zur Pflanze',E'Pollen, 30 - 45 µm;',E'Ligustrum vulgare L.',E'Oleaceae',null,null,6,8,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (15,2,E't 901',E'Ash, common',null,E'Growing to 40 m high and up to approx. 200 years old, this sprouting pioneer tree has opposed pinnate leaves 9 – 13 in number; buds black; blossoms without calyx and crown leaves, inconspicuous; anemogamic; flowering time: IV - V (middle bloomer); winged fruits; fairly hard fine-grained wood; is used as utility, turning and furniture wood;',E'Inhalation (April - May);',E'Pollen of approx. 20 µm diameter;',E'Esche, gewöhnliche',null,E'Bis 40 m hoher und ca. 200 Jahre alt werdender ausschlagfähiger Pionierbaum mit gegenständigen 9 - 13-zählig gefiederten Blättern; Knospen schwarz; Blüten ohne Kelch- und Kronblätter, unscheinbar; anemogam; Blütezeit: IV - V (Mittelblüher); Früchte geflügelt; Holz feinfaserig und ziemlich hart; dient als Werk-, Drechsel- und Möbelholz;',E'Inhalativ (April - Mai);',E'Pollen von ca. 20 µm Durchmesser;',E'Fraxinus excelsior L.',E'Oleaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (16,2,E't 9',E'Olive tree',E'Ölbaum;',E'A 10 m to 16 m high and up to over 1000 years old tree with a stocky appearance and gnarled trunk, grain often twisted with age and cleft into bizarre stilts through a rotting processes; leaves opposite, longish, leathery and silver-grey underneath; flowers small, white, in panicles; anemogamous; flowering season: IV - VI (central bloomer); stone fruit (=olive), plume-like and very rich in oil;',E'Inhalative (April - June);',E'Pollen, approx. 15 x 25 µm;',E'Ölbaum (Olivenbaum)',E'Ölbaum;',E'Gedrungen wirkender 10 m bis 16 m hoch und über 1000 Jahre alt werdender Baum mit knorrigem, im Alter oft drehwüchsigem und durch Ausfaulen in skurrile Stelzen zerteiltem Stamm; Blätter gegenständig, länglich, ledrig und unterseits silbergrau; Blüten klein, weiß, in Rispen; anemogam; Blütezeit: IV - VI (Mittelblüher); Steinfrucht (=Olive), pflaumenähnlich und sehr ölhaltig;',E'Inhalativ (April - Juni);',E'Pollen, ca. 15 x 25 µm;',E'Olea europaea L.',E'Oleaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (17,2,E't 23',E'Cypress, Italian',E'Mittelmeerzypresse, Säulenzypresse, Trauerbaum;',E'Evergreen, up to 25 m high tree with branches spreading out (wild variety) or upward reaching, forming a dense, slim pyramid; small, scale-like leaves, and monoecious flowers; anemogamous; flowering season: II - IV (early bloomer); the seeds ripen in woody cones.',E'Inhalative;',E'Pollen, approx. 25 µm;',E'Zypresse',E'Mittelmeerzypresse, Säulenzypresse, Trauerbaum;',E'Immergrüner bis 25 m hoher mit seitlich ausgebreiteten (Wildform) oder hochstrebenden, eine dichte, schmale Pyramide formenden Ästen, kleinen schuppenförmigen Blättern, und einhäusigen Blüten; anemogam; Blütezeit: II - IV (Frühblüher); die Samen reifen in holzigen  Zapfen.',E'Inhalativ;',E'Pollen, ca. 25 µm;',E'Cupressus sempervirens L.',E'Cupressaceae',null,null,2,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (18,2,E't 6',E'Sabine',E'Spanish savin;',E'Low-growing cops with rising branches and scale-like leaves; height up to 2 m (6 m); twiggs smell unpleasant when crushed; poisonous; anemogamous; flowering season: IV - V (Central bloomer);  berries brown-black, hanging in cone-like clusters; used as medicinal plant and against vermin (farm gardens);',E'Inhalative (April - May);',E'Pollen;',E'Sadebaum',E'Stinkwacholder;',E'Niederliegendes Gehölz mit aufsteigenden Ästen und schuppenförmigen Blättern; Höhe bis 2 m (6 m); Zweige zerrieben unangenehm riechend; giftig; anemogam; Blütezeit: IV - V (Mittelblüher); Beerenzapfen braunschwarz, hängend; Verwendung als Heilpflanze und gegen Ungeziefer (Bauerngärten);',E'Inhalativ (April - Mai);',E'Pollen;',E'Juniperus sabina L.',E'Cupressaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (19,2,E't 70',E'Mulberry, white',E'silkworm mulberry',E'An up to12 m high tree or bush with many-shaped, oval, entire to serrated leaves and capitate inflorescence; anemogamous; flowering season : V (central bloomer); the maximum amount of pollen is released in the early moring; the nut fruits are surrounded by a fleshy yellowish-white (name) integument, form an alliance and so assume an appearance similar to that of the blackberry (mulberry);',E'Inhalative (May);',E'Pollen;',E'Maulbeerbaum, weißer',null,E'Bis 12 m hoher Baum oder Strauch mit vielgestaltigen, ovalen, ganzrandigen bis gezähnten Blättern und kopfig-ährigen Blütenständen; anemogam; Blütezeit: V (Mittelblüher); das Maximum der Pollenfreisetzung ist am frühen Morgren; die Nußfrüchte sind von fleischig werdenden gelblich-weißen (Name) Hüllblättern umgeben, bilden einen Verband und haben so ein brombeerartiges Aussehen (Maulbeere);',E'Inhalativ (Mai);',E'Pollen;',E'Morus alba L.',E'Moraceae',null,null,5,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (20,2,E't 906',E'Sweet mock orange',E'Großer Pfeifenstrauch;',E'A bush reaching a height of up to 3 m with egg-shaped to elliptical, serrated leaves;  4-5 white flowers, very fragrant and bunched in clusters of  1-10; entomogamous; flowering season: V - VI (central bloomer); frequent ornamental shrub;',E'Inhalative (May - June);',E'Pollen;',E'Jasmin, falscher',E'Großer Pfeifenstrauch;',E'Bis 3 m hoher Strauch mit eiförmig-elliptischen und gezähnten Blättern; Blüten weiß, 4-5-zählig, stark duftend und zu 1-10 Stück traubig angeordnet; entomogam; Blütezeit: V - VI (Mittelblüher); häufiges  Ziergehölz;',E'Inhalativ (Mai - Juni);',E'Pollen;',E'Philadelphus coronarius L.',E'Philadelphaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (21,2,E't 904',E'Pussywillow',E'goat willow, sallow;',E'Dioecious, 3 - 9 m high bush or tree; catkins appearing before the grey-green leaves, white tomentose on the under side; anemogamous and entomogamous; flowering season: III - IV (early bloomer); seeds very small and capable of flying by means of a tuft of hair;',E'Inhalative (March - April);',E'Pollen, approx. 15 x 30 µm;',E'Weide, Sal-',null,E'Zweihäusiger 3 - 9 m hoher Strauch oder Baum; Kätzchen vor den unterseits graugrünen bis weißfilzigen Blättern erscheinend; anemogam und entomogam; Blütezeit: III - IV (Frühblüher); Samen sehr klein und durch Haarschopf flugfähig;',E'Inhalativ (März - April);',E'Pollen, ca. 15 x 30 µm;',E'Salix caprea L.',E'Salicaceae',null,null,3,4,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (1,2,E'g 1',E'Vernal grass, scented',E'Goldgras, Lavendelgras, Gemeines Ruchgras,E',E'An up to 50 cm tall, unbranched spiked meadow grass; perennial; anemogamous; flowering season : V-VIII (central bloomer); poorness indicator; frequent, however rarely stand-forming; with a scent like sweet woodruff;',E'Inhalative (May - August);',E'Pollen, 24-40 µm;',E'Ruchgras, wohlriechendes',E'Goldgras, Lavendelgras, Gemeines Ruchgras,E',E'Bis 50 cm hohes unverzweigtes Ährenrispengras; mehrjährig; anemogam; Blütezeit: V-VIII (Mittelblüher); Magerkeitszeiger; häufig, jedoch nur selten bestandsbildend; nach Waldmeister duftend (Kumarin);',E'Inhalativ (Mai - August);',E'Pollen, 24-40 µm;',E'Anthoxantum odoratum L.',E'Poaceae',null,null,5,8,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (2,1,E'k 71',E'Castor bean',E'Castor bean, castor oil plant, [German: Christuspalme, Wunderbaum, Kreuzbaum];',E'The seeds are bean-sized, marbled reddish-brown, and extremely toxic due to the protein ricin. When extracting the castor oil from the bean, the ricin remains in the pomace. The seeds contain approx. 50% castor oil. This is colorless to light yellow and consists primarily of the glycerinester of ricinic acid, an unsaturated monohydroxycarboxylic acid.',E'Industrial processing of the seeds causes an inhalative exposition.',E'Proteins originating from the seeds; also traces contained in the oil;',E'Rizinusbohne',E'Castorbohne, Christuspalme, Wunderbaum, Kreuzbaum;',E'Die Samen sind bohnengroß, rötlich-bräunlich marmoriert und aufgrund des Proteins Rizin äußerst giftig. Bei der Ölgewinnung verbleibt dieses im Pressrückstand. Die Samen enthalten ca. 50% Rizinusöl. Dieses ist farblos bis leicht gelblich und besteht zum größten Teil aus dem Glycerinester der Rizinolsäure, einer ungesättigten Monohydroxycarbonsäure.',E'Durch die industrielle Verarbeitung der Samen besteht eine inhalative Exposition.',E'Aus den Samen stammende Proteine; in Spuren auch im Öl enthalten;',E'Ricinus communis L.',E'Euphorbiaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (3,6,E's 1',E'Aniseed',null,null,null,null,E'Anis',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (4,5,null,E'Small canine tapeworm',E'Fox tapeworm; bladder worm',E'Only 4-6 mm tapeworm consisting of one head with three to four segments. The final segment contains larva, enclosed in egg shells.',E'The eggs or larva enter humans via the excrement of the final hosts.',null,E'Kleiner Hundebandwurm',E'Fuchsbandwurm, Blasenwurm;',E'Nur 4-6mm langer Bandwurm, der nur aus einem Kopf mit drei bis vier Gliedern besteht. Das letzte Glied enthält die von Eischalen umgebenen Larven.',E'Die Eier bzw. Larven gelangen über den Kot der Endwirte in den Menschen.',null,E'Echinococcus granulosus Batsch',null,E'Cestodes, Bandwürmer;',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (5,4,E'f 10',E'Sesame',null,null,null,null,E'Sesam',null,null,null,null,null,null,null,10,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (6,7,E'c 209',E'Paracetamol/Phenacetin',E'Phenacetin, 4`-Hydroxyacetanilid;',null,null,null,E'Paracetamol/Phenacetin',E'Phenacetin, 4`-Hydroxyacetanilid;',null,null,null,null,null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (7,9,E'i 3',E'wasp',E'Vespula germanica and Vespula vulgaris;',E'Approx. 15 - 20 mm in length, multi-winged insects with contrasting black/yellow markings and a hairless body; the so-called wasp waist is between breast and abdomen; Occurs in three casts: workers, free flying, stinging, unfertile; males, free flying, non-stinging, fertile; queen, free flying only while founding a nest, stinging, fertile;',E'Sting, by which 2 - 10 µg protein can enter the body; while in the case of the honey bee, the stinger always remains in the victim, this is only seldom the case for the wasps sting, but it does occur for a certain percent of the cases.',E'Proteins of large molecular weight in the animal’s poison;',E'Wespe',E'Vespula germanica u. Vespula vulgaris;',E'Ca. 15 - 20 mm lange, vierflügelige Insekten mit kontrastreich schwarz-gelb gezeichnetem und unbehaartem Körper; zwischen Brust und Hinterleib befindet sich die sogenannte Wespentaille;\nAuftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, freifliegend nur bis zur Nestgründung, stechend, fruchtbar;',E'Stich, bei dem 2 - 10 µg Protein in den Körper gelangen; während bei der Biene der Stachel immer stecken bleibt, ist dies beim Wespenstich zwar seltener der Fall, kommt jedoch auch in einem gewissen Prozentsatz der Fälle vor.',E'Hochmolekulare Proteine im Gift der Tiere;',E'Paravespula germanica F. und P. vulgaris L.',E'Vespidae',E'Hymenoptera, Hautflügler',null,6,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (8,3,E'e 79 (Serum), e 78 (Federn), e 77 (Kot)',E'Parakeet (Melopsittacus undulatus)',null,E'Approx. 25 cm long bird originiating in Austrlia, with the typical curved parrot beak and climbing claws - two toes pointing forwards and two backwards. Since 1840 selective breeding has produced dozens of color and size variations from the yellow-headed, green-bellied and dark-backed curly wild form.',E'Feather and feces dust is inhaled.',E'Proteins from the feces and feathers. Since dust and fungi in these materials can distort the diagnosis, one attempts to detect specific antibodies over the purely representable serum proteins related to the structure of feathers and feces.',E'Wellensittich',null,E'Ca. 25 cm langer aus Australien stammender Vogel mit dem für Papageien typischen Krummschnabel und Kletterfuß - zwei Zehen nach vorne und zwei nach hinten gerichtet. Seit 1840 wurden aus der gelbköpfigen, bauchseitig grünen und oberseits dunkel gewellten (Name) Wildform dutzende Farb- und Größenvarianten gezüchtet.',E'Feder- und Kotstaub wird inhalativ aufgenommen.',E'Proteine aus Kot und Federn. Da Stäube und Pilze bei diesen Materialien die Diagnose verfälschen können, versucht man den Nachweis spezifischer Antikörper auch über die rein darstellbaren Serumproteine, die mit dem Aufbau der Federn und dem Kot in Bezug stehen.',E'Melopsittacus undulatus Shaw',E'Psittacidae',E'Psittaciformes, Papageienartige',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (9,8,E'm 5',E'Candida albicans (Robin) Berkhout',E'Syringospora albicans, Procandida grubyi, Candida claussenii Lodder & Kreger - v. Rij, Candida longeroni Doetr. Ex v. Uden & Buckley, Candida stellatoidea Langer & Guerra; Soor fungus;',E'White slime colonies; growth as sprouting single cells and hyphen species, in the transition to pseudo hyphen, blasto- and clamydo-spores ;',E'Almost exclusively by contact and by foodstuffs;',null,E'Candida albicans (Robin) Berkhout',E'Syringospora albicans, Procandida grubyi, Candida claussenii Lodder & Kreger - v. Rij, Candida langeroni Doetr. Ex v. Uden & Buckley, Candida stellatoidea Langer & Guerra; Soorpilz;',E'Weißliche, schleimige Kolonien; Wachstum als sprossende Einzelzellen und hyphenartig, im Übergang mit Pseudohyphen, Blasto- und Clamydosporen;',E'Fast ausschließlich durch Kontakt und über die Nahrung;',null,E'Candida albicans (Robin) Berkhout',E'Cryptococcaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (10,2,E't 28',E'Acacia, black',E'black locust, robinia;',E'Sparse, up to 25 m high tree with white flowers in hanging clusters; leaves odd-pinnated, somewhat resmbling those of the acacia (cf. name); outer bark rough and splitting open, net-like; bee pasture; entomogamous; flowering season: V - VI (Central bloomer); the fruit is a capsule which bursts open like a trap; the very firm, durable and load-bearing wood is employed for construction, furniture, and as commercial timber.',E'Inhalative (May - June); ingestive (mixed honeys and so-called acacia honey);',E'Pollen, 26-40 µm;',E'Robinie',E'Gewöhnliche Robinie, Scheinakazie;',E'Lichter bis 25 m hoher Baum mit weißen Blüten in hängenden Trauben; Blätter unpaarig gefiedert, denen der Akazie ähnelnd (vgl. den Namen); Borke grob und netzartig aufreißend;  Bienenweide; entomogam; Blütezeit: V - VI (Mittelblüher); die frucht ist eine klappig aufspringende Hülse; das sehr feste, dauerhafte und tragfähige Holz findet als Bau-, Werk- und Möbelholz Verwendung.',E'Inhalativ (Mai - Juni);\nIngestiv (Mischhonige u. sogenannter Akazienhonig);',E'Pollen, 26-40 µm;',E'Robinia pseudoacacia L.',E'Fabaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (11,2,E't 14',E'Poplar, white',null,E'A quickly growing, relatively slim dioecious tree, 30 m in height and up to 400 years years of age. Flowers inconspicuous in catkins, leaves alternate, sinuatedly lobed, with very  tomentose  undersides; trunk with a light whitish-grey bark; anemogamous; flowering season  III - IV (early bloomer); seeds with a bushel of hair distribution by wind, i.e. anemochory; the wood is very soft and coarse-grained, used for wood-cutting (cloggs) and as commercial wood. Furthermore, it is chemically processed to viscose fibre and artifical silk.',E'Inhalative (March - April);',E'Pollen, approx. 30 µm;',E'Pappel, Silber-',null,E'Raschwüchsiger, relativ schlanker bis 30 m hoch und 400 Jahre alt werdender zweihäusiger Baum. Blüten unscheinbar in Kätzchen, Blätter wechselständig, buchtig gelappt, unterseits dicht filzig; Stamm hell-weißgrau berindet; anemogam; Blütezeit III - IV (Frühblüher); Samen mit Haarschopf (Windverbreitung); das Holz ist sehr weich und grobfaserig und wird zum Schnitzen (Holzschuhe) und als Werkholz verwendet. Darüber hinaus wird es chemisch zu Zellwolle und Kunstseide aufgearbeitet.',E'Inhalativ (März - April);',E'Pollen, ca. 30 µm;',E'Populus alba L.',E'Salicaceae',null,null,3,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (12,2,E't 902',E'Spruce, common',E'Picea excelsa Lk.; Norway spruce, Christmas tree;',E'An up to 60 m tall and over 300 years old tree with the crown tapering to a thin tip, dark green needles, an outer bark that at first is light brown, later reddish brown; anemogamous ; flowering season : IV - VI (central bloomer); seeds in up to 16 cm long, hanging cones; the wood, which is soft and easy to process, is ideal for building and is employed as resonance wood for pianos and organs as well as for paper production and the chemical extraction of staple and artificial silk; tanning agent is extracted from the bark and vanillin from the resin.',E'Inhalative(April - June);',E'Pollen approx. 70 x 100 µm with two air sacks which strongly impede moistening and thus the release of the patient.allergens;',E'Fichte',E'Picea excelsa Lk.; \nRottanne, Rotfichte;',E'Bis 60 m hoher und über 300 Jahre alt werdender Baum mit spitz zulaufender Krone, dunkelgrünen Nadeln, anfangs hellbrauner, später rötlichgrauer Borke; anemogam; Blütezeit: IV - VI (Mittelblüher); Samen in bis zu 16 cm langen, hängenden Zapfen; das weiche und gut zu bearbeitende Holz ist ideal zum Bauen und dient sowohl als Resonanzholz für den Klavier und Orgelbau als auch zur Papierherstellung und chemischen Gewinnung von Zellwolle und Kunstseide; Nutzung der Rinde zur Gerbstoffgewinnung und des Harzes zur Vanillingewinnung.',E'Inhalativ (April - Juni);',E'Pollen ca. 70 x 100 µm mit zwei Luftsäcken, die eine Benetzung und damit die Freisetzung der Allergene stark behindern;',E'Picea abies (L.) Karst.',E'Pinaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (13,2,E't 21',E'Lilac, common',null,E'A bush or tree reaching up to 6 m in height with white, red or blue-violet colored flowers in upright panicles; leaves opposite, entire and heart-shaped at the base; entomogamous; flowering season : V - VI (central bloomer); 2-sectioned fruits ; the wood is very hard, well suited for polishing and is employed in artistic carpentry and as turned wood.',E'Inhalative (April - June);',E'Pollen;',E'Flieder, gewöhnlicher',null,E'Bis 6 m hoher Strauch oder Baum mit weißen, rötlichen oder bläulich violetten Blüten in aufrechten Rispen; Blätter gegenständig, ganzrandig und am Grunde herzförmig; entomogam; Blütezeit: V - VI (Mittelblüher); Früchte zweifächerig; das Holz ist sehr hart, gut polierbar und findet in der Kunsttischlerei und als Drechselholz Verwendung.',E'Inhalativ (April - Juni);',E'Pollen;',E'Syringa vulgaris L.',E'Oleaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (22,2,E't 903',E'Hornbeam, common',E'Weißbuche;',E'A tree reaching up to 25 m in height and 150 years of age; it has distichous, creased leaves that are biserrate at the edge;  bark smooth, grey-black, with contorted, longitudinal pouches in old-age; male flowers in catkins; anemogamous; flowering season : IV - V (central bloomer); the fruit is an encased nut; the wood is hard and difficult to split and serves as lumber and turned wood (bowling pins);',E'Inhalative (April - May);',E'Pollen, approx. 25 x 35 µm;',E'Hainbuche',E'Weißbuche;',E'Bis 25 m hoher und bis 150 jahre alt werdender Baum mit zweizeiligen, faltigen Blättern, die am Rande doppelt gesägt sind; Rinde glatt, grau-schwarz, im Alter mit gedrehten Längswülsten; männliche Blüten in Kätzchen; anemogam; Blütezeit: IV - V (Mittelblüher); die Frucht ist eine von einer Hülle umgebene Nuss; das harte und schwer spaltbare Holz dient als Werk- und Drechselholz (Kegel);',E'Inhalativ (April - Mai);',E'Pollen, ca. 25 x 35 µm;',E'Carpinus betulus L.',E'Corylaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (23,2,E't 27',E'Linden, little leaf',E'Tilia ulmifolia Scop.; Tilia parvifolia Ehrh.;',E'Tree reaching a height of up to 30 m, with heart-shaped, asymmetric leaves in two rows, that are brown-bearded in the vein-corners on the underside. Inflorescense stem grown together with a wing-like terminal leaf up half its length, supporting the distribution of the seeds by the wind; entomogamous  (bee pasture); flowering season : VI - VII (late bloomer); medicinal plant (lime leaf tea); the wood serves for wood-cutting, as inferior wood (veneer carrier) and for charcoal.',E'Inhalative (June - July); ingestive (lime honey or mixed summer honeys);',E'Pollen, up to 40 µm;',E'Linde, Winter-',E'Tilia ulmifolia Scop.;\nTilia parvifolia Ehrh.;',E'Bis 30 m hoch werdender Baum mit zweizeilig angeordneten, herzförmig - asymmetrischen Blättern, die unterseits in den Aderwinkeln braunbärtig sind. Infloureszenzstiel bis zur Hälfte mit einem flügelartigen Hochblatt verwachsen, das die Verbreitung der Samen durch den Wind unterstützt;  entomogam (Bienenweide); Blütezeit: VI - VII (Spätblüher); Heilpflanze (Lindenblütentee); das Holz dient zum Schnitzen, als Blindholz (Furnierträger) und zur Holzkohlegewinnung.',E'Inhalativ (Juni - Juli); \nIngestiv (Lindenhonig oder Sommermischhonige);',E'Pollen, bis 40 µm;',E'Tilia cordata Mill.',E'Tiliaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (24,2,E't 26',E'Elder, common',E'Elderberry',E'A bush reaching up to 7 m in height with unequally pinnated leaves; flowers white, in umbrella-shaped cymes; anemogamous and entomogamous; flowering season : V - VI (Central bloomer); the fruit are dark-red to black berries (edible fruit); bark light brown ; the center of the branch is white; also an ornamental and medicinal plant;',E'Inhalative (May - June);',E'Pollen, approx. 15 x 35 µm;',E'Holunder, schwarzer',E'Holler;',E'Bis 7 m hoher Strauch mit unpaarig gefiederten Blättern; Blüten weiß, in schirmförmigen Trugdolden; anemogam und entomogam; Blütezeit: V - VI (Mittelblüher); die Früchte sind dunkelrote bis schwarze Beeren (Obst); Rinde hellbraun; Mark der Äste weiß; auch Zier- und Heilpflanze;',E'Inhalativ (Mai - Juni);',E'Pollen, ca. 15 x 35 µm;',E'Sambucus nigra L.',E'Caprifoliaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (25,2,E't 19',E'Golden wattle, Sydney',E'Acacia floribunda;',E'A shrub not native to Central Europe but originating from the tropics, whose flower stems have been wrongly termed mimosa by florists; flowers yellow, in capitulae, paniculiformly arranged; flowering season  III - IV (early bloomer);',E'Inhalative;',E'Pollen,approxa. 45µm;',E'Mimose',E'Acacia floribunda;',E'In Mitteleuropa nicht heimisches sondern aus den Tropen stammendes Gehölz, dessen Blütenstengel in der Floristik fälschlicherweise als Mimosen bezeichnet werden; Blüten gelb, in Köpfchen, welche rispenartig angeordnet sind; Blütezeit III - IV (Frühblüher);',E'Inhalativ;',E'Pollen, ca. 45µm;',E'Acacia longifolia (Andr.) Willd.',E'Mimosaceae',null,null,3,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (26,2,E't 18',E'Gum, blue',E'Tasmanian blue gum',E'Reaching a height of over 20 m, this evergreen tree has entire, crescent-shaped leaves; petals are grown together to a kind of lid-like cap that falls off towards the flowering season; this reticular, closed flower cup gave the genus its name (Greek.: the well-veiled). The fruit is a woody capsule. The bark is smoolth and peels off in strips.',E'Inhalative; epidermal;',E'Pollen;',E'Eukalyptus',E'Blaugummibaum;',E'Über 20 m hoch werdender, immergrüner Baum mit ganzrandigen, sichelförmigen Blättern; Blütenkronblätter zu einer deckelartigen Mütze verwachsen, die zur Blütezeit abfällt; dieser haubenartige, geschlossene Blütenkelch hat der Gattung den Namen gegeben (griech.: der wohlverhüllte). Die Frucht ist eine holzige Kapsel. Die Rinde ist glatt und löst sich in Streifen.',E'Inhalativ;\nEpicutan;',E'Pollen;',E'Eucalyptus globulus Labill.',E'Myrtaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (27,2,E't 17',E'Chestnut, sweet',E'Spanish chestnut;',E'A tree reaching up to 30 m in height and 500 years of age, with two-rowed and spikey serrated leaves, up to 20 cm in length; flowers in upright catkins of up to 20 cm in length; bee pasture; entomogamous and anemogamous; flowering season: VI (late bloomer); fruit and seeds simular to those of the horse chestnut – only with very prickly bristles around the fruit case; the seeds – called chestnuts or maroni – are prepared in numerous different ways as a popular food item. The trunk is usually strongly contorted and covered with a cracked outer bark. The wood is employed as lumber for woodwork and building.',E'Inhalative (June); Ingestive (chestnut honey or mixed summer honeys);',E'Pollen;',E'Kastanie',E'Esskastanie, Edelkastanie;',E'Bis zu 30 m hoch und bis zu 500 Jahre alt werdender Baum mit bis zu 20 cm langen, zweizeilig angeordneten und stachelig gezähnten Blättern; Blüten in aufrechten bis zu 20 cm langen Kätzchen; Bienenweide; entomogam und anemogam; Blütezeit: VI (Spätblüher); Früchte und Samen denen der Roßkastanie ähnlich - die Borsten der Fruchthülle jedoch stark stechend; die Samen - Kastanien oder Maronen genannt - sind, auf die unterschiedlichste Art zubereitet, ein begehrtes Nahrungsmittel. Der Stamm ist meist stark gedreht und mir rissiger Borke bedeckt. Das Holz findet als Werk- und Bauholz Verwendung.',E'Inhalativ (Juni);\nIngestiv (Kastanienhonig oder Sommermischhonige);',E'Pollen;',E'Castanea sativa Mill.',E'Fagaceae',null,null,6,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (28,2,E't 16',E'Pine, black, Scots and Eastern white',E'Die Waldkiefer wird auch Föhre genannt.',E'Up to 40 m (P. nigra 30 m) high coniferous trees - P. nigra with needles in a pair per sheath, 8 to 15 cm long; P. sylvestris needles in pairs, 3 to 8 cm long; P. strobus in groups of five and 14 cm long – with a scaly bark; anemogamous; a very large amount of pollen; flowering season : V - VI (central bloomer); the seeds ripen in woody cones; wood very tenacious and multi-purpose; the close-grained, soft and easy to process wood of the Eastern white pine is especially remarkable -   with its specific weight of 0.39 it is the lightest cultivated wood in these parts and for this reason is favored for the making of wooden boxes, barrels and bee houses (apiaries).',E'Inhalative (May - June);',E'Pollen approx. 40 - 80 µm with two air sacs (so-called flight organs), that strongly impede moisturizing and thus the release of patient.allergens;',E'Kiefer, Schwarz-, Wald- und Weymouths-',E'Die Waldkiefer wird auch Föhre genannt.',E'Bis 40 m (P. nigra 30 m) hoch werdende Nadelbäume - P. nigra Nadeln zu zweit in einer Scheide, 8 bis 15 cm lang; P. sylvestris Nadeln zu zweit, 3 bis 8 cm lang; P. strobus Nadeln zu fünft und bis 14 cm lang - mit Schuppenborke; anemogam; mit sehr großen Pollenmengen;  Blütezeit: V - VI (Mittelblüher); die Samen reifen in holzigen Zapfen; Holz sehr dauerhaft und vielseitig verwendbar; besonders hervorzuheben ist das feinfaserige, weiche und gut zu bearbeitende Holz der Weymouthskiefer - es ist mit einem spezifischen Gewicht von 0,39 das leichteste bei uns kultivierte Holz und wird deshalb vorzugsweise für Kisten, Böttcherwaren und Bienenkästen (Beuten) verwendet.',E'Inhalativ (Mai - Juni);',E'Pollen ca. 40 - 80 µm mit zwei Luftsäcken (sog. Flugorgane), die eine Benetzung und damit die Freisetzung der Allergene stark behindern;',E'Pinus L.; nigra Arnold, sylvestris L., strobus L.',E'Pinaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (29,2,E't 11',E'Plane, oriental',null,E'An up to 50 m tall tree with an imposing crown and a yellowish-green outer bark that flakes off in thin plates, so that the trunk appears a light dappled color. The wood serves as commercial lumber, for carving and for paper production. The leaves are lobed in a hand-shape above the middle. The flowers are arranged in capitula, of which always two to four hang together. The flowers are anemogamous. Flowering season: V (Central bloomer); fruit in round, petiolar, hanging infructescences.',E'Inhalative (May);',E'Pollen, approx. 16 x 22 µm;',E'Platane, morgenländische',null,E'Bis 50 m hoher Baum mit mächtiger Krone und gelblich-grüner Borke, die in großen dünnen Platten abspringt, so dass der Stamm hell gescheckt erscheint. Das Holz dient als Werkholz, als Schnitzholz und zur Papiergewinnung. Die Blätter sind bis über die Mitte handförmig gelappt. Die Blüten sind in Köpfchen angeordnet, von denen jeweils zwei bis vier zusammen hängen.\nDie Blüten sind anemogam. Blütezeit: V (Mittelblüher); Früchte in kugeligen, gestielten, herabhängenden Fruchtständen.',E'Inhalativ (Mai);',E'Pollen, ca. 16 x 22 µm;',E'Platanus orientalis L.',E'Platanaceae',null,null,5,5,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (30,2,E't 10',E'Walnut, English (Persian)',null,E'Reaching a height of up to 30 m  and up to 200 years of age, the tree has a wide, expansive crown and a silver-grey trunk that only later turns dark and cracked; leaves very large, odd-pinnated; male flowers in hanging catkins; female flowers inconspicuous, located at the end of the year’s new shoots; flowering season: IV - V (central bloomer); the stone of the 4 to 5 cm large, green and slightly oval stone fruit is the walnut. Wood varnishes are extracted from the fruit pulp. The wood is suited for carving, turning and the manufacture of furniture.',E'Inhalative (April - May);',E'Pollen, approx. 35 µm;',E'Walnuß',null,E'Bis 30 m hoch und bis 200 Jahre alt werdender Baum mit breiter ausladender Krone und silbergrauem, erst später dunkel und rissig werdendem Stamm; Blätter sehr groß, unpaarig gefiedert; männliche Blüten in hängenden Kätzchen; weibliche Blüten unscheinbar, am Ende diesjähriger Triebe; anemogam; Blütezeit: IV - V (Mittelblüher); \nder Stein der 4 bis 5 cm großen, grünen und leicht ovalen Steinfrüchte ist die Walnuß. Aus dem Fruchtfleisch werden Holzbeizen gewonnen. Das Holz eignet sich zum Schnitzen, Drechseln und zur Möbelherstellung.',E'Inhalativ (April - Mai);',E'Pollen, ca. 35 µm;',E'Juglans regia L.',E'Juglandaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (31,2,E't 8',E'Elm, Scotch',E'Ulmus scabra Mill.; Ulmus montana With.; Rüster, Bergrüster;',E'Reaching up to 35 m in height, a tree which achieves up to 400 years of age, with a grey outer bark bearing slight longitudinal cracks; two-rowed, asymmetric leaves, 8 bis 16 cm long and very rough on the upper side; flowers relatively inconspicuous, in clustery inflorescenses; anemogamous; flowering season: III - IV (early bloomer); the fruit is a wide-winged nut. The wood is employed as commercial timber, for turned work and furniture.',E'Inhalative (March - April);',E'Pollen, approx. 30 µm;',E'Ulme, Berg-',E'Ulmus scabra Mill.; Ulmus montana With.;\nRüster, Bergrüster;',E'Bis 35 m hoch und bis 400 Jahre alt werdender Baum mit grauer, schwach längsrissiger Borke, zweizeilig gestellten, asymmetrischen, 8 bis 16 cm langen und oberseits sehr rauhen Blättern; Blüten relativ unscheinbar, in büschelartigen Blütenständen; anemogam; Blütezeit: III - IV (Frühblüher); die Frucht ist eine breitgeflügelte Nuss. Das Holz findet als Werk-, Drechsel- und Möbelholz Verwendung.',E'Inhalativ (März - April);',E'Pollen, ca. 30 µm;',E'Ulmus glabra Huds. em. Moss',E'Ulmaceae',null,null,3,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (32,2,E't 7',E'Oak, english',E'Quercus pedunculata Ehrh.;',E'Reaching a height of up to 50 m, this tree can reach over 1000 years of age; it has a grey-brown, deeply furrowed outer bark, short-stemmed, emarginately lobed, assymetric leaves  that are heartshaped and auriculate at the base; male flowers in catkins; female inflorescence inconspicuous, 1 to 2 flowers; anemogamous; flowering season : IV - V (central bloomer); the long-stemmed (name) fruits, the so-called acorns (used to be sought after for fattening pigs) are nuts surrounded by a shallow cup. The very hard wood is not to be surpassed by any other indiginous wood for its firmness and elasticity. Furthermore, it is extremely durable and, like the bark, very rich in tanning agent (used to be much in demand by tanners). For these reasons, numerous natural oak groves fell victim to exploitive forestry, especially between 1500 and 1750; this especially in coastal areas, since the load-bearing wood is ideal for shipbuilding. Today it is mostly employed for furniture, parquet floors and construction wood for earthworks, buildings, waterworks and bridge building.',E'Inhalative (April - May);',E'Pollen; approx. 20 x 40 µm;',E'Eiche, Stiel-',E'Quercus pedunculata Ehrh.;',E'Bis 50 m hoher und über 1000 Jahre alt werdender Baum mit graubrauner, tiefgefurchter Borke, kurzstieligen, buchtig gelappten und am Grunde herzförmig geöhrten, asymmetrischen Blättern; männliche Blüten in Kätzchen; weibliche Blütenstände unscheinbar, ein- bis fünfblütig; anemogam; Blütezeit: IV - V (Mittelblüher); die lang gestielten (Name) Früchte, die sogenannten Eicheln (früher zur Schweinemast begehrt) sind Nüsse, die am Grunde von einem flachen Becher umgeben sind. Das sehr harte Holz wird an Festigkeit und Elastizität von keiner anderen heimischen Baumart übertroffen. Zudem ist es äußerst dauerhaft und wie die Rinde sehr gerbstoffhaltig (früher von Gerbereien begehrt). Zahlreiche natürliche Eichenwälder sind aus diesen Gründen vor allem zwischen 1500 und 1750 dem Raubbau zum Opfer gefallen; dies vor allem in den Küstengebieten, da das tragfähige Holz sich ideal zum Schiffbau eignet. Heute dient es vor allem als Möbelholz, Parkettholz und Bauholz zum Erd-, Hoch-, Wasser- und Brückenbau.',E'Inhalativ (April - Mai);',E'Pollen; ca. 20 x 40 µm;',E'Quercus robur L.',E'Fagaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (33,2,E't 5',E'Beech, Common',null,E'Reaching up to 40 m in height and up to 300 years of age, when inside closed forests this tree grows a high trunk which does not branch until the high crown, whereas free-standing trees develop a very low-reaching crown; bark light gray, thin and smooth; leaves egg-shaped and entire; male flowers in numerous round catkins; femal inflorescence geminiflorous and surrounded by a spiky protective cover in which two three-cornered nuts develop later (beach-nuts) ; anemogamous; flowering season : IV - V (central bloomer); the wood is heavy, hard, easy to split and red-colored (name). As commertial timber it has many uses: railroad ties, furniture, parquet floors, charcoal;',E'Inhalative (April - May);',E'Pollen, approx. 40 µm;',E'Buche, Rot-',null,E'Bis 40 m hoch und bis 300 Jahre alt werdender Baum, der in geschlossenen Wäldern einen bis weit hinauf zweiglosen Stamm ausbildet, während freistehende Bäume eine tief herabreichende Krone ausbilden; Rinde hellgrau, dünn und glatt; Blätter eiförmig und ganzrandig; männliche Blüten zu vielen in kugeligen Kätzchen; weibliche Blütenstände zweiblütig und von einer stacheligen Hülle umgeben in der sich später zwei dreikantige Nüsse (Bucheckern) entwickeln; anemogam; Blütezeit: IV - V (Mittelblüher); das Holz ist schwer, hart, leicht spaltbar und rötlich (Name). Als Nutzholz findet es vielerlei Verwendung: Eisenbahnschwellen, Möbel, Parkett, Holzkohle',E'Inhalativ (April - Mai);',E'Pollen, ca. 40 µm;',E'Fagus sylvatica L.',E'Fagaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (34,2,E't 4',E'Cob, hazel',E'Gewöhnliche Haselnuss;',E'Reaching a height of three to five meters, this bush, branched from the base, has a gray, smooth bark; leaves roundish to heart-shaped, serrated; male flowers in catkins; pollen plant for bees; female flowers are small and hidden in buds, with only the red stigmas projecting; flowering season : XII -IV (early bloomer); nuts situated in bunches and surronded by a lobed seed case; wood tough and pliable;',E'Inhalative (December - May); ingestive (spring honey);',E'Pollen, 20 - 30 µm;',E'Hasel, gewöhnliche',E'Gewöhnliche Haselnuss;',E'Drei bis fünf Meter hoher, vom Grund auf verzweigter Strauch mit grauer, glatter Rinde; Blätter rundlich bis herzförmig, gesägt; männliche Blüten in Kätzchen; Pollenpflanze für Bienen; weibliche Blüten klein und in Knospen verborgen, nur die roten Narben herausragend; Blütezeit: XII -IV (Frühblüher); Nüsse zu mehreren zusammensitzend und von einer zerlappten Fruchthülle umgeben; Holz zäh und biegsam;',E'Inhalativ (Dezember - Mai);\nIngestiv (Frühjahrshonig);',E'Pollen, 20 - 30 µm;',E'Corylus avellana L.',E'Corylaceae',null,null,12,5,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (35,2,E't 3',E'Birch, Weeping',E'Betula verrucosa Ehrh.; European White Birch;',E'Reaching up to  30 m of height and 120 years of age, the tree branches out towards the crown; young branches glistening reddish-brown, with many warty resin glands; leaves triangular to rhombic, entire at the base, biserrate towards the tip; male flowers winter in catkins; pollen plant for bees; the female catkins develop with the leaves; anemogamous ; flowering season : IV - V (central bloomer); the fruits ripen in July and become small winged nuts; the young trunk has a glossy golden-brown bark, which turns white, smooth and striped crosswise with cork; older trees with an irregularly cracked, dark outer bark; wood white and without duramen, used for shingles, furniture, veneers and for turned woodwork; as early as the Stone Age, a universal glue was achieved by heating the white bark under airtight conditions (= birch pitch; used in medicine against rheumatism and sciatica complaints). Brush wood used to be made into brooms. The rising sap can be processed into wine and hair tonic; finally, a medicinal tea against disorders of the lower urinary tract and rheumatism.',E'Inhalative (March - June); ingestive (spring honey);',E'Pollen, 20 - 25 µm;',E'Birke, Hänge-',E'Betula verrucosa Ehrh.;\nWarzenbirke;',E'Bis 30 m hoher und bis 120 Jahre alt werdender Baum mit starker Verzweigung im Kronenbereich; junge Äste glänzend rötlich-braun, mit vielen warzigen Harzdrüsen; Blätter dreieckig-rhombisch, mit ganzrandigem Grund, zur Spitze hin doppelt gesägt; männliche Blüten schon in Kätzchen überwinternd; Pollenpflanze für Bienen; die weiblichen Blütenkätzchen erscheinen mit den Blättern; anemogam; Blütezeit: IV - V (Mittelblüher); die im Juli reifenden und in ungeheueren Mengen erzeugten Früchte sind kleine geflügelte Nüsschen; Stamm in jungen Jahren mit glänzend goldbrauner Rinde, die in zunehmendem Alter weiß, glatt und durch Korkleisten quergestreift wird; ältere Bäume am Stammgrund mit unregelmäßig rissiger und dunkler Borke; \nHolz weiß und kernlos, in Gebrauch für Schindeln, Möbel, Furniere und für Drechslerarbeiten; bereits in der Steinzeit wurde durch Erhitzen der weißen Rinde unter Luftabschluss ein Universalklebstoff gewonnen (= Birkenpech; auch in der Medizin gegen Rheuma- und Ischiasbeschwerden). Reisig wurde früher zu Besen gebunden. Der aufsteigende Saft kann zu Wein und Haarwasser verarbeitet werden; schließlich wird aus den Blättern ein Heiltee gegen Erkrankungen der Harnwege und gegen Rheuma gewonnen.',E'Inhalativ (März - Juni);\nIngestiv (Frühjahrshonig);',E'Pollen, 20 - 25 µm;',E'Betula pendula Roth',E'Betulaceae',null,null,3,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (36,2,E't 2',E'Alder, common',null,E'Reaching up to  25 m in height and 120 years of age, this tree has a continuous trunk all the way to the tip and roundish, serrated leaves that are blunt or even emarinate; male and female inflorescence both winter in catkins; during maturity the female catkins turn woody (lignify) and thus resemble small cones. The pollination and distribution of the small, red-colored, winged nuts is caused by the wind. Flowering season : II - IV (early bloomer); bark black-brown; because of a symbiotic relationship to nodule bacteria in its root area it is capable of utilizing the nitrogen in the air; wood yellow to red colored, versatile use (furniture, waterworks, commercial wood, paper);',E'Inhalative (February - April); ingestive (spring honey);',E'Pollen, approx.  20 µm;',E'Erle, Schwarz-',null,E'Bis 25 m hoch und 120 Jahre alt werdender Baum mit einem bis zur Spitze durchgehenden Stamm und rundlichen, gesägten, und der Spitze stumpfen oder gar ausgerandeten Blättern; männliche und weibliche Blütenstände jeweils bereits in Kätzchen überwinternd; während der Reife verholzen die weiblichen Kätzchen und ähneln dadurch kleinen Zapfen. \nDie Bestäubung und die Verbreitung der kleinen rötlich geflügelten Nüsschen geschieht durch den Wind. Blütezeit: II - IV (Frühblüher); Rinde schwarzbraun; ist durch Symbiose mit Knöllchenbakterien im Wurzelbereich in der Lage Luftstickstoff zu verwerten; Holz gelblich bis rötlich, vielseitig verwendbar (Möbel, Wasserbau, Werkholz, Papier);',E'Inhalativ (Februar - April);\nIngestiv (Frühjahrshonig);',E'Pollen, um 20 µm;',E'Alnus glutinosa (L.) Gaertn.',E'Betulaceae',null,null,2,4,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (37,2,E't 1',E'Sycamore',null,E'Up to 30 m tall and 500 years of age with hand-sized, decussate, five-lobed leaves; greenish flowers in hanging clusters; entomogamous (bee pasture); flowering season : IV - V (central bloomer); winged double fruit; grey-brown bark which peels off in large, irregular scales; bleeding sap is sachariferous (maple syrup); the wood can be used in many different ways for instruments, furniture, parquet floors, charcoal, turned woodwork and as lumber;',E'Inhalative(April - May); ingestive (spring honey);',E'Pollen, 25 x 45 µm;',E'Ahorn, Berg-',null,E'Bis 30 m hoch und bis 500 Jahre alt werdender Baum mit handgroßen, kreuzgegenständigen,  fünflappigen Blättern; Blüten grünlich, in hängenden Trauben; entomogam (Bienenweide); Blütezeit: IV - V (Mittelblüher); geflügelte Doppelfrüchte; Rinde graubraun, sich in großen unregelmäßigen Schuppen ablösend; Blutungssaft dient zuweilen als  Zuckerlieferant (Ahornsirup); Holz vielfach verwendbar für Instrumente, Möbel, Parkett, Holzkohle, Drechslerarbeiten und als Werkholz;',E'Inhalativ (April - Mai);\nIngestiv (Frühjahrshonig);',E'Pollen, 25 x 45 µm;',E'Acer pseudoplatanus L.',E'Aceraceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (38,2,E'g 2',E'Bermuda grass',E'Bermudagras;',E'A finger grass of up to 40 cm in height with long runners above ground; two short internodes are always followed by one long one; perennial; flowering season : V - VI;',E'Inhalative (May - June);',E' Pollen, 20 - 30 µm;',E'Hundszahngras',E'Bermudagras;',E'Bis 40 cm hohes Fingergras mit langen oberirdischen Ausläufern; auf zwei kurze Stengelglieder folgt jeweils ein langes; mehrjährig; Blütezeit: V - VI;',E'Inhalativ (Mai - Juni);',E' Pollen, 20 - 30 µm;',E'Cynodon dactylon (L.) Pers.',E'Poaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (39,2,E'g 3',E'Cocksfoot',E'orchard grass;',E'An up to 100 cm high, grey-green  meadow grass; seed-heads in a cluster at the end of the panicle branches; caespitose; perennial; flowering season : V - VI; rich and high-yielding fodder; nitrogen indicator;',E'Inhalative (May - June);',E'Pollen, approx. 30 µm;',E'Knäuelgras, Wiesen-',E'Gemeines Knäuel- oder Knaulgras;',E'Bis 100 cm hohes, graugrünes Rispengras; Ährchen am Ende der Rispenäste knäuelig gehäuft; horstbildend; mehrjährig; Blütezeit: V - VI; wertvolles und ertragreiches Futtergras; Stickstoffzeiger;',E'Inhalativ (Mai  - Juni);',E'Pollen, ca. 30 µm;',E'Dactylis glomerata L.',E'Poaceae',null,null,5,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (40,2,E'g 4',E'Meadow fescue',E'Festuca elatior L.;',E'Up to 1 m high meadow-grass with a usually short creeping basilar axis; perennial; inflorescence up to 20 cm long; flowering season: V - VI; rich fodder;',E'Inhalative (May - June);',E'Pollen, approx. 30 µm;',E'Wiesenschwingel',E'Festuca elatior L.;',E'Bis 1 m hohes Rispengras mit meist kurz kriechender Grundachse; mehrjährig; Infloreszenz bis 20 cm lang;  Blütezeit: V - VI; wertvolles Futtergras;',E'Inhalativ (Mai - Juni);',E'Pollen, ca. 30 µm;',E'Festuca pratensis Huds.',E'Poaceae',null,null,5,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (41,2,E'g 5',E'Rye-grass',E'Ausdauernder Lolch, Leitergras, Weidelgras;',E'Reaching a height of up to 50 cm, this spiked grass, unlike the couch grass, has its seed heads facing the rachilla with their short side; perennial; flowering season: V - IX; rich fodder; main ingredient of all lawn grass mixtures; nitrogen indicator;',E'Inhalative (May - September);',E'Pollen, approx. 30 µm;',E'Raygras, englisches',E'Ausdauernder Lolch, Leitergras, Weidelgras;',E'Bis 50 cm hohes Ährengras; im Gegensatz zur Quecke Ährchen mit der Schmalseite der Ährenachse zugewandt; mehrjährig; Blütezeit: V - IX; wertvolles Futtergras; Hauptbestandteil aller Rasengrasmischungen; Stickstoffzeiger;',E'Inhalativ (Mai - September);',E'Pollen, ca. 30 µm;',E'Lolium perenne L.',E'Poaceae',null,null,5,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (42,2,E'g 6',E'Timothy',E'Cat’s tail;',E'Up to 1 m height, spiked meadow grass with uniform cylinder-shaped seed-head panicle; in contrast to simular-looking species alopecurus pratensis L., meadow foxtail,  the individual seed-head with its short awns has the form of a boot-jack; perennial; flowering season: V - IX; rich fodder; nitrogen indicator;',E'Inhalative (May - September);',E'Pollen, 30 - 40 µm;',E'Wiesenlieschgras',E'Timotheusgras, Katzenschweif, Kaminkehrer;',E'Bis 1 m hohes Ährenrispengras mit gleichförmig-zylindrischer Ährenrispe; im Gegensatz zu der im Habitus ähnlichen Art Alopecurus pratensis L., dem Wiesenfuchsschwanzgras, hat das einzelne Ährchen mit seinen kurzen Grannen die Form eines Stiefelknechtes; mehrjährig; Blütezeit: V - IX; wertvolles Futtergras; Stickstoffzeiger;',E'Inhalativ (Mai - September);',E'Pollen, 30 - 40 µm;',E'Phleum pratense L.',E'Poaceae',null,null,5,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (43,2,E'g 7',E'Reed, common',E'Phragmites communis Trin.; reed, reed grass;',E'Up to 4 m (10 m) tall meadow-grass with a  20 bis 50 cm  long panicle; perennial; flowering seasons: VII - IX; ground-forming marshland pioneer plant; roots reaching as deep as 1 m and runners up to 10 m long;',E'Inhalative (July - September);',E'Pollen, approx. 20 µm;',E'Schilf',E'Phragmites communis Trin.;\nSchilfrohr, Teichrohr, Röhricht;',E'Bis 4 m (10 m) hohes Rispengras mit 20 bis 50 cm langer Rispe; mehrjährig; Blütezeit: VII - IX; Verlandungspionier; bis 1 m tief wurzelnd und mit bis zu 10 m langen Ausläufern;',E'Inhalativ (Juli - September);',E'Pollen, ca. 20 µm;',E'Phragmites australis (Cav.) Trin. Ex Steud.',E'Poaceae',null,null,7,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (44,2,E'g 8',E'Blue grass, (Kentucky)',null,E'Up to 60 cm tall meadow-grass with outspread, pyramid-formed panicle and long underground runners; perennial; flowering season: V - VII; good fodder;',E'Inhalative (May - July);',E'Pollen, approx. 20 x 25 µm;',E'Wiesenrispengras',null,E'Bis 60 cm hohes Rispengras mit ausgebreiteter, pyramidaler Rispe und langen unterirdischen Ausläufern; mehrjährig; Blütezeit: V - VII; gutes Futtergras;',E'Inhalativ (Mai - Juli);',E'Pollen, ca. 20 x 25 µm;',E'Poa pratensis L.',E'Poaceae',null,null,5,7,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (45,2,E'g 9',E'Creeping bent',E'Agrostis alba auct. p. p.; spreading bent;',E'Up to 80 cm tall meadow-grass with very small seed-heads, thus appearing very delicate and fragile; with short runners above and underground; perennial; flowering season: VI - VIII; only mediocre fodder;',E'Inhalative (June - August);',E'Pollen, approx. 30 µm;',E'Straußgras, weißes',E'Agrostis alba auct. p. p.;\nFuchsschmiele, Flechtstraußgras;',E'Bis 80 cm hohes Rispengras mit sehr kleinen Ährchen, dadurch sehr fein und zerbrechlich wirkend; mit kurzen ober- und unterirdischen Ausläufern; mehrjährig; Blütezeit: VI - VIII; nur mäßiges Futtergras;',E'Inhalativ (Juni - August);',E'Pollen, ca. 30 µm;',E'Agrostis stolonifera L.',E'Poaceae',null,null,6,8,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (46,2,E'g 12',E'Ryegrass, perennial',null,E'Type of cereal, especially in Northern Europe; spiked grass reaching up to above a meter with blue-pruinose leaves and a four-cornered, projecting, multi-rowed seed-head; awns 2 - 8 cm long; annual; flowering season: V - VI; originating from Southwest Asia, introduced  to central Europe as a cultivated plant in the Neolithic period, approx. 5000 B.C..;',E'Inhalative (May - June);',E'Pollen, 40 - 60 µm;',E'Roggen',null,E'Getreideart, vor allem in Nordeuropa; bis über ein Meter hohes Ährengras mit blau-bereiften Blättern und vierkantiger überhängender, mehrzeiliger, begrannter Ähre; Grannen 2 - 8 cm lang; einjährig; Blütezeit: V - VI; aus Südwest-Asien stammend und in der Jungsteinzeit, ca. 5000 v. Chr., nach Mitteleuropa als Kulturpflanze eingeführt;',E'Inhalativ (Mai - Juni);',E'Pollen, 40 - 60 µm;',E'Secale cereale L.',E'Poaceae',null,null,5,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (47,2,E'g 10',E'Johnson grass (Sudan grass)',E'Andropogon halepensis (L.) Brot.;',E'Originating from the Eastern Mediterranean area, this is an up to 120 cm high meadow-grass; perennial; flowering season: VI - VII; the seed are a component of bird feed;',E'Inhalative (June - July);',E'Pollen;',E'Sorgo (Sudangras)',E'Andropogon halepensis (L.) Brot.;\nMohrenhirse, Wilde Mohrenhirse, Aleppohirse;',E'Aus dem östlichen Mittelmeergebiet stammendes bis 120 cm hohes Rispengras; mehrjährig; Blütezeit: VI - VII; die Samen sind\nBestandteil von Vogelfutter;',E'Inhalativ (Juni - Juli);',E'Pollen;',E'Sorghum halepense (L.) Pers.',E'Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (48,2,E'g 13',E'Yorkshire fog',null,E'30 - 100 cm high meadow grass with soft-haired leaf sheaths and nodes; perennial; flowering season : V - VIII; low-grade fodder; growing in grey-green tufts; occasionally crop-forming (honey grass fields); avoids lime;',E'Inhalative (May - August);',E'Pollen, approx. 30 µm;',E'Honiggras, wolliges',null,E'30 - 100 cm hoch werdendes Rispengras mit weichhaarigen Blattscheiden und Knoten; mehrjährig; Blütezeit: V - VIII; minderwertiges Futtergras; in graugrünen Horsten wachsend; zuweilen bestandsbildend (Honiggraswiesen); kalkmeidend;',E'Inhalativ (Mai - August);',E'Pollen, ca. 30 µm;',E'Holcus lanatus L.',E'Poaceae',null,null,5,8,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (49,2,E'g 14',E'Oats, common',null,E'A cereal with numerous types; hexaploid, 2n = 42; an up to 150 cm high meadow grass; annual; flowering season : VI - VII; the basic form is the wild oat (Avena fatua L.), originating from Asia. Introduced in the Bronze Age as a cultivated plant; today more commonly used as feed;',E'Inhalative (June - July);',E'Pollen, approx. 35 µm;',E'Hafer, Saat-',null,E'Getreideart mit zahlreichen Sorten; hexaploid, 2n = 42; bis 150 cm hohes Rispengras; einjährig; Blütezeit: VI - VII; Stammform ist der aus Asien stammende Windhafer (Avena fatua L.). In der Bronzezeit als Kulturpflanze eingeführt; heute mehr Futterpflanze;',E'Inhalativ (Juni - Juli);',E'Pollen, ca. 35 µm;',E'Avena sativa L.',E'Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (50,2,E'g 15',E'Wheat, common',E'Triticum hybernum L.;',E'Most important cereal world-wide; presumably originating from Northern Perisa out of T. dicoccon Schr. x Triticum squarrosa, 8 000 to 10 000 years ago; hexaploid (2n = 42); spiked grass, reaching up to over a meter in height; annual; flowering season: VI - VII;',E'Inhalative (June - July);',E'Pollen, 40 - 60 µm;',E'Weizen, Saat-',E'Triticum hybernum L.;',E'Weltweit wichtigste Getreideart; vermutlich in Nordpersien aus T. dicoccon Schr. x Triticum squarrosa vor 8 000 bis 10 000 Jahren entstanden; hexaploid (2n = 42); bis über ein Meter hohes Ährengras; einjährig; Blütezeit: VI - VII;',E'Inhalativ (Juni - Juli);',E'Pollen, 40 - 60 µm;',E'Triticum aestivum L.',E'Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (51,2,E'g 16',E'Meadow foxtail',null,E'An up to 100 cm high  spiked meadow-grass with underground runners reaching a length of up to 10 cm; seed-head panicle approx. 1 cm thick; perennial; flowering season: V - VII; a good and rich fodder when harvested early; moisture and nutrient indicator; easily confused with Phleum pratense L., however appearing a good deal earlier in the year;',E'Inhalative (May - July);',E'Pollen, approx. 40 µm;',E'Wiesenfuchsschwanz',null,E'Bis 100 cm hoch werdendes Ährenrispengras mit bis zu 10 cm langen unterirdischen Ausläufern; Ährenrispe ca. 1 cm dick; mehrjährig; Blütezeit: V - VII; bei Frühschnitt gutes ergiebiges Futtergras; Nässe- und Nährstoffzeiger; leicht mit Phleum pratense L. zu verwechseln (s. dort), jedoch deutlich früher im Jahr auftretend;',E'Inhalativ (Mai - Juli);',E'Pollen, um 40 µm;',E'Alopecurus pratensis L.',E'Poaceae',null,null,5,7,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (52,2,E'g 17',E'False oat grass',E'Französisches Raygras, Wiesenhafer, Falscher Hafer;',E'A meadow grass reaching up to 150 cm in height, panicle spreads out widely toward the flowering season; perennial; flowering season : VI - VIII; high-yielding and very nourishing fodder;',E'Inhalative (June - August);',E'Pollen, approx. 30 µm;',E'Glatthafer',E'Französisches Raygras, Wiesenhafer, Falscher Hafer;',E'Bis 150 cm hohes Rispengras mit zur Blütezeit weit ausgebreiteter Rispe; mehrjährig; Blütezeit: VI - VIII; ertragreiches und wertvolles Futtergras;',E'Inhalativ (Juni - August);',E'Pollen, ca. 30 µm;',E'Arrhenatherum elatius (L.) J. & K. Presl',E'Poaceae',null,null,6,8,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (53,2,E'g 18',E'Barley',E'Gemeine Gerste;',E'A cereal encompassing many types, originating in central Asia; introduced as a cultivated plant in the Neolithic period; today more often cultivated for feed purposes; up to120 cm high spiked cereal; ear multi-rowed, with four to six awn rows; awns up to 15 cm long; diploid (2n = 14); annual; flowering season : VI - VII;',E'Inhalative (June bis July);',E'Pollen, approx. 40 µm;',E'Gerste, mehrzeilige',E'Gemeine Gerste;',E'Aus Zentralasien stammende Getreideart mit vielen Sorten; in der Jungsteinzeit als Kulturpflanze eingeführt; heute mehr zu  Futterzwecken angebaut; bis 120 cm hohes Ährengras; Ähre mehrzeilig, mit vier bis sechs Grannenreihen; Grannen bis 15 cm lang; diploid (2n = 14); einjährig; Blütezeit: VI - VII;',E'Inhalativ (Juni bis Juli);',E'Pollen, ca. 40 µm;',E'Hordeum vulgare L.',E'Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (54,2,E'g 20',E'Corn',E'Maize, sweet corn;',E'Up to 3 m high, old cultivated plant of the American Indian advanced civilizations with an approx. 4 cm thick shoot axis and monoecious flowers;  female flowers in axillary ears; male flowers in terminal panicles, releasing very large amounts of pollen; annual; flowering season: VII - IX;  also used as feed in stock fattening;  shredded, the entire plant serves as forage maize;',E'Inhalative (July - September);',E'Pollen, 50 - 140 µm;',E'Mais',null,E'Bis 3 m hohe, alte Kulturpflanze der indianischen Hochkulturen Amerikas mit ca. 4 cm dicker Sproßachse und einhäusigen Blüten; weibliche Blüten in blattachselständigen Kolben; männliche Blüten in endständiger Rispe, sehr große Pollenmengen freisetzend; einjährig; Blütezeit: VII - IX; auch als Futtermais in der Viehmast eingesetzt; zudem dienen die ganzen Pflanzen in gehäckselter Form auch als Silofutter;',E'Inhalativ (Juli - September);',E'Pollen, 50 - 140 µm;',E'Zea mays L.',E'Poaceae',null,null,7,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (55,2,E'g 21',E'Couch grass',E'Elymus repens (L.) Gould;',E'A spiked, runner-forming grass up to 150 cm high; in contrast to ryegrass the seed heads face the rachilla with their broad side; perennial; flowering season: VI - VIII; roots up to 80 cm deep; nitrogen indicator;',E'Inhalative (June - August);',E'Pollen, 30 - 40 µm;',E'Quecke, gewöhnliche',E'Elymus repens (L.) Gould;\nKriechende Quecke;',E'Bis 150 cm hohes Ausläufer bildendes Ährengras ; im Gegensatz zum Raygras Ährchen mit der Breitseite der Ährenachse zugewandt; mehrjährig; Blütezeit: VI - VIII; bis 80 cm tief wurzelnd; Stickstoffzeiger;',E'Inhalativ (Juni - August);',E'Pollen, 30 - 40 µm;',E'Agropyron repens (L.) P. B.',E'Poaceae',null,null,6,8,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (56,2,E'g 70',E'Lyme-grass',E'wild rye',E'perennial; flowering season : V - VI; rich fodder; nitrogen indicator;',null,null,E'Haargerste',null,E'mehrjährig; Blütezeit: V - VI; wertvolles Futtergras; Stickstoffzeiger;',null,null,E'Elymus triticoides',E'Poaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (57,2,E'g 901',E'Common bent',E'Agrostis vulgaris With, Agrostis tenuis Sibth.;',E'Up to 40 cm high meadow-grass with very small, usually reddish-violett seed-heads; looks very delicate and fragile; with short underground runners; perennial; flowering season: VI - VIII; good but not very plentifl fodder; poorness indicator;',E'Inhalative (June - August);',E'Pollen;',E'Straußgras, rotes',E'Agrostis vulgaris With, Agrostis tenuis Sibth.;',E'Bis 40 cm hohes Rispengras mit sehr kleinen, meist rötlich-violetten Ährchen; sehr fein und zerbrechlich wirkend; mit kurzen unterirdischen Ausläufern; mehrjährig; Blütezeit: VI - VIII; gutes aber unergiebiges Futtergras; Magerkeitszeiger;',E'Inhalativ (Juni - August);',E'Pollen;',E'Agrostis capillaris L.',E'Poaceae',null,null,6,8,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (58,2,E'w 1',E'Ragweed, common',E'Ambrosia elatior L.;',E'An annual herb reaching up to 1.5 m; its thin leaves, the two lower ones always bipinnatifid, closely resemble those of the mugwort (name); stems hirsute; monoecious plant, capitulum however unisexual; male flowers are united in nodding capitula into a terminal, cluster-like inflorescence; the uniflorous female capitula underneath; anemogamous ; flowering season: VIII - X;',E'Inhalative(August - October);',E'Pollen, um 20 µm;',E'Ambrosie, beifußblättrige',E'Ambrosia elatior L.;\nHohe Ambrosie; Hohes Traubenkraut;\nHoher Ragweed',E'Bis 1,5 m hohes einjähriges Kraut mit dünnen Blättern, von denen die unteren stets doppelt fiederspaltig sind und an die Blätter des Beifußes erinnern (Name); Stengel rauhhaarig; Pflanze einhäusig, Köpfchen jedoch eingeschlechtlich; männliche Blüten in nickenden Köpfchen zu endständiger, traubiger Influreszenz vereint; darunter die einblütigen weiblichen Köpfchen; anemogam; Blütezeit: VIII - X;',E'Inhalativ (August - Oktober);',E'Pollen, um 20 µm;',E'Ambrosia artemisiifolia L.',E'Asteraceae',null,null,8,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (59,2,E'w 2',E'Ragweed, western',E'Perennial "Traubenkraut" (ambrosia coronopifolia);',E'Up to 80 cm high, perennial plant with far-reaching roots and runners; stout leaves, pinnated to pinnatifid with entirely or slightly toothed leaf tips; stalks as well as leaves downy to tomentose; monoecious plant, capitulum however unisexual; male flowers are united in nodding capitula into a terminal, cluster-like inflorescence; the uniflorous female capitula underneath; anemogamous ; flowering season : VIII - X;',E'Inhalative (August - October);',E'Pollen, ca. 20 µm;',E'Ambrosie, ausdauernde',E'Ausdauerndes Traubenkraut;\nRagweed',E'Bis 80 cm hohe, ausdauernde Pflanze mit weit kriechenden Wurzeln und Wurzelsprossen; Blätter dicklich, einfach gefiedert bis fiederspaltig mit ganzrandigen oder wenig gezähnten Blattzipfeln; sowohl Stengel als auch Blätter feinhaarig bis filzig;  Pflanze einhäusig, Köpfchen jedoch eingeschlechtlich; männliche Blüten in nickenden Köpfchen zu endständiger, traubiger Influreszenz vereint; darunter die einblütigen weiblichen Köpfchen; anemogam; Blütezeit: VIII - X;',E'Inhalativ (August - Oktober);',E'Pollen, um 20 µm;',E'Ambrosia psilostachya D.C.',E'Asteraceae',null,null,8,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (60,2,E'w 3',E'Ragweed, giant',E'Ragweed',E'Up to  2 m high, annual herb with more or less three-lobed leaves; stem covered in sparse hair to hairless; monoecious plant, capitulum however unisexual; male flowers are united in nodding capitula into a terminal, cluster-like inflorescence; the uniflorous female capitula underneath; anemogamous;flowering season : VIII - X;',E'Inhalative (August - October);',E'Pollen, um 20 µm;',E'Ambrosie, dreilappige',E'Ragweed',E'Bis über 2 m hohes einjähriges Kraut mit mehr oder weniger dreilappigen Blättern; Stengel spärlich behaart bis kahl; Pflanze einhäusig, Köpfchen jedoch eingeschlechtlich; männliche Blüten in nickenden Köpfchen zu endständiger, traubiger Influreszenz vereint; darunter die einblütigen weiblichen Köpfchen; anemogam; Blütezeit: VIII - X;',E'Inhalativ (August - Oktober);',E'Pollen, um 20 µm;',E'Ambrosia trifida L.',E'Asteraceae',null,null,8,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (61,2,E'w 4',E'Ambrosie, false',null,E'Annual herb; VII - X;',null,null,E'Ambrosie, falsche',null,E'Einjähriges Kraut; VII - X;',null,null,E'Franseria acanthicarpa',E'Asteraceae',null,null,7,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (62,2,E'w 5',E'Absinthe',E'common wormwood;',E'Up to 1 m high, aromatic, silky hirsuite, shrubby plant; basal leaves two to three times pinnatipartite with lanceolar cusps; yellow capitulae, 2-4 mm wide and arranged like panicles; perennial; anemogamous; flowering season  VII - IX; old medicinal plant employed in a variety of ways with a strongly bitter taste; contains ethereal oils, including  the poisonous Thujon; once used to make absinth liquor; this however has not been allowed since 1923 because of the systematic side effects.',E'Inhalative (July - September);',E'Pollen, approx. 15 x 25 µm;',E'Wermut',E'Absinth;',E'Bis 1 m hohe, aromatisch duftende, seidig behaarte und strauchartig wachsende Pflanze; Grundblätter zwei- bis dreifach fiederteilig mit lanzettlichen Zipfeln; Blütenköpchen gelb, 2-4 mm breit und rispenförmig angeordnet; mehrjährig; anemogam; Blütezeit VII - IX; alte, vielfältig eingesetzte Heilpflanze mit stark bitterem Geschmack; enthält ätherische Öle, u.a. das giftige Thujon; früher zur Herstellung von Absinthlikör verwendet; dies ist jedoch wegen der systemischen Nebenwirkungen seit 1923 nicht mehr erlaubt.',E'Inhalativ (Juli - September);',E'Pollen, ca. 15 x 25 µm;',E'Artemisia absinthium L.',E'Asteraceae',null,null,7,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (63,2,E'w 6',E'Mugwort',E'Motherwort;',E'Sometimes reaching over 2 m in height, this plant has a bush-like growth with many branches; feathery leaves dark green on top and white and tomentose beneath, basal auriculate, the upper ones also are deeply serrated; capitula green to brown colored; perennial plant; anemogamous; flowering season  VII - IX; old synanthropic plant, is sometimes also used as an edible vegetable, or healing and spice plant; the cineole in the oil has an anthelmintic effect;',E'Inhalative (July - September); nutritive (Gewürz, Liköre)',E'Pollen, ca. 15 - 20 µm;',E'Beifuß, gewöhnlicher',E'Pfefferkraut, Gewürzbeifuß, Fliegenkraut;',E'Bis über 2 m hohe, strauchartig und stark verzweigt wachsende Pflanze; Fiederblätter oberseits dunkelgrün und unterseits weißfilzig, am Gunde geöhrt, zudem die oberen tief gesägt; Blütenköpfchen grünlich bis bräunlich; Pflanze mehrjährig; anemogam; Blütezeit VII - IX; alter Kulturbegleiter, wird zuweilen auch als Gemüse-, Heil- und Gewürzpflanze eingesetzt; das im Öl enthaltene Cineol besitzt wurmtreibende Wirkung;',E'Inhalativ (Juli - September); nutritiv (Gewürz, Liköre)',E'Pollen, ca. 15 - 20 µm;',E'Artemisia vulgaris L.',E'Asteraceae',null,null,7,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (64,2,E'w 7',E'Daisy, moon',E'Leucanthemum vulgare Lam.; ox-eye daisy',E'Herbaceous plant, 20 - 100 cm high; pinnatipartite leaves; flowers arranged in large, up to 5 cm wide captiulae; these sit at the end of a stem and are composed of yellow tubular florets and white  ligulate ray flowers; perennial; entomogamous; flowering season: V - X; very diverse group of species, so far still with insufficient subdivisions; often cultivated as an ornamental plant, as are several other species of the genus; occasionally also used as a medicinal plant (effect spasmolytic and diuretic);',E'Inhalative (May - October);',E'Pollen, 20 - 30 µm;',E'Margerite',E'Leucanthemum vulgare Lam.;\nMarguerite, Wiesenwucherblume, Gewöhnliche Wucherblume, Orakelblume;',E'Pflanze krautig, 20 - 100 cm hoch werdend; Blätter fiederteilig; Blüten in großen, bis über 5 cm breiten Köpfchen angeordnet; diese einzeln am Ende eines Stengels sitzend, aus gelben Röhrenblüten und weißen Zungenblüten zusammengesetzt;\nmehrjährig; entomogam; Blütezeit: V - X; sehr formenreiche Sammelart mit noch unzureichender Untergliederung; wie einige andere Arten der Gattung häufig als Zierpflanze kultiviert; gelegentlich auch als Heilpflanze in Gebrauch (Wirkung spasmolytisch u. diuretisch);',E'Inhalativ (Mai - Oktober);',E'Pollen, 20 - 30 µm;',E'Chrysanthemum leucanthemum L',E'Asteraceae',null,null,5,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (65,2,E'w 8',E'Dandelion',E'About 140 subspecies are summerized as the group T.-officinale. Classificating literature utilizes very different systems and names for groups and species.',E'Plant with cross-cut saw shaped leaves in basilar leaf rosettes and a straight, fleshy root; all parts with milky sap; stalk 5 - 40 cm high, unbranched, tubular, hollow and with only one capitulum; this is 3 -5 cm wide and consists only of yellow ligulate ray flowers; fruit with a stem on which a tuft of hair is situated (pappus) so as to be dispersed by the wind (anemochory)  (headword: parachute, dandelion-clock); perennial; entomogamous  (bee pasture); flowering season: III - VII; medicinal plant and vegetable;',E'Inhalative (March - July); ingestive (mixed honeys, dandelion honey);',E'Pollen, approx. 35 µm;',E'Löwenzahn',E'Kuhblume;\nEtwa 140 Kleinarten werden zur T.-officinale-Gruppe zusammengefaßt.\nDie Bestimmungsliteratur gibt höchst unterschiedliche Systeme, Gruppen- und Artnamen an.',E'Pflanze mit schrotsägeförmigen Blättern in grundständiger Blattrosette und pfahlförmiger, fleischiger Wurzel; alle Teile mit Milchsaft; Infloureszenzschaft 5 - 40 cm hoch, blattlos, röhrig, hohl und mit nur einem Blütenkörbchen; dieses 3 -5 cm breit und nur mit gelben Zungenblüten; Früchte mit Stiel (Schnabel) und einem darauf sitzenden Haarbüschel (Pappus) zur Windverbreitung (Stichwort: Fallschirm, Pusteblume); mehrjährig; entomogam (Bienenweide); Blütezeit: III - VII; Heil- und Gemüsepflanze;',E'Inhalativ (März - Juli);\nIngestiv (Mischhonige, Löwenzahnhonig);',E'Pollen, ca. 35 µm;',E'Taraxacum officinale Wiggers',E'Asteraceae',null,null,3,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (66,2,E'w 9',E'Plantain, English',E'Ribwort',E'Plant with lanceolar, distinctly 3 to 7 nervate, approx. 20 cm long leaves in a basilar rosette; inflorescene developed as a seed head, its shaft 15 - 50 cm high, sulcate and without leaves; the individual flowers inconspicuous; anemogamous; perennial; flowering season: V - IX; good forage plant; medicinal plant;',E'Inhalative (May bis September);',E'Pollen, approx. 20 µm;',E'Wegerich, Spitz-',null,E'Pflanze mit lanzettlichen, deutlich 3- bis 7-nervigen, ca. 20 cm langen Blättern in grundständiger Rosette; Schaft der als Ähre ausgebildeten Influreszenz 15 - 50 cm hoch, gefurcht und blattlos; die einzelnen Blüten unscheinbar; anemogam; mehrjährig; Blütezeit: V - IX; gute Futterpflanze; Heilpflanze;',E'Inhalativ (Mai bis September);',E'Pollen, ca. 20 µm;',E'Plantago lanceolata L.',E'Plantaginaceae',null,null,5,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (67,2,E'w 10',E'Goose-foot',null,E'Reaching a height of up to one meter, this is a strongly dendric annual herb with diamond-shaped to lanceolar, sometimes slightly three-lobed leaves; the plant is usually white-mealy pruinose in its entirety, but especially in the inflorescence area; flower heads clustered and pyramid-shaped; blossoms green colored and inconspicuous; flowering season : V - X; a pionieer plant with roots reaching a into depth of up to one meter; a synanthropic plant since the Neolithic period because of its use as a vegetable and a source of meal;',E'Inhalative (May - October);',E'Pollen, approx. 30 µm;',E'Gänsefuß, weißer',null,E'Bis ein Meter hoch werdendes, stark verästeltes, einjähriges Kraut mit rautenförmigen bis lanzettlichen, zuweilen schwach dreilappigen Blättern; Pflanze im Ganzen, besonders jedoch der Influreszenzbereich meist weißmehlig bereift; Blütenstände knäuelig und pyramidenförmig; Blüten grünlich und unscheinbar; anemogam; Blütezeit: V - X; bis ein Meter tief wurzelnde Pionierpflanze; Kulturbegleiter seit der Jungsteinzeit wegen der Nutzung als Gemüsepflanze und als Mehlfrucht;',E'Inhalativ (Mai - Oktober);',E'Pollen, ca. 30 µm;',E'Chenopodium album L.',E'Chenopodiaceae',null,null,5,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (68,2,E'w 12',E'Goldenrod, European',null,E'Reaching a height of up to 20 - 100 cm, this perennial plant has elongated, alternate, undivided and serrated leaves, a 7 - 8 mm long flowerhead, 10 - 15 mm in diameter and with 5 - 8 yellow ligulate ray flowers in dense,  upright, pyramid-shaped, secundiflorous, nodding panicles; entomogamous and autogamous; flowering season : VII - X; as a drug its effect is diuretic, spasmolytic and hypotensive ;',E'Inhalative (July - October);',E'Pollen, approx. 25 µm;',E'Goldrute, echte',null,E'20 - 100 cm hoch werdende, mehrjährige Pflanze mit länglichen, wechselständigen, ungeteilten und gesägten Blättern; Blütenköpfchen 7 - 8 mm lang, 10 - 15 mm im Durchmesser und mit 5 - 8 gelben Zungenblüten in dichten, aufrechten pyramidenförmigen, einseitswendigen, nickenden Rispen; entomogam und autogam; Blütezeit: VII - X; wirkt als Droge diuretisch, spasmolytisch und blutdrucksenkend;',E'Inhalativ (Juli - Oktober);',E'Pollen, ca. 25 µm;',E'Solidago virgaurea L.',E'Asteraceae',null,null,7,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (69,2,E'w 14',E'Amaranth, coarse-haired',E'Coarse-haired foxtail;',E'Up to 80 cm in height, annual herb with egg-shaped to elongated, gray downy leaves and green, totally inconspicuous blossoms in single, thick, cone-shaped panicle; flowering time: VI - IX;',E'Inhalation (June - September);',E'Pollen, approx. 25 µm;',E'Amaranth, rauhhaariger',E'Rauhhaariger Fuchsschwanz;',E'Bis 80 cm hohes, einjähriges Kraut mit eiförmigen bis länglichen, grauflaumigen Blättern und grünlichen, völlig unscheinbaren Blüten in endständiger, dichter, kegelförmiger Rispe; Blütezeit: VI - IX;',E'Inhalativ (Juni - September);',E'Pollen, ca. 25 µm;',E'Amaranthus retroflexus L.',E'Amaranthaceae',null,null,6,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (70,2,E'w 15',E'Orach',null,E'Reaching a height of 20 to 150 cm, these annual herbs are sometimes silvery-mealy and make a patulous (widespreading) impression; leaves elongated to a point, usually serrated or sinuate (cleft); flowers greenish, inconspicuous, clustered, in false spikes; entomogamous and autogamous; flowering season: VI - X; occasionally some species are cultivated as vegetable plants.',E'Inhalative (June - October);',E'Pollen, approx. 20 µm;',E'Melde',null,E'20 bis 150 cm hoch werdende, sparrig wirkende, einjährige und zuweilen mehlig bestäubte Kräuter; Blätter länglich zugespitzt, meist gezähnt oder gebuchtet; Blüten grünlich, unscheinbar, knäuelig gehäuft, in Scheinähren; entomogam und autogam; Blütezeit: VI - X; selten werden manche Arten noch als Gemüsepflanzen kultiviert.',E'Inhalativ (Juni - Oktober);',E'Pollen, um 20 µm;',E'Atriplex L.',E'Chenopodiaceae',null,null,6,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (71,2,E'w 16',E'Sumpseed, rough',E'Iva annua L., Iva caudata;',E'Annual herb with long-stemmed, serrated leaves that are opposite in the lower area; greenish-white, small capitula, in an inflorescence made up of several false spikes; anemogamous and entomogamous; flowering season : VII - X;',E'Inhalative (July - October);',E'Pollen;',E'Schlagkraut',E'Iva annua L., Iva caudata;',E'Einjäriges Kraut mit lang gestielten, gezähnten und im unteren Bereich gegenständigen Blättern; Blüten in grünlich-weißen, kleinen Köpfchen; diese in einem aus mehreren Scheinähren zusammengesetzten Blütenstand; anemogam und entomogam; Blütezeit: VII - X;',E'Inhalativ (Juli - Oktober);',E'Pollen;',E'Iva ciliata',E'Asteraceae',null,null,7,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (72,2,E'w 17',E'Aster, China',E'Aster chinensis; summer aster;',E'Reaching a height of up to 10 - 80 cm , this is an annual herb with entire alternate leaves and up to 40 - 80 mm wide, single, terminal, double (depending on the type) capitula; entomogamous; flowering season : VIII - X; ornamental plant, with numerous  types and variations of color. (white, cream, pink, red and violet);',E'Inhalative (August - October);',E'Pollen;',E'Aster, Garten-',E'Aster chinensis;\nSommeraster;',E'10 - 80 cm hoch werdendes, einjähriges Kraut mit ungeteilten, wechselständigen Blättern und 40 - 80 mm breiten, einzelnen, endständigen, je nach Sorte auch gefüllten Blütenköpfchen; entomogam; Blütezeit: VIII - X; Zierpflanze, in zahlreichen Sorten und Farbvarianten (Weiß, Creme, Rosa, Rot u. Violett);',E'Inhalativ (August - Oktober);',E'Pollen;',E'Callistephus chinensis (L.) Nees',E'Asteraceae',null,null,8,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (73,2,E'w 18',E'Dock, curly; sorrel., garden; s., sheep',E'to 2: Acetosa pratensis Mill.; to 3: Acetosella vulgaris (Koch) Fourr.;',E'Perennial plant reaching a height of 5 - 100 cm, with alternate, entire, heart-shaped to lanceolar leaves, with a tunicate fistula (ochrea) enclosing the base; leaves taste sour because of the oxalic acid they contain; flowers relatively inconspicuous, small, white to reddish in terminal, seed-head like inflorescence; anemogamous; flowering seasons: V - VIII; fruit three-cornered (cf. buckwheat);  sometimes vegetable and soup plant; extraction of potassium oxolate for the removal of blood and rust stains.',E'Inhalative (May - August);',E'Pollen, approx. 20 - 35 µm;',E'Sauerampfer, krauser; S., großer; S., kleiner',E'Zu 2: Acetosa pratensis Mill.;\nZu 3: Acetosella vulgaris (Koch) Fourr.;\nAmpfer;',E'5 - 100 cm hoch werdende, mehrjährige Pflanze mit wechselständigen, ungeteilten, herzförmigen bis spießförmigen Blättern, die am Grunde eine stängelumfassende, häutige Röhre (Ochrea) besitzen; Blätter durch die enthaltene Oxalsäure sauer schmeckend; Blüten relativ unscheinbar, klein, weiß bis rötlich in endständigen, ährig zusammengesetzten Blütenständen; anemogam; Blütezeit: V - VIII; Früchte dreikantig (vgl. Buchweizen); gelegentlich Gemüse und Suppenpflanze; Gewinnung von Kaliumoxalat zur Blut- und Rostfleckenentfernung.',E'Inhalativ (Mai - August);',E'Pollen, ca. 20 - 35 µm;',E'Rumex crispus L., R. acetosa L., R. acetosella L.',E'Polygonaceae',null,null,5,8,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (74,2,E'w 19',E'Parietaria',E'Parietaria erecta Mert. & Koch;',E'Reaching a height of 20 -100 cm , this sparsely branching perennial plant has alternate, large, longish to egg-shaped leaves with a glass-like shine; flowers in inconspicuous seed balls; anemogamous; flowering season  VI - IX; used to be officinal (Herba parietariae) as a divretic agent, wound healing, rheumatism and cough remedy;',E'Inhalative (June - September);',E'Pollen, 12 - 17 µm;',E'Glaskraut, aufrechtes',E'Parietaria erecta Mert. & Koch;',E'20 -100 cm hoch werdende, spärlich verzweigte, mehrjährige Pflanze mit wechselständigen, großen, länglichen bis eiförmigen Blättern, die glasartig glänzen; Blüten unscheinbar, knäuelig gehäuft; anemogam; Blütezeit VI - IX; früher offizinell (Herba parietariae) als Diureticum, Wundheil-, Rheuma- und Hustenmittel;',E'Inhalativ (Juni - September);',E'Pollen, 12 - 17 µm;',E'Parietaria officinalis L.',E'Urticaceae',null,null,6,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (75,2,E'w 20',E'Nettle, stinging',null,E'Reaching 0.5 - 2 m of height, this perennial plant with few branches is completely covered, and thus armed, with stings; it has largely (roughly) serrated leaves, running to a long tip (apiculated) and heart-formed at the base; flowers small and inconspicuous in hanging panicles; anemogamous; flowering season : VI - X; nitrogen or, in forests, humidity indicator; leaves are used as greens, medicinal tea and coloring agent; substitute fiber plant (stem);',E'Inhalative (June - October);',E'pollen, approx. 15 µm;',E'Brennessel, große',null,E'0,5  - 2 m hoch werdende, mehrjährige, wenig verzweigte und im Ganzen mit Brennhaaren bewehrte Pflanze mit grob gesägten, lang zugespitzten und am Grunde herzförmigen Blättern; Blüten klein und unscheinbar, in hängenden Rispen; anemogam; Blütezeit: VI - X; Stickstoff- oder im Wald Feuchtigkeitszeiger; Blätter als Gemüse, Heiltee und Färbemittel; Ersatzfaserpflanze (Stängel);',E'Inhalativ (Juni - Oktober);',E'Pollen, um 15 µm;',E'Urtica dioica L.',E'Urticaceae',null,null,6,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (76,2,E'w 21',E'Pellitory of the wall',E'Parietaria ramiflora Moench, Parietaria diffusa Mert. & Koch, Parietaria punctata Willd.;',E'A 5 - 30 cm tall, fairly decumbent, multi-branched, perennial plant with alternate, small, egg-shaped to roundish leaves; flowers in inconspicuous seed balls; anemogamous ; flowering season  V - X;',E'Inhalative (May - October);',E'Pollen, 12 - 17 µm;',E'Glaskraut, Mauer-',E'Parietaria ramiflora Moench, Parietaria diffusa Mert. & Koch, Parietaria punctata Willd.;',E'5 - 30 cm hohe mehr niederliegende stark verzweigte, mehrjährige Pflanze mit wechselständigen, kleinen, eiförmigen bis rundlichen Blättern; Blüten unscheinbar, knäuelig gehäuft; anemogam; Blütezeit V - X;',E'Inhalativ (Mai - Oktober);',E'Pollen, 12 - 17 µm;',E'Parietaria judaica L.',E'Urticaceae',null,null,5,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (77,2,E'w 22',E'Chrysanthemum',E'Dendranthema indicum (L.) Desm., Chrysanthemum japonicum Thunb., Dendranthema x hortorum, Chrysanthemum x hortorum;',E'A semi-shrub, reaching up to 25 to 150 cm depending on the type, this perennial ornamental plant with grey-green, largely lobed leaves and multicolored, usually paniclly piled, double capitula with a diameter of up to 20 cm; flowering season in the wild IX - XII; the various types are categorized into different groups. One differentiates between the "indicum", the "koreanum" and the "rubellum group".',E'Inhalative outdoors in the open (September - December) or as cut flowers (i.e. all year around);',E'Pollen, approx. 35 µm;',E'Chrysantheme',E'Dendranthema indicum (L.) Desm., Chrysanthemum japonicum Thunb., Dendranthema x hortorum, Chrysanthemum x hortorum;',E'Halbstrauchige, je nach Sorte 25 bis 150 cm hoch werdende, mehrjährige Zierpflanze mit graugrünen, grob-gelappten Blättern und vielfarbigen, meist rispig gehäuften, gefüllten und bis 20 cm im Durchmesser großen Blütenköpfchen; Blütezeit im Freiland IX - XII;  Die einzelnen Sorten werden in verschiedene Gruppen eingeordnet. Man unterscheidet die "Indicum-", die "Koreanum-" und die "Rubellumgruppe".',E'Inhalativ im Freiland (September - Dezember) oder bei Schnittblumen (ggf. ganzjährig);',E'Pollen, ca. 35 µm;',E'Chrysanthemum indicum L. div. var.',E'Asteraceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (78,2,E'w 23',E'Dahlia',E'Dahlia variabilis Hort.;',E'Depending on the type, this perennial ornamental plant reaches a height of 30 - 250 cm; leaves pinnatifid, with serrated sections; types with double or single flowers can reach a diameter up to 30 cm; flowering season : VII - XI; The various types are categorized into different groups. One differentiates between anemonen-flowered dahlia, "Halskraus" dahlia, cactus dahlia, "Mignon" dahlia, pompon dahlia and "Schmuck" dahlien (ornamental dahlia).',E'Inhalative in the open (July - November) or for cut flowers occasionally outside of this time period;',E'Pollen;',E'Dahlie',E'Dahlia variabilis Hort.;\nGeorgine;',E'Je nach Sorte 30 - 250 cm hoch werdende mehrjährige Zierpflanze; Blätter fiederspaltig, mit gezähnten Abschnitten;\nSorten mit gefüllten oder nicht gefüllten Blüten, die im Durchmesser bis zu 30 cm groß sein können; Blütezeit: VII - XI; Die einzelnen Sorten werden in verschiedene Gruppen eingeteilt. Man unterscheidet anemonenblütige Dahlien, Halskrausendahlien, Kaktusdahlien, Mignondahlien, Pompondahlien und Schmuckdahlien.',E'Inhalativ im Freiland (Juli  - November) oder bei Schnittblumen gelegentlich außerhalb dieses Zeitraums;',E'Pollen;',E'Dahlia x cultorum Thorsr. & Reis',E'Asteraceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (79,2,E'w 24',E'Alfalfa, lucerne',null,E'A 20 to 80 cm high, perennial  plant with odd-pinnated leaves; flowers about 1 cm long, blue or violett, sometimes also white-colored, greenish or yellowish; entomogamous  (bee pasture) and autogamous; flowering season: V - IX; the pods are curled up into a spiral in two to three loose bends; cultivated plant since early ancient times, originating from Near East; rich feed source; a nitrogen collector with roots reaching up to 5 m into the earth;',E'Inhalative (May - September);',E'Pollen, approx. 30 x 35 µm;',E'Luzerne',null,E'20 bis 80 cm hohe, mehrjährige Pflanze mit unpaarig gefiederten Blätten; Blüten um 1 cm lang, blau oder violett, zuweilen auch weißlich, grünlich oder gelblich; entomogam (Bienenweide) und autogam; Blütezeit: V - IX; die Hülsenfrüchte sind mit zwei bis drei lockeren Windungen spiralich eingerollt; Kulturpflanze seit der frühen Antike, aus dem vorderen Orient stammend; wertvolle Futterpflanze; bis 5 m tief wurzelnder Stickstoffsammler;',E'Inhalativ (Mai - September);',E'Pollen, ca. 30 x 35 µm;',E'Medicago sativa L.',E'Fabaceae',null,null,5,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (80,2,E'w 25',E'Chamomille, German',E'Matricaria chamomilla auct., non L., Chamomilla recutita (L.) Rausch.',E'Reaching a height of 15 - 40 cm, this annual herb has bipinnafid leaves with lineal pinnules; flower-head in the center with yellow tubular florets and a circle of white ligulate ray flowers around the edge; entomogamous (flies); flowering season  V - IX; a cultivated plant since the Neolithic period; old medicinal plant with a characteristic scent;',E'Inhalative out in the open (V - IX); inhalative via steam baths (= chamomille flower extract); ingestive (tea = chamomille flower extract);',E'Pollen;',E'Kamille, echte',E'Matricaria chamomilla auct., non L.,\nChamomilla recutita (L.) Rausch.',E'15 - 40 cm hohes, einjähriges Kraut mit doppelt gefiederten Blättern, Fiederchen lineal; Blütenköpfchen im Zentrum mit gelben Röhrenblüten und am Rande mit einem Kreis weißer Zungenblüten; entomogam (Fliegen); Blütezeit V - IX; Kulturbegleiter seit der Jungsteinzeit; alte Arzneipflanze mit charakteristischem Duft;',E'Inhalativ im Freiland (V - IX);\nInhalativ bei Dampfbädern (= Kamilleblütenextrakt);\nIngestiv (Tee = Kamilleblütenextrakt);',E'Pollen;',E'Matricaria recutita L.',E'Asteraceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (81,2,E'w 26',E'Lent lily',E'Tenby daffodil;',E'Up to 15 - 30 cm high, bulbiferous shrub with baslilar, steeply rising, lanceolar and entire leaves; sulphur-yellow petals, spread in a star and with a cup-shaped, elongated corona; entomogamous  (bumble-bee flower); flowering season  III - V; ornamental plant; poisonous; plants occuring in the wild are protected;',E'Inhalative (March - May);',E'Pollen, approx. 30 x 60 µm;',E'Narzisse, gelbe',E'Osterglocke;',E'15 - 30 cm hohe Zwiebelstaude mit grundständigen, steil aufragenden, lanzettlichen und ganzrandigen Blättern; Blütenkronblätter schwefelgelb, sternförmig ausgebreitet und mit becherförmig verlängerter Nebenkrone; entomogam (Hummelblume); Blütezeit III - V; Zierpflanze; giftig; wild vorkommende Pflanzen sind geschützt;',E'Inhalativ (März - Mai);',E'Pollen, ca. 30 x 60 µm;',E'Narcissus pseudonarcissus L.',E'Amaryllidaceae',null,null,3,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (82,2,E'w 28',E'Rose, Japanese',null,E'Bushes usually no more than a meter in height with dense, bristly, odd-pinnated, very rugose leaves, tomentose underneath; flowers reddish to red, rarely white, usually single-flowered; flowering season V - VII; fruit (rosehips) large, suited for the production of jams and wine;',E'Inhalative (May - July); ingestive (mixed honeys);',E'Pollen;',E'Rose, Kartoffel-',null,E'In der Regel nicht mehr als ein Meter hoch werdende Sträucher mit dicht stachelborstigen Zweigen, unpaarig gefiederten, stark runzeligen und unterseits filzigen Blättern; Blüten rötlich - rot, selten weiß, meist ungefüllt; Blütezeit V - VII; Früchte (Hagebutten) groß, zur Marmeladen- und Weinherstellung geeignet;',E'Inhalativ (Mai - Juli);\nIngestiv (Mischhonige);',E'Pollen;',E'Rosa rugosa Thunb.',E'Rosaceae',null,null,5,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (83,2,E'w 29',E'Sunflower, common',null,E'Reaching a height of up to 2.5 m, this annual plant has a  hirsute shoot axis with alternate, heart-shaped leaves; buttons up to  40 cm wide, with an outer circle of yellow ligulate ray flowers; entomogamous (bee pasture); flowering season VII - X; seeds important oil crop;',E'Inhalative (July - October); ingestive (sunflower honey, late summer mixed honeys);',E'Pollen, approx. 35 µm;',E'Sonnenblume, gewöhnliche',null,E'Bis 2,5 m hoch werdende, einjährige Pflanze mit rauhhaariger Sprossachse; Blätter wechselständig, herzförmig; Blütenköpfe bis 40 cm breit, im äußeren Kreis gelbe Zungenblüten; entomogam (Bienenweide); Blütezeit VII - X; Samen wichtige Ölfrucht;',E'Inhalativ (Juli - Oktober);\nIngestiv (Sonnenblumenhonig, Spätsommer-Mischhonige);',E'Pollen, ca. 35 µm;',E'Helianthus annuus L.',E'Asteraceae',null,null,7,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (84,2,E'w 30',E'Tulpip, garden',null,E'Reaching a height of 30 to 60 cm, this is a buliferous, perennial shrub of great variety with basilar, errect, wide-lanceolar; petals calyx-shaped, blunt or pointed, sometimes fringed, in all colors except blue and black; entomogamous; flowering season  IV - V; diverse ornamental plant in many types;',E'Inhalative (April - May);',E'Pollen, approx. 40 µm;',E'Tulpe, Garten-',null,E'30 bis 60 cm hoch werdende, sortenreiche Zwiebelstaude mit grundständigen, aufragenden, breit-lanzettlichen und ganzrandigen Blättern; Blütenblätter kelchförmig, stumpf oder spitzlich, zuweilen gefranst, mit Ausnahme von blau und schwarz in allen Farben; entomogam; Blütezeit IV - V; formenreiche Zierpflanze;',E'Inhalativ (April - Mai);',E'Pollen, ca. 40 µm;',E'Tulipa gesnerana L.',E'Liliaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (85,2,E'w 32',E'Rape, oilseed',E'Coleseed rape',E'Up to 2 m high, this annual to biennial herb becomes very patulous (widespreading) with age; it has smooth, blue-green pruinose leaves and yellow flowers in clusters; these commence to blossem from the bottom upwards, thus the buds project above the already blooming flowers; partly entomogamous (very good bee pasture); for seeding in the previous year flowering season: IV - V, when the seeding takes place in the spring: VIII - X; deep-rooting plant, important oil crop; source material for margarine; recently also used to produce fuel;',E'Inhalative (April - May and August - October); ingestive ( rape honey, mixed honeys);',E'Pollen, approx. 20 x 40 µm;',E'Raps',null,E'Bis 2 m hohes und bei der Reife sehr sparriges, ein- bis zweijähriges Kraut mit glatten, blaugrün bereiften Blättern und goldgelben, traubig angeordneten Blüten; Trauben von unten nach oben hin aufblühend, daher Blütenknospen die bereits geöffneten Blüten überragend; teilweise entomogam (sehr gute Bienenweide); Blütezeit bei Aussaat im Vorjahr: IV - V, bei Aussaat im Frühjahr: VIII - X; Tiefwurzler; wichtige Ölfrucht; Margarinegrundstoff; heute auch zur Treibstoffgewinnung;',E'Inhalativ (April - Mai und August - Oktober);\nIngestiv (Rapshonig, Mischhonige);',E'Pollen, ca. 20 x 40 µm;',E'Brassica napus L. ssp. Napus',E'Brassicaceae',null,null,4,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (86,2,E'w 35',E'Geranium, bedding',E'geranium, zonal pelargonium;',E'Up to approx. 50 cm in height, frost-sensitive semishrub with sinuated but undivided leaves; flowers in many colors, umbellarly heaped towards the end of the inflorescence stem; partly entomgomous ; flowering season : VI - X; main inhalation substance is geraniol – not to be confused with geranium oil, which is occasionally listed under the same name - , one of the most frequently used compounds in the perfume industry;',E'Inhalative (June - October);',E'Pollen, approx. 80 µm;',E'Geranie, gewöhnliche',E'Pelargonie;',E'Ca. 50 cm hoch werdender, frostempfindlicher Halbstrauch mit eingebuchteten aber ungeteilten Blättern; Blüten in vielen Farben, am Ende des Influreszenzstiels doldig gehäuft; teilweise entomogam; Blütezeit: VI - X; Hauptinhaltsstoff ist  Geraniol - nicht zu verwechseln mit Geraniumöl, das gelegentlich unter dem gleichen Namen geführt wird - , eine der meist verwendeten Verbindungen in der Parfümindustrie;',E'Inhalativ (Juni - Oktober);',E'Pollen, ca. 80 µm;',E'Pelargonium zonale (L.) L´Herit. ex Aiton',E'Geraniaceae',null,null,6,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (87,2,E'w 36',E'Primrose',E'Schlüsselblume, Gartenaurikel;',E'Reaching a height of approx. 30 cm, this is a tenacious plant with more or less entire and rosette-like leaves; flowers in many colors clustered at the end of the inflorescence stem; entomogamous; flowering season: IV - VII;',E'Inhalative (April - July);',E'Pollen, approx. 25 x 35 µm;',E'Primel',E'Schlüsselblume, Gartenaurikel;',E'Ca. 30 cm hoch werdende, ausdauernde Pflanze mit mehr oder weniger ganzrandigen und rosettenartig angeordneten Blättern; Blüten in vielen Farben am Ende des Influreszenzstiels knäuelig gehäuft; entomogam; Blütezeit: IV - VII;',E'Inhalativ (April - Juli);',E'Pollen, ca. 25 x 35 µm;',E'Primula hortensis Wettst.',E'Primulaceae',null,null,4,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (88,2,E'w 40',E'Hyazinth',null,E'Reaching a height of approx. 20 to 30 cm, this is an intensely fragrant bulbiferous shrub with basilar, erect, lanceolar and entire leaves; inflorescense racemiform; flowers cup-shaped, originally dark blue – as of recently there are also white and red-colored types; entomogamous; flowering season  IV - VI; very aromatic ornamental shrub; the oil is employed in the perfume industry;',E'Inhalative (April - June); occasionally also at other times in the florist trade;',E'Pollen;',E'Hyazinthe',null,E'Ca. 20 bis 30 cm hoch werdende, stark duftende Zwiebelstaude mit grundständigen, aufragenden, lanzettlichen und ganzrandigen Blättern; Influreszenz traubig; Blüten becherförmig, ursprünglich dunkelblau - neuerdings gibt es auch weiße und rötliche Sorten; entomogam; Blütezeit IV - VI; stark duftende Zierpflanze; Verwendung des Öls in der Parfümindustrie;',E'Inhalativ (April - Juni); im Floristikbereich gelegentlich auch zu anderer Zeit;',E'Pollen;',E'Hyacinthus orientalis L.',E'Liliaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (89,9,E'd 1',E'Dermatophagoides pteronyssinus; house dust mite',E'Mealia toxopei Oudemans, Visceroptes saitoi Sasa; European house dust mite, bed mite;',E'House dust mites are tiny, eight-legged arachnids from 0.2 to 0.4 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. Morphologically, there are only microscopic differences between the three Dermatophagoides species.',E'Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.',E'Excrement balls; patient.allergens in the finest dust',E'Dermatophagoides pteronyssinus; Hausstaubmilbe',E'Mealia toxopei Oudemans, Visceroptes saitoi Sasa;\nEuropäische Hausstaubmilbe, Bettmilbe;',E'Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,4 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Morphologisch bestehen nur mikroskopische Unterschiede zwischen den drei Dermatophagoidesarten.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.',E'Kotballen; Allergene im Feinstaub',E'Dermatophagoides pteronyssinus Trouessart',E'Pyroglyphidae',E'Acari, Milben',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (90,9,E'd 2',E'Dermatophagoides farinae; house dust mite',E'Dermatophagoides culinae De Leon; American house dust mite, bed mite;',E'House dust mites are tiny, eight-legged arachnids from 0.2 to 0.4 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. Morphologically, there are only microscopic differences between the three Dermatophagoides species.',E'Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.',E'Excrement balls; patient.allergens in the finest dust',E'Dermatophagoides farinae; Hausstaubmilbe',E'Dermatophagoides culinae De Leon;\nAmerikanische Hausstaubmilbe, Bettmilbe;',E'Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,4 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Morphologisch bestehen nur mikroskopische Unterschiede zwischen den drei Dermatophagoidesarten.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.',E'Kotballen; Allergene im Feinstaub',E'Dermatophagoides farinae Hughes',E'Pyroglyphidae',E'Acari, Milben',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (91,9,E'd 3',E'Dermatophagoides microceras; house dust mite',E'bed mite;',E'House dust mites are tiny, eight-legged arachnids from 0.2 to 0.4 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. Morphologically, there are only microscopic differences between the three Dermatophagoides species. Because of its very strong similarity to Dermatophagoides farinae Hughes, this species was first discovered in 1971 as a separate species and was previously probably often overlooked.',E'Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.',E'Excrement balls; patient.allergens in the finest dust',E'Dermatophagoides microceras; Hausstaubmilbe',E'Bettmilbe;',E'Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,4 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Morphologisch bestehen nur mikroskopische Unterschiede zwischen den drei Dermatophagoidesarten. Diese Art ist wegen ihrer starken Ähnlichkeit zu Dermatophagoides farinae Hughes erst 1971 als eigenständige Art beschrieben worden und ist wahrscheinlich bisher auch oft übersehen worden.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.',E'Kotballen; Allergene im Feinstaub',E'Dermatophagoides microceras Griffith & Cunnington',E'Pyroglyphidae',E'Acari, Milben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (92,9,E'd 74',E'Euroglyphus maynei; house dust mite',E'Mealia maynei Cooreman; Dermatophagoides maynei Hughes;',E'House dust mites are tiny, eight-legged arachnids from 0.2 to 0.3 mm in length. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. The morphologically most conspicuous difference with the three Dermatophagoides species is that there are no four long train hairs on the abdomen end.',E'Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.',E'Excrement balls; patient.allergens in the finest dust',E'Euroglyphus maynei; Hausstaubmilbe',E'Mealia maynei Cooreman; Dermatophagoides maynei Hughes;',E'Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,3 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Der morphologisch auffälligste Unterschied zu den drei Dermatophagoidesarten besteht darin, dass sich am Hinterleibsende keine vier langen Schlepphaare befinden.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.',E'Kotballen; Allergene im Feinstaub',E'Euroglyphus maynei Cooreman',E'Pyroglyphidae',E'Acari, Milben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (93,9,E'd 70',E'Acarus siro; food mite',E'Acarus siro var. farinae L., Aleurobius farinae var. africana Oudemans; flour mite;',E'These food mites are tiny, eight-legged arachnids from 0.3 to 0.7 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can recognize on the back a body an incision between the second and third pair of legs. The males possess tarsal and anal suckers, the females a claw at the end of each foot. Furthermore, the males possess a clearly expressed hook-like extension at the thigh of the first leg pair. Both sexes possess four long dragged hairs on the back end. The body color is shining white; the mandibles and the legs, depending upon their nourishment, are colored yellow to brown. The mandibles together with their feelers resemble tongs or tweezers.',E'Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours',E'Probably proteins in the excrement;',E'Acarus siro; Vorratsmilbe',E'Acarus siro var. farinae L., Aleurobius farinae var. africana Oudemans;\nMehlmilbe;',E'Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,7 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man auf der Rückseite einen Körpereinschnitt zwischen dem zweiten und dritten Beinpaar. Die Männchen besitzen Tarsal- und Analsaugnäpfe, die Weibchen eine Kralle an jedem Fußende. Zusätzlich besitzen die Männchen am Schenkel des ersten Beinpaares unterseits einen deutlich ausgeprägten hakenförmigen Fortsatz. Beide Geschlechter besitzen am Hinterende vier lange Schlepphaare. \nDie Körperfarbe ist glänzend weiß; dagegen sind die Mundwerkzeuge und die Beine in Abhängigkeit von der Nahrung gelblich bis braun gefäbt. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen',E'Wahrscheinlich Proteine im Kot;',E'Acarus siro L.',E'Acaridae',E'Acari, Milben',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (94,9,E'd 71',E'Lepidoglyphus destructor; food mite',E'Acarus destructor Schrank, Acarus spinipes Koch, Glycyphagus anglicus Hull, Lepidoglyphus cadaverum Türk & Türk, Glycyphagus destructor Hughes;',E'These food mites are tiny, eight-legged arachnids from 0.3 to 0.6 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can notice that the body has no incision between the second and the third leg pairs. The males possess no suction pads; by the females, a short copulation pipe is visible. For both sexes, the body bristles are very long and feathery. A certain way of distinguishing between Gylcyphagus domesticus De Geer is an inserted, elongated, and pointed scale on the end limb of the legs with short haired surface. Nevertheless, the scale is difficult to recognize if it is not spread out but laid out along the last leg limb.',E'Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours',E'Probably proteins in the excrement;',E'Lepidoglyphus destructor; Vorratsmilbe',E'Acarus destructor Schrank, Acarus spinipes Koch, Glycyphagus anglicus Hull, Lepidoglyphus cadaverum Türk & Türk, Glycyphagus destructor Hughes;',E'Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,6 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man, dass der Körper keinen Einschnitt zwischen dem zweiten und dritten Beinpaar besitzt. Die Männchen besitzen keine Saugnäpfe; bei den Weibchen ist eine kurze Kopulationsröhre sichtbar. Bei beiden Geschlechtern sind die Körperborsten sehr lang und gefiedert. Ein sicheres Unterscheidungsmerkmal zu Gylcyphagus domesticus De Geer ist eine am Endglied der Beine inserierende, längliche und spitz zulaufende Schuppe mit kurzhaariger Oberfläche. Allerdings ist die Schuppe schwer zu erkennen, wenn sie nicht abgespreitzt sondern dem letzten Fußglied angelegt ist.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen',E'Wahrscheinlich Proteine im Kot;',E'Lepidoglyphus destructor Schrank',E'Glycyphagidae',E'Acari, Milben',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (95,9,E'd 72',E'Tyrophagus putrescentiae; food mite',E'Acarus putrescentiae Schrank, Tyrophagus longior var. castellanii Hirst, Tyrophagus noxius Zachvatkin, Tyrophagus brauni Türk & Türk;',E'These food mites are tiny, eight-legged arachnids from 0.3 to 0.5 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can recognize on the back of the body an incision between the second and third pair of legs. The males possess strongly expressed tarsal suckers, but no hook-like extension on the thigh of the first pair of legs; the females possess a claw at the end of each foot. Both sexes clearly possess more than four long train hairs on the rear end. The body color is light. The mandibles together with their feelers resemble tongs or tweezers.',E'Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours',E'Probably proteins in the excrement;',E'Tyrophagus putrescentiae; Vorratsmilbe',E'Acarus putrescentiae Schrank, Tyrophagus longior var. castellanii Hirst, Tyrophagus noxius Zachvatkin, Tyrophagus brauni Türk & Türk;',E'Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,5 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man auf der Rückseite einen Körpereinschnitt zwischen dem zweiten und dritten Beinpaar. Die Männchen besitzen stark ausgeprägte Tarsalsaugnäpfe, jedoch keine hakenförmigen Fortsätze am Schenkel des ersten Beinpaares; die Weibchen besitzen eine Kralle an jedem Fußende. Beide Geschlechter besitzen am Hinterende deutlich mehr als vier lange Schlepphaare. \nDie Körperfarbe ist weißlich-hell. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen',E'Wahrscheinlich Proteine im Kot;',E'Tyrophagus putrescentiae Schrank',E'Acaridae',E'Acari, Milben',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (96,9,E'd 73',E'Glycyphagus domesticus, food mite',E'Acarus domesticus De Geer, Oudemansium domesticum Zachvatkin;',E'These food mites are tiny, eight-legged arachnids from 0.3 to 0.8 mm in length. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can notice that the body has no incision between the second and the third leg pairs. The males possess no suction pads; by the females, a short copulation pipe is visible. For both sexes, the body bristles are very long and feathery. A certain way of distinguishing with Lepidoglyphus destructor Schrank is the lack of a scale on the end limb of the legs. Nonetheless, the scale is hard to identify if it is not spread out but rather lies along the last leg limb.',E'Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours',E'Probably proteins in the excrement;',E'Glycyphagus domesticus, Vorratsmilbe',E'Acarus domesticus De Geer, Oudemansium domesticum Zachvatkin;',E'Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,8 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man, dass der Körper keinen Einschnitt zwischen dem zweiten und dritten Beinpaar besitzt. Die Männchen besitzen keine Saugnäpfe; bei den Weibchen ist eine kurze Kopulationsröhre sichtbar. Bei beiden Geschlechtern sind die Körperborsten sehr lang und gefiedert. Ein sicheres Unterscheidungsmerkmal zu Lepidoglyphus destructor Schrank ist eine am Endglied der Beine nicht vorhandene Schuppe. Allerdings ist die Schuppe schwer zu erkennen, wenn sie nicht abgespreitzt sondern dem letzten Fußglied angelegt ist.',E'Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen',E'Wahrscheinlich Proteine im Kot;',E'Glycyphagus domesticus De Geer',E'Glycyphagidae',E' Acari, Milben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (97,9,E'i 1',E'Bee poison',null,E'Approx. 15 - 20 mm in length multi-winged insects with yellow to brown markings and hairy body; strong incision between breast and abdomen; occur in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; queen, only flies out one or two times for mating, stinging, fertile;',E'Sting, by which 50 - 100 µg protein enters the body; while in the case of the wasp sting, the stinger only remains lodged in the victim a certain small percent of the time, for the bee it is always the case.',E'Proteins of large molecular weight in the animal’s poison;',E'Bienengift',null,E'Ca. 15 - 20 mm lange vierflügelige Insekten mit gelblich bis bräunlich gezeichnetem und behaartem Körper; starker Einschnitt zwischen Brust und Hinterleib; Auftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, fliegt nur ein- bis zweimal zur Begattung aus, stechend, fruchtbar;',E'Stich, bei dem 50 - 100 µg Protein in den Körper gelangen; während beim Wespenstich der Stachel nur in einem gewissen Prozentsatz der Fälle stecken bleibt, ist dies bei der Biene immer der Fall.',E'Hochmolekulare Proteine im Gift der Tiere;',E'Apis mellifera L.',E'Apidae',E' Hymenoptera, Hautflügler',null,3,10,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (98,9,E'i 6',E'Kitchen cockroach, German',E'Roach;',E'Approx. 10 to 13 mm in length, in the shape of a long oval, dorsal-ventrally flattened insect with feelers of more than body length, biting-chewing mandibles and of a brown color; Head hidden under the large head shield; easily distinguishable from beetles by two short tail bristles;',E'Inhalation as house dust component or sometimes ingested in polluted foodstuffs;',E'Body proteins from dead and decomposed roaches as well as proteins in the excrement;',E'Küchenschabe, deutsche',E'Kakerlake;',E'Ca. 10 bis 13 mm langes, im Umriss länglich ovales, dorsoventral abgeplattetes Insekt mit mehr als körperlangen Fühlern, beißend-kauenden Mundwerkzeugen und von bräunlicher Farbe; Kopf unter dem großen Halsschild verborgen; von Käfern durch zwei kurze Schwanzborsten gut zu unterscheiden;',E'Inhalativ als Hausstaubbestandteil oder ggf. ingestiv durch verunreinigte Lebensmittel;',E'Körperproteine abgestorbener und zerfallener Tiere sowie Proteine im Kot;',E'Blatella germanica (L.)',E'Blatellidae',E'Blattodea, Schaben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (99,9,E'i 8',E'Bumble-bee',null,E'16 - 35 mm in length, furry and seemingly plump, multi-winged insects with one or numerous colored cross markings on the breast and abdomen; Occurs in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; queen, flies only in the springtime until enough workers are available to her, stinging, fertile;',E'Sting; while for the honeybee sting, the stinger stays in the victim, for the bumble-bee this is never the case.',E'Proteins of large molecular weight in the animal’s poison;',E'Hummel',null,E'16 - 35 mm lange, pelzig behaarte und etwas plump wirkende, vierflügelige Insekten mit einem bis mehreren farbigen Querstreifen auf Brust und Hinterleib; Auftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, fliegt nur im Frühjahr bis ihr genügend Arbeiterinnen zur Seite stehen aus, stechend, fruchtbar;',E'Stich; während beim Bienenstich der Stachel immer stecken bleibt, ist dies bei der Hummel nie der Fall.',E'Hochmolekulare Proteine im Gift der Tiere;',E'Bombus (Latreille) div. spec.',E'Apidae',E'Hymenoptera, Hautflügler',null,3,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (100,9,E'i 9',E'Rice flour beetle',E'American rice flour beetle;',E'Approx. 3 to 4 mm in length, narrow, dark brown colored beetle with feelers barely 1 mm in length;',E'Inhalation as part of the house dust or possibly ingested in polluted foodstuffs;',E'Body and excrement proteins;',E'Reismehlkäfer',E'Amerikanischer Reismehlkäfer;',E'Ca. 3 bis 4 mm langer, schmaler, dunkelbraun gefärbter Käfer mit knapp 1 mm langen Fühlern;',E'Inhalativ als Hausstaubbestandteil oder ggf. ingestiv durch verunreinigte Lebensmittel;',E'Körper- und Kotproteine;',E'Tribolium confusum Jacquelin-Duval',E'Tenebrionidae',E'Coleoptera, Käfer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (101,9,E'i 71',E'Mosquito',E'Schnake;',E'Delicate mosquito of approx. 8 mm body length; The head when viewed from the side in one line with thorax and abdomen; mouth parts transformed into a stinging proboscis; males with feathery feelers, blossom seekers; females blood sucking; larvae aquatic;',E'Sting as well as inhalation (from particles of deceased individuals);',E'The sting of the female injects anti-clotting as well as other human-like substances which can result in allergic reactions.',E'Mücke',E'Schnake;',E'Zarte Mücke von etwa 8 mm Körperlänge; Kopf von der Seite betrachtet in einer Linie mit Thorax und Abdomen; Mundteile zu einem Stechrüssel umgewandelt; Männchen mit gefiederten Fühlern, Blütenbesucher; Weibchen Blutsauger; Larven aquatisch;',E'Stich und auch Inhalation (von Partikeln abgestorbener Tiere);',E'Beim Stich der Weibchen injizieren diese gerinnungshemmende und andere körpereigene Stoffe, auf die allergische Reaktionen erfolgen können.',E'Culex pipiens L.',E'Culicidae',E'Diptera, Zweiflügler',null,3,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (102,9,E'i 73',E'Red mosquito larva',E'Feather mosquitos, swarm mosquitos;',E'Very delicate mosquito of approx. 8 mm body length; from a side view with noticeably hunchbacked thorax, which covers the head when viewed from the top; mouth parts not formed to a stinging proboscis; feelers of the males strongly plumed; red, larvae up to 2 cm long and thin;',E'Inhalation;',E'Hemoglobin which is freed on the disintegration of deceased and dried out larvae, but also released  by chrysalis and imagines;',E'Rote Mückenlarve',E'Federmücken, Schwarmmücken;',E'Sehr zarte Mücke von etwa 8 mm Körperlänge; in Seitenansicht mit auffallend buckligem Thorax, der den Kopf von oben betrachtet verdeckt; Mundteile nicht zu einem Stechrüssel umgewandelt; Fühler der Männchen stark gefiedert; Larven rot, bis 2 cm lang und dünn;',E'Inhalativ;',E'Hämoglobine, die beim Zerfall abgestorbener und ausgetrockneter Larven, aber auch Puppen und Imagines frei werden;',E'Chironomus thummi',E'Chironomidae',E'Diptera, Zweiflügler',null,3,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (103,9,E'i 76',E'Museum beetle',null,E'Brown marbling and elongated oval beetle with a body length of 3 - 4 mm, in the case of danger it can fold its legs and feelers in the respective furrow and body indentations. Most commonly one confronts the beetle as a larvae or chrysalis of approx. 5 mm in length.',E'Inhalation and contact;',E'Body and excrement proteins of the individuals as well as the chemicals of the arrow hairs',E'Museumskäfer',null,E'Bräunlich marmorierter und länglich-ovaler Käfer mit einer Körperlänge von 3 - 4 mm, der bei Gefahr seine Beine und Fühler in entsprechende Rinnen und Körpervertiefungen versenken kann. Meist trifft man den Käfer als etwa 5 mm lange Larve oder Puppe an.',E'Inhalation und Berührung;',E'Körper- und Kotproteine der Tiere sowie die Chemikalien der Pfeilhaare',E'Trogoderma angustum',E'Dermestidae',E'Coleoptera, Käfer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (104,9,E'i 75',E'Hornet poison',null,E'Approx. 19 - 35 mm in length, multi-winged insects with contrasting black and yellow markings on the abdomen, red-brown colored head region and breast section and hairless body; between breast and abdomen there is the so-called wasp waist; Occur in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; queen, free flying only when establishing the nest, stinging, fertile;',E'Sting, for the approx. 100 µg protein can enter the body; while in the case of the bee the stinger always sticks in the victim and this is sometimes the case for the wasp, this never takes place for the hornet sting.',E'Proteins of large molecular weight in the animal’s poison;',E'Hornissengift',null,E'Ca. 19 - 35 mm lange, vierflügelige Insekten mit kontrastreich schwarz-gelb gezeichnetem Hinterleib, rötlich-bräunlich gefärbtem Hinterkopfbereich und Brustabschnitt und unbehaartem Körper; zwischen Brust und Hinterleib befindet sich die sogenannte Wespentaille;\nAuftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, freifliegend nur bis zur Nestgründung, stechend, fruchtbar;',E'Stich, bei dem ca. 100 µg protein in den Körper gelangen; während bei der Biene der Stachel immer stecken bleibt und dies bei der Wespe manchmal der Fall ist, kommt dies beim Hornissenstich nicht vor.',E'Hochmolekulare Proteine im Gift der Tiere;',E'Vespa crabro L.',E'Vespidae',E'Hymenoptera, Hautflügler',null,4,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (105,9,E'i 201',E'Horse fly',E'Stomach assel;',E'brown colored fly of 12 - 15 mm length and sharply tapered abdomen;',null,E'Body and excrement proteins of the larvae',E'Pferdefliege',E'Magendassel;',E'Bräunlich gefärbte Fliege von 12 - 15 mm Länge und spitz zulaufendem Hinterleib;',null,E'Körper- und Kotproteine der Larven',E'Gasterophilus intestinalis',E'Gasterophilidae',E'Diptera, Zweiflügler',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (106,9,E'i 202',E'Grain beetle, weevil',E'Calandra granaria L.;',E'Dark brown, long oval beetle with a 2,3 - 3,5 mm body length and a snout-like extended head and stunted flight wings. The neck shield is relatively large and hardly shorter than the abdomen. The wing covers and the neck shield are deep and densely dotted.',E'Ingestion with contaminated flour products; sometimes also through the inhaling of dust in mills and storage places;',E'Body and excrement proteins of the beetle; secondary consideration is also fungus proteins, since in attacked substrates it can easily lead to a fungus attack.',E'Kornkäfer, Rüsselkäfer',E'Calandra granaria L.; \nKrebsel, Klander, Kornreuter;',E'Dunkelbrauner, länglich-ovaler Käfer von 2,3 - 3,5 mm Körperlänge und einem rüsselartig ausgezogenen Kopf und verkümmerten Flugflügeln. Der Halsschid ist relativ groß und kaum kürzer als der Hinterleib. Die Flügeldecken und der Halsschild sind tief und dicht punktiert.',E'Ingestiv mit verunreinigten Mehlprodukten; ggf. auch inhalativ durch Stäube in Mühlen und Speichern;',E'Körper- und Kotproteine der Käfer; Sekundär kommen auch Pilzproteine in Frage, da es in befallenen Substraten leicht zu Pilzbefall kommt.',E'Sitophilus granarius',E'Curculionidae',E'Coleoptera, Käfer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (107,9,E'i 203',E'Flour moth',null,E'Small nondescript butterfly of 10 - 12 mm body length and 20 - 22 mm wingspan. The basic color of the front wings is of blue-gray or red-gray tone; th latter are unclearly zigzag-shaped cross bands.',E'Ingestion by polluted foodstuffs;',E'Probably excrement proteins of the caterpillar;',E'Mehlmotte',null,E'Kleiner unscheinbarer Schmetterling von 10 - 12 mm Körperlänge und 20 - 22 mm Flügelspannweite. Die Grundfarbe der Vorderflügel ist von blaugrauem oder rötlich grauem Ton; letztere sind undeutlich zickzackförmig quergebändert.',E'Ingestiv durch verunreinigte Lebensmittel;',E'Wahrscheinlich Kotproteine der Raupe;',E'Ephestia keuhniella Zeller',E'Pyralidae',E'Lepidoptera, Schmetterlinge',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (108,9,E'i 901',E'Pigeon tick',null,E'Coarse skinned, in fully bloated state - for females - up to 9 mm in length, red-brown, shield-like tick with mandibles on the bottom side which cannot be seen from the top; eight legged, since it belongs to the arachnids;',E'Sting;',E'The sting of the female injects anti-clotting as well as other human-like substances which can result in allergic reactions.',E'Taubenzecke',null,E'Derbhäutige, in vollgesogenem Zustand - nur Weibchen - bis 9 mm große, rötlich-braune, schildförmige Zecke mit von oben unsichtbaren, auf der Bauchseite liegenden Mundwerkzeugen; achtbeinig, da zu den Spinnentieren gehörig;',E'Stich;',E'Beim Stich der Weibchen injizieren diese gerinnungshemmende und andere körpereigene Stoffe, auf die allergische Reaktionen erfolgen können.',E'Argas reflexus F.',E'Argasidae',E' Acari, Milben',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (109,9,E'i 902',E'Cloths moth',null,E'Inconspicuous, totally gray-brown small butterfly with 10 - 16 mm wingspan; body brown; feelers relatively long and then; sucking beak only slightly developed;',E'Inhalation as house dust component;',E'Body and excrement proteins of the caterpillar and butterfly;',E'Kleidermotte',null,E'Unauffälliger, einheitlich graubrauner Kleinschmetterling mit 10 - 16 mm Flügelspannweite; Körper braun; Fühler relativ lang und dünn; Saugrüssel nur schwach entwickelt;',E'Inhalativ als Hausstaubbestandteil;',E'Körper- und Kotproteine von Raupe und Schmetterling;',E'Tineola bisselliella Hummel',E'Tineidae',E'Lepidoptera, Schmetterlinge',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (110,9,E'i 904',E'Polistes',E'Paper wasp, yellow jackets; only in American usage',E'Approx. 12 -18 mm in length, multi-winged insects with a generally black head and breast region and a yellow-black abdomen; strong incision between breast and abdomen; conspicuous during the flight are the long down-hanging rear legs; Occurs in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; one or a number of queens pro population; they fly in numbers only during the period of nest building, stinging, fertile;',E'Sting; in the case of the honey bee the stinger always stays and for German and common wasp it sometimes stays in the victim, for the polistes this never is the case.',E'Proteins of large molecular weight in the animal’s poison;',E'Feldwespe',E'Papierwespe (Paperwasp), nur im bzw. durch den amerikanischen Sprachgebrauch;',E'Ca. 12 -18 mm lange, vierflügelige Insekten mit weitestgehend schwarzem Kopf- und Brustbereich und gelbschwarzem Hinterleib; starker Einschnitt zwischen Brust und Hinterleib; auffällig sind die während des Fluges lang herabhängenden Hinterbeine; Auftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; eine bis mehrere Königinnen pro Volk; diese fliegen vermehrt nur während der Zeit des Nestbaus, stechend, fruchtbar;',E'Stich; während bei der Biene der Stachel immer und bei Deutscher und Gewöhnlicher Wespe manchmal stecken bleibt, ist dies beim Stich der Feldwespe nie der Fall.',E'Hochmolekulare Proteine im Gift der Tiere;',E'Polistes Latreille spec.',E'Vespidae',E'Hymenoptera, Hautflügler',null,4,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (111,3,E'e 1 (Epithelien)',E'Cat, domestic',null,E'The domestic cat is approx. 40 - 50 cm long and 25 cm tall at the shoulder; the tail measures 20 - 30 cm. The coloring is similar to the Lybian wildcat (Felis silvestris libyca), the basic form of the domestic cat, light gray with dark gray to black spots and stripes; aside from this coloring, however, there are also black, white and reddish marked animals with all conceivable transitions between the colors and markings. In addition, selective breeding has led to the emergence of very special breeds. Especially well known are the long-haired gray Angoras and the short-haired Siamese cats with their prominent dark markings.',E'Inhalative;',E'Allergy-triggering proteins could be detected in the skin, hair, saliva, serum and in the urine; therefore fundamentally it is possible to test for specific antibodies against serum, urine, and skin scale (on demand) or skin and hair proteins inclusive saliva proteins (e1).',E'Katze, Haus-',null,E'Die Hauskatze ist ca. 40 - 50 cm lang und an der Schulter 25 cm hoch; der Schwanz misst 20 - 30 cm. Die Färbung ist in Anlehnung an die Falbkatze (Felis silvestris libyca), die Stammform der Hauskatze, hellgrau mit dunkelgrauen bis schwarzen Flecken und Streifen; daneben kommen jedoch auch schwarz, weiß und rötlich gezeichnete Tiere mit allen denkbaren Übergängen vor. Zusätzlich haben gezielte Züchtungen zur Herausbildung spezieller Rassen geführt. Bekannt sind vor allem die langhaarigen, grauen Angorakatzen und die kurzhaarigen, dunkel gezeichneten Siamkatzen.',E'Inhalativ;',E'Allergieauslösende Proteine konnten in der Haut, in den Haaren, im Speichel, im Serum und im Urin nachgewiesen werden;\nGrundsätzlich wird daher die Möglichkeit geboten, auf spezifische Antikörper gegen Serum-, Urin-, Hautschuppenproteine (jeweils auf Anfrage) oder Haut- und Haarproteine inklusive Speichelproteine (e 1) zu testen.',E'Felis domestica',E'Felidae',E'Carnivora, Reißtiere',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (112,3,E'e 2 (Epithelien), e 5 (Schuppen)',E'Dog, domestic',null,E'Mankind has domesticated the wolf (Canis lupus L.) ever since the remote Stone Age approx. 12 000 years ago. Extremely diverse breeds of dogs have developed since those ancient times, allowing for no one uniform description of the animal. The spectrum ranges from the size of a rabbit (Chihuahua) to that of a young foal (Great Dane), from almost hairless (Mexican hairless) to extremely long and thick fur (Puli), from long-legged (Greyhound) to very short-legged (Dachshund), from narrow, elongated head forms (Borsoi) to  flat-nosed head forms (Boxer), and from an extremely slender body shape (Italian whippet) to a heavily massive form (Bulldog).',E'Inhalative;',E'Allergy-triggering proteins can be detected in the skin, in the hair, in saliva, in serum and in the urine; basically it is therefore possible to test for specific antibodies against serum, urine, (each case on request) skin scale proteins (e 5) or skin and hair proteins inclusive saliva proteins (e 2).',E'Hund, Haus-',null,E'Seit der jüngeren Altsteinzeit, vor ca. 12 000 Jahren, hat der Mensch den Wolf (Canis lupus L.) zum Hund domestiziert; dabei sind durch den langen Zeitraum so verschiedengestaltige Rassen entstanden, dass keine einheitliche Beschreibung möglich erscheint. Das Spektrum reicht von der Größe eines Kaninchens (Chihuahua) bis zu der eines Fohlens (Dogge), von fast völlig unbehaart (Nackthund) bis extrem lang und dicht behaart (Puli), von hochbeinig (Windhund) bis sehr kurzbeinig (Dackel), von schmalen und lang gestreckten Kopfformen (Borsoi) bis zu plattschnauzigen Kopfformen (Boxer) und von sehr schlanker Körpergestalt (Italienisches Windspiel) bis zu sehr massiger Gestalt (Bulldogge).',E'Inhalativ;',E'Allergieauslösende Proteine konnten in der Haut, in den Haaren, im Speichel, im Serum und im Urin nachgewiesen werden;\nGrundsätzlich wird daher die Möglichkeit geboten, auf spezifische Antikörper gegen Serum-, Urin-, (jeweils auf Anfrage) Hautschuppenproteine (e 5) oder Haut- und Haarproteine inklusive Speichelproteine  (e 2) zu testen.',E'Canis familiaris L.',E'Canidae',E'Carnivora, Reißtiere',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (113,3,E'e 3 (Epithelien), e 205 (Serum), vgl. f 59',E'Horse',null,E'The domestic horse, often also simply designated Equus caballus L., is descended from the Eurasian wild horse (Equus przewalskii Poljakov), which was originally widespread in several species from East Asia to Western Europe. The domestication process began approx. 6,000 years ago. A great many different breeds have developed since that time, so that no one uniform description is possible. A basic distinction is made between the very powerful and heavy, quiet "Kaltblut" horses comprising the main breeds of Belgium, Norik and Schleswig; the especially noble thoroughbreds primarily used as racing horses, with the main breeds Arabian thoroughbred and English thoroughbred; the robust and good-natured ponies (up to 148 cm at the shoulder) with the breeds Shetland, Skiro, Exmoore, Island and Welsh-Mountain, and the half-breeds, diverse breeds and types which cannot be distinctly assigned to any of the previous categories. Horses are described according to color: chestnuts with reddish-brown coat and the same color mane and tail, bays with black mane and tail, whites, grays, blacks and dappled. Horses are long-legged, fast-running (up to 90 km/h) ungulate (hooved) mammals who feed on green forage; all their toes have receded with the exception of the middle toe, which is extended to form a hoof (the toenail; ungulates walk "on tiptoe"). Only a tiny remnant of the second and fourth toe remain (pastern). Another characteristic is the set of typical herbivore teeth with high-crowned molars (grinders) and hard enamel folds in the chewing surface. The canine teeth are stunted in stallions and lacking altogether in mares.',E'Inhalative or ingestive;',E'The allergy-triggering proteins have been able to be detected in the skin, dander and in the hair; horse serum also apparently contains related patient.allergens; horsemeat and mare''s milk likewise are responsible for specific proteins.',E'Pferd',null,E'Das Hauspferd, oft auch nur als Equus caballus L. bezeichnet, stammt vom Eurasischen Wildpferd (Equus przewalskii Poljakov) ab, welches ursprünglich in mehreren Rassen von Ostasien bis nach Westeuropa verbreitet war. Der Domestikationsprozess hatte vor ca. 6 000 Jahren begonnen.\nSeit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass keine einheitliche Beschreibung möglich ist. Man teilt ein in die sehr kräftigen und schweren und ruhigen Kaltblüter mit den Hauptrassen Belgier, Noriker und Schleswiger; in die besonders edlen, vor allem als Rennpferde eingesetzten Vollblüter mit den Hauptrassen Arabisches Vollblut und Englisches Vollblut; in die bis 148 cm Schulterhöhe großen, robusten und gutartigen Ponys mit den Rassen Shetland, Skiro, Exmoore, Island und Welsh-Mountain und in die Halbblutrassen, unterschiedliche Pferderassen und -schläge, die nicht eindeutig einer der vorangegangenen Gruppen zugeordnet werden können. Nach der Farbe teilt man ein in Füchse mit rotbraunem Haar und gleichfarbiger Mähne und Schweif, in Braune dagegen mit schwarzer Mähne und Schweif, in Schimmel, Rappen und Schecken. \nPferde sind hochbeinige, schnelllaufende (bis 90 km/h), Grünfutter fressende Säugetiere, bei denen alle Zehen mit Ausnahme der stark verlängerten und in einem Huf (Zehennagel; Zehenspitzengänger) endenden Mittelzehe, zurückgebildet sind. Von der zweiten und vierten Zehe sind nur winzige Reste (Griffelbeine) erhalten geblieben. Ein weiteres Kennzeichen ist das typische Pflanzenfressergebiss mit hochkronigen Backenzähnen und harten Schmelzfalten auf der Kaufläche. Die Eckzähne sind bei den Hengsten verkümmert und fehlen bei den Stuten ganz.',E'Inhalativ bzw. ingestiv;',E'Die allergieauslösenden Proteine konnten in der Haut, in den Hautschuppen und in den Haaren nachgewiesen werden; auch das Pferdeserum beinhaltet offensichtlich damit verwandte Allergene; im Pferdefleisch und in der Stutenmilch sind ebenfalls spezifische Proteine verantwortlich.',E'Equus przewalskii f. caballus L.',E'Equidae',E'Perissodactyla, Unpaarhufer',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (114,3,E'e 4 (Epithelien), vgl. f 27  u. Milchprodukte',E'Cattle',null,E'Bovine cattle, often also designated only as Bos taurus L., is descended from the original Aurochs (Bos primigenius Bojanus), which became extinct over 300 years ago. The domestication process for this most important animal for humans began over 8,000 years ago. Since that time many diverse breeds have developed, so that a uniform description has to be kept relatively general. The torso of  bovine cattle is massive, especially the stomach of a well-fed animal is noticeably rounded, increasing its plump appearance. An adult cow weighs 500 to 700 kg, strong bulls attain over 1,000 kg. In the case of the bull, its stocky neck and head and the two horns on its broad forehead are especially striking. In both sexes the horns consist of unbranched sheaths of the frontal bone cone. The horns are not shed. The horns can have very different shapes and in some breeds also take on enormous proportions. The legs are relatively short and powerful and emphasize the overall stocky impression. A fold of skin called the dewlap runs from the neck down to the front legs. Cattle can reach a height of 150 to 160 cm measured at the withers.The long tail ends in a tassle of hair which serves as an effective flyswatter. The skin is relatively thick, but soft and elastic, covered with a thick coat of soft hair. Bovine cattle are cloven-hoof ungulates with two developed toes and two stunted so-called spurious toes. The main breeds of middle Europe are divided into the highland cattle with white patches, largely colored reddish-brown and in the lowland cattle which generally occur in black-white variations.',E'Inhalative, epicutan or ingestive;',E'With regard to epithelia the allergy-triggering proteins have been able to be detected in the skin, in the dander and in the hairs; also the meat, milk and related milk products contain specific proteins which could trigger allergies.',E'Rind',null,E'Das Hausrind, oft auch nur als Bos taurus L. bezeichnet, stammt vom Ur oder Auerochsen (Bos primigenius Bojanus) ab, der vor über 300 Jahren ausgestorben ist. Der Domestikationsprozess für dieses wichtigste Haustier des Menschen setzte vor über 8 000 Jahren ein. Seit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass eine einheitliche Beschreibung relativ allgemein gehalten werden muss.\nDer Körper des Rindes ist massig, besonders der Bauch ist bei einem gesättigten Tier seitlich stark aufgetrieben, was das plumpe Aussehen verstärkt. Eine ausgewachsene Kuh wiegt 500 bis 700 kg, starke Stiere erreichen über 1 000 kg. Bei ihnen fallen besonders der gedrungene Hals und Kopf auf, welcher an der breiten Stirn zwei Hörner trägt. Diese bestehen bei beiden Geschlechtern aus unverzweigten Uberzügen des Stirnbeinzapfens. Die Hörner werden nicht abgeworfen. Die Hörner können sehr verschieden geformt sein und bei manchen Rassen gewaltige Ausmaße annehmen. Die Beine sind relativ kurz und kräftig und unterstreichen den gedrungenen Gesamteindruck. Vom Hals zu den Vorderbeinen verläuft eine Hautfalte, die Wamme. Am Widerrist erreicht das Rind eine Höhe von 150 bis 160 cm.Der lange Schwanz endigt in einer Haarquaste und dient als wirksamer Fliegenwedel. Die Haut ist verhältnismäßig dick, aber weich und dehnbar und ganz von weichen, dichten Haaren bedeckt. \nDas Rind ist ein Zehenspitzengänger mit zwei ausgebildeten Zehen und zwei verkümmerten sogenannten Afterzehen. Die Hauptrassen Mitteleuropas werden gegliedert in Höhenfleckvieh mit überwiegend rot-bräunlicher Färbung und in Niederungs- oder Tieflandvieh, welches hauptsächlich in Schwarz-Weiß-Varianten auftritt.',E'Inhalativ, epicutan bzw. ingestiv;',E'Bezüglich der Epithelien konnten die allergieauslösenden Proteine in der Haut, in den Hautschuppen und in den Haaren nachgewiesen werden; auch im Fleisch, in der Milch und in den aus ihr gewonnenen Produkten befinden sich spezifische Eiweiße, die Allergien auslösen können.',E'Bos primigenius f. taurus L.',E'Bovidae',E'Artiodactyla, Paarhufer',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (115,3,E'e 6 (Epithelien);',E'Guinea pig',null,E'The Guinea pig, often designated just Cavia porcellus, is a relatively compact-looking rodent about 18 - 25 cm long, with short legs, small ears and the tiny residue of a tail. It is descended from the Peruvian Guinea pig, Cavia aperea. The fur can vary extremely in structure and color. It is either uniformly colored or mottled. The colors include white, black, gray, rust-brown and yellowish. The animals are very tame and are therefore easily kept as a live children''s toy, but also as experimental animal in labs. The advanced ancient civilizations in South America kept Guinea pigs as sacrificial animal due to their tasty meat.',E'Inhalative;',E'Epithel and urine;',E'Meerschweinchen',null,E'Das Meerschweinchen, oft auch nur als Cavia porcellus bezeichnet, ist ein relativ kompakt wirkendes Nagetier von 18 - 25 cm Länge mit kurzen Beinen, kleinen Ohren und dem winzigen Rest eines Schwanzes. Es stammt vom peruanischen Meerschweinchen, Cavia aperea, ab. Das Fell kann in Struktur und Farbe außerordentlich stark variieren. Es ist entweder einheitlich gefärbt oder gefleckt. Als Farben kommen vor: weiß, schwarz, grau, rostbraun und gelblich. Die Tiere sind sehr zahm und werden daher gerne als lebendiges Kinderspielzeug aber auch als Versuchstiere gehalten. In den südamerikanischen Hochkulturen wurden bereits Meerschweinchen wegen ihres wohlschmeckenden Fleisches und als Opfertiere gehalten.',E'Inhalativ;',E'Epithel und Urin;',E'Cavia aperea f. porcellus',E'Caviidae',E'Rodentia, Nagetiere',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (116,3,E'e 9 (Federn)',E'Canary (Serinus canarius)',null,E'About 12 cm long, in its wild form a greenish bird with short, sharp and powerful beak. Its domestication began after the Spanish conquest of the Canary Islands at the end of the 15th century. The practice of keeping canaries spread further over Italy and Austria, and bird strains of numerous color variations as well as extraordinary singers developed. The main breed froms include the Harzer Roller (plain yellow; especially good singer), the orange Red Canary (Serinus canarius) and the crested canary with its particular head plumage).',E'Inhalation;',E'Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens',E'Kanarienvogel',null,E'Etwa 12 cm langer, in der Wildform grünlicher Vogel mit kurzem, spitzem und kräftigem Schnabel. Die Domestikation setzte nach der spanischen Eroberung der Kanarischen Inseln am Ende des 15. Jahrhunderts ein. Über Italien und Österreich breitete sich die Haltung weiter aus und es entstanden sowohl zahlreiche Farbvarianten als auch hervorragende Sänger. Die Hauptzuchtformen sind der Harzer Roller (einfarbig gelb; besonders gute Sänger), der Rote Kanarienvogel (orangefarbig) und der Haubenkanarienvogel (mit besonderer Kopfbefiederung).',E'Inhalation;',E'Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert.',E'Serinus canaria L.',E'Fringillidae',E'Passeriformes, Sperlingsvögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (117,3,E'e 10 (Federn)',E'Parrot, African gray (Psittacus erithacus)',null,E'Approx. 40 cm long bird with gray body plumage, conspicuous short, red tail and whitish-gray, bare area around the eyes. The very powerful beak is black and is curved. The foot has two toes pointed forwards and two pointed backwards, which act as climbing or climbing/grasping claw.',E'Inhalation;',E'Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens.',E'Papagei, Grau-',null,E'Ca. 40 cm langer Vogel mit grauem Körpergefieder, auffallend kurzem, rotem Schwanz und weißlich-gauer, nackter Augenumgebung. Der sehr kräftige Schnabel ist schwarz und nach Papageienart gekrümmt. Der Fuß ist mit zwei nach vorne und zwei nach hinten gerichten Zehen als Kletter- oder Greiffuß ausgebildet.',E'Inhalation;',E'Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allergene diskutiert.',E'Psittacus erithacus L.',E'Psittacidae',E'Psittaciformes, Papageienartige',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (118,3,E'e 7 (Taubenkot), e 11 (Taubenfedern)',E'Dove, pigeon',null,null,null,null,E'Taube',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (119,3,E'e 50 (Federn)',E'Finch, domestic',null,null,null,null,E'Zierfinken',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (120,3,E'e 70 (Federn), e 96 (Daunen), vgl. f 58 (Fleisch)',E'Goose, domestic',null,E'The domestic goose is descended from the gray goose (Anser anser (L.)). As a rule it is pure white, approx. 70 to 90 cm long and weighs 3 to 5 kg. The head tops a long thickish neck. The tip of the upper beak is formed as a powerful downward-turning nail, designed for better pulling out and plucking up grasses, leaves, and stems. When folded, the wings stretch to the tip of the short tail. The feet are large and powerful; the front toes are webbed. While flying, a goose extends its head and neck out forwards. As a flock geese fly in v-form.',E'Inhalative or ingestive;',E'Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens. Likewise, specific proteins in the meat and in the eggs could trigger allergic reactions.',E'Gans, Haus-',null,E'Die Hausgans stammt von der Graugans, (Anser anser (L.)), ab. Sie ist in der Regel rein weiß, ca. 70 bis 90 cm lang und drei bis 5 kg schwer. Der Kopf sitzt auf einem langen dicklichen Hals. Die Oberschnabelspitze ist als kräftiger, nach unten gebogener Nagel gestaltet, der zum besseren Abrupfen und -zupfen von Gräsern, Blättern und Halmen dient. Die Flügel reichen zusammengelegt bis zur Spitze des kurzen Schwanzes. Die Füße sind groß und kräftig; die Vorderzehen sind durch Schwimmhäute miteinander verbunden. Im Flug werden Kopf und Hals vorgestreckt. Im Verband fliegen Gänse in Keilform.',E'Inhalativ bzw. ingestiv;',E'Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert. Ebenso können im Fleisch und in den Eiern spezifische Proteine allergische Reaktionen auslösen.',E'Anser anser f. domestica (L.)',E'Anseridae',E'Anseriformes, Gänse- u. Entenartige Vögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (121,3,E'e 86 (Federn), e 95 (Daunen), vgl. f 57 (Fleisch)',E'Duck, domestic',null,E'The domestic duck is descended from the mallard duck (Anas platyrhynchos (L.)). It is pure white or also black-and-white, approx. 60 cm long and weighs 1-2 kg depending on the breed. The head tops a long neck, which is however shorter than the neck of a goose. The relatively short legs emerge far behind the middle of the body and clearly qualify the duck more for swimming than walking (waddle stride). The feet are large and powerful; the front toes are webbed. While flying, the duck extends its head and neck out forwards. As a flock ducks fly in a row or in pairs, with the female out in front. However domestic ducks are often unable to fly at all due to their excessive weight.',E'Inhalative or ingestive;',E'Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens. Likewise, specific proteins in the meat and in the eggs could trigger allergic reactions.',E'Ente, Haus-',null,E'Die Hausente stammt von der Stockente (Anas platyrhynchos (L.)), ab. Sie ist rein weiß oder auch schwarz-weiß, ca. 60 cm lang und je nach Zuchtform ein bis zwei kg schwer. Der Kopf sitzt auf einem langen Hals, der allerdings kürzer ist als bei der Gans. Die relativ kurzen Beine inserieren weit hinter der Körpermitte und befähigen die Ente eindeutig mehr zum Schwimmen als zum laufen (Watschelgang). Die Füße sind groß und kräftig; die Vorderzehen sind durch Schwimmhäute miteinander verbunden. Im Flug werden Kopf und Hals vorgestreckt. Im Verband fliegen Enten in einer Reihe oder paarweise mit dem Weibchen voran. Allerdings sind die Hausenten auf Grund ihres hohen Gewichtes oft flugunfähig.',E'Inhalativ bzw. ingestiv;',E'Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert. Ebenso können im Fleisch und in den Eiern spezifische Proteine allergische Reaktionen auslösen.',E'Anas platyrhynchos f. domestica (L.)',E'Anatidae',E'Anseriformes, Gänse- und Entenartige Vögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (122,3,E'e 85 (Federn), vgl. f 83, f1,67,68,74,75',E'Hen, domestic',null,E'The domestic hen is descended from the Indian Bankiva hen (Gallus gallus f. bankiva Temm.). Approximately 150 breeds developed in the course of domestication, which do not permit any uniform description. Fundamentally the hen has a stocky, massive torso, and its elongated neck carries a relatively small head. The two powerful, as a rule unfeathered running legs each have a foot with three toes pointing outwards and one pointing backwards. The cock (rooster) has a sharp, powerful spur positioned above the back toe. The cocks are also larger than the hens, have a large comb as well as a big wattle and their plumage is more colorful. The cockle-doodle-doo call of the rooster is well-known everywhere; the hens only cackle or cluck. A distinction is made between five different types of strains: 1. Laying strains which produce over 300 eggs per hen a year (Rebhuhnfarbige Italiener, Weisses Leghuhn); 2. Dual strains for the production of both eggs and meat (Deutsche Sperber, Andalusier); 3. Meat strains which yield up to to 6 kg in weight (Brahma, Deutsche Langschan); 4. Ornamental hens for collectors (dwarf hens, crestnhuhn (crested hen?), Barthuhn (bearded hen?) and Nackthalshen (hairless neck hen?), Phoenix; 5. Fighting hens for cockfighting;',E'Inhalative or Ingestiv;',E'Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens. Likewise, specific proteins in the meat and in the eggs could trigger allergic reactions. Such components of the egg are the ovalbumin (f 67) and the ovomucoid (f68).',E'Huhn, Haus-',null,E'Das Haushuhn stammt vom indischen Bankivahuhn (Gallus gallus f. bankiva Temm.) ab. Durch die Domestikation sind etwa 150 Rassen entstanden, die keine einheitliche Beschreibung erlauben. Grundsätzlich hat das Huhn einen gedrungenen, massigen Rumpf und der gestreckte Hals trägt einen verhältnismäßig kleinen Kopf. Die kräftigen, in der Regel unbefiederten Laufbeine tragen einen Fuß mit drei nach vorne und einer nach hinten gerichteten Zehe. Über der Hinterzehe besitzen die Hähne einen spitzen, kräftigen Sporn. Ferner sind sie größer als die Hennen, tragen einen großen Kamm sowie große Kehllappen und ihr Gefieder ist farbenprächtiger. Allseits bekannt ist der Kikeriki-ruf der Hähne; die Hennen gackern oder glucken nur. Man unterscheidet fünf Zuchtrichtungen:\n1. Legerassen mit über 300 Eiern pro Huhn im Jahr (Rebhuhnfarbige Italiener, Weißes Leghuhn);\n2. Zwierassen zur Eier und Fleischnutzung (Deutsche Sperber, Andalusier);\n3. Fleischrassen mit bis zu 6 kg Gewicht (Brahma, Deutsch Langschan);\n4. Zierhühner für Liebhaberzwecke (Zwerghühner, Hauben-, Bart- und Nackthalshühner, Phoenixhühner);\n5. Kampfhühner für Hahnenkämpfe;',E'Inhalativ bzw. Ingestiv;',E'Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert. Ebenso können im Fleisch und in den Eiern spezifische Proteine allergische Reaktionen auslösen. Solche Eibestandteile sind das Ovalbumin (f 67) und das Ovomucoid (f68).',E'Gallus gallus f. gallus L.',E'Phasianidae',E'Galliformes, Hühner',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (123,3,E'e 71, e 88 (Epithelien), e 72 (Urin), e 76 (Serum)',E'Mouse, domestic',null,E'Rodent with a body length of 70 to 110 mm and a tail of 60 to 105 mm. The ears are 11 -15 mm long and the body weight is 12 to 30 g. An unambiguous recognition characteristic is a notch on the back edge of the upper incisors. The Eastern sub-family M. m. musculus L., cereal mouse, is grayish-brown on the upper side and has a distinctly lighter underside. The western form M. m. domesticus Rutty is gray on top and underneath only a slightly bit lighter. There is no absolutely clear demarcation between the two. The domestic mouse is also the basic form of the laboratory mouse, which is bred as cream-colored and albino.',E'Epicutan and inhalative;',E'dander, hair and proteins in the urine and in serum',E'Maus, Haus-',null,E'Nagetier mit einer Körperlänge von 70 bis 110 mm und einem 60 bis 105 mm langen Schwanz. Die Ohren sind 11 -15 mm lang und das Körpergewicht beträgt 12 bis 30 g. Ein eindeutiges Erkennungsmerkmal ist eine Einkerbung am Hinterrand der oberen Schneidezähne. Die östliche Unterart M. m. musculus L., Ährenmaus, ist oberseits graubraun und besitzt eine deutlich heller abgesetzte Unterseite. Die westliche Form, M. m. domesticus Rutty ist oben grau und unterseits nur wenig heller. Es existiert keine deutliche Trennungslinie. Die Hausmaus ist auch die Stammform der Labormaus, welche in cremefarbener Form und in Albinoform gezüchtet wird.',E'Epicutan und inhalativ;',E'Hautschuppen, Haare und Proteine im Urin und im Serum',E'Mus musculus L.',E'Muridae',E'Rodentia, Nagetiere',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (124,3,E'e 73, e 87 (Epithelien), e 74 (Urin), e 90 (Kot)',E'Rat, laboratory (Norway rat)',null,E'Light to dark gray, sometimes also brownish or almost black rodent with a body length of 18 to 28 cm and a 13 - 23 cm long tail. The ears are 18 - 23 mm long and the body weight between 200 to 500 g. The Norway rat (also known as brown rat or sewer rat) is also the basic form of the laboratory rat which is usually bred in its albino form.',E'Epicutan and inhalative;',E'dander, hair and proteins in the urine, in the feces and in serum',E'Ratte, Labor-',null,E'Hell- bis dunkelgraues, bisweilen auch bräunliches oder fast schwarzes Nagetier mit einer Körperlänge von 18 bis 28 cm und einem 13 bis 23 cm langen Schwanz. Die Ohren sind 18 - 23 mm lang und das Körpergewicht beträgt 200 bis 500 g. Die Wanderratte ist auch die Stammform der Laborratte, welche meist in der Albinoform gezüchtet wird.',E'Epicutan und inhalativ;',E'Hautschuppen, Haare und Proteine im Urin, im Kot und im Serum',E'Rattus norvegicus (Berkenhout)',E'Muridae',E'Rodentia, Nagetiere',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (125,3,E'e 81(Epithelien), vgl. f 88 (Lammfleisch)',E'Sheep, domestic',null,E'The domestic sheep, often also only designated as Ovis aries L., is descended from the mouflon (Ovis ammon L.), which still occurs in the wild in the Mediterranean area. The domestication process for this important domestic animal began over 8,000 years ago. Since that time selective breeding has produced specific breeds for meat, milk, wool and fat extraction. Depending on the breed, sheep attain a body length of 110 to 200 cm and a shoulder height of 60 to 125 cm. The tail is only 5 to 10 cm long. In some breeds the male sheep have a strongly curved set of horns. Aside from the feet and ears, a sheep''s entire body is covered with thick wooly fur, which in the case of wool sheep is shorn each year in April/May. The sheep is a cloven-hoof ungulate with two developed toes.',E'Inhalative, epicutan or ingestive;',E'dander and hair. Specific proteins which can trigger allergies are also found in the meat, milk and related products.',E'Schaf, Haus-',null,E'Das Hausschaf, oft auch nur als Ovis aries L. bezeichnet, stammt vom Mufflon (Ovis ammon L.) ab, welches im Mittelmeerraum stellenweise noch wild vorkommt. Der Domestikationsprozess für dieses wichtige Haustier setzte vor über 8 000 Jahren ein. Seit dieser Zeit sind mehrere Rassen zur Fleisch-, Milch-, Woll- und Fettgewinnung gezüchtet worden.\nDas Schaf erreicht je nach Rasse eine Körperlänge von 110 bis 200 cm und eine Schulterhöhe von 60 bis 125 cm. Der Schwanz ist nur 5 bis 10 cm lang. Bei manchen Rassen tragen die männlichen Schafe ein stark gewundenes Gehörn. Außer den Füßen und den Ohren ist der ganze Körper von einem dichten Fell bedeckt, das bei den Wollschafen im April/Mai geschoren wird. Das Schaf ist ein Zehenspitzengänger mit zwei ausgebildeten Zehen.',E'Inhalativ, epicutan bzw. ingestiv;',E'Hautschuppen und Haare. Auch im Fleisch, in der Milch und in den aus ihr gewonnenen Produkten befinden sich spezifische Eiweiße, die Allergien auslösen können.',E'Ovis ammon f. aries L.',E'Bovidae',E'Artiodactyla, Paarhufer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (126,3,E'e 82 (Epithelien), e 211 (Urin), vgl. f 213',E'Rabbit',null,E'The domestic rabbit (often erroneously called hare or hutch hare) has been bred from the wild rabbit since the early Middle Ages. A great diversity of breeds has developed since that time; hence the further description refers to the wild rabbit. This gets to be 40 to 50 cm long and weighs from 1.5 to 2.5 kg, with a yellowish-brown coat. Due to an increase in wooly hairs, the winter coat appears more gray in color. The wild rabbit has a short white stumpy tail and long ears about 8 cm in length. Its typical posture is sitting, with a curved back. The 5 toes of the front paws and 4 toes of the back paws have powerful claws. The teeth differ from rodents teeth in that there are so-called crown teeth located behind the upper incisors. The domestic breeds are in some ways far removed from this original form. A few examples are in particular the Belgische Riesen ("Belgian Giant"), Deutsche Widder ("German Ram"), Blaue and Weisse Wiener (Blue & White Viennese), angora rabbits, and large and small silver rabbits. Rabbits are also kept as laboratory and experimental animals, among other things for the production of special antibodies.',E'Inhalative, epicutan or ingestive;',E'Dander and hair; in urine and meat there are specific proteins which can trigger the allergies.',E'Kaninchen',null,E'Das Hauskaninchen (fälschlicherweise oft Hase oder Stallhase genannt) wurde seit dem frühen Mittelalter aus dem Wildkaninchen gezüchtet. Seit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass die weitere Beschreibung auf das Wildkaninchen Bezug nimmt. Diese wird 40 bis 50 cm lang, 1,5 bis 2,5 kg schwer und ist von gelblich-brauner Färbung. Das Winterkleid wirkt in Folge der Vermehrung der Wollhaare mehr grau. Das Wildkaninchen besitzt einen kurzen, weißen Stummelschwanz und bis zu 8 cm lange Ohren. Die typische Körperhaltung ist sitzend, mit gekrümmtem Rücken. Die 5  Zehen der Vorderpfoten und die 4 Zehen der Hinterpfoten tragen kräftige Krallen. Das Gebiss unterscheidet sich von dem der Nagetiere dadurch, dass sich hinter den oberen Schneidezähnen noch sogenannte Stiftzähne befinden.\nDie Hausrassen haben sich von dieser Form teilweise sehr weit entfernt. Zu nennen sind vor allem Belgische Riesen, Deutsche Widder, Blaue und Weiße Wiener, Angorakaninchen, Groß- und Kleinsilber.\nKaninchen werden auch als Labor- und Versuchstiere gehalten; u.a. zur Produktion spezieller Antikörper.',E'Inhalativ, epicutan bzw. ingestiv;',E'Hautschuppen und Haare; Im Urin und im Fleisch befinden sich spezifische Eiweiße, die Allergien auslösen können.',E'Oryctolagus cuniculus (L.)',E'Leporidae',E'Lagomorpha, Hasenartige',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (127,3,E'e 83 (Epithelien), e 204 (Serumalbumin), vgl. f 26',E'Pig, domestic',null,E'The domestic pig is descended from the wild pig, Sus scrofa L.. The domestication process for this very important domestic animal began over 8,000 years ago. Since that time extremely diverse breeds have developed, so that a uniform description has to be kept relatively general. The body of the domestic pig is clearly lower and longer than the wild pig. This gives it a plump and ponderous appearance. The pig has a trunk-like extended snout which ends in a flat noseplate. From the elongated tail of the wild pig, selective breeding has created a curly corkscrew tail, and floppy ears out of upright ears. Hair growth is considerably more scanty than on a wild pig. In contrast to the wild pig, the canine teeth are strongly stunted; in the case of the sow they are not even visible when her mouth is closed. A domestic pig attains a slaughter weight of about 100 kg after approx. 8 months. The pig is an ungulate with two fully developed and two only weakly developed toes. The German names of major swine breeds in central Europe are Deutsches Sattelschwein, Deutsche Landrasse, Deutsches Weideschwein, Deutsches weisses [white] Edelschwein and Rotbuntes [red] Schwein. Domestic pigs have an enormous economic value as provider of meat, fat, leather, and bristle. Due to its physiological similarity with mankind, the pig is also often used as an experimental and laboratory animal;',E'Inhalative, epicutan or ingestive;',E'dander and hair; specific proteins which can trigger allergies are found in the urine, serum and in meat.',E'Schwein, Haus-',null,E'Das Hausschwein stammt vom Wildschwein, Sus scrofa L. ab. Der Domestikationsprozess für dieses sehr wichtige Haustier des Menschen setzte vor über 8 000 Jahren ein. Seit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass eine einheitliche Beschreibung relativ allgemein gehalten werden muss.\nDer Körper des Hausschweins ist deutlich niedriger und länger gebaut als der des Wildschweins. Dadurch wirkt es plump und schwerfällig. Es besitzt eine rüsselartig verlängerte Schnauze, die in einer Nasenscheibe endet. Aus dem gestreckten Schwanz des Wildschweins wurde durch die Züchtung ein Ringelschwänzchen und aus den aufrecht stehenden Ohrmuscheln sind Schlappohren geworden. Die Behaarung ist wesentlich spärlicher als beim Wildschwein. Im Gegensatz zum Wildschwein sind auch die Eckzähne stark zurückgebildet; bei der Sau sind sie bei geschlossenem Maul nicht mehr sichtbar. \n Ein Hausschwein erreicht nach ca. 8 Monaten ein Schlachtgewicht von 100 kg. Das Schwein ist ein Zehenspitzengänger mit zwei voll ausgebildeten und zwei sehr schwach ausgebildeten Zehen. Die Hauptrassen Mitteleuropas sind Deutsches Sattelschwein, Deutsche Landrasse, Deutsches Weideschwein, Deutsches weißes Edelschwein und Rotbuntes Schwein. Hausschweine sind von größter wirtschaftlicher Bedeutung als Fleisch, Fett, Leder- und Borstenlieferant. Auf Grund seiner physiologischen Ähnlichkeit zum Menschen ist das Schwein auch Versuchs- und Labortier;',E'Inhalativ, epicutan bzw. ingestiv;',E'Hautschuppen und Haare; Im Urin, Serum und im Fleisch befinden sich spezifische Eiweiße, die Allergien auslösen können.',E'Sus scrofa f. domestica L.',E'Suidae',E'Artiodactyla, Paarhufer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (128,3,E'e 84',E'Goldhamster epithelia',null,E'Approx. 18 cm long rodent with short, about 1.5 cm long tail, short but nimble legs and pronounced cheek pockets. The thick fur is gray to golden-brown on the top. The fur on the stomach is whitish. On the throat and neck the fur is lighter.',E'Inhalative;',E'skin, hair and possibly saliva',E'Goldhamsterepithelien',null,E'Ca. 18 cm langer Nager mit kurzem, etwa 1,5 cm langem Schwanz, kurzen aber behenden Beinen und ausgeprägten Backentaschen. Das dichte Fell ist oberseits grau bis goldbraun. Die Bauchseite ist weißlich. An der Kehle und den Halsseiten ist das Fell hell gezeichnet.',E'Inhalativ;',E'Haut, Haare und möglicherweise Speichel',E'Mesocricetus auratus',E'Cricetidae',E'Rodentia Nagetiere',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (129,3,E'e 203',E'Chinchilla epithelia',null,null,null,null,E'Chinchillaepithelien',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (130,3,E'e 207',E'Parakeet (Nymphicus hollandicus) feathers',null,E'Approx. 32 cm long, slender bird with largely gray plumage. Wings have a white, wedge-shaped spot. Head yellowish with white feathers and an orange spot just below the eye. The coloring is stronger in some of the males. A long extended pointed crest on the top of the head. In addition there are also white and mottled breeds. The very powerful beak has a meaty to gray hue and is bent like a parrot''s beak. The foot has two toes pointed forwards and two pointed backwards, which act as climbing or climbing/grasping claw.',E'Inhalative;',E'Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens.',E'Nymphensittichfedern',null,E'Ca. 32 cm langer, schlanker Vogel mit überwiegend grauem Gefieder. Flügel mit weißem, keilförmigen Fleck. Kopf gelblich, weiß befiedert und mit einem orangenen Fleck unterhalb des Auges. Die Färbung ist bei den Männchen kräftiger. Oberkopf mit lang ausgezogener spitzer Haube. Zusätzlich gibt es weiße und scheckige Zuchtformen. Der sehr kräftige Schnabel ist fleischfarben bis grau und nach Papageienart gekrümmt. Der Fuß ist mit zwei nach vorne und zwei nach hinten gerichten Zehen als Kletter- oder Greiffuß ausgebildet.',E'Inhalativ;',E'Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert.',E'Nymphicus hollandicus Kerr.',E'Psittacidae',E'Psittaciformes, Papageienartige Vögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (131,7,E'c 1',E'Penicillin G',E'Benzylpenicillin, (6R)-6-(2-Phenylacetamido)penicillansäure;',null,null,null,E'Penicillin G',E'Benzylpenicillin, (6R)-6-(2-Phenylacetamido)penicillansäure;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (132,7,E'c 2',E'Penicillin V',E'Phenoxymethylpenicillin; (6R)-6-(2-Phenoxyacetamido)penicillan-säure;',null,null,null,E'Penicillin V',E'Phenoxymethylpenicillin; (6R)-6-(2-Phenoxyacetamido)penicillan-säure;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (133,7,E'c 201',E'Cephalosporins',E'The different cephalosporins appear under the following more or less trivial trade names: Cefaclor, Cefadroxil, Cefalexin, Cefamandol, Cefazolin, Cefepim, Cefetamet, Cefixim, Cefmenoxim, Cefodizim, Cefoperazon, Cefotaxim, Cefotiam, Cefoxitin, Cefpodoxim, Cefsulodin, Ceftazidim, Cefdibuten, Ceftizoxim, Ceftriaxon, Cefuroxim;',null,null,null,E'Cephalosporine',E'Die verschiedenen Cephalosporine treten unter folgenden Trivialnamen auf: Cefaclor, Cefadroxil, Cefalexin, Cefamandol, Cefazolin, Cefepim, Cefetamet, Cefixim, Cefmenoxim, Cefodizim, Cefoperazon, Cefotaxim, Cefotiam, Cefoxitin, Cefpodoxim, Cefsulodin, Ceftazidim, Cefdibuten, Ceftizoxim, Ceftriaxon, Cefuroxim;',null,null,null,null,null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (134,7,E'c 205',E'Ampicillin',E'D-(-)-(alpha-aminobenzyl)penicillin;',null,null,null,E'Ampicillin',E'D-(-)-(alpha-aminobenzyl)penicillin;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (135,7,E'c 207',E'Acetylsalicylic acid',E'2-Acetoxybenzoic acid;',null,null,null,E'Acetylsalicylsäure',E'2-Acetoxybenzoesäure;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (136,7,E'c 214',E'Amoxicillin',E'alpha-Amino-4-hydroxybenzylpenicillin;',null,null,null,E'Amoxicillin',E'alpha-Amino-4-hydroxybenzylpenicillin;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (137,4,E'f 2',E'Cow milk protein',null,null,null,null,E'Kuhmilcheiweiß',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (138,4,E'f 60',E'Camembert',null,null,null,null,E'Camembert',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (139,4,E'f 70',E'Swiss cheese',null,null,null,null,E'Schweizer Käse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (140,4,E'f 76',E'Alpha-lactalbumin',null,null,null,null,E'Alpha-Lactalbumin',null,null,null,null,null,null,null,1,1,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (141,4,E'f 77',E'Beta-lactoglobulin',null,null,null,null,E'ß-Lactoglobulin',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (142,4,E'f 78',E'Casein',null,null,null,null,E'Casein',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (143,4,E'f 81',E'Cheddar cheese',null,null,null,null,E'Cheddarkäse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (144,4,E'f 82',E'Mould cheese',null,null,null,null,E'Schimmelkäse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (145,4,E'f 150',E'Edamer cheese',null,null,null,null,E'Edamer Käse',null,null,null,null,null,null,null,1,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (146,4,E'f 201',E'Gouda cheese',null,null,null,null,E'Gouda Käse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (147,4,E'f 203',E'Milk, boiled',null,null,null,null,E'Milch, gekocht',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (148,4,E'f 205',E'Yogurt',null,null,null,null,E'Joghurt',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (149,4,E'f 206',E'Kefir',null,null,null,null,E'Kefir',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (150,4,E'f 286',E'Mare''s milk',null,null,null,null,E'Stutenmilch',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (151,4,E'f 26',E'Pork',null,null,null,null,E'Schweinefleisch',null,null,null,null,null,null,null,2,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (152,4,E'f 27',E'Beef, raw',null,null,null,null,E'Rindfleisch, roh',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (153,4,E'f 57',E'Duck',null,null,null,null,E'Entenfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (154,4,E'f 58',E'Goose',null,null,null,null,E'Gänsefleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (155,4,E'f 59',E'Horsemeat',null,null,null,null,E'Pferdefleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (156,4,E'f 83',E'Chicken',null,null,null,null,E'Hühnerfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (157,4,E'f 88',E'Lamb/Mutton',null,null,null,null,E'Lamm-/Hammelfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (158,4,E'f 130',E'Turkey',null,null,null,null,E'Putenfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (159,4,E'f 213',E'Rabbit',null,null,null,null,E'Kaninchenfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (160,4,E'f 1, f 67 Ovalbumin, f 68 Ovomucoid, f 74 Gesamthü',E'Chicken egg',null,null,null,null,E'Hühnerei',null,null,null,null,null,null,null,3,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (161,4,E'f 12',E'Pea',null,null,null,null,E'Erbse',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (162,4,E'f 14',E'Soy bean',null,null,null,null,E'Sojabohne',null,null,null,null,null,null,null,4,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (163,4,E'f 15',E'Bean, white',null,null,null,null,E'Bohne, weiße',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (164,4,E'f 25',E'Tomato',null,null,null,null,E'Tomate',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (165,4,E'f 31',E'Carrots',null,null,null,null,E'Karotte',null,null,null,null,null,null,null,4,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (166,4,E'f 35',E'Potatoes',null,null,null,null,E'Kartoffel',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (167,4,E'f 38',E'Spinach',null,null,null,null,E'Spinat',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (168,4,E'f 39',E'Cabbage',null,null,null,null,E'Kohl',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (169,4,E'f 46',E'Paprika, sweet',null,null,null,null,E'Paprika, Gemüse-',null,null,null,null,null,null,null,4,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (170,4,E'f 47',E'Garlic',null,null,null,null,E'Knoblauch',null,null,null,null,null,null,null,4,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (171,4,E'f 48',E'Onions',null,null,null,null,E'Zwiebel',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (172,4,E'f 54',E'Sweet potato (Batate)',null,null,null,null,E'Süßkartoffel (Batate)',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (173,4,E'f 61',E'Cauliflower, cooked',null,null,null,null,E'Blumenkohl, gekocht',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (174,4,E'f 65',E'Lentil',null,null,null,null,E'Linse',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (175,4,E'f 66',E'Leeks',null,null,null,null,E'Porree',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (176,4,E'f 86',E'Parsley',null,null,null,null,E'Petersilie',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (177,4,E'f 96',E'Avocado',null,null,null,null,E'Avokado',null,null,null,null,null,null,null,4,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (178,4,E'f 100',E'Head lettuce',null,null,null,null,E'Kopfsalat',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (179,4,E'f 127',E'Mushroom',null,null,null,null,E'Champignon',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (180,4,E'f 132',E'Beans, green',null,null,null,null,E'Bohnen, grüne',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (181,4,E'f 133',E'Cucumber',null,null,null,null,E'Gurke',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (182,4,E'f 134',E'Broccoli',null,null,null,null,E'Brokkoli',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (183,4,E'f 137',E'Asparagus',null,null,null,null,E'Spargel',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (184,4,E'f 287',E'Bean, red',null,null,null,null,E'Bohne, rot',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (185,4,E'f 301',E'Eggplant',null,null,null,null,E'Aubergine',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (186,4,E'f 309',E'Radishes',null,null,null,null,E'Radieschen',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (187,4,E'f 311',E'Brussels sprouts',null,null,null,null,E'Rosenkohl',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (188,4,E'f 318',E'Zucchini',null,null,null,null,E'Zucchini',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (189,4,E'f 901',E'Pepperoni',null,null,null,null,E'Peperoni',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (190,8,E'm 1',E'Penicillium chrysogenum Thom',E'Penicillium notatum Westling;',E'Colonies auf Czapek agar (CzA) at 25° C 2.5-4 cm in 10 days (faster growing on malt agar MEA), satin-like to flaky, often a light yellow exudate is released; rear side yellow, seldom uncolored; conidiophore smooth-walled, 200-300 µm long; penicilli usually have three to four levels of  branching; metulae short 8-12 µm long; bottle-shaped phialides usually 7-10 x 2-2.5 µm; conidia smooth-walled, ellipsoid, 2.5-4 µm long, blue or blue-green.',E'Inhalation, ingestion;',null,E'Penicillium chrysogenum Thom',E'Penicillium notatum Westling;',E'Kolonien auf Czapek-Agar (CzA) bei 25° C 2.5-4 cm in 10 Tagen (auf Malzagar MEA schneller wachsend), samtig bis flockig, häufig ein hellgelbes Exudat freisetzend; Rückseite gelb, selten ungefärbt;\nKonidienträger glattwandig, 200-300 µm lang; Penicilli gewöhnlich drei- bis vierstufig verzeigt; Metulae kurz 8-12 µm lang; flaschenförmige Phialiden meist 7-10 x 2-2.5 µm;   Konidien glattwandig, ellipsoid, 2,5-4 µm lang, blau oder blaugrün.',E'Inhalativ, ingestiv;',null,E'Penicillium chrysogenum Thom',null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (191,8,E'm 2',E'Cladosporium herbarum (Pers.) Link ex Gray',E'Cladosporium entoxylinum, Corda, Dematium herbarum Pers. ex Schleich, Dematium graminum Pers., Cladosporium graminum (Pers.) Link, Dematium epiphyllum Pers. ex Hook, Cladosporium epiphyllum (Pers. ex Hook.) Nees ex Fr.;',E'Colonies on malt agar (MEA 2%) with moderate growth, satin-like, olive green to olive brown, rear side olive black; conidiophore lateral or sometimes terminal on the hyphen, to 250 µm long, 3-6 µm wide, with terminal and intercalar swellings as well as extensions, pale to mid-dark olive-brown or brown, smooth-walled, with distinct protruding brown scars; conidia ellipsoid to cylindrical with rounded ends, rough as well with distinct protruding brown scars, often two or more celled, single-celled conidia 5.5-13 x 3.8-6 µm; the conidia in their turn again become conidiogen cells, so that often ramified chains are generated.',E'Inhalation, ingestion;',null,E'Cladosporium herbarum (Pers.) Link ex Gray',E'Cladosporium entoxylinum, Corda, Dematium herbarum Pers. ex Schleich, Dematium graminum Pers., Cladosporium graminum (Pers.) Link, Dematium epiphyllum Pers. ex Hook, Cladosporium epiphyllum (Pers. ex Hook.) Nees  ex Fr.;',E'Kolonien auf Malzagar (MEA 2%) mit moderatem Wachstum, samtig, olivgrün bis olivbraun, Rückseite olivschwarz;\nKonidienträger lateral oder manchmal terminal auf den Hyphen, bis 250 µm lang, 3-6 µm breit, mit terminalen und intercalaren Schwellungen sowie Verlängerungen, blaß bis mittelstark olivbraun oder braun, glattwandig, mit deutlich hervorstehenden braunen Narben; Konidien ellipsoid bis zylindrisch mit abgerundeten Enden, rauh ebenfalls mit deutlich hervorstehenden braunen Narben, oft 2- oder mehrzellig, einzellige Konidien 5,5-13 x 3.8-6 µm;\nDie Konidien werden ihrerseits wieder zu konidiogenen Zellen, so dass häufig verzweigte Ketten entstehen.',E'Inhalativ, ingestiv;',null,E'Cladosporium herbarum (Pers.) Link ex Gray',null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (192,8,E'm 3',E'Aspergillus fumigatus Fres.',E'Aspergillus phialiseptus Kwon-Chung, Aspergillus anomalus Mosseray, Aspergillus cellulosae Hopffe;',E'Colonies on Czapek agar (CzA) at 25 °C 3-5 cm in 7 days, dark blue-green, consisting of a dense fur of short conidiophores, intertwined with air hypha; the colonies grow faster and produce more spores on malt agar. The conidiophore stems are smooth-walled, often green in the upper regions; conidia heads consist of single-rowed parallel conidia chains; vesicle wide club-shaped, 20-30 µm wide; conidia rough-walled, spherical (to elliptical), 2.5-3 µm diameter.',E'Inhalation or ingestion;',null,E'Aspergillus fumigatus Fres.',E'Aspergillus phialiseptus Kwon-Chung, Aspergillus anomalus Mosseray, Aspergillus cellulosae Hopffe;',E'Kolonien auf Czapekagar (CzA) bei 25 °C 3-5 cm in 7 Tagen, dunkel blaugrün, bestehend aus einem dichten Pelz aus kurzen Kondienträgern, durchflochten mit Lufthyphen; die Kolonien wachsen auf Malzagar schneller und sporulieren stärker. Kondienträgerstiele glattwandig, oft grün im oberen Bereich; Konidienköpfe bestehend aus einreihigen parallelen Konidienketten; Vesikel breit keulenförmig, 20-30 µm breit; Konidien rauhwandig, kugelig (bis elliptisch), 2.5-3 µm Durchmesser.',E'Inhalativ oder ingestiv;',null,E'Aspergillus fumigatus Fres.',null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (193,8,E'm 4',E'Mucor racemosus Fres. f. racemosus',E'Clamydomucor racemosus (Fres.) Bref., Mucor dimorphosporus Lendner, Mucor christianensis Hagem, Mucor varians Pispek;',E'Colonies grow rapidly, light gray-brown; sporangiophores hyaline, up to 20 mm x 24-17 µm, monopodially as well as sympodially ramified, short branchings are often bent over; sporangies brown, up to 80(-90) µm diameter; Columellar round to pear-shaped, often with flattened base, light-brown with collars; sporangiophores smooth-walled, round to wide ellipsoid, up to 8-10 µm diameter; chlamydospore  in sporangiophores; zygospores up to 110 µm diameter, brown, short thorned; suspensors equally or almost equally large; heterothallic.',E'Inhalation and ingestion;',null,E'Mucor racemosus Fres. f. racemosus',E'Clamydomucor racemosus (Fres.) Bref., Mucor dimorphosporus Lendner, Mucor christianensis Hagem, Mucor varians Pispek;',E'Kolonien schnellwachsend, hell graubraun; Sporangiophoren hyalin, bis zu 20 mm x 24-17 µm, sowohl monopodial als auch sympodial verzweigt, kurze Verzweigungen oft eingekrümmt; Sporangien braun, bis zu 80(-90) µm Durchmesser; Columellar rundlich bis birnenförmig, oft mit abgeflachter Basis, hellbraun mit Kragen; Sporangiophoren glattwandig, rund bis breit ellipsoid, bis zu 8-10 µm Durchmesser; Chlamydosporen in Sporangiophoren; Zygosporen bis zu 110 µm Durchmesser, braun, kurzstachelig; Suspensoren gleich oder beinahe gleich groß; heterothallisch.',E'Inhalativ und ingestiv;',null,E'Mucor racemosus Fres. f. racemosus',E'Mucoraceae',E'Mucorales',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (194,8,E'm 6',E'Alternaria alternata (Fr.) Keissl',E'Alternaria tenuis Nees., Torula alternata Fr., Macrosporium tomato Cooke;',E'Colonies on malt agar (MEA) at 25 °C with a diameter of 6 cm in 7 days, black-gray to olive green. Conidiophore, 1-3 celled, usually unbranched, with one or only a few stigma (conidiogenesis), up to 50 µm long, 3-6 µm wide; conidia slightly club-shaped to ellipsoid, with a short cylindrical beak shape, 23-56 x 8-17 µm; brown, wall-shaped septa, a stigma at the end, usually arranged in unbranched chains of 10 or more;',E'Inhalation and ingestion;',null,E'Alternaria alternata (Fr.) Keissl',E'Alternaria tenuis Nees., Torula alternata Fr., Macrosporium tomato Cooke;',E'Kolonien auf Malzagar (MEA) bei 25 °C mit einem Durchmesser von 6 cm in 7 Tagen, schwarzgrau bis olivgrün. Konidienträger 1-3-zellig, meist unverzweigt, mit einer oder wenigen Narben (Konidiogenese), bis zu 50 µm lang, 3-6 µm breit; Konidien schwach keulenförmig bis ellipsoid, mit einem kurzen zylindrischen Schnabel, 23-56 x 8-17 µm; braun, mauerförmig septiert, am Ende mit einer Narbe, meist in unverzweigten Ketten von 10 oder mehr angeordnet;',E'Inhalativ und ingestiv;',null,E'Alternaria alternata (Fr.) Keissl',E'Dematiaceae',null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (195,8,E'm 7',E'Botrytis cinerea Pers.',E'Sclerotium durum Pers. ex St.-Am., Haplaria grisea Link ex Leman, Phymadeadrichum gemellum Bonord., Botrytis fuckeliana Buchw.;',E'Colonies grow rapidly, on oat agar (OA) at 20 °C and reach a diameter of at least 6 cm in 10 days, at first transparent, then becoming light to dark gray; black Sclerotine as well as on ground and also on natural substrates, very variable in size and form; condiophores erect, often 2mm long and 16-30 µm wide, septate, in the lower regions colored brown and smooth-walled, with a head composed of branchings at the end; the conidiogen cells swollen at the ends produce simultaneously numerous blasto-conids on small denticels. Conidia oval 8-14 x 6-9 µm, pale brown, hydrophobic, smooth-walled; Myrioconium state: phialidische microconida on sporodochia 2.5-3 µm diameter;',E'Inhalation or ingestion, especially on the consumption or when handling wine grapes, wine and other fruits;',null,E'Botrytis cinerea Pers.',E'Sclerotium durum Pers. ex St.-Am., Haplaria grisea Link ex Leman, Phymatotrichum gemellum Bonord., Botrytis fuckeliana Buchw.;',E'Kolonien schnellwachsend, auf Haferagar (OA) bei 20 °C einen Durchmesser von mindestens 6 cm in 10 Tagen erreichend, zunächst durchscheinend, dann hell bis dunkelgrau werdend; Schwarze Sclerotien sowohl auf Nährboden als auch auf  natürlichen Substraten, sehr variabel in Größe und Form; Kondiophoren aufrecht, häufig 2mm lang und 16-30 µm breit, septiert, im unteren Bereich braun, glattwandig, mit einem Kopf aus Verzweigungen am Ende; die am Ende geschwollenen konidiogenen Zellen produzieren simultan zahlreiche Blastokoniden auf kleinen Dentikeln. Konidien oval 8-14 x 6-9 µm, blaßbraun, hydophob, glattwandig; \nMyrioconium Stadium: phialidische Mikrokonidien auf Sporodochien 2.5-3 µm Durchmesser;',E'Inhalativ oder ingestiv, besonders bei Verzehr oder im Umgang mit Weitrauben, Wein und anderen Früchten;',null,E'Botrytis cinerea Pers.',E'Moniliaceae',null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (196,8,E'm 8',E'Exserohilum rostratum (Drechsler) Leonard & Suggs',E'Helminthosporium halodes Drechsler, Drechslera halodes (Drechsler) Subramanian & Jain, Drechslera rostrata (Drechsler) Richardson & Fraser, Helminthosporium rostratum Drechsler;',E'Conidiophores and phragmoconidies dark, distoseptate;',E'Inhalation;',null,E'Exserohilum rostratum (Drechsler) Leonard & Suggs',E'Helminthosporium halodes Drechsler, Drechslera halodes (Drechsler) Subramanian & Jain, Drechslera rostrata (Drechsler) Richardson & Fraser, Helminthosporium rostratum Drechsler;',E'Konidiophoren und Phragmokonidien dunkel, distoseptiert;',E'Inhalativ;',null,E'Exserohilum rostratum (Drechsler) Leonard & Suggs',E'Dematiaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (197,8,E'm 9',E'Fusarium verticillioides (Sacc.) Nirenberg;',E'Fusarium moniliforme Sheldon;',E'Colonies on oat agar (OA) very rapid-growing (4.6 cm/ 4 d), with much air mycelia, white to pink or violet, often discrete or as amorphous orange sporodoches, conidiophores on the side of the air mycelia, seldom ramified; conidiogene cells strictly monophialidic; macroconidies sickle-shaped to almost straight, 3-5 septate, 31-58 x 2.7-3.6 µm, sometimes only a few; microconida often oval to sickle-shaped, in chains, 7-10 x 2.5-3.2 µm; scleroties can be extant, dark blue, give the colony a blue tinge;',E'Inhalation, ingestion or by contact;',null,E'Fusarium verticillioides (Sacc.) Nirenberg;',E'Fusarium moniliforme Sheldon;',E'Kolonien auf Haferagar (OA) sehr schnell wachsend (4.6 cm/ 4 d), mit viel Luftmycel, weiß bis rosa bzw. violett, häufig diskrete oder verschmelzende orangene Sporodochen vorhanden,  Konidiophoren seitlich auf dem Luftmycel, selten verzweigt; Konidiogene Zellen streng monophialidisch; Makrokonidien sichelförmig  bis fast gerade, 3-5 septiert, 31-58 x 2.7-3.6 µm, manchmal nur wenige; Mikrokonidien häufig oval bis sichelförmig, in Ketten, 7-10 x 2.5-3.2 µm; Sklerotien können vorhanden sein, dunkelblau, geben der Kolonie ein bläuliches Aussehen;',E'Inhalativ, ingestiv oder durch Kontakt;',null,E'Fusarium verticillioides (Sacc.) Nirenberg;',E'Tuberculariaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (198,8,E'm 10',E'Stemphylium botryosum Wallroth 1833',null,E'Colonies thick, gray, condiogene cells and conidia dark, Kondidien muriform, spherical to egg-shaped; double walled ascus with 8 spores in one or two longitudinal rows; ascosporea gold-brown, attitudinally and longitudinally septate;',E'Inhalation, nutritive;',null,E'Stemphylium botryosum Wallroth 1833',null,E'Kolonien dicht, grau, Kondiogene Zellen und Konidien dunkel, Kondidien muriform, kugelig bis eiförmig; \ndoppelwandiger Ascus mit 8 Sporen in einer oder zwei Längsreihen; Ascosporen goldbraun, quer und längs septiert;',E'Inhalativ, nutritiv;',null,E'Stemphylium botryosum Wallroth 1833',E'Dematiaceae',E'Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (199,8,E'm 11',E'Rhizopus stolonifer (Ehrenb. ex Link) Lind 1913',E'Mucor stolonifer Ehrenb. 1818 ex Link 1824: Fr. 1832, Rhizopus nigricans Ehrenb. 1820 ex Corda 1838;',E'Colonies grow rapidly on malt agar (MEA), white, sporangies carrier grouped 1-3 (sometimes more), brown, up to 2 mm high and 20 µm thick; well developed ramified rhizoide; sporangies are black, round, diameter up to 275 µm, Columella conical up to 140 µm high; sporangiospore  irregular, variable, of bent, round to ellipsoid, up to 13 µm long, striped; none chlamydospore ; zygospore  black, warty, up to 200 µm diameter, between unequally large suspensors, heterothallic;',E'Inhalation, nutritive;',null,E'Rhizopus stolonifer (Ehrenb. ex Link) Lind 1913',E'Mucor stolonifer Ehrenb. 1818 ex Link 1824: Fr. 1832,\nRhizopus nigricans Ehrenb. 1820 ex Corda 1838;',E'Kolonien auf Malzagar (MEA) schnellwachsend, weißlich, Sporangienträger zu 1-3 (manchmal mehr) gruppiert, bräunlich, bis zu 2 mm hoch und 20 µm dick; gut entwickelte verzweigte Rhizoide; Sporangien schwarz, rund, Durchmesser bis zu 275 µm, Columella konisch bis zu 140 µm hoch; Sporangiosporen unregelmäßig, variabel, von gekrümmt, rundlich bis ellipsoid, bis zu 13 µm lang, gestreift; keine Chlamydosporen;\nZygosporen schwarz, warzig, bis zu 200 µm Durchmesser, zwischen ungleich großen Suspensoren, heterothallisch;',E'Inhalativ, nutritiv;',null,E'Rhizopus stolonifer (Ehrenb. ex Link) Lind 1913',E'Mucoraceae',E'Mucorales',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (200,8,E'm 13',E'Phoma betae Frank',null,E'Colonies at first white, later darkening; builds thin-walled pyknidies with oval, hyaline, single-celled conidia;',E'Inhalation, on contact, nutritive;',null,E'Phoma betae Frank',null,E'Kolonien erst weiß, später nachdunkelnd; bildet dünnwandige Pyknidien mit ovalen, hyalinen, einzelligen Konidien;',E'Inhalativ, kontaktiv, nutritiv;',null,E'Phoma betae Frank',E'Phomaceae',E'Sphaeropsidales',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (201,8,E'm 14',E'Epicoccum nigrum Link ex Link 1825',E'Epicoccum purpurascens Ehrenb. ex Schlecht; Toruloidea tobaica of Szilvinyi; Epicoccum granulatum Penzig; Epicoccum humicola (Buchanan) Saccardo; Thyrococcum humicola Buchanan; Epicoccum neglectum Desmazières; Epicoccum mezzetti, Goidánich; Epicoccum oryza, S. Ito & Iwadare; Epicoccum vulgare Corda;',E'Colonies on malt (MEA) or oat agar (OA) at 20°C reach a diameter of at least 6 cm in 10 days, yellow-orange, red or brown, sometimes greenish. On the bottom side they are often more intensively colored. Alter 8-10 days, visible sporodochia (clustered conidiophores) appear as black dots, diameter 100-2000 µm. Conidiophores, straight or more or less bent; individually formed blasto-conidis, round to pear-shaped, often 15-25 µm, with a funnel-shaped base and wide base scar, dark gold-brown, rough, builds septs, which divide the conidia into up to 15 cells; the spores are actively catapulted away. Frequently, sterile cultures can be  induced to sporulation by means of UV light.',E'Inhalation, nutritive;',null,E'Epicoccum nigrum Link ex Link 1825',E'Epicoccum purpurascens Ehrenb. ex Schlecht;\nToruloidea tobaica von Szilvinyi;\nEpicoccum granulatum Penzig;\nEpicoccum humicola (Buchanan) Saccardo;\nThyrococcum humicola Buchanan;\nEpicoccum neglectum Desmazières;\nEpicoccum mezzetti, Goidánich;\nEpicoccum oryza, S. Ito & Iwadare;\nEpicoccum vulgare Corda;',E'Kolonien auf Malz- (MEA) oder Haferagar (OA) erreichen bei 20°C einen Durchmesser von mindestens 6 cm in 10 Tagen, gelborange, rot oder braun, manchmal grünlich. Auf der Unterseite sind sie oft intensiver gefärbt. Nach 8-10 Tagen erscheinen als schwarze Punkte sichtbare Sporodochien (geclusterte Konidiophoren), Durchmesser 100-2000 µm. Konidiophoren, gerade oder mehr oder weniger gekrümmt; einzeln gebildete Blastokonidien, rund bis birnenförmig, häufig 15-25 µm, mit einer trichterförmigen Basis und breiter Ansatznarbe, dunkel goldbraun, rauh, bildet Septen, welche die Konidien in bis zu 15 Zellen teilen; die Sporen werden aktiv weggeschleudert.\nHäufig sterile Kulturen können mittels UV-Licht zur Sporulation angeregt werden.',E'Inhalativ, nutritiv;',null,E'Epicoccum nigrum Link ex Link 1825',E'Tuberculariaceae',E'Hyphomycetes',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (202,8,E'm 15',E'Trichoderma viride Pers. ex Gray 1821',E'Trichoderma lignorum (Tode) Harz; Eidamia viridescens Horne & Williamson;',E'Colonies on oat agar (OA) at 20°C can reach a diameter of 4.5-7.5(-9) cm in 5 days; at first more or less hyaline, later becoming white-green with bush-like blue-green conidia regions; rear side colorless; conidiophores pyramidal ramified; phialids are in groups of 2-4 and long and often bent (6-)8-14(-20) x 2,4-3.0 µm; conidia round, sometimes a rather wide ellipsoid, 3,6-4.5(-4,8) µm, rough-walled; chlamydospores usually extant in the mycelia of older cultures, intercalar, sometimes terminal, usually round, hyaline, smooth-walled;',E'Inhalation, nutritive;',null,E'Trichoderma viride Pers. ex Gray 1821',E'Trichoderma lignorum (Tode) Harz;\nEidamia viridescens Horne & Williamson;',E'Kolonien auf Haferagar (OA) erreichen bei 20°C einen Durchmesser von 4,5-7,5(-9) cm in  5 Tagen; zunächst mehr oder weniger hyalin, später weißlich-grün werdend mit büscheligen bläugrünen Konidienregionen; Rückseite farblos; Konidiophoren pyramidal verzweigt; Phialiden in Gruppen von 2-4 lang und oft gebogen (6-)8-14(-20) x 2,4-3,0 µm; Konidien rundlich, manchmal eher breit ellipsoid, 3,6-4,5(-4,8) µm, rauhwandig; Chlamydosporen meist vorhanden im Mycel älterer Kulturen, intercalar, manchmal terminal, meist rund, hyalin, glattwandig;',E'Inhalativ, nutritiv;',null,E'Trichoderma viride Pers. ex Gray 1821',E'Moniliaceae Familie: Moniliaceae',E'Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (203,8,E'm 16',E'Curvularia lunata (Wakker) Boedijn 1933; as var. aeria and var. Lunata',E'Malustela aeria Batista et al. Acrothecium lunatum Wakker 1898, Helminthosporium curvulum Saccardo 1916, Curvularia lycoperci Tandon & Kakkar 1964;',E'Dark brown colonies on oat agar (OA) achieve a diameter of 6 cm in 5 days at 25 °C. conidiophores variable, individually or in groups, ramified or unbranched, straight or bent, sometimes bent over, brown, pale for the point, on natural substrate up to 650 µm (smaller in cultures), 5-9 µm wide on the base; Poroconidies three-fold septate, third cell bent, often darker, 20-30 x 9-15 µm; acomata black, 410-700 µm high, with distinct beaked opening, asci cylindrical or club-shaped, unitunicate; spores string-shaped, twisted in the ascus, narrowing somewhat at the end, 6-15-fold septate, 130-270 x 3,8-6.5 µm;',E'Inhalation; nutritive',null,E'Curvularia lunata (Wakker) Boedijn 1933',E'Malustela aeria Batista et al. \nAcrothecium lunatum Wakker 1898, Helminthosporium curvulum Saccardo 1916, Curvularia lycoperci Tandon & Kakkar 1964;',E'Dunkelbraune Kolonien erreichen auf Haferagar (OA) einen Durchmesser von 6 cm in 5 Tagen bei 25 °C. Konidiophoren variabel, einzeln oder in Gruppen, verzweigt oder unverzweigt, gerade oder gekrümmt, manchmal geknickt, braun, blasser zur Spitze, auf natürlichem Substrat bis zu 650 µm (in Kultur kleiner), an der Basis 5-9 µm breit; Porokonidien dreifach septiert, dritte Zelle gekrümmt, oft dunklert, 20-30 x 9-15 µm; \nAcomata schwarz, 410-700 µm hoch, mit deutlich geschnäbelter Öffnung, Asci zylindrisch oder keulenförmig, unitunicat; Sporen fadenförmig, im Ascus verdreht, zum Ende sich etwas verjüngend,  6-15-fach septiert, 130-270 x 3,8-6,5 µm;',E'Inhalativ; nutritiv',null,E'Curvularia lunata (Wakker) Boedijn 1933; als var. aeria und var. lunata',E'Dematiaceae',E'Hyphomycetes',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (204,8,E'm 19',E'Aspergillus versicolor (Vuill.) Tiraboschi 1926',E'Aspergillus amoenus Roberg, Sterigmatocystis versicolor Vuill 1903;',E'Colonies on Czapek agar (CZ) can reach a diameter of 1.0-1.5 cm in 7 days. Within two weeks spores form; either tightly standing conidiophores, or conidiophores on thickly woven mycelia; color at first white, then changing to yellow, orange-yellow to yellow-green, often mixed with flesh or pink colors; conidiophores hyaline or lightly pigmented, smooth-walled; vesicle round to ellipsoid, diameter 12-16 µm; phialids 5.5-8.0 x 2.5-3.0 µm on metulae 5.0-7.5 x 2.0-2.5 µm; conidia round, diameter 2-3.5 µm, thorned; Hull cells sometimes extant, colonies on malt agar are faster growing and with less air mycelium; colors are then in darker shades of gray;',E'Inhalation or nutritive;',null,E'Aspergillus versicolor (Vuill.) Tiraboschi 1926',E'Aspergillus amoenus Roberg, Sterigmatocystis versicolor Vuill 1903;',E'Kolonien erreichen auf Czapekagar (CZ) einen Durchmesser von 1,0-1,5 cm in 7 Tagen. Innerhalb von zwei Wochen sporulierend; entweder dichtstehende Konidiophoren, oder Konidiophoren auf dicht verwobenem Mycel; Farbe erst weiß, dann sich verändernd über gelb, orangelb bis gelbgrün, oft fleisch- oder pinkfarben untermischt; Konidiophoren hyalin oder leicht pigmentiert, glattwandig; Vesikel rundlich bis ellipsoid, Durchmesser 12-16 µm; Phialiden 5,5-8,0 x 2,5-3,0 µm auf Metulae 5,0-7,5 x 2,0-2,5 µm; Konidien rund, Durchmesser 2-3,5 µm, stachelig; Hüllzellen manchmal vorhanden, Kolonien auf Malzagar schneller wachsend und mit weniger Luftmyzel; Farben dann in dunkleren Grauschattierungen;',E'Inhalativ oder nutritiv;',null,E'Aspergillus versicolor (Vuill.) Tiraboschi 1926',E'Moniliaceae Familie: Moniliaceae',E'Hyphomycetes Familie: Moniliaceae',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (205,8,E'm 20',E'Mucor mucedo Mich. ex St.-Am 1821;',E'Mucor griseo-ochraceus Naumov 1915, Mucor murorum Naumov 1915, Mucor coprophilus Povah 1917;',E'Colonies in darkness up to 25 mm high, yellow-gray, in the light on natural substrate very long (up to 15 cm) consisting of a sparse layer of high, seldom ramified sporangiophores and a well-developed layer of short often ramified sporangiophores; sporangies diameter 80-200 µm, at first yellow then yellow-gray, with prickly light blurred wall, Columella oval or in reverse egg-shaped to cylindrical; sporangiospores ellipsoid 6-12 x 8-9 µm; zygospores  round or pressed between the suspensors up to 200 x 250 µm with warty appendages of up to 15 µm long; suspensors similar to the zygospore , swollen, yellow to brown;',E'Inhalation and nutritive;',null,E'Mucor mucedo Mich. ex St.-Am 1821;',E'Mucor griseo-ochraceus Naumov 1915, Mucor murorum Naumov 1915, Mucor coprophilus Povah 1917;',E'Kolonien im Dunkeln bis zu 25 mm hoch, gelblichgrau, im Hellen auf natürlichem Substrat sehr lang (bis zu 15 cm) bestehend aus einer spärlichen Schicht hoher, selten verzweigter Sporangiophoren und einer gut entwickelten Schicht von kurzen häufig verzweigten Sporangiophoren; Sporangiendurchmesser 80-200 µm, zunächst gelb dann gelbgrau, mit stacheliger leicht zerfließender Wand, Columella oval oder umgekehrt eiförmig bis zylindrisch; Sporangiosporen ellipsoid 6-12 x 8-9 µm;\nZygosporen rund oder eingepresst zwischen den Suspensoren bis zu 200 x 250 µm mit warzigen Anhängseln bis zu 15 µm lang; Suspensoren ähnlich wie die Zygosporen, geschwollen, gelblich bis bräunlich;',E'Inhalativ und nutritiv;',null,E'Mucor mucedo Mich. ex St.-Am 1821;',E'Mucoraceae',E'Mucorales',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (206,8,E'm 21',E'Aspergillus clavatus Desm. 1834',null,E'Colonies on Czapek agar (CZ) attain a diameter of 2.5-3.5 cm in 7 days; mostly consisting of a dense coat of blue-green long conidiophores; conidia heads club-shaped, usually splitting up from each other in separate rows; conidiophores 1.5-3.0 mm long, hyaline, smooth-walled; vesicle club-shaped, usually 40-60 µm wide; phialids standing directly on the vesicle, of variable size, (2.5)7-(3.5)8 x 2-3 µm.  Conidia ellipsoid, 3.0-4.5 x 2.5-4.5 µm, greenish, smooth-walled;',E'Inhalation or nutritive;',null,E'Aspergillus clavatus Desm. 1834',null,E'Kolonien auf Czapekagar (CZ) erreichen einen Durchmesser von 2,5-3,5 cm in 7 Tagen; meist bestehend aus einem dichten Fell blaugrüner langer Konidiophoren; Konidienköpfe keulenförmig, gewöhnlich sich aufspaltend in von einander abstehenden Reihen; Konidiophoren 1,5-3,0 mm lang, hyalin, glattwandig; Vesikel keulenförmig, meist 40-60 µm breitM; Phialiden stehen direkt auf dem Vesikel, von variabler Größe, (2,5)7-(3,5)8 x 2-3 µm. Konidien ellipsoid, 3,0-4,5 x 2,5-4,5 µm, grünlich, glattwandig;',E'Inhalativ oder nutritiv;',null,E'Aspergillus clavatus Desm. 1834',E'Moniliaceae',E'Hyphomycetes',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (207,8,E'm 32',E'Cladosporium cladosporioides (Fres.) de Vries 1952',E'Monilia humicola Oudemans, Cladosporium pisicola Snyder (Synonym of Cladosporium cladosporioides f. pisicola); Black fungus;',E'Colonies on malt agar (MEA) at 18-20 °C can reach a diameter of (1.5)3-4 cm in 10 days. They are satin-like, become powdery during the production of spores and are olive brown or gray-green. The rear side is greenish-black. Conidiophores sometimes emerge from the side terminal on the hyphen, and are up to 350 µm long, but usually shorter and 2-6 µm wide. They carry ramified conidiacettes and are pale to olive brown, smooth-walled or warty. Ramoconidies on the base of the chains, 0-1(-2) septate, more or less cylindrical, to 30 x 3.5 µm, brown or green-brown, smooth-walled or sometimes with tiny warts; conidia in the acropetalen chains usually single-celled, ellipsoid to lemon-shaped, 3-7(-11) x 2-4(5) µm, brown or green-brown, usually smooth-walled, sometimes warty;',E'Inhalation and nutritive;',null,E'Cladosporium cladosporioides (Fres.) de Vries 1952',E'Monilia humicola Oudemans, Cladosporium pisicola Snyder (Synonym von Cladosporium cladosporioides f. pisicola);\nSchwärzepilz;',E'Kolonien erreichen auf Malzagar (MEA) bei 18-20 °C einen Durchmesser von (1,5)3-4 cm in 10 Tagen. Sie sind samtig, werden durch die Produktion von Konidien pudrig und sind olivbraun oder graugrün. Die Rückseite ist grünlichschwarz. Konidiophoren entstehen seitlich manchmal terminal auf den Hyphen, sind bis zu 350 µm lang, meist jedoch kürzer und 2-6 µm breit. Sie tragen verzweigte Konidienketten und sind blaß bis olivbraun, glattwandig oder warzig. Ramokonidien an der Basis der Ketten, 0-1(-2) septiert, mehr oder weniger zylindrisch, bis zu 30 x 3,5 µm, braun oder grünbraun, glattwandig oder manchmal mit winzigen Warzen; Konidien in den akropetalen Ketten meist einzellig, ellipsoid bis zitronenförmig, 3-7(-11) x 2-4(5) µm, braun oder grünbraun, meist glattwandig, manchmal warzig;',E'Inhalativ und nutritiv;',null,E'Cladosporium cladosporioides (Fres.) de Vries 1952',E'Moniliaceae',E'Hyphomycetes',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (208,8,E'm 36',E'Aspergillus terreus Thom',null,E'On Czapek agar (CZ) at 25°C, the colonies can reach a diameter of 3.5-5.0 cm in 7 days and consist usually of a thick layer of yellow-brown conidiophores, which become darker with age. Little conidia heads are compact, rod-shaped, usually 150-500 x 30-50 µm; conidiophores hyaline, smooth-walled; round vesicle, 10-20 µm in diameter; phialides 5-7 x 2.0-2.5 µm on standing metulae; round to ellipsoid conidia, 1.5-2.5 µm diameter, hyaline to light yellow, smooth;',E'Inhalation and nutritive;',null,E'Aspergillus terreus Thom',null,E'Die Kolonien erreichen auf Czapekagar (CZ) bei 25°C einen Durchmesser von 3,5-5,0 cm in 7 Tagen und bestehen meist aus einem dichten Filz von gelbbraunen Konidiophoren, die mit dem Alter dunkler werden. Konidienköpfchen kompakt, säulenförmig, meist 150-500 x 30-50 µm; Konidiophoren hyalin, glattwandig; Vesikel rundlich, 10-20 µm im Durchmesser; Phialiden 5-7 x 2,0-2,5 µm auf Metulae stehend; Konidien rund bis ellipsoid, 1,5-2,5 µm Durchmesser, hyalin bis leicht gelblich, glatt;',E'Inhalativ und nutritiv;',null,E'Aspergillus terreus Thom',E'Moniliaceae',E'Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (209,8,E'm 40',E'Aspergillus hollandicus Gams & Samson',E'Aspergillus amstelodami (Mangin) Thom & Church, Aspergillus vitis Novobranova;',E'Member of the Aspergillus glaucus group; colonies inhibited on Czapek agar (CZ), grow rapidly auf Agar with 20% saccharose, yellow to matt yellow-gray; little conidia heads radially to loose rod-shaped, olive green; condidiophores smooth-walled, 275-350 µm long; vesicle ball-shaped, 18-25 µm diameter; condiogene cells unseriate, 5-8 x 3,4-5 µm, cover at least the upper two thirds of the vesicles; conidia more or less ball-shaped, finely roughed to thickly thorned, 3-5 µm diameter. Ascomata (Cleisdeadhecien), spherical 120-160 µm, clustered, form a thick layer; Asci 8 spores,  round, 10-12 µm; Ascospore  pale, rough-walled, with a V-shaped equatorial fissure, lens-shaped 4.5-6 x 3.5-4 µm;',E'Inhalation and nutritive;',null,E'Aspergillus hollandicus Gams & Samson',E'Aspergillus amstelodami (Mangin) Thom & Church,\nAspergillus vitis Novobranova;',E'Angehöriger der Aspergillus glaucus Gruppe; Kolonien auf Czapekagar (CZ) gehemmt, schnellwachsend auf Agar mit 20% Saccharose, gelb bis matt gelbgrau; Konidienköpfchen radiär bis locker säulenförmig, olivgrün; Konidiophoren glattwandig, 275-350 µm lang; Vesikel kugelförmig, 18-25 µm Durchmesser; Konidiogene Zellen unseriat, 5-8 x 3,4-5 µm, bedecken mindestens die oberen zwei Drittel des Vesikels; Konidien mehr oder weniger kugelförmig, fein angerauht bis dichtstachelig, 3-5 µm Durchmesser. Ascomata (Cleistothecien), kugelig 120-160 µm, geclustert, bilden eine dichte Schicht; Asci 8 sporig, rund oder rundlich, 10-12 µm; Ascosporen blaß, rauhwandig, mit einer V-förmigen äquatorialen Furche, linsenförmig 4,5-6 x 3,5-4 µm;',E'Inhalativ und nutritiv;',null,E'Aspergillus hollandicus Gams & Samson',E'Moniliaceae',E'Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (210,8,E'm 42',E'Wheat blight',null,E'In cultivation, only one yeast stage is formed. In the host plant, the fungus grows unobtrusively up to the ripening of the blight spore .',E'Inhalation;',null,E'Weizenbrand',null,E'In Kultur wird nur ein Hefestadium gebildet. In der Wirtspflanze wächst der Pilz unscheinbar bis zur Ausbildung der Brandsporen.',E'Inhalativ;',null,E'Ustilago tritici (Persoon : Persoon) Rostrup',E'Ustilaginaceae',E'Ustilaginales',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (211,8,E'm 43',E'Brewer’s yeast',E'Saccharomyces boulardii Seguela et al., Saccharomyces chodatii Steiner, Saccharomyces cordubensis Santa María, Saccharomyces coreanus Saito, Saccharomyces diastaticus Andrews & Gilliland ex van der Walt, Saccharomyces ellipsoideus Reess var. ellipsoideus, Saccharomyces steineri Lodder & Kreger-van Rij, Saccharomyces gaditensis Santa María, Saccharomyces hienipiensis Santa María, Saccharomyces hispalensis Santa María, Saccharomyces hispanica Santa María, Saccharomyces lindneri Guilliermond, Saccharomyces logos Van Laer ex A. Jörgensen, Saccharomyces norbensis Santa María, Saccharomyces oleaceus Santa María, Saccharomyces oleaginosus Santa María, Saccharomyces onubensis Santa María, Saccharomyces prostoserdovii Kudryavtsev, Saccharomyces odessa Schnegg & Oehlkers, Saccharomyces italicus Castelli var.iItalicus, Saccharomyces willianus Saccardo, Saccharomyces aceti Santa María, Saccharomyces beticus Marcilla ex Santa María, Saccharomyces capensis van der Walt & Tscheuschner, Saccharomyces brasiliensis Lindner, Candida robusta Diddens & Lodder; brewer’s yeast, backer’s yeast;',E'Colonies slow growing, cream colored, damp; budding cells wide ellipsoid, buds multilateral; sometimes exist pseudomycel; ascospore  form in 1-4 in budded cells, round to wide ellipsoid, smooth-walled;',E'Nutritive;',null,E'Brauereihefe',E'Saccharomyces boulardii Seguela et al.,\nSaccharomyces chodatii Steiner,\nSaccharomyces cordubensis Santa María,\nSaccharomyces coreanus Saito,\nSaccharomyces diastaticus Andrews & Gilliland ex van der Walt,\nSaccharomyces ellipsoideus Reess var. ellipsoideus,\nSaccharomyces steineri Lodder & Kreger-van Rij,\nSaccharomyces gaditensis Santa María,\nSaccharomyces hienipiensis Santa María,\nSaccharomyces hispalensis Santa María,\nSaccharomyces hispanica Santa María,\nSaccharomyces lindneri Guilliermond,\nSaccharomyces logos Van Laer ex A. Jörgensen,\nSaccharomyces norbensis Santa María,\nSaccharomyces oleaceus Santa María,\nSaccharomyces oleaginosus Santa María,\nSaccharomyces onubensis Santa María,\nSaccharomyces prostoserdovii Kudryavtsev,\nSaccharomyces odessa Schnegg & Oehlkers,\nSaccharomyces italicus Castelli var.iItalicus,\nSaccharomyces willianus Saccardo,\nSaccharomyces aceti Santa María,\nSaccharomyces beticus Marcilla ex Santa María,\nSaccharomyces capensis van der Walt & Tscheuschner,\nSaccharomyces brasiliensis Lindner,\nCandida robusta Diddens & Lodder;\nBrauhefe, Bäckerhefe;',E'Kolonien langsam wachsend, cremefarben, feucht; Knospende Zellen breit ellipsoid, Knospung multilateral; manchmal Pseudomycel vorhanden; Ascosporen werden zu 1-4 in geknospten Zellen gebildet, rund bis breit ellipsoid, glattwandig;',E'Nutritiv;',null,E'Saccharomyces cerevisiae Meyen ex Hansen',E'Saccharomycetaceae',E'Endomycetales',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (212,8,E'm 45',E'Chaetomium globosum Kunze ex Steud. 1824',E'Chaetomidium barbatum Traaen, Chaetomium coarctatum Sergejeva, Chaetomium fibripilium Ames, Chaetomium mollipilium Ames, Chaetomium ochraceum Tschudy, Chaetomium olivaceum Cooke & Ellis, Chaetomium rectum Sergejeva, Chaetomium spiculipilium Ames, Chaetomium subglobosum Sergejeva, Chaetomium subterraneum Swift & Povah, Chaetomium lusitanicum M. Gomes, Chaetomium affine Corda, Chaetomium globosum var. affine Tschudy, Chaetomium kunzeanum Zopf, Chaetomium kunzeanum var. chlorina Saccardo, Chaetomium spirale Zopf;',E'Colonies on oat agar (OA) grow rapidly, with pale or olive-colored air mycelium, often with yellow, gray-green, green or red exudates; Ascomata (perithezies) spherical to oval 175-280 µm diameter, wall (Peridium) brown; ascomata with numerous hairs, these are usually unbranched, bent or twisted, septate, brownish to 500 µm long; asci 8-spores, club-shaped, 30-40 x 11-16 µm; ascospore  lemon-shaped, flattened on the side, usually brownish, 9-12 x 8-10 x 6-8 µm with an apical seed pore;',E'Inhalation and nutritive;',null,E'Chaetomium globosum Kunze ex Steud. 1824',E'Chaetomidium barbatum Traaen,\nChaetomium coarctatum Sergejeva,\nChaetomium fibripilium Ames,\nChaetomium mollipilium Ames,\nChaetomium ochraceum Tschudy,\nChaetomium olivaceum Cooke & Ellis,\nChaetomium rectum Sergejeva,\nChaetomium spiculipilium Ames,\nChaetomium subglobosum Sergejeva,\nChaetomium subterraneum Swift & Povah,\nChaetomium lusitanicum M. Gomes,\nChaetomium affine Corda,\nChaetomium globosum var. affine Tschudy,\nChaetomium kunzeanum Zopf,\nChaetomium kunzeanum var. chlorina Saccardo,\nChaetomium spirale Zopf;',E'Kolonien auf Haferagar (OA) schnellwachsend, mit blassem oder olivfarbenem Luftmyzel, häufig mit gelben, graugrünen, grünen oder roten Exudaten; Ascomata (Perithezien) kugelig bis oval 175-280 µm Durchmesser, Wand (Peridium) braun; Ascomata mit zahlreichen Haaren, diese gewöhnlich unverzweigt, gebogen oder sich windend, septiert, bräunlich bis 500 µm lang; Asci 8-sporig, keulenförmig, 30-40 x 11-16 µm; Ascosporen zitronenförmig, seitlich abgeflacht, gewöhnlich bräunlich, 9-12 x 8-10 x 6-8 µm mit einer apikalen Keimpore;',E'Inhalativ und nutritiv;',null,E'Chaetomium globosum Kunze ex Steud. 1824',E'Chaetomiaceae',E'Sordariales',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (213,8,E'm 47',E'Aspergillius nidulans (Eidam) Winter',null,E'The Aspergillus nidulans group provides the name; colonies on Czapek agar (CZ) grow rapidly, green, cream-leather colored or honey yellow, back side dark purple; conidia heads short and pillar-shaped, up to 80 µm long; conidophore stems brown, 60-130 x 2.5-3 µm; vesicle hemispheric, 8-10 µm diameter; conidiogene cells biserrate, 5,9 x 2-3 µm; metulae 5-6 x 2,3 µm; conidia spherical, with wrinkled surface, almost hyaline, greenish when in great amounts, 3-4 µm; ascomata spherical, purplish, 100-200 µm, surrounded by a yellowish to cinnamon-colored layer of fungal threads surrounded by dense aggregations of pale yellow, thick-walled roundish peridium cells; 8-spore asci, round to roundish, 7-12 µm; ascospores  purplish-red, smooth-walled, with two equatorial ridges (crista), lentil-shaped, 3.8-4.5 x 3.5-4 µm (excluding the ridges (crista);',E'Inhalation;',null,E'Aspergillius nidulans (Eidam) Winter',null,E'Der Aspergillus nidulans Gruppe den Namen gebend;\nKolonien auf Czapekagar (CZ) schnellwachsend, grün, crème-lederfarben oder honiggelb, Rückseite dunkelpurpurn;\nKonidienköpfe kurz, säulenförmig, bis zu 80 µm lang; Konidophorenstiele braun, 60-130 x 2,5-3 µm; Vesikel halbkugelig, 8-10 µm Durchmesser; Konidiogene Zellen biseriat, 5,9 x 2-3 µm; Metulae 5-6 x 2,3 µm; Konidien kugelig, mit faltiger Oberfläche, fast hyalin, in Massen grünlich, 3-4 µm;\nAscomata kugelig, purpurn, 100-200 µm, umgeben von einer gelblichen bis zimtfarbenen Schicht Hyphen, welche dichte Aggregationen  blassgelber, dickwandiger, rundlicher Hüllzellen umgeben;  Asci 8-sporig, rund bis rundlich, 7-12 µm; Ascosporen purpurrot, glattwandig, mit zwei äquatorialen Kämmen, linsenförmig, 3,8-4,5 x 3,5-4 µm (ausschließlich der Kämme);',E'Inhalativ;',null,E'Aspergillius nidulans (Eidam) Winter',E'Moniliaceae',E'Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (214,8,E'm 902',E'Pullularia pullulans (de Bary) Berkh.',E'Hormonema pullulans (de Bary) Robak; Aureobasidium pullulans (de Bary) Arn.',E'colonies auf malt agar (MEA) grow rapidly, smooth, soon covered with a slimy extrusion, cream colored or pink, later usually becoming brown or black; vegetative hyphen 3-12 µm wide, hyaline, locally changing into black-brown, thick-walled chlamydospores; expanding hyphen with irregular dichotomic branchings; undifferentiated conidiogene cells, usually intercalar in hyaline hyphen; conidia are produced in thick groups synchronal on small denticles. Later new ones are developed there. The Conidia remain in slimy heads, conidia hyaline, ellipsoid, very variable in form and size, (7.5)9-11(-16) x (3.5-)4-5.5(-7) µm, single-celled, often with a inconspicuous scar; buds open, endoconides open in intercalaral cells;',E'Inhalation and nutritive;',null,E'Pullularia pullulans (de Bary) Berkh.',E'Hormonema pullulans (de Bary) Robak;\nAureobasidium pullulans (de Bary) Arn.',E'Kolonien auf Malzagar (MEA) schnellwachsend, glatt, bald mit einem schleimigen Exudat bedeckt, crèmefarben oder pink, später meist braun oder schwarz werdend; vegetative Hyphen 3-12 µm breit, hyalin, lokal sich in schwarzbraune, dickwandige Chlamydosporen umwandelnd; expandierende Hyphen mit unregelmäßig dichotomen Verzweigungen; konidiogene Zellen undifferenziert, meist interkalar in hyalinen Hyphen; Konidien werden in dichten Gruppen synchron auf kleinen Dentikeln produziert. Später werden dort neue gebildet. Die Konidien verbleiben in schleimigen Köpfen. Konidien hyalin, ellipsoid, sehr variabel in Form und Größe, (7,5)9-11(-16) x (3,5-)4-5,5(-7) µm, 1-zellig, oft mit einer unscheinbaren Narbe; Knospung häufig, Endokonidien oft in interkalaren Zellen;',E'Inhalativ und nutritiv;',null,E'Pullularia pullulans (de Bary) Berkh.',null,E'Hyphomycetes',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (215,4,E'f 84',E'Kiwi',null,null,null,null,E'Kiwi',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (216,4,E'f 122',E'Plum',null,null,null,null,E'Pflaume',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (217,4,E'f 91',E'Mango',null,null,null,null,E'Mango',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (218,4,E'f 292',E'Guava fruit',null,null,null,null,E'Guave',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (219,4,E'f 4',E'Wheat flour',null,null,null,null,E'Weizenmehl',null,null,null,null,null,null,null,6,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (220,4,E'f 6',E'Barley flour',null,null,null,null,E'Gerstenmehl',null,null,null,null,null,null,null,6,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (221,4,E'f 7',E'Oat flour',null,null,null,null,E'Hafermehl',null,null,null,null,null,null,null,6,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (222,4,E'f 5',E'Rye flour',null,null,null,null,E'Roggenmehl',null,null,null,null,null,null,null,6,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (223,4,E'f 9',E'Rice',null,null,null,null,E'Reis',null,null,null,null,null,null,null,6,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (224,4,E'f 92',E'Banana',null,null,null,null,E'Banane',null,null,null,null,null,null,null,5,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (225,4,E'f 293',E'Papaya',null,null,null,null,E'Papaya',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (226,6,E's 2',E'Curry',null,null,null,null,E'Curry',null,null,null,null,null,null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (227,6,E's 6',E'Paprika, condiment',null,null,null,null,E'Paprika, Gewürz-',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (228,6,E'f 263',E'Pepper',null,null,null,null,E'Pfeffer, Grüner',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (229,6,E's 7',E'Pepper',null,null,null,null,E'Pfeffer',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (230,4,E'f 13',E'Peanut',null,null,null,null,E'Erdnuss',null,null,null,null,null,null,null,7,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (231,1,E'k 82',E'Latex',E'Natural caoutchouc, paracaoutchouc;',E'Natural latex is the milk sap emulsion of certain (mostly tropical) plants. The most important source for rubber production is the caoutchouc tree, Hevea brasiliensis (Willd.) Muell. Arg., belonging to the spurge (wolf''s-milk) family. Latex is extracted from the strictly tropical species indigenous to the Amazon basin by scratching the secondary bark. Latex contains an average of 65% water, 33% rubber (caoutchouc; cis-1-4-Isopren), up to 2% resin and 1.8% allergologically relevant protein. After harvesting, a premature coagulation is inhibited by adding  ammonia, or acids are directly added to coagulate the substance into raw caoutchouc. This is later vulcanized for the manufacture of rubber, i.e.  kneaded with sulphur and fillers at 140°C. A sulphur content of 4 – 5% produces a soft, elastic rubber and a content of 25 – 30% produces hard rubber.',E'Contactive, inhalative;',E'The proteins contained in the milk sap;',E'Latex',E'Naturkautschuk, Parakautschuk;',E'Naturlatex ist die Milchsaftemulsion bestimmter, meist tropischer Pflanzen. Wichtigster Lieferant für die Gummiproduktion ist der Parakautschukbaum,  Hevea brasiliensis (Willd.) Muell. Arg., ein Wolfsmilchgewächs.\nDie aus dem Amazonasbecken stammende, streng tropische Art erlaubt die Latexgewinnung durch Anritzen der sekundären Rinde. Latex enthält im Mittel neben 65% Wasser 33% Kautschuk (cis-1-4-Isopren), bis 2% Harz und 1,8% allergologisch relevantes Eiweiß.\nNach der Ernte verhindert man vorzeitiges Gerinnen durch Ammoniakzusatz oder er wird direkt durch Zusatz von Säuren zu Rohkautschuk koaguliert. Zur Gummiherstellung wird dieser später vulkanisiert, d. h. bei 140°C mit Schwefel und Füllstoffen verknetet. Dabei führt ein Schwefelgehalt von 4 – 5% zu weichem, elastischem Gummi und ein Gehalt von 25 – 30% zu Hartgummi.  \n',E'Kontaktiv, inhalativ;',E'Die im Milchsaft enthaltenen Proteine;',null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (232,4,E'f 49',E'Apple',null,null,null,null,E'Apfel',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (233,4,E'f 94',E'Pear',null,null,null,null,E'Birne',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (234,4,E'f 95',E'Peach',null,null,null,null,E'Pfirsich',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (235,4,E'f 271',E'Apricot',null,null,null,null,E'Aprikose',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (236,4,null,E'Lychee',null,null,null,null,E'Lychee',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (237,4,E'f 33',E'Orange',null,null,null,null,E'Orange',null,null,null,null,null,null,null,5,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (238,6,E's 901',E'Celery',null,null,null,null,E'Sellerie',null,null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (239,6,E's 11',E'Dill',null,null,null,null,E'Dill',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (240,6,E's 3',E'Caraway seed',null,null,null,null,E'Kümmel',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (241,6,E's 202',E'Coriander',null,null,null,null,E'Koriander',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (242,4,E'f 19',E'Edible chestnut',null,null,null,null,E'Esskastanie',null,null,null,null,null,null,null,7,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (243,4,null,E'Poppy seeds',null,null,null,null,E'Mohnsamen',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (244,4,E'f 908',E'Pig gelatine',null,null,null,null,E'Gelatine, Schweine-',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (245,4,E'f 909',E'gelatine, beef',null,null,null,null,E'Gelatine, Rinder-',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (246,4,E'f 801',E'Fruit gums',null,null,null,null,E'Gummibärchen',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (247,1,null,E'Ficus benjamini (Tropic Laurel, Weeping Fig)',null,E'The ornamental fig Ficus benjamina L. is indigenous in the greater East Asian-Indian-Australian area. The plant has a dense foliage of oval-pointed leathery leaves, and is a small-growing, often bush-like tree of the mulberry plant family, with overhanging branches. The genus Ficus includes more than 1,000 different species. In indigenous areas the plant is used as a host tree for lac insects, from whose secretions shellac is extracted, and it also serves as a latex supplier for the manufacture of rubber. In Europe the Tropic Laurel has grown to become one of the most popular decorative plants for living rooms and businesses. Such species do not blossom. Likewise kept as indoor plants are the rubber plant, Ficus elastica, the fiddle leaf fig, Ficus lyrata, the clown fig, Ficus aspera, the mistletoe fig, Ficus deltoidea as well as Ficus cannonii, Ficus rubiginosa, Ficus sagittata, Ficus montana, Ficus pumila and Ficus villosa.',E'Inhalative and contactive;',E'The proteins in the milk sap. The patient.allergens also make their way to the leaf surface and bind themselves to dust particles there. This way they are also present in house dust.',E'Ficus benjamini (Birkenfeige)',null,E'Die Zierfeige Ficus benjamina L. ist im Ostasiatisch-Indisch-Australischen Raum beheimatet. Es handelt sich um einen dicht mit oval zugespitzten, ledrigen Blättern belaubten, kleinwüchsigen, oft strauchartigen Baum mit überhängenden Zweigen aus der Familie der Maulbeerbaumgewächse. Die Gattung Ficus fasst über 1000 verschiedene Arten zusammen. \nIn ihrer Heimat dient die Pflanze zum einen als Wirtsbaum für Lackschildläuse, aus deren Sekreten Schelllack gewonnen wird und zum anderen als Latexlieferant zur Herstellung von Kautschuk. \nIn Europa zählt die Birkenfeige mittlerweile zu den populärsten Dekorationspflanzen in Wohn- und Geschäftsräumen. Als solche gelangt die Art nicht zur Blüte.\nEbenfalls als Zimmerpflanzen gehalten werden der Gummibaum, Ficus elastica, die Geigenfeige, Ficus lyrata, die Clownfeige, Ficus aspera, die Mistelfeige, Ficus deltoidea sowie Ficus cannonii, Ficus rubiginosa, Ficus sagittata, Ficus montana, Ficus pumila und Ficus villosa.\n',E'Inhalativ und kontaktiv;',E'Die im Milchsaft enthaltenen Proteine. Die Allergene gelangen auch an die Blattoberfläche und binden sich dort an Staubpartikel. So sind sie im Anschluss auch im Hausstaub präsent.  ',E'Ficus benjamina L.',E'Moraceae',null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (248,4,E'f 87',E'Melon',null,null,null,null,E'Melone',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (249,4,E'f17',E'Hazelnut',null,null,null,null,E'Haselnuss',null,null,null,null,null,null,null,7,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (250,4,E'f16',E'Walnut',null,null,null,null,E'Walnuss',null,null,null,null,null,null,null,7,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (251,4,E'f51',E'Soy meal',null,null,null,null,E'Sojaschrot',null,null,null,null,null,null,null,8,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (252,4,E'f219',E'Fennel seed',null,null,null,null,E'Fenchelsamen',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (253,4,E'f73',E'Cherry',null,null,null,null,E'Kirsche',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (254,9,null,E'Blomia tropicalis',null,null,E'Inhalation; the dead individuals and their dried out excrement eventually with time turn to dust. This is lifted into the air by handling the supplies or by activities in the house.',E'Probably body and excrement proteins',E'Blomia tropicalis',null,null,E'Inhalativ; die abgestorbenen Tiere und deren ausgetrockneter Kot zerfallen mit der Zeit zu Staub. Dieser wird bei der Handhabung der Vorräte oder bei Aktivitäten im Haus aufgewirbelt.',E'Wahrscheinlich Körper- und Kotproteine',E'Blomia tropicalis; Glycyphagidae; Acari, Milben',null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (255,9,null,E'Silverfish',E'Zuckergast',null,E'Inhalation; dead individuals and their remains turn to dust in time and then can enter the breathing air. In house dust samples, up to 0.01% silverfish protein has been detected.',E'Probably body and excrement proteins',E'Silberfischchen',E'Zuckergast',null,E'Inhalativ; tote Tiere und deren Hinterlassenschaften zerfallen mit der Zeit zu Staub und können so schließlich in die Atemluft gelangen. In Hausstaubproben konnte bereits 0,01% Silberfischprotein nachgewiesen werden. ',E'Wahrscheinlich Körper- und Kotproteine',E'Lepisma saccharina L., Lepismatidae, Fischchen; Thysanura, Borstenschwänze',null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (256,4,E'f23',E'Shrimp',null,null,null,null,E'Garnele',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (257,4,E'f80',E'Lobster',null,null,null,null,E'Hummer',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (258,4,E'f234',E'Crab',null,null,null,null,E'Krabbe',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (259,4,E'f71',E'Crayfish',null,null,null,null,E'Languste',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (260,4,E'f24',E'Scampi',null,null,null,null,E'Scampi',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (261,8,null,E'Pityrosporum, oval',E'Cryptococcus malassezi (Sabouraud) Benedek; Cryptococcus ovalis Vuillemin; Cryptococcus psoriasis Rivolta; Dermatophyton malassez Dold; Malassezia ovalis (Bizzozero) Acton & Panja; Malassezia tropica (Castellani) Schmitter; Microsporon furfur C.E. Robin; Monilia furfur (C.E. Robin) Vuillemin; Oidium furfur (C.E. Robin) Zopf; Pityrosporum orbiculare Gordon; Pityrosporum ovale (Bizzozero) Castellani & Chalmers; Saccharomyces capillitii Oudemans & Pekelharing; Saccharomyces ovalis Bizzozero; Saccharomyces sphaericus Bizzozero; Sporotrichum furfur (C.E. Robin) Saccardo; Torulopsis ovalis (Bizzozero) de Almeida',E'The species requires an oil-rich substrate for growth; i.e. Sabouraud Dextroseagar covered with olive oil. They build cream-colored to yellow yeast colonies which are smooth or slightly folded, shining or matte, smooth edged or serrated. After 3 days at 37 °C, two forms can appear: 1. An oval form with predominantly ovoid, ellipsoid to cylindrical cells of 2.0-6.0 x 1.5-4.5 µm diameter and 2. a ball-like form with predominantly round cells of 2.5-4.5 µm diameter. The buds are monopolar with a wide base. On the skin the species behaves dimorphic, that is, in addition to the yeast cells they also build hyphen.',E'Skin contact',null,E'Pityrosporum ovale',E'Cryptococcus malassezi (Sabouraud) Benedek; \nCryptococcus ovalis Vuillemin; \nCryptococcus psoriasis Rivolta; \nDermatophyton malassez Dold; \nMalassezia ovalis (Bizzozero) Acton & Panja; \nMalassezia tropica (Castellani) Schmitter; \nMicrosporon furfur C.E. Robin; \nMonilia furfur (C.E. Robin) Vuillemin; \nOidium furfur (C.E. Robin) Zopf; \nPityrosporum orbiculare Gordon; \nPityrosporum ovale (Bizzozero) Castellani & Chalmers; \nSaccharomyces capillitii Oudemans & Pekelharing; \nSaccharomyces ovalis Bizzozero; \nSaccharomyces sphaericus Bizzozero; \nSporotrichum furfur (C.E. Robin) Saccardo; \nTorulopsis ovalis (Bizzozero) de Almeida \n',E'Die Art benötigt zum Wachstum ein ölhaltiges Substrat; z.B. mit Olivenöl überschichteter Sabouraud Dextroseagar. Sie bildet cremefarbige bis gelbliche Hefekolonien, die glatt bis leicht gefaltet, glänzend oder matt, ganzrandig oder eingebuchtet sind.\nNach 3 Tagen bei 37 °C können zwei Formen auftreten: 1. Eine ovale Form mit überwiegend ovoiden, ellipsoiden bis zylindrischen Zellen von 2,0-6.0 x 1,5-4,5 µm Durchmesser und 2. eine kugelige Form mit überwiegend runden Zellen von 2,5-4,5 µm Durchmesser.\nDie Knospung erfolgt monopolar mit breiter Basis.\nAuf der Haut verhält sich die Art dimorph, d.h. sie bildet zusätzlich zu den Hefezellen auch Hyphen.\n',E'Hautkontakt',null,E'Pityrosporum ovale',null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (262,2,null,E'Red Fescue',null,E'20 cm to 60 cm high, runner-forming, grassy meadow grasses with greenish to red ears and 1 mm to 2 mm long grains; perennial; leaves 3 mm wide at most; the base leaves in fact are bristly; flowering time: VI - VII; average  fodder grass; eight minor species or subspecies have  been described.',E'Inhalation (June – July);',E'Pollen',E'Roter Schwingel',null,E'20 cm bis 60 cm hohes, Ausläufer bildendes, lockerrasiges Rispengras mit grünlichen bis rötlichen Ährchen und 1 mm bis 2 mm langen Grannen; mehrjährig; Blätter höchstens 3 mm breit; die Grundblätter sogar nur borstlich;\nBlütezeit: VI - VII; mittelwertiges Futtergras; es wurden 8 Kleinarten bzw. Unterarten beschrieben.\n',E'Inhalativ (Juni – Juli);',E'Pollen',E'Festuca rubra L.',E'Poaceae',null,null,6,7,2,2);

SELECT SETVAL('patient.allergens_id_seq', (SELECT MAX(id)+1 FROM patient.allergens), FALSE);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (-1,777,'----','-----','-----',2);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,774,'Nuts','Fruits à coque','Schalenfrüchte',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,773,'Milk (including lactose)','Lait (inclusive Lactose)','Milch (inklusive Laktose)',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,772,'Soy','Soja','Soja',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,3971,'Egg','Oeuf','Ei',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,771,'Peanut','Arachide','Erdnuss',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,782,'Gluten','Glute','Gluten',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,776,'Mustard','Moutarde','Senf',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,775,'Celery','Céleri','Sellerie',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,768,'Crustaceans','Crustacés','Krebstiere',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,3972,'Fish','Poisson','Fisch',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,778,'Sulphur dioxide / Sulphite','Dioxyde de soufre / Sulfite','Schwefeldioxid / Sulfit',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,3974,'Molluscs','Mollusques','Weichtiere',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,3973,'Lupin','Lupin','Lupinen',1000);
INSERT INTO patient.allergens (groupid,code,name_en,name_fr,name_de,datasource) values (1000,777,'Sesame seeds','Graines de sésame','Sesamsamen',1000);



INSERT INTO patient.incident_entry_types (name,mime_type) VALUES(E'soap.s',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES(E'soap.o',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES(E'soap.a',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES(E'soap.p',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES(E'measurement',E'text/plain');

INSERT INTO patient.incident_entry_types (name,mime_type) VALUES (E'cons.1',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES (E'cons.2',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES (E'cons.3',E'text/plain');
INSERT INTO patient.incident_entry_types (name,mime_type) VALUES (E'sick_leave',E'text/plain');

/** Insert the diagnosis codes for the autocompletion of the sick leave field */

INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'01 | Acte médical avec suite latrogénique', E'01');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'02 | Cure thermale', E'02');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'03 | Convalescence après intervention chirurgicale jusqu'' à la 1ère reprise de travail', E'03');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'04 | Cancer', E'04');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'05 | Fractrue', E'05');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'06 | Contusion, élongation, foulure, commotion', E'06');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'07 | Plaie, brûlure', E'07');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'10 | Vertiges', E'10');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'11 | Céphalées', E'11');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'12 | Accident vasculaire cérébral', E'12');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'13 | Maladie dégénérative du système nerveux', E'13');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'14 | Canal carpien', E'14');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'15 | Autre affection neurologique ou musculaire', E'15');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'20 | Syndrome grippal', E'20');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'21 | Influenza', E'21');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'22 | Broncho-pneumopathie bactérienne', E'22');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'23 | Otite', E'23');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'24 | Sinusite', E'24');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'25 | Gastro-entérite aiguë', E'25');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'26 | Hépatite virale', E'26');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'27 | Infection de al sphère uro-génitale', E'27');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'28 | Tuberculose', E'28');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'29 | Autre maladie infectieuse ou parasitaire', E'29');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'35 | Ulcère gastro-duodénal, gastrite, oesophagite', E'35');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'36 | Colon irritable', E'36');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'37 | Colite inflammatoire spécifique', E'37');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'38 | Autre affection non cancéreuse du tube digestif', E'38');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'40 | Eczéma, urticaire, psoriasis', E'40');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'41 | Autre affection non cancéreuse de la peau', E'41');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'42 | Rhumatisme inflammatoire', E'42');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'43 | Maladie dégénérative d''ue articulation du membre supérieur', E'43');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'44 | Maladie dégénérative d''ue articulation du membre inférieur', E'44');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'45 | Arthrose du rachis', E'45');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'46 | Hernie discale', E'46');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'47 | Affection inflammatoire des gaines, des tendons et des bourses', E'47');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'50 | Insuffisance rénale chronique', E'50');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'51 | Lithiase urinaire', E'51');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'52 | Autre affection non cancéreuse de l''appareil uro-génital', E'52');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'55 | Affection dentaire', E'55');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'56 | Autre affection non cancéreuse de la sphère ORL', E'56');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'58 | Affection hématologique non cancéreuse', E'58');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'60 | Affection de la rétine', E'60');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'61 | Autre atteinte ophtalmologique', E'61');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'65 | Insuffisance coronarienne', E'65');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'66 | Trouble du rythme cardiaque', E'66');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'67 | Artérite des membres inférieurs', E'67');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'68 | Affection veineuse des membres inférieurs', E'68');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'69 | Autre affection cardio-vasculaire', E'69');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'70 | Insuffisance respiratoire chronique', E'70');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'71 | Insuffisance respiratoire aiguë', E'71');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'72 | Autre affection broncho-pulmonaire non cancéreuse', E'72');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'75 | Intoxication éthylique (y compris les complications)', E'75');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'76 | Autre toxicomanie', E'76');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'77 | Cure de désintoxication', E'77');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'78 | Dépression', E'78');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'79 | Psychose', E'79');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'86 | Affection non cancéreuse du pancréas', E'86');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'87 | Lithiase biliaire', E'87');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'88 | Autre affection non cancéreuse du foie', E'88');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'90 | Affection non cancéreuse de la thyroïde', E'90');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'91 | Diabète', E'91');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'92 | Autre maladie endocrinienne ou métabolique', E'92');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'95 | Affection non cancéreuse du sein', E'95');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'96 | Complication au cours de la grossesse', E'96');
INSERT INTO core.autocompletion (context,short_cut,replacement_text) VALUES (E'sick_leave', E'99 | Autre pathologie', E'99');
