CREATE TABLE patient.allergens
(
   id serial PRIMARY KEY not null,
   groupid int4 not null,
   code varchar(50),

   name_en varchar(128) not null,
   synonyms_en varchar(1500),
   description_en varchar(2000),
   invasion_en varchar(500),
   trigger_en varchar(500),
   name_de varchar(128),
   synonyms_de varchar(1500),
   description_de varchar(2000),
   invasion_de varchar(500),
   trigger_de varchar(500),
   name_fr varchar(128),
   synonyms_fr varchar(1500),
   description_fr varchar(2000),
   invasion_fr varchar(500),
   trigger_fr varchar(500),
   name_latin varchar(128),
   family_latin varchar(128),
   order_latin varchar(128),
   food_typeid int4,
   exposition_from int2,
   exposition_to int2,
   clinical_relevance int2,
   datasource int4
);

INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (14,2,'t 20','Privet, common','Rainweide;','Reaching a height up to 4 m, this is a mostly evergreen bush with opposite, entire and elliptic shiny leathery leaves; the remarkably fragrant small white flowers are arranged in upright panicles; bee pasture; entomogamous; flowering season : VI - VIII (late bloomer); fruit: black, poisonous berries;','Inhalative (June - August); only when there is direct contact to the plant;','Pollen, 30 - 45 µm;','Liguster, gewöhnlicher','Rainweide;','Bis 4 m hoher überwiegend immergrüner Strauch mit gegenständigen, ganzrandigen, elliptischen und glänzenden ledrigen Blättern; die stark duftenden kleinen weißen Blüten sind in aufrechten Rispen angeordnet; Bienenweide; entomogam; Blütezeit: VI - VIII (Spätblüher); Früchte: schwarze giftige Beeren;','Inhalativ (Juni - August);\nnur bei direktem Kontakt zur Pflanze','Pollen, 30 - 45 µm;','Ligustrum vulgare L.','Oleaceae',null,null,6,8,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (15,2,'t 901','Ash, common',null,'Growing to 40 m high and up to approx. 200 years old, this sprouting pioneer tree has opposed pinnate leaves 9 – 13 in number; buds black; blossoms without calyx and crown leaves, inconspicuous; anemogamic; flowering time: IV - V (middle bloomer); winged fruits; fairly hard fine-grained wood; is used as utility, turning and furniture wood;','Inhalation (April - May);','Pollen of approx. 20 µm diameter;','Esche, gewöhnliche',null,'Bis 40 m hoher und ca. 200 Jahre alt werdender ausschlagfähiger Pionierbaum mit gegenständigen 9 - 13-zählig gefiederten Blättern; Knospen schwarz; Blüten ohne Kelch- und Kronblätter, unscheinbar; anemogam; Blütezeit: IV - V (Mittelblüher); Früchte geflügelt; Holz feinfaserig und ziemlich hart; dient als Werk-, Drechsel- und Möbelholz;','Inhalativ (April - Mai);','Pollen von ca. 20 µm Durchmesser;','Fraxinus excelsior L.','Oleaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (16,2,'t 9','Olive tree','Ölbaum;','A 10 m to 16 m high and up to over 1000 years old tree with a stocky appearance and gnarled trunk, grain often twisted with age and cleft into bizarre stilts through a rotting processes; leaves opposite, longish, leathery and silver-grey underneath; flowers small, white, in panicles; anemogamous; flowering season: IV - VI (central bloomer); stone fruit (=olive), plume-like and very rich in oil;','Inhalative (April - June);','Pollen, approx. 15 x 25 µm;','Ölbaum (Olivenbaum)','Ölbaum;','Gedrungen wirkender 10 m bis 16 m hoch und über 1000 Jahre alt werdender Baum mit knorrigem, im Alter oft drehwüchsigem und durch Ausfaulen in skurrile Stelzen zerteiltem Stamm; Blätter gegenständig, länglich, ledrig und unterseits silbergrau; Blüten klein, weiß, in Rispen; anemogam; Blütezeit: IV - VI (Mittelblüher); Steinfrucht (=Olive), pflaumenähnlich und sehr ölhaltig;','Inhalativ (April - Juni);','Pollen, ca. 15 x 25 µm;','Olea europaea L.','Oleaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (17,2,'t 23','Cypress, Italian','Mittelmeerzypresse, Säulenzypresse, Trauerbaum;','Evergreen, up to 25 m high tree with branches spreading out (wild variety) or upward reaching, forming a dense, slim pyramid; small, scale-like leaves, and monoecious flowers; anemogamous; flowering season: II - IV (early bloomer); the seeds ripen in woody cones.','Inhalative;','Pollen, approx. 25 µm;','Zypresse','Mittelmeerzypresse, Säulenzypresse, Trauerbaum;','Immergrüner bis 25 m hoher mit seitlich ausgebreiteten (Wildform) oder hochstrebenden, eine dichte, schmale Pyramide formenden Ästen, kleinen schuppenförmigen Blättern, und einhäusigen Blüten; anemogam; Blütezeit: II - IV (Frühblüher); die Samen reifen in holzigen  Zapfen.','Inhalativ;','Pollen, ca. 25 µm;','Cupressus sempervirens L.','Cupressaceae',null,null,2,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (18,2,'t 6','Sabine','Spanish savin;','Low-growing cops with rising branches and scale-like leaves; height up to 2 m (6 m); twiggs smell unpleasant when crushed; poisonous; anemogamous; flowering season: IV - V (Central bloomer);  berries brown-black, hanging in cone-like clusters; used as medicinal plant and against vermin (farm gardens);','Inhalative (April - May);','Pollen;','Sadebaum','Stinkwacholder;','Niederliegendes Gehölz mit aufsteigenden Ästen und schuppenförmigen Blättern; Höhe bis 2 m (6 m); Zweige zerrieben unangenehm riechend; giftig; anemogam; Blütezeit: IV - V (Mittelblüher); Beerenzapfen braunschwarz, hängend; Verwendung als Heilpflanze und gegen Ungeziefer (Bauerngärten);','Inhalativ (April - Mai);','Pollen;','Juniperus sabina L.','Cupressaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (19,2,'t 70','Mulberry, white','silkworm mulberry','An up to12 m high tree or bush with many-shaped, oval, entire to serrated leaves and capitate inflorescence; anemogamous; flowering season : V (central bloomer); the maximum amount of pollen is released in the early moring; the nut fruits are surrounded by a fleshy yellowish-white (name) integument, form an alliance and so assume an appearance similar to that of the blackberry (mulberry);','Inhalative (May);','Pollen;','Maulbeerbaum, weißer',null,'Bis 12 m hoher Baum oder Strauch mit vielgestaltigen, ovalen, ganzrandigen bis gezähnten Blättern und kopfig-ährigen Blütenständen; anemogam; Blütezeit: V (Mittelblüher); das Maximum der Pollenfreisetzung ist am frühen Morgren; die Nußfrüchte sind von fleischig werdenden gelblich-weißen (Name) Hüllblättern umgeben, bilden einen Verband und haben so ein brombeerartiges Aussehen (Maulbeere);','Inhalativ (Mai);','Pollen;','Morus alba L.','Moraceae',null,null,5,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (20,2,'t 906','Sweet mock orange','Großer Pfeifenstrauch;','A bush reaching a height of up to 3 m with egg-shaped to elliptical, serrated leaves;  4-5 white flowers, very fragrant and bunched in clusters of  1-10; entomogamous; flowering season: V - VI (central bloomer); frequent ornamental shrub;','Inhalative (May - June);','Pollen;','Jasmin, falscher','Großer Pfeifenstrauch;','Bis 3 m hoher Strauch mit eiförmig-elliptischen und gezähnten Blättern; Blüten weiß, 4-5-zählig, stark duftend und zu 1-10 Stück traubig angeordnet; entomogam; Blütezeit: V - VI (Mittelblüher); häufiges  Ziergehölz;','Inhalativ (Mai - Juni);','Pollen;','Philadelphus coronarius L.','Philadelphaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (21,2,'t 904','Pussywillow','goat willow, sallow;','Dioecious, 3 - 9 m high bush or tree; catkins appearing before the grey-green leaves, white tomentose on the under side; anemogamous and entomogamous; flowering season: III - IV (early bloomer); seeds very small and capable of flying by means of a tuft of hair;','Inhalative (March - April);','Pollen, approx. 15 x 30 µm;','Weide, Sal-',null,'Zweihäusiger 3 - 9 m hoher Strauch oder Baum; Kätzchen vor den unterseits graugrünen bis weißfilzigen Blättern erscheinend; anemogam und entomogam; Blütezeit: III - IV (Frühblüher); Samen sehr klein und durch Haarschopf flugfähig;','Inhalativ (März - April);','Pollen, ca. 15 x 30 µm;','Salix caprea L.','Salicaceae',null,null,3,4,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (1,2,'g 1','Vernal grass, scented','Goldgras, Lavendelgras, Gemeines Ruchgras,','An up to 50 cm tall, unbranched spiked meadow grass; perennial; anemogamous; flowering season : V-VIII (central bloomer); poorness indicator; frequent, however rarely stand-forming; with a scent like sweet woodruff;','Inhalative (May - August);','Pollen, 24-40 µm;','Ruchgras, wohlriechendes','Goldgras, Lavendelgras, Gemeines Ruchgras,','Bis 50 cm hohes unverzweigtes Ährenrispengras; mehrjährig; anemogam; Blütezeit: V-VIII (Mittelblüher); Magerkeitszeiger; häufig, jedoch nur selten bestandsbildend; nach Waldmeister duftend (Kumarin);','Inhalativ (Mai - August);','Pollen, 24-40 µm;','Anthoxantum odoratum L.','Poaceae',null,null,5,8,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (2,1,'k 71','Castor bean','Castor bean, castor oil plant, [German: Christuspalme, Wunderbaum, Kreuzbaum];','The seeds are bean-sized, marbled reddish-brown, and extremely toxic due to the protein ricin. When extracting the castor oil from the bean, the ricin remains in the pomace. The seeds contain approx. 50% castor oil. This is colorless to light yellow and consists primarily of the glycerinester of ricinic acid, an unsaturated monohydroxycarboxylic acid.','Industrial processing of the seeds causes an inhalative exposition.','Proteins originating from the seeds; also traces contained in the oil;','Rizinusbohne','Castorbohne, Christuspalme, Wunderbaum, Kreuzbaum;','Die Samen sind bohnengroß, rötlich-bräunlich marmoriert und aufgrund des Proteins Rizin äußerst giftig. Bei der Ölgewinnung verbleibt dieses im Pressrückstand. Die Samen enthalten ca. 50% Rizinusöl. Dieses ist farblos bis leicht gelblich und besteht zum größten Teil aus dem Glycerinester der Rizinolsäure, einer ungesättigten Monohydroxycarbonsäure.','Durch die industrielle Verarbeitung der Samen besteht eine inhalative Exposition.','Aus den Samen stammende Proteine; in Spuren auch im Öl enthalten;','Ricinus communis L.','Euphorbiaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (3,6,'s 1','Aniseed',null,null,null,null,'Anis',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (4,5,null,'Small canine tapeworm','Fox tapeworm; bladder worm','Only 4-6 mm tapeworm consisting of one head with three to four segments. The final segment contains larva, enclosed in egg shells.','The eggs or larva enter humans via the excrement of the final hosts.',null,'Kleiner Hundebandwurm','Fuchsbandwurm, Blasenwurm;','Nur 4-6mm langer Bandwurm, der nur aus einem Kopf mit drei bis vier Gliedern besteht. Das letzte Glied enthält die von Eischalen umgebenen Larven.','Die Eier bzw. Larven gelangen über den Kot der Endwirte in den Menschen.',null,'Echinococcus granulosus Batsch',null,'Cestodes, Bandwürmer;',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (5,4,'f 10','Sesame',null,null,null,null,'Sesam',null,null,null,null,null,null,null,10,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (6,7,'c 209','Paracetamol/Phenacetin','Phenacetin, 4`-Hydroxyacetanilid;',null,null,null,'Paracetamol/Phenacetin','Phenacetin, 4`-Hydroxyacetanilid;',null,null,null,null,null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (7,9,'i 3','wasp','Vespula germanica and Vespula vulgaris;','Approx. 15 - 20 mm in length, multi-winged insects with contrasting black/yellow markings and a hairless body; the so-called wasp waist is between breast and abdomen; Occurs in three casts: workers, free flying, stinging, unfertile; males, free flying, non-stinging, fertile; queen, free flying only while founding a nest, stinging, fertile;','Sting, by which 2 - 10 µg protein can enter the body; while in the case of the honey bee, the stinger always remains in the victim, this is only seldom the case for the wasps sting, but it does occur for a certain percent of the cases.','Proteins of large molecular weight in the animal’s poison;','Wespe','Vespula germanica u. Vespula vulgaris;','Ca. 15 - 20 mm lange, vierflügelige Insekten mit kontrastreich schwarz-gelb gezeichnetem und unbehaartem Körper; zwischen Brust und Hinterleib befindet sich die sogenannte Wespentaille;\nAuftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, freifliegend nur bis zur Nestgründung, stechend, fruchtbar;','Stich, bei dem 2 - 10 µg Protein in den Körper gelangen; während bei der Biene der Stachel immer stecken bleibt, ist dies beim Wespenstich zwar seltener der Fall, kommt jedoch auch in einem gewissen Prozentsatz der Fälle vor.','Hochmolekulare Proteine im Gift der Tiere;','Paravespula germanica F. und P. vulgaris L.','Vespidae','Hymenoptera, Hautflügler',null,6,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (8,3,'e 79 (Serum), e 78 (Federn), e 77 (Kot)','Parakeet (Melopsittacus undulatus)',null,'Approx. 25 cm long bird originiating in Austrlia, with the typical curved parrot beak and climbing claws - two toes pointing forwards and two backwards. Since 1840 selective breeding has produced dozens of color and size variations from the yellow-headed, green-bellied and dark-backed curly wild form.','Feather and feces dust is inhaled.','Proteins from the feces and feathers. Since dust and fungi in these materials can distort the diagnosis, one attempts to detect specific antibodies over the purely representable serum proteins related to the structure of feathers and feces.','Wellensittich',null,'Ca. 25 cm langer aus Australien stammender Vogel mit dem für Papageien typischen Krummschnabel und Kletterfuß - zwei Zehen nach vorne und zwei nach hinten gerichtet. Seit 1840 wurden aus der gelbköpfigen, bauchseitig grünen und oberseits dunkel gewellten (Name) Wildform dutzende Farb- und Größenvarianten gezüchtet.','Feder- und Kotstaub wird inhalativ aufgenommen.','Proteine aus Kot und Federn. Da Stäube und Pilze bei diesen Materialien die Diagnose verfälschen können, versucht man den Nachweis spezifischer Antikörper auch über die rein darstellbaren Serumproteine, die mit dem Aufbau der Federn und dem Kot in Bezug stehen.','Melopsittacus undulatus Shaw','Psittacidae','Psittaciformes, Papageienartige',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (9,8,'m 5','Candida albicans (Robin) Berkhout','Syringospora albicans, Procandida grubyi, Candida claussenii Lodder & Kreger - v. Rij, Candida longeroni Doetr. Ex v. Uden & Buckley, Candida stellatoidea Langer & Guerra; Soor fungus;','White slime colonies; growth as sprouting single cells and hyphen species, in the transition to pseudo hyphen, blasto- and clamydo-spores ;','Almost exclusively by contact and by foodstuffs;',null,'Candida albicans (Robin) Berkhout','Syringospora albicans, Procandida grubyi, Candida claussenii Lodder & Kreger - v. Rij, Candida langeroni Doetr. Ex v. Uden & Buckley, Candida stellatoidea Langer & Guerra; Soorpilz;','Weißliche, schleimige Kolonien; Wachstum als sprossende Einzelzellen und hyphenartig, im Übergang mit Pseudohyphen, Blasto- und Clamydosporen;','Fast ausschließlich durch Kontakt und über die Nahrung;',null,'Candida albicans (Robin) Berkhout','Cryptococcaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (10,2,'t 28','Acacia, black','black locust, robinia;','Sparse, up to 25 m high tree with white flowers in hanging clusters; leaves odd-pinnated, somewhat resmbling those of the acacia (cf. name); outer bark rough and splitting open, net-like; bee pasture; entomogamous; flowering season: V - VI (Central bloomer); the fruit is a capsule which bursts open like a trap; the very firm, durable and load-bearing wood is employed for construction, furniture, and as commercial timber.','Inhalative (May - June); ingestive (mixed honeys and so-called acacia honey);','Pollen, 26-40 µm;','Robinie','Gewöhnliche Robinie, Scheinakazie;','Lichter bis 25 m hoher Baum mit weißen Blüten in hängenden Trauben; Blätter unpaarig gefiedert, denen der Akazie ähnelnd (vgl. den Namen); Borke grob und netzartig aufreißend;  Bienenweide; entomogam; Blütezeit: V - VI (Mittelblüher); die frucht ist eine klappig aufspringende Hülse; das sehr feste, dauerhafte und tragfähige Holz findet als Bau-, Werk- und Möbelholz Verwendung.','Inhalativ (Mai - Juni);\nIngestiv (Mischhonige u. sogenannter Akazienhonig);','Pollen, 26-40 µm;','Robinia pseudoacacia L.','Fabaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (11,2,'t 14','Poplar, white',null,'A quickly growing, relatively slim dioecious tree, 30 m in height and up to 400 years years of age. Flowers inconspicuous in catkins, leaves alternate, sinuatedly lobed, with very  tomentose  undersides; trunk with a light whitish-grey bark; anemogamous; flowering season  III - IV (early bloomer); seeds with a bushel of hair distribution by wind, i.e. anemochory; the wood is very soft and coarse-grained, used for wood-cutting (cloggs) and as commercial wood. Furthermore, it is chemically processed to viscose fibre and artifical silk.','Inhalative (March - April);','Pollen, approx. 30 µm;','Pappel, Silber-',null,'Raschwüchsiger, relativ schlanker bis 30 m hoch und 400 Jahre alt werdender zweihäusiger Baum. Blüten unscheinbar in Kätzchen, Blätter wechselständig, buchtig gelappt, unterseits dicht filzig; Stamm hell-weißgrau berindet; anemogam; Blütezeit III - IV (Frühblüher); Samen mit Haarschopf (Windverbreitung); das Holz ist sehr weich und grobfaserig und wird zum Schnitzen (Holzschuhe) und als Werkholz verwendet. Darüber hinaus wird es chemisch zu Zellwolle und Kunstseide aufgearbeitet.','Inhalativ (März - April);','Pollen, ca. 30 µm;','Populus alba L.','Salicaceae',null,null,3,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (12,2,'t 902','Spruce, common','Picea excelsa Lk.; Norway spruce, Christmas tree;','An up to 60 m tall and over 300 years old tree with the crown tapering to a thin tip, dark green needles, an outer bark that at first is light brown, later reddish brown; anemogamous ; flowering season : IV - VI (central bloomer); seeds in up to 16 cm long, hanging cones; the wood, which is soft and easy to process, is ideal for building and is employed as resonance wood for pianos and organs as well as for paper production and the chemical extraction of staple and artificial silk; tanning agent is extracted from the bark and vanillin from the resin.','Inhalative(April - June);','Pollen approx. 70 x 100 µm with two air sacks which strongly impede moistening and thus the release of the patient.allergens;','Fichte','Picea excelsa Lk.; \nRottanne, Rotfichte;','Bis 60 m hoher und über 300 Jahre alt werdender Baum mit spitz zulaufender Krone, dunkelgrünen Nadeln, anfangs hellbrauner, später rötlichgrauer Borke; anemogam; Blütezeit: IV - VI (Mittelblüher); Samen in bis zu 16 cm langen, hängenden Zapfen; das weiche und gut zu bearbeitende Holz ist ideal zum Bauen und dient sowohl als Resonanzholz für den Klavier und Orgelbau als auch zur Papierherstellung und chemischen Gewinnung von Zellwolle und Kunstseide; Nutzung der Rinde zur Gerbstoffgewinnung und des Harzes zur Vanillingewinnung.','Inhalativ (April - Juni);','Pollen ca. 70 x 100 µm mit zwei Luftsäcken, die eine Benetzung und damit die Freisetzung der Allergene stark behindern;','Picea abies (L.) Karst.','Pinaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (13,2,'t 21','Lilac, common',null,'A bush or tree reaching up to 6 m in height with white, red or blue-violet colored flowers in upright panicles; leaves opposite, entire and heart-shaped at the base; entomogamous; flowering season : V - VI (central bloomer); 2-sectioned fruits ; the wood is very hard, well suited for polishing and is employed in artistic carpentry and as turned wood.','Inhalative (April - June);','Pollen;','Flieder, gewöhnlicher',null,'Bis 6 m hoher Strauch oder Baum mit weißen, rötlichen oder bläulich violetten Blüten in aufrechten Rispen; Blätter gegenständig, ganzrandig und am Grunde herzförmig; entomogam; Blütezeit: V - VI (Mittelblüher); Früchte zweifächerig; das Holz ist sehr hart, gut polierbar und findet in der Kunsttischlerei und als Drechselholz Verwendung.','Inhalativ (April - Juni);','Pollen;','Syringa vulgaris L.','Oleaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (22,2,'t 903','Hornbeam, common','Weißbuche;','A tree reaching up to 25 m in height and 150 years of age; it has distichous, creased leaves that are biserrate at the edge;  bark smooth, grey-black, with contorted, longitudinal pouches in old-age; male flowers in catkins; anemogamous; flowering season : IV - V (central bloomer); the fruit is an encased nut; the wood is hard and difficult to split and serves as lumber and turned wood (bowling pins);','Inhalative (April - May);','Pollen, approx. 25 x 35 µm;','Hainbuche','Weißbuche;','Bis 25 m hoher und bis 150 jahre alt werdender Baum mit zweizeiligen, faltigen Blättern, die am Rande doppelt gesägt sind; Rinde glatt, grau-schwarz, im Alter mit gedrehten Längswülsten; männliche Blüten in Kätzchen; anemogam; Blütezeit: IV - V (Mittelblüher); die Frucht ist eine von einer Hülle umgebene Nuss; das harte und schwer spaltbare Holz dient als Werk- und Drechselholz (Kegel);','Inhalativ (April - Mai);','Pollen, ca. 25 x 35 µm;','Carpinus betulus L.','Corylaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (23,2,'t 27','Linden, little leaf','Tilia ulmifolia Scop.; Tilia parvifolia Ehrh.;','Tree reaching a height of up to 30 m, with heart-shaped, asymmetric leaves in two rows, that are brown-bearded in the vein-corners on the underside. Inflorescense stem grown together with a wing-like terminal leaf up half its length, supporting the distribution of the seeds by the wind; entomogamous  (bee pasture); flowering season : VI - VII (late bloomer); medicinal plant (lime leaf tea); the wood serves for wood-cutting, as inferior wood (veneer carrier) and for charcoal.','Inhalative (June - July); ingestive (lime honey or mixed summer honeys);','Pollen, up to 40 µm;','Linde, Winter-','Tilia ulmifolia Scop.;\nTilia parvifolia Ehrh.;','Bis 30 m hoch werdender Baum mit zweizeilig angeordneten, herzförmig - asymmetrischen Blättern, die unterseits in den Aderwinkeln braunbärtig sind. Infloureszenzstiel bis zur Hälfte mit einem flügelartigen Hochblatt verwachsen, das die Verbreitung der Samen durch den Wind unterstützt;  entomogam (Bienenweide); Blütezeit: VI - VII (Spätblüher); Heilpflanze (Lindenblütentee); das Holz dient zum Schnitzen, als Blindholz (Furnierträger) und zur Holzkohlegewinnung.','Inhalativ (Juni - Juli); \nIngestiv (Lindenhonig oder Sommermischhonige);','Pollen, bis 40 µm;','Tilia cordata Mill.','Tiliaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (24,2,'t 26','Elder, common','Elderberry','A bush reaching up to 7 m in height with unequally pinnated leaves; flowers white, in umbrella-shaped cymes; anemogamous and entomogamous; flowering season : V - VI (Central bloomer); the fruit are dark-red to black berries (edible fruit); bark light brown ; the center of the branch is white; also an ornamental and medicinal plant;','Inhalative (May - June);','Pollen, approx. 15 x 35 µm;','Holunder, schwarzer','Holler;','Bis 7 m hoher Strauch mit unpaarig gefiederten Blättern; Blüten weiß, in schirmförmigen Trugdolden; anemogam und entomogam; Blütezeit: V - VI (Mittelblüher); die Früchte sind dunkelrote bis schwarze Beeren (Obst); Rinde hellbraun; Mark der Äste weiß; auch Zier- und Heilpflanze;','Inhalativ (Mai - Juni);','Pollen, ca. 15 x 35 µm;','Sambucus nigra L.','Caprifoliaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (25,2,'t 19','Golden wattle, Sydney','Acacia floribunda;','A shrub not native to Central Europe but originating from the tropics, whose flower stems have been wrongly termed mimosa by florists; flowers yellow, in capitulae, paniculiformly arranged; flowering season  III - IV (early bloomer);','Inhalative;','Pollen,approxa. 45µm;','Mimose','Acacia floribunda;','In Mitteleuropa nicht heimisches sondern aus den Tropen stammendes Gehölz, dessen Blütenstengel in der Floristik fälschlicherweise als Mimosen bezeichnet werden; Blüten gelb, in Köpfchen, welche rispenartig angeordnet sind; Blütezeit III - IV (Frühblüher);','Inhalativ;','Pollen, ca. 45µm;','Acacia longifolia (Andr.) Willd.','Mimosaceae',null,null,3,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (26,2,'t 18','Gum, blue','Tasmanian blue gum','Reaching a height of over 20 m, this evergreen tree has entire, crescent-shaped leaves; petals are grown together to a kind of lid-like cap that falls off towards the flowering season; this reticular, closed flower cup gave the genus its name (Greek.: the well-veiled). The fruit is a woody capsule. The bark is smoolth and peels off in strips.','Inhalative; epidermal;','Pollen;','Eukalyptus','Blaugummibaum;','Über 20 m hoch werdender, immergrüner Baum mit ganzrandigen, sichelförmigen Blättern; Blütenkronblätter zu einer deckelartigen Mütze verwachsen, die zur Blütezeit abfällt; dieser haubenartige, geschlossene Blütenkelch hat der Gattung den Namen gegeben (griech.: der wohlverhüllte). Die Frucht ist eine holzige Kapsel. Die Rinde ist glatt und löst sich in Streifen.','Inhalativ;\nEpicutan;','Pollen;','Eucalyptus globulus Labill.','Myrtaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (27,2,'t 17','Chestnut, sweet','Spanish chestnut;','A tree reaching up to 30 m in height and 500 years of age, with two-rowed and spikey serrated leaves, up to 20 cm in length; flowers in upright catkins of up to 20 cm in length; bee pasture; entomogamous and anemogamous; flowering season: VI (late bloomer); fruit and seeds simular to those of the horse chestnut – only with very prickly bristles around the fruit case; the seeds – called chestnuts or maroni – are prepared in numerous different ways as a popular food item. The trunk is usually strongly contorted and covered with a cracked outer bark. The wood is employed as lumber for woodwork and building.','Inhalative (June); Ingestive (chestnut honey or mixed summer honeys);','Pollen;','Kastanie','Esskastanie, Edelkastanie;','Bis zu 30 m hoch und bis zu 500 Jahre alt werdender Baum mit bis zu 20 cm langen, zweizeilig angeordneten und stachelig gezähnten Blättern; Blüten in aufrechten bis zu 20 cm langen Kätzchen; Bienenweide; entomogam und anemogam; Blütezeit: VI (Spätblüher); Früchte und Samen denen der Roßkastanie ähnlich - die Borsten der Fruchthülle jedoch stark stechend; die Samen - Kastanien oder Maronen genannt - sind, auf die unterschiedlichste Art zubereitet, ein begehrtes Nahrungsmittel. Der Stamm ist meist stark gedreht und mir rissiger Borke bedeckt. Das Holz findet als Werk- und Bauholz Verwendung.','Inhalativ (Juni);\nIngestiv (Kastanienhonig oder Sommermischhonige);','Pollen;','Castanea sativa Mill.','Fagaceae',null,null,6,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (28,2,'t 16','Pine, black, Scots and Eastern white','Die Waldkiefer wird auch Föhre genannt.','Up to 40 m (P. nigra 30 m) high coniferous trees - P. nigra with needles in a pair per sheath, 8 to 15 cm long; P. sylvestris needles in pairs, 3 to 8 cm long; P. strobus in groups of five and 14 cm long – with a scaly bark; anemogamous; a very large amount of pollen; flowering season : V - VI (central bloomer); the seeds ripen in woody cones; wood very tenacious and multi-purpose; the close-grained, soft and easy to process wood of the Eastern white pine is especially remarkable -   with its specific weight of 0.39 it is the lightest cultivated wood in these parts and for this reason is favored for the making of wooden boxes, barrels and bee houses (apiaries).','Inhalative (May - June);','Pollen approx. 40 - 80 µm with two air sacs (so-called flight organs), that strongly impede moisturizing and thus the release of patient.allergens;','Kiefer, Schwarz-, Wald- und Weymouths-','Die Waldkiefer wird auch Föhre genannt.','Bis 40 m (P. nigra 30 m) hoch werdende Nadelbäume - P. nigra Nadeln zu zweit in einer Scheide, 8 bis 15 cm lang; P. sylvestris Nadeln zu zweit, 3 bis 8 cm lang; P. strobus Nadeln zu fünft und bis 14 cm lang - mit Schuppenborke; anemogam; mit sehr großen Pollenmengen;  Blütezeit: V - VI (Mittelblüher); die Samen reifen in holzigen Zapfen; Holz sehr dauerhaft und vielseitig verwendbar; besonders hervorzuheben ist das feinfaserige, weiche und gut zu bearbeitende Holz der Weymouthskiefer - es ist mit einem spezifischen Gewicht von 0,39 das leichteste bei uns kultivierte Holz und wird deshalb vorzugsweise für Kisten, Böttcherwaren und Bienenkästen (Beuten) verwendet.','Inhalativ (Mai - Juni);','Pollen ca. 40 - 80 µm mit zwei Luftsäcken (sog. Flugorgane), die eine Benetzung und damit die Freisetzung der Allergene stark behindern;','Pinus L.; nigra Arnold, sylvestris L., strobus L.','Pinaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (29,2,'t 11','Plane, oriental',null,'An up to 50 m tall tree with an imposing crown and a yellowish-green outer bark that flakes off in thin plates, so that the trunk appears a light dappled color. The wood serves as commercial lumber, for carving and for paper production. The leaves are lobed in a hand-shape above the middle. The flowers are arranged in capitula, of which always two to four hang together. The flowers are anemogamous. Flowering season: V (Central bloomer); fruit in round, petiolar, hanging infructescences.','Inhalative (May);','Pollen, approx. 16 x 22 µm;','Platane, morgenländische',null,'Bis 50 m hoher Baum mit mächtiger Krone und gelblich-grüner Borke, die in großen dünnen Platten abspringt, so dass der Stamm hell gescheckt erscheint. Das Holz dient als Werkholz, als Schnitzholz und zur Papiergewinnung. Die Blätter sind bis über die Mitte handförmig gelappt. Die Blüten sind in Köpfchen angeordnet, von denen jeweils zwei bis vier zusammen hängen.\nDie Blüten sind anemogam. Blütezeit: V (Mittelblüher); Früchte in kugeligen, gestielten, herabhängenden Fruchtständen.','Inhalativ (Mai);','Pollen, ca. 16 x 22 µm;','Platanus orientalis L.','Platanaceae',null,null,5,5,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (30,2,'t 10','Walnut, English (Persian)',null,'Reaching a height of up to 30 m  and up to 200 years of age, the tree has a wide, expansive crown and a silver-grey trunk that only later turns dark and cracked; leaves very large, odd-pinnated; male flowers in hanging catkins; female flowers inconspicuous, located at the end of the year’s new shoots; flowering season: IV - V (central bloomer); the stone of the 4 to 5 cm large, green and slightly oval stone fruit is the walnut. Wood varnishes are extracted from the fruit pulp. The wood is suited for carving, turning and the manufacture of furniture.','Inhalative (April - May);','Pollen, approx. 35 µm;','Walnuß',null,'Bis 30 m hoch und bis 200 Jahre alt werdender Baum mit breiter ausladender Krone und silbergrauem, erst später dunkel und rissig werdendem Stamm; Blätter sehr groß, unpaarig gefiedert; männliche Blüten in hängenden Kätzchen; weibliche Blüten unscheinbar, am Ende diesjähriger Triebe; anemogam; Blütezeit: IV - V (Mittelblüher); \nder Stein der 4 bis 5 cm großen, grünen und leicht ovalen Steinfrüchte ist die Walnuß. Aus dem Fruchtfleisch werden Holzbeizen gewonnen. Das Holz eignet sich zum Schnitzen, Drechseln und zur Möbelherstellung.','Inhalativ (April - Mai);','Pollen, ca. 35 µm;','Juglans regia L.','Juglandaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (31,2,'t 8','Elm, Scotch','Ulmus scabra Mill.; Ulmus montana With.; Rüster, Bergrüster;','Reaching up to 35 m in height, a tree which achieves up to 400 years of age, with a grey outer bark bearing slight longitudinal cracks; two-rowed, asymmetric leaves, 8 bis 16 cm long and very rough on the upper side; flowers relatively inconspicuous, in clustery inflorescenses; anemogamous; flowering season: III - IV (early bloomer); the fruit is a wide-winged nut. The wood is employed as commercial timber, for turned work and furniture.','Inhalative (March - April);','Pollen, approx. 30 µm;','Ulme, Berg-','Ulmus scabra Mill.; Ulmus montana With.;\nRüster, Bergrüster;','Bis 35 m hoch und bis 400 Jahre alt werdender Baum mit grauer, schwach längsrissiger Borke, zweizeilig gestellten, asymmetrischen, 8 bis 16 cm langen und oberseits sehr rauhen Blättern; Blüten relativ unscheinbar, in büschelartigen Blütenständen; anemogam; Blütezeit: III - IV (Frühblüher); die Frucht ist eine breitgeflügelte Nuss. Das Holz findet als Werk-, Drechsel- und Möbelholz Verwendung.','Inhalativ (März - April);','Pollen, ca. 30 µm;','Ulmus glabra Huds. em. Moss','Ulmaceae',null,null,3,4,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (32,2,'t 7','Oak, english','Quercus pedunculata Ehrh.;','Reaching a height of up to 50 m, this tree can reach over 1000 years of age; it has a grey-brown, deeply furrowed outer bark, short-stemmed, emarginately lobed, assymetric leaves  that are heartshaped and auriculate at the base; male flowers in catkins; female inflorescence inconspicuous, 1 to 2 flowers; anemogamous; flowering season : IV - V (central bloomer); the long-stemmed (name) fruits, the so-called acorns (used to be sought after for fattening pigs) are nuts surrounded by a shallow cup. The very hard wood is not to be surpassed by any other indiginous wood for its firmness and elasticity. Furthermore, it is extremely durable and, like the bark, very rich in tanning agent (used to be much in demand by tanners). For these reasons, numerous natural oak groves fell victim to exploitive forestry, especially between 1500 and 1750; this especially in coastal areas, since the load-bearing wood is ideal for shipbuilding. Today it is mostly employed for furniture, parquet floors and construction wood for earthworks, buildings, waterworks and bridge building.','Inhalative (April - May);','Pollen; approx. 20 x 40 µm;','Eiche, Stiel-','Quercus pedunculata Ehrh.;','Bis 50 m hoher und über 1000 Jahre alt werdender Baum mit graubrauner, tiefgefurchter Borke, kurzstieligen, buchtig gelappten und am Grunde herzförmig geöhrten, asymmetrischen Blättern; männliche Blüten in Kätzchen; weibliche Blütenstände unscheinbar, ein- bis fünfblütig; anemogam; Blütezeit: IV - V (Mittelblüher); die lang gestielten (Name) Früchte, die sogenannten Eicheln (früher zur Schweinemast begehrt) sind Nüsse, die am Grunde von einem flachen Becher umgeben sind. Das sehr harte Holz wird an Festigkeit und Elastizität von keiner anderen heimischen Baumart übertroffen. Zudem ist es äußerst dauerhaft und wie die Rinde sehr gerbstoffhaltig (früher von Gerbereien begehrt). Zahlreiche natürliche Eichenwälder sind aus diesen Gründen vor allem zwischen 1500 und 1750 dem Raubbau zum Opfer gefallen; dies vor allem in den Küstengebieten, da das tragfähige Holz sich ideal zum Schiffbau eignet. Heute dient es vor allem als Möbelholz, Parkettholz und Bauholz zum Erd-, Hoch-, Wasser- und Brückenbau.','Inhalativ (April - Mai);','Pollen; ca. 20 x 40 µm;','Quercus robur L.','Fagaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (33,2,'t 5','Beech, Common',null,'Reaching up to 40 m in height and up to 300 years of age, when inside closed forests this tree grows a high trunk which does not branch until the high crown, whereas free-standing trees develop a very low-reaching crown; bark light gray, thin and smooth; leaves egg-shaped and entire; male flowers in numerous round catkins; femal inflorescence geminiflorous and surrounded by a spiky protective cover in which two three-cornered nuts develop later (beach-nuts) ; anemogamous; flowering season : IV - V (central bloomer); the wood is heavy, hard, easy to split and red-colored (name). As commertial timber it has many uses: railroad ties, furniture, parquet floors, charcoal;','Inhalative (April - May);','Pollen, approx. 40 µm;','Buche, Rot-',null,'Bis 40 m hoch und bis 300 Jahre alt werdender Baum, der in geschlossenen Wäldern einen bis weit hinauf zweiglosen Stamm ausbildet, während freistehende Bäume eine tief herabreichende Krone ausbilden; Rinde hellgrau, dünn und glatt; Blätter eiförmig und ganzrandig; männliche Blüten zu vielen in kugeligen Kätzchen; weibliche Blütenstände zweiblütig und von einer stacheligen Hülle umgeben in der sich später zwei dreikantige Nüsse (Bucheckern) entwickeln; anemogam; Blütezeit: IV - V (Mittelblüher); das Holz ist schwer, hart, leicht spaltbar und rötlich (Name). Als Nutzholz findet es vielerlei Verwendung: Eisenbahnschwellen, Möbel, Parkett, Holzkohle','Inhalativ (April - Mai);','Pollen, ca. 40 µm;','Fagus sylvatica L.','Fagaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (34,2,'t 4','Cob, hazel','Gewöhnliche Haselnuss;','Reaching a height of three to five meters, this bush, branched from the base, has a gray, smooth bark; leaves roundish to heart-shaped, serrated; male flowers in catkins; pollen plant for bees; female flowers are small and hidden in buds, with only the red stigmas projecting; flowering season : XII -IV (early bloomer); nuts situated in bunches and surronded by a lobed seed case; wood tough and pliable;','Inhalative (December - May); ingestive (spring honey);','Pollen, 20 - 30 µm;','Hasel, gewöhnliche','Gewöhnliche Haselnuss;','Drei bis fünf Meter hoher, vom Grund auf verzweigter Strauch mit grauer, glatter Rinde; Blätter rundlich bis herzförmig, gesägt; männliche Blüten in Kätzchen; Pollenpflanze für Bienen; weibliche Blüten klein und in Knospen verborgen, nur die roten Narben herausragend; Blütezeit: XII -IV (Frühblüher); Nüsse zu mehreren zusammensitzend und von einer zerlappten Fruchthülle umgeben; Holz zäh und biegsam;','Inhalativ (Dezember - Mai);\nIngestiv (Frühjahrshonig);','Pollen, 20 - 30 µm;','Corylus avellana L.','Corylaceae',null,null,12,5,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (35,2,'t 3','Birch, Weeping','Betula verrucosa Ehrh.; European White Birch;','Reaching up to  30 m of height and 120 years of age, the tree branches out towards the crown; young branches glistening reddish-brown, with many warty resin glands; leaves triangular to rhombic, entire at the base, biserrate towards the tip; male flowers winter in catkins; pollen plant for bees; the female catkins develop with the leaves; anemogamous ; flowering season : IV - V (central bloomer); the fruits ripen in July and become small winged nuts; the young trunk has a glossy golden-brown bark, which turns white, smooth and striped crosswise with cork; older trees with an irregularly cracked, dark outer bark; wood white and without duramen, used for shingles, furniture, veneers and for turned woodwork; as early as the Stone Age, a universal glue was achieved by heating the white bark under airtight conditions (= birch pitch; used in medicine against rheumatism and sciatica complaints). Brush wood used to be made into brooms. The rising sap can be processed into wine and hair tonic; finally, a medicinal tea against disorders of the lower urinary tract and rheumatism.','Inhalative (March - June); ingestive (spring honey);','Pollen, 20 - 25 µm;','Birke, Hänge-','Betula verrucosa Ehrh.;\nWarzenbirke;','Bis 30 m hoher und bis 120 Jahre alt werdender Baum mit starker Verzweigung im Kronenbereich; junge Äste glänzend rötlich-braun, mit vielen warzigen Harzdrüsen; Blätter dreieckig-rhombisch, mit ganzrandigem Grund, zur Spitze hin doppelt gesägt; männliche Blüten schon in Kätzchen überwinternd; Pollenpflanze für Bienen; die weiblichen Blütenkätzchen erscheinen mit den Blättern; anemogam; Blütezeit: IV - V (Mittelblüher); die im Juli reifenden und in ungeheueren Mengen erzeugten Früchte sind kleine geflügelte Nüsschen; Stamm in jungen Jahren mit glänzend goldbrauner Rinde, die in zunehmendem Alter weiß, glatt und durch Korkleisten quergestreift wird; ältere Bäume am Stammgrund mit unregelmäßig rissiger und dunkler Borke; \nHolz weiß und kernlos, in Gebrauch für Schindeln, Möbel, Furniere und für Drechslerarbeiten; bereits in der Steinzeit wurde durch Erhitzen der weißen Rinde unter Luftabschluss ein Universalklebstoff gewonnen (= Birkenpech; auch in der Medizin gegen Rheuma- und Ischiasbeschwerden). Reisig wurde früher zu Besen gebunden. Der aufsteigende Saft kann zu Wein und Haarwasser verarbeitet werden; schließlich wird aus den Blättern ein Heiltee gegen Erkrankungen der Harnwege und gegen Rheuma gewonnen.','Inhalativ (März - Juni);\nIngestiv (Frühjahrshonig);','Pollen, 20 - 25 µm;','Betula pendula Roth','Betulaceae',null,null,3,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (36,2,'t 2','Alder, common',null,'Reaching up to  25 m in height and 120 years of age, this tree has a continuous trunk all the way to the tip and roundish, serrated leaves that are blunt or even emarinate; male and female inflorescence both winter in catkins; during maturity the female catkins turn woody (lignify) and thus resemble small cones. The pollination and distribution of the small, red-colored, winged nuts is caused by the wind. Flowering season : II - IV (early bloomer); bark black-brown; because of a symbiotic relationship to nodule bacteria in its root area it is capable of utilizing the nitrogen in the air; wood yellow to red colored, versatile use (furniture, waterworks, commercial wood, paper);','Inhalative (February - April); ingestive (spring honey);','Pollen, approx.  20 µm;','Erle, Schwarz-',null,'Bis 25 m hoch und 120 Jahre alt werdender Baum mit einem bis zur Spitze durchgehenden Stamm und rundlichen, gesägten, und der Spitze stumpfen oder gar ausgerandeten Blättern; männliche und weibliche Blütenstände jeweils bereits in Kätzchen überwinternd; während der Reife verholzen die weiblichen Kätzchen und ähneln dadurch kleinen Zapfen. \nDie Bestäubung und die Verbreitung der kleinen rötlich geflügelten Nüsschen geschieht durch den Wind. Blütezeit: II - IV (Frühblüher); Rinde schwarzbraun; ist durch Symbiose mit Knöllchenbakterien im Wurzelbereich in der Lage Luftstickstoff zu verwerten; Holz gelblich bis rötlich, vielseitig verwendbar (Möbel, Wasserbau, Werkholz, Papier);','Inhalativ (Februar - April);\nIngestiv (Frühjahrshonig);','Pollen, um 20 µm;','Alnus glutinosa (L.) Gaertn.','Betulaceae',null,null,2,4,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (37,2,'t 1','Sycamore',null,'Up to 30 m tall and 500 years of age with hand-sized, decussate, five-lobed leaves; greenish flowers in hanging clusters; entomogamous (bee pasture); flowering season : IV - V (central bloomer); winged double fruit; grey-brown bark which peels off in large, irregular scales; bleeding sap is sachariferous (maple syrup); the wood can be used in many different ways for instruments, furniture, parquet floors, charcoal, turned woodwork and as lumber;','Inhalative(April - May); ingestive (spring honey);','Pollen, 25 x 45 µm;','Ahorn, Berg-',null,'Bis 30 m hoch und bis 500 Jahre alt werdender Baum mit handgroßen, kreuzgegenständigen,  fünflappigen Blättern; Blüten grünlich, in hängenden Trauben; entomogam (Bienenweide); Blütezeit: IV - V (Mittelblüher); geflügelte Doppelfrüchte; Rinde graubraun, sich in großen unregelmäßigen Schuppen ablösend; Blutungssaft dient zuweilen als  Zuckerlieferant (Ahornsirup); Holz vielfach verwendbar für Instrumente, Möbel, Parkett, Holzkohle, Drechslerarbeiten und als Werkholz;','Inhalativ (April - Mai);\nIngestiv (Frühjahrshonig);','Pollen, 25 x 45 µm;','Acer pseudoplatanus L.','Aceraceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (38,2,'g 2','Bermuda grass','Bermudagras;','A finger grass of up to 40 cm in height with long runners above ground; two short internodes are always followed by one long one; perennial; flowering season : V - VI;','Inhalative (May - June);',' Pollen, 20 - 30 µm;','Hundszahngras','Bermudagras;','Bis 40 cm hohes Fingergras mit langen oberirdischen Ausläufern; auf zwei kurze Stengelglieder folgt jeweils ein langes; mehrjährig; Blütezeit: V - VI;','Inhalativ (Mai - Juni);',' Pollen, 20 - 30 µm;','Cynodon dactylon (L.) Pers.','Poaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (39,2,'g 3','Cocksfoot','orchard grass;','An up to 100 cm high, grey-green  meadow grass; seed-heads in a cluster at the end of the panicle branches; caespitose; perennial; flowering season : V - VI; rich and high-yielding fodder; nitrogen indicator;','Inhalative (May - June);','Pollen, approx. 30 µm;','Knäuelgras, Wiesen-','Gemeines Knäuel- oder Knaulgras;','Bis 100 cm hohes, graugrünes Rispengras; Ährchen am Ende der Rispenäste knäuelig gehäuft; horstbildend; mehrjährig; Blütezeit: V - VI; wertvolles und ertragreiches Futtergras; Stickstoffzeiger;','Inhalativ (Mai  - Juni);','Pollen, ca. 30 µm;','Dactylis glomerata L.','Poaceae',null,null,5,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (40,2,'g 4','Meadow fescue','Festuca elatior L.;','Up to 1 m high meadow-grass with a usually short creeping basilar axis; perennial; inflorescence up to 20 cm long; flowering season: V - VI; rich fodder;','Inhalative (May - June);','Pollen, approx. 30 µm;','Wiesenschwingel','Festuca elatior L.;','Bis 1 m hohes Rispengras mit meist kurz kriechender Grundachse; mehrjährig; Infloreszenz bis 20 cm lang;  Blütezeit: V - VI; wertvolles Futtergras;','Inhalativ (Mai - Juni);','Pollen, ca. 30 µm;','Festuca pratensis Huds.','Poaceae',null,null,5,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (41,2,'g 5','Rye-grass','Ausdauernder Lolch, Leitergras, Weidelgras;','Reaching a height of up to 50 cm, this spiked grass, unlike the couch grass, has its seed heads facing the rachilla with their short side; perennial; flowering season: V - IX; rich fodder; main ingredient of all lawn grass mixtures; nitrogen indicator;','Inhalative (May - September);','Pollen, approx. 30 µm;','Raygras, englisches','Ausdauernder Lolch, Leitergras, Weidelgras;','Bis 50 cm hohes Ährengras; im Gegensatz zur Quecke Ährchen mit der Schmalseite der Ährenachse zugewandt; mehrjährig; Blütezeit: V - IX; wertvolles Futtergras; Hauptbestandteil aller Rasengrasmischungen; Stickstoffzeiger;','Inhalativ (Mai - September);','Pollen, ca. 30 µm;','Lolium perenne L.','Poaceae',null,null,5,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (42,2,'g 6','Timothy','Cat’s tail;','Up to 1 m height, spiked meadow grass with uniform cylinder-shaped seed-head panicle; in contrast to simular-looking species alopecurus pratensis L., meadow foxtail,  the individual seed-head with its short awns has the form of a boot-jack; perennial; flowering season: V - IX; rich fodder; nitrogen indicator;','Inhalative (May - September);','Pollen, 30 - 40 µm;','Wiesenlieschgras','Timotheusgras, Katzenschweif, Kaminkehrer;','Bis 1 m hohes Ährenrispengras mit gleichförmig-zylindrischer Ährenrispe; im Gegensatz zu der im Habitus ähnlichen Art Alopecurus pratensis L., dem Wiesenfuchsschwanzgras, hat das einzelne Ährchen mit seinen kurzen Grannen die Form eines Stiefelknechtes; mehrjährig; Blütezeit: V - IX; wertvolles Futtergras; Stickstoffzeiger;','Inhalativ (Mai - September);','Pollen, 30 - 40 µm;','Phleum pratense L.','Poaceae',null,null,5,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (43,2,'g 7','Reed, common','Phragmites communis Trin.; reed, reed grass;','Up to 4 m (10 m) tall meadow-grass with a  20 bis 50 cm  long panicle; perennial; flowering seasons: VII - IX; ground-forming marshland pioneer plant; roots reaching as deep as 1 m and runners up to 10 m long;','Inhalative (July - September);','Pollen, approx. 20 µm;','Schilf','Phragmites communis Trin.;\nSchilfrohr, Teichrohr, Röhricht;','Bis 4 m (10 m) hohes Rispengras mit 20 bis 50 cm langer Rispe; mehrjährig; Blütezeit: VII - IX; Verlandungspionier; bis 1 m tief wurzelnd und mit bis zu 10 m langen Ausläufern;','Inhalativ (Juli - September);','Pollen, ca. 20 µm;','Phragmites australis (Cav.) Trin. Ex Steud.','Poaceae',null,null,7,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (44,2,'g 8','Blue grass, (Kentucky)',null,'Up to 60 cm tall meadow-grass with outspread, pyramid-formed panicle and long underground runners; perennial; flowering season: V - VII; good fodder;','Inhalative (May - July);','Pollen, approx. 20 x 25 µm;','Wiesenrispengras',null,'Bis 60 cm hohes Rispengras mit ausgebreiteter, pyramidaler Rispe und langen unterirdischen Ausläufern; mehrjährig; Blütezeit: V - VII; gutes Futtergras;','Inhalativ (Mai - Juli);','Pollen, ca. 20 x 25 µm;','Poa pratensis L.','Poaceae',null,null,5,7,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (45,2,'g 9','Creeping bent','Agrostis alba auct. p. p.; spreading bent;','Up to 80 cm tall meadow-grass with very small seed-heads, thus appearing very delicate and fragile; with short runners above and underground; perennial; flowering season: VI - VIII; only mediocre fodder;','Inhalative (June - August);','Pollen, approx. 30 µm;','Straußgras, weißes','Agrostis alba auct. p. p.;\nFuchsschmiele, Flechtstraußgras;','Bis 80 cm hohes Rispengras mit sehr kleinen Ährchen, dadurch sehr fein und zerbrechlich wirkend; mit kurzen ober- und unterirdischen Ausläufern; mehrjährig; Blütezeit: VI - VIII; nur mäßiges Futtergras;','Inhalativ (Juni - August);','Pollen, ca. 30 µm;','Agrostis stolonifera L.','Poaceae',null,null,6,8,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (46,2,'g 12','Ryegrass, perennial',null,'Type of cereal, especially in Northern Europe; spiked grass reaching up to above a meter with blue-pruinose leaves and a four-cornered, projecting, multi-rowed seed-head; awns 2 - 8 cm long; annual; flowering season: V - VI; originating from Southwest Asia, introduced  to central Europe as a cultivated plant in the Neolithic period, approx. 5000 B.C..;','Inhalative (May - June);','Pollen, 40 - 60 µm;','Roggen',null,'Getreideart, vor allem in Nordeuropa; bis über ein Meter hohes Ährengras mit blau-bereiften Blättern und vierkantiger überhängender, mehrzeiliger, begrannter Ähre; Grannen 2 - 8 cm lang; einjährig; Blütezeit: V - VI; aus Südwest-Asien stammend und in der Jungsteinzeit, ca. 5000 v. Chr., nach Mitteleuropa als Kulturpflanze eingeführt;','Inhalativ (Mai - Juni);','Pollen, 40 - 60 µm;','Secale cereale L.','Poaceae',null,null,5,6,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (47,2,'g 10','Johnson grass (Sudan grass)','Andropogon halepensis (L.) Brot.;','Originating from the Eastern Mediterranean area, this is an up to 120 cm high meadow-grass; perennial; flowering season: VI - VII; the seed are a component of bird feed;','Inhalative (June - July);','Pollen;','Sorgo (Sudangras)','Andropogon halepensis (L.) Brot.;\nMohrenhirse, Wilde Mohrenhirse, Aleppohirse;','Aus dem östlichen Mittelmeergebiet stammendes bis 120 cm hohes Rispengras; mehrjährig; Blütezeit: VI - VII; die Samen sind\nBestandteil von Vogelfutter;','Inhalativ (Juni - Juli);','Pollen;','Sorghum halepense (L.) Pers.','Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (48,2,'g 13','Yorkshire fog',null,'30 - 100 cm high meadow grass with soft-haired leaf sheaths and nodes; perennial; flowering season : V - VIII; low-grade fodder; growing in grey-green tufts; occasionally crop-forming (honey grass fields); avoids lime;','Inhalative (May - August);','Pollen, approx. 30 µm;','Honiggras, wolliges',null,'30 - 100 cm hoch werdendes Rispengras mit weichhaarigen Blattscheiden und Knoten; mehrjährig; Blütezeit: V - VIII; minderwertiges Futtergras; in graugrünen Horsten wachsend; zuweilen bestandsbildend (Honiggraswiesen); kalkmeidend;','Inhalativ (Mai - August);','Pollen, ca. 30 µm;','Holcus lanatus L.','Poaceae',null,null,5,8,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (49,2,'g 14','Oats, common',null,'A cereal with numerous types; hexaploid, 2n = 42; an up to 150 cm high meadow grass; annual; flowering season : VI - VII; the basic form is the wild oat (Avena fatua L.), originating from Asia. Introduced in the Bronze Age as a cultivated plant; today more commonly used as feed;','Inhalative (June - July);','Pollen, approx. 35 µm;','Hafer, Saat-',null,'Getreideart mit zahlreichen Sorten; hexaploid, 2n = 42; bis 150 cm hohes Rispengras; einjährig; Blütezeit: VI - VII; Stammform ist der aus Asien stammende Windhafer (Avena fatua L.). In der Bronzezeit als Kulturpflanze eingeführt; heute mehr Futterpflanze;','Inhalativ (Juni - Juli);','Pollen, ca. 35 µm;','Avena sativa L.','Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (50,2,'g 15','Wheat, common','Triticum hybernum L.;','Most important cereal world-wide; presumably originating from Northern Perisa out of T. dicoccon Schr. x Triticum squarrosa, 8 000 to 10 000 years ago; hexaploid (2n = 42); spiked grass, reaching up to over a meter in height; annual; flowering season: VI - VII;','Inhalative (June - July);','Pollen, 40 - 60 µm;','Weizen, Saat-','Triticum hybernum L.;','Weltweit wichtigste Getreideart; vermutlich in Nordpersien aus T. dicoccon Schr. x Triticum squarrosa vor 8 000 bis 10 000 Jahren entstanden; hexaploid (2n = 42); bis über ein Meter hohes Ährengras; einjährig; Blütezeit: VI - VII;','Inhalativ (Juni - Juli);','Pollen, 40 - 60 µm;','Triticum aestivum L.','Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (51,2,'g 16','Meadow foxtail',null,'An up to 100 cm high  spiked meadow-grass with underground runners reaching a length of up to 10 cm; seed-head panicle approx. 1 cm thick; perennial; flowering season: V - VII; a good and rich fodder when harvested early; moisture and nutrient indicator; easily confused with Phleum pratense L., however appearing a good deal earlier in the year;','Inhalative (May - July);','Pollen, approx. 40 µm;','Wiesenfuchsschwanz',null,'Bis 100 cm hoch werdendes Ährenrispengras mit bis zu 10 cm langen unterirdischen Ausläufern; Ährenrispe ca. 1 cm dick; mehrjährig; Blütezeit: V - VII; bei Frühschnitt gutes ergiebiges Futtergras; Nässe- und Nährstoffzeiger; leicht mit Phleum pratense L. zu verwechseln (s. dort), jedoch deutlich früher im Jahr auftretend;','Inhalativ (Mai - Juli);','Pollen, um 40 µm;','Alopecurus pratensis L.','Poaceae',null,null,5,7,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (52,2,'g 17','False oat grass','Französisches Raygras, Wiesenhafer, Falscher Hafer;','A meadow grass reaching up to 150 cm in height, panicle spreads out widely toward the flowering season; perennial; flowering season : VI - VIII; high-yielding and very nourishing fodder;','Inhalative (June - August);','Pollen, approx. 30 µm;','Glatthafer','Französisches Raygras, Wiesenhafer, Falscher Hafer;','Bis 150 cm hohes Rispengras mit zur Blütezeit weit ausgebreiteter Rispe; mehrjährig; Blütezeit: VI - VIII; ertragreiches und wertvolles Futtergras;','Inhalativ (Juni - August);','Pollen, ca. 30 µm;','Arrhenatherum elatius (L.) J. & K. Presl','Poaceae',null,null,6,8,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (53,2,'g 18','Barley','Gemeine Gerste;','A cereal encompassing many types, originating in central Asia; introduced as a cultivated plant in the Neolithic period; today more often cultivated for feed purposes; up to120 cm high spiked cereal; ear multi-rowed, with four to six awn rows; awns up to 15 cm long; diploid (2n = 14); annual; flowering season : VI - VII;','Inhalative (June bis July);','Pollen, approx. 40 µm;','Gerste, mehrzeilige','Gemeine Gerste;','Aus Zentralasien stammende Getreideart mit vielen Sorten; in der Jungsteinzeit als Kulturpflanze eingeführt; heute mehr zu  Futterzwecken angebaut; bis 120 cm hohes Ährengras; Ähre mehrzeilig, mit vier bis sechs Grannenreihen; Grannen bis 15 cm lang; diploid (2n = 14); einjährig; Blütezeit: VI - VII;','Inhalativ (Juni bis Juli);','Pollen, ca. 40 µm;','Hordeum vulgare L.','Poaceae',null,null,6,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (54,2,'g 20','Corn','Maize, sweet corn;','Up to 3 m high, old cultivated plant of the American Indian advanced civilizations with an approx. 4 cm thick shoot axis and monoecious flowers;  female flowers in axillary ears; male flowers in terminal panicles, releasing very large amounts of pollen; annual; flowering season: VII - IX;  also used as feed in stock fattening;  shredded, the entire plant serves as forage maize;','Inhalative (July - September);','Pollen, 50 - 140 µm;','Mais',null,'Bis 3 m hohe, alte Kulturpflanze der indianischen Hochkulturen Amerikas mit ca. 4 cm dicker Sproßachse und einhäusigen Blüten; weibliche Blüten in blattachselständigen Kolben; männliche Blüten in endständiger Rispe, sehr große Pollenmengen freisetzend; einjährig; Blütezeit: VII - IX; auch als Futtermais in der Viehmast eingesetzt; zudem dienen die ganzen Pflanzen in gehäckselter Form auch als Silofutter;','Inhalativ (Juli - September);','Pollen, 50 - 140 µm;','Zea mays L.','Poaceae',null,null,7,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (55,2,'g 21','Couch grass','Elymus repens (L.) Gould;','A spiked, runner-forming grass up to 150 cm high; in contrast to ryegrass the seed heads face the rachilla with their broad side; perennial; flowering season: VI - VIII; roots up to 80 cm deep; nitrogen indicator;','Inhalative (June - August);','Pollen, 30 - 40 µm;','Quecke, gewöhnliche','Elymus repens (L.) Gould;\nKriechende Quecke;','Bis 150 cm hohes Ausläufer bildendes Ährengras ; im Gegensatz zum Raygras Ährchen mit der Breitseite der Ährenachse zugewandt; mehrjährig; Blütezeit: VI - VIII; bis 80 cm tief wurzelnd; Stickstoffzeiger;','Inhalativ (Juni - August);','Pollen, 30 - 40 µm;','Agropyron repens (L.) P. B.','Poaceae',null,null,6,8,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (56,2,'g 70','Lyme-grass','wild rye','perennial; flowering season : V - VI; rich fodder; nitrogen indicator;',null,null,'Haargerste',null,'mehrjährig; Blütezeit: V - VI; wertvolles Futtergras; Stickstoffzeiger;',null,null,'Elymus triticoides','Poaceae',null,null,5,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (57,2,'g 901','Common bent','Agrostis vulgaris With, Agrostis tenuis Sibth.;','Up to 40 cm high meadow-grass with very small, usually reddish-violett seed-heads; looks very delicate and fragile; with short underground runners; perennial; flowering season: VI - VIII; good but not very plentifl fodder; poorness indicator;','Inhalative (June - August);','Pollen;','Straußgras, rotes','Agrostis vulgaris With, Agrostis tenuis Sibth.;','Bis 40 cm hohes Rispengras mit sehr kleinen, meist rötlich-violetten Ährchen; sehr fein und zerbrechlich wirkend; mit kurzen unterirdischen Ausläufern; mehrjährig; Blütezeit: VI - VIII; gutes aber unergiebiges Futtergras; Magerkeitszeiger;','Inhalativ (Juni - August);','Pollen;','Agrostis capillaris L.','Poaceae',null,null,6,8,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (58,2,'w 1','Ragweed, common','Ambrosia elatior L.;','An annual herb reaching up to 1.5 m; its thin leaves, the two lower ones always bipinnatifid, closely resemble those of the mugwort (name); stems hirsute; monoecious plant, capitulum however unisexual; male flowers are united in nodding capitula into a terminal, cluster-like inflorescence; the uniflorous female capitula underneath; anemogamous ; flowering season: VIII - X;','Inhalative(August - October);','Pollen, um 20 µm;','Ambrosie, beifußblättrige','Ambrosia elatior L.;\nHohe Ambrosie; Hohes Traubenkraut;\nHoher Ragweed','Bis 1,5 m hohes einjähriges Kraut mit dünnen Blättern, von denen die unteren stets doppelt fiederspaltig sind und an die Blätter des Beifußes erinnern (Name); Stengel rauhhaarig; Pflanze einhäusig, Köpfchen jedoch eingeschlechtlich; männliche Blüten in nickenden Köpfchen zu endständiger, traubiger Influreszenz vereint; darunter die einblütigen weiblichen Köpfchen; anemogam; Blütezeit: VIII - X;','Inhalativ (August - Oktober);','Pollen, um 20 µm;','Ambrosia artemisiifolia L.','Asteraceae',null,null,8,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (59,2,'w 2','Ragweed, western','Perennial "Traubenkraut" (ambrosia coronopifolia);','Up to 80 cm high, perennial plant with far-reaching roots and runners; stout leaves, pinnated to pinnatifid with entirely or slightly toothed leaf tips; stalks as well as leaves downy to tomentose; monoecious plant, capitulum however unisexual; male flowers are united in nodding capitula into a terminal, cluster-like inflorescence; the uniflorous female capitula underneath; anemogamous ; flowering season : VIII - X;','Inhalative (August - October);','Pollen, ca. 20 µm;','Ambrosie, ausdauernde','Ausdauerndes Traubenkraut;\nRagweed','Bis 80 cm hohe, ausdauernde Pflanze mit weit kriechenden Wurzeln und Wurzelsprossen; Blätter dicklich, einfach gefiedert bis fiederspaltig mit ganzrandigen oder wenig gezähnten Blattzipfeln; sowohl Stengel als auch Blätter feinhaarig bis filzig;  Pflanze einhäusig, Köpfchen jedoch eingeschlechtlich; männliche Blüten in nickenden Köpfchen zu endständiger, traubiger Influreszenz vereint; darunter die einblütigen weiblichen Köpfchen; anemogam; Blütezeit: VIII - X;','Inhalativ (August - Oktober);','Pollen, um 20 µm;','Ambrosia psilostachya D.C.','Asteraceae',null,null,8,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (60,2,'w 3','Ragweed, giant','Ragweed','Up to  2 m high, annual herb with more or less three-lobed leaves; stem covered in sparse hair to hairless; monoecious plant, capitulum however unisexual; male flowers are united in nodding capitula into a terminal, cluster-like inflorescence; the uniflorous female capitula underneath; anemogamous;flowering season : VIII - X;','Inhalative (August - October);','Pollen, um 20 µm;','Ambrosie, dreilappige','Ragweed','Bis über 2 m hohes einjähriges Kraut mit mehr oder weniger dreilappigen Blättern; Stengel spärlich behaart bis kahl; Pflanze einhäusig, Köpfchen jedoch eingeschlechtlich; männliche Blüten in nickenden Köpfchen zu endständiger, traubiger Influreszenz vereint; darunter die einblütigen weiblichen Köpfchen; anemogam; Blütezeit: VIII - X;','Inhalativ (August - Oktober);','Pollen, um 20 µm;','Ambrosia trifida L.','Asteraceae',null,null,8,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (61,2,'w 4','Ambrosie, false',null,'Annual herb; VII - X;',null,null,'Ambrosie, falsche',null,'Einjähriges Kraut; VII - X;',null,null,'Franseria acanthicarpa','Asteraceae',null,null,7,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (62,2,'w 5','Absinthe','common wormwood;','Up to 1 m high, aromatic, silky hirsuite, shrubby plant; basal leaves two to three times pinnatipartite with lanceolar cusps; yellow capitulae, 2-4 mm wide and arranged like panicles; perennial; anemogamous; flowering season  VII - IX; old medicinal plant employed in a variety of ways with a strongly bitter taste; contains ethereal oils, including  the poisonous Thujon; once used to make absinth liquor; this however has not been allowed since 1923 because of the systematic side effects.','Inhalative (July - September);','Pollen, approx. 15 x 25 µm;','Wermut','Absinth;','Bis 1 m hohe, aromatisch duftende, seidig behaarte und strauchartig wachsende Pflanze; Grundblätter zwei- bis dreifach fiederteilig mit lanzettlichen Zipfeln; Blütenköpchen gelb, 2-4 mm breit und rispenförmig angeordnet; mehrjährig; anemogam; Blütezeit VII - IX; alte, vielfältig eingesetzte Heilpflanze mit stark bitterem Geschmack; enthält ätherische Öle, u.a. das giftige Thujon; früher zur Herstellung von Absinthlikör verwendet; dies ist jedoch wegen der systemischen Nebenwirkungen seit 1923 nicht mehr erlaubt.','Inhalativ (Juli - September);','Pollen, ca. 15 x 25 µm;','Artemisia absinthium L.','Asteraceae',null,null,7,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (63,2,'w 6','Mugwort','Motherwort;','Sometimes reaching over 2 m in height, this plant has a bush-like growth with many branches; feathery leaves dark green on top and white and tomentose beneath, basal auriculate, the upper ones also are deeply serrated; capitula green to brown colored; perennial plant; anemogamous; flowering season  VII - IX; old synanthropic plant, is sometimes also used as an edible vegetable, or healing and spice plant; the cineole in the oil has an anthelmintic effect;','Inhalative (July - September); nutritive (Gewürz, Liköre)','Pollen, ca. 15 - 20 µm;','Beifuß, gewöhnlicher','Pfefferkraut, Gewürzbeifuß, Fliegenkraut;','Bis über 2 m hohe, strauchartig und stark verzweigt wachsende Pflanze; Fiederblätter oberseits dunkelgrün und unterseits weißfilzig, am Gunde geöhrt, zudem die oberen tief gesägt; Blütenköpfchen grünlich bis bräunlich; Pflanze mehrjährig; anemogam; Blütezeit VII - IX; alter Kulturbegleiter, wird zuweilen auch als Gemüse-, Heil- und Gewürzpflanze eingesetzt; das im Öl enthaltene Cineol besitzt wurmtreibende Wirkung;','Inhalativ (Juli - September); nutritiv (Gewürz, Liköre)','Pollen, ca. 15 - 20 µm;','Artemisia vulgaris L.','Asteraceae',null,null,7,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (64,2,'w 7','Daisy, moon','Leucanthemum vulgare Lam.; ox-eye daisy','Herbaceous plant, 20 - 100 cm high; pinnatipartite leaves; flowers arranged in large, up to 5 cm wide captiulae; these sit at the end of a stem and are composed of yellow tubular florets and white  ligulate ray flowers; perennial; entomogamous; flowering season: V - X; very diverse group of species, so far still with insufficient subdivisions; often cultivated as an ornamental plant, as are several other species of the genus; occasionally also used as a medicinal plant (effect spasmolytic and diuretic);','Inhalative (May - October);','Pollen, 20 - 30 µm;','Margerite','Leucanthemum vulgare Lam.;\nMarguerite, Wiesenwucherblume, Gewöhnliche Wucherblume, Orakelblume;','Pflanze krautig, 20 - 100 cm hoch werdend; Blätter fiederteilig; Blüten in großen, bis über 5 cm breiten Köpfchen angeordnet; diese einzeln am Ende eines Stengels sitzend, aus gelben Röhrenblüten und weißen Zungenblüten zusammengesetzt;\nmehrjährig; entomogam; Blütezeit: V - X; sehr formenreiche Sammelart mit noch unzureichender Untergliederung; wie einige andere Arten der Gattung häufig als Zierpflanze kultiviert; gelegentlich auch als Heilpflanze in Gebrauch (Wirkung spasmolytisch u. diuretisch);','Inhalativ (Mai - Oktober);','Pollen, 20 - 30 µm;','Chrysanthemum leucanthemum L','Asteraceae',null,null,5,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (65,2,'w 8','Dandelion','About 140 subspecies are summerized as the group T.-officinale. Classificating literature utilizes very different systems and names for groups and species.','Plant with cross-cut saw shaped leaves in basilar leaf rosettes and a straight, fleshy root; all parts with milky sap; stalk 5 - 40 cm high, unbranched, tubular, hollow and with only one capitulum; this is 3 -5 cm wide and consists only of yellow ligulate ray flowers; fruit with a stem on which a tuft of hair is situated (pappus) so as to be dispersed by the wind (anemochory)  (headword: parachute, dandelion-clock); perennial; entomogamous  (bee pasture); flowering season: III - VII; medicinal plant and vegetable;','Inhalative (March - July); ingestive (mixed honeys, dandelion honey);','Pollen, approx. 35 µm;','Löwenzahn','Kuhblume;\nEtwa 140 Kleinarten werden zur T.-officinale-Gruppe zusammengefaßt.\nDie Bestimmungsliteratur gibt höchst unterschiedliche Systeme, Gruppen- und Artnamen an.','Pflanze mit schrotsägeförmigen Blättern in grundständiger Blattrosette und pfahlförmiger, fleischiger Wurzel; alle Teile mit Milchsaft; Infloureszenzschaft 5 - 40 cm hoch, blattlos, röhrig, hohl und mit nur einem Blütenkörbchen; dieses 3 -5 cm breit und nur mit gelben Zungenblüten; Früchte mit Stiel (Schnabel) und einem darauf sitzenden Haarbüschel (Pappus) zur Windverbreitung (Stichwort: Fallschirm, Pusteblume); mehrjährig; entomogam (Bienenweide); Blütezeit: III - VII; Heil- und Gemüsepflanze;','Inhalativ (März - Juli);\nIngestiv (Mischhonige, Löwenzahnhonig);','Pollen, ca. 35 µm;','Taraxacum officinale Wiggers','Asteraceae',null,null,3,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (66,2,'w 9','Plantain, English','Ribwort','Plant with lanceolar, distinctly 3 to 7 nervate, approx. 20 cm long leaves in a basilar rosette; inflorescene developed as a seed head, its shaft 15 - 50 cm high, sulcate and without leaves; the individual flowers inconspicuous; anemogamous; perennial; flowering season: V - IX; good forage plant; medicinal plant;','Inhalative (May bis September);','Pollen, approx. 20 µm;','Wegerich, Spitz-',null,'Pflanze mit lanzettlichen, deutlich 3- bis 7-nervigen, ca. 20 cm langen Blättern in grundständiger Rosette; Schaft der als Ähre ausgebildeten Influreszenz 15 - 50 cm hoch, gefurcht und blattlos; die einzelnen Blüten unscheinbar; anemogam; mehrjährig; Blütezeit: V - IX; gute Futterpflanze; Heilpflanze;','Inhalativ (Mai bis September);','Pollen, ca. 20 µm;','Plantago lanceolata L.','Plantaginaceae',null,null,5,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (67,2,'w 10','Goose-foot',null,'Reaching a height of up to one meter, this is a strongly dendric annual herb with diamond-shaped to lanceolar, sometimes slightly three-lobed leaves; the plant is usually white-mealy pruinose in its entirety, but especially in the inflorescence area; flower heads clustered and pyramid-shaped; blossoms green colored and inconspicuous; flowering season : V - X; a pionieer plant with roots reaching a into depth of up to one meter; a synanthropic plant since the Neolithic period because of its use as a vegetable and a source of meal;','Inhalative (May - October);','Pollen, approx. 30 µm;','Gänsefuß, weißer',null,'Bis ein Meter hoch werdendes, stark verästeltes, einjähriges Kraut mit rautenförmigen bis lanzettlichen, zuweilen schwach dreilappigen Blättern; Pflanze im Ganzen, besonders jedoch der Influreszenzbereich meist weißmehlig bereift; Blütenstände knäuelig und pyramidenförmig; Blüten grünlich und unscheinbar; anemogam; Blütezeit: V - X; bis ein Meter tief wurzelnde Pionierpflanze; Kulturbegleiter seit der Jungsteinzeit wegen der Nutzung als Gemüsepflanze und als Mehlfrucht;','Inhalativ (Mai - Oktober);','Pollen, ca. 30 µm;','Chenopodium album L.','Chenopodiaceae',null,null,5,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (68,2,'w 12','Goldenrod, European',null,'Reaching a height of up to 20 - 100 cm, this perennial plant has elongated, alternate, undivided and serrated leaves, a 7 - 8 mm long flowerhead, 10 - 15 mm in diameter and with 5 - 8 yellow ligulate ray flowers in dense,  upright, pyramid-shaped, secundiflorous, nodding panicles; entomogamous and autogamous; flowering season : VII - X; as a drug its effect is diuretic, spasmolytic and hypotensive ;','Inhalative (July - October);','Pollen, approx. 25 µm;','Goldrute, echte',null,'20 - 100 cm hoch werdende, mehrjährige Pflanze mit länglichen, wechselständigen, ungeteilten und gesägten Blättern; Blütenköpfchen 7 - 8 mm lang, 10 - 15 mm im Durchmesser und mit 5 - 8 gelben Zungenblüten in dichten, aufrechten pyramidenförmigen, einseitswendigen, nickenden Rispen; entomogam und autogam; Blütezeit: VII - X; wirkt als Droge diuretisch, spasmolytisch und blutdrucksenkend;','Inhalativ (Juli - Oktober);','Pollen, ca. 25 µm;','Solidago virgaurea L.','Asteraceae',null,null,7,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (69,2,'w 14','Amaranth, coarse-haired','Coarse-haired foxtail;','Up to 80 cm in height, annual herb with egg-shaped to elongated, gray downy leaves and green, totally inconspicuous blossoms in single, thick, cone-shaped panicle; flowering time: VI - IX;','Inhalation (June - September);','Pollen, approx. 25 µm;','Amaranth, rauhhaariger','Rauhhaariger Fuchsschwanz;','Bis 80 cm hohes, einjähriges Kraut mit eiförmigen bis länglichen, grauflaumigen Blättern und grünlichen, völlig unscheinbaren Blüten in endständiger, dichter, kegelförmiger Rispe; Blütezeit: VI - IX;','Inhalativ (Juni - September);','Pollen, ca. 25 µm;','Amaranthus retroflexus L.','Amaranthaceae',null,null,6,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (70,2,'w 15','Orach',null,'Reaching a height of 20 to 150 cm, these annual herbs are sometimes silvery-mealy and make a patulous (widespreading) impression; leaves elongated to a point, usually serrated or sinuate (cleft); flowers greenish, inconspicuous, clustered, in false spikes; entomogamous and autogamous; flowering season: VI - X; occasionally some species are cultivated as vegetable plants.','Inhalative (June - October);','Pollen, approx. 20 µm;','Melde',null,'20 bis 150 cm hoch werdende, sparrig wirkende, einjährige und zuweilen mehlig bestäubte Kräuter; Blätter länglich zugespitzt, meist gezähnt oder gebuchtet; Blüten grünlich, unscheinbar, knäuelig gehäuft, in Scheinähren; entomogam und autogam; Blütezeit: VI - X; selten werden manche Arten noch als Gemüsepflanzen kultiviert.','Inhalativ (Juni - Oktober);','Pollen, um 20 µm;','Atriplex L.','Chenopodiaceae',null,null,6,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (71,2,'w 16','Sumpseed, rough','Iva annua L., Iva caudata;','Annual herb with long-stemmed, serrated leaves that are opposite in the lower area; greenish-white, small capitula, in an inflorescence made up of several false spikes; anemogamous and entomogamous; flowering season : VII - X;','Inhalative (July - October);','Pollen;','Schlagkraut','Iva annua L., Iva caudata;','Einjäriges Kraut mit lang gestielten, gezähnten und im unteren Bereich gegenständigen Blättern; Blüten in grünlich-weißen, kleinen Köpfchen; diese in einem aus mehreren Scheinähren zusammengesetzten Blütenstand; anemogam und entomogam; Blütezeit: VII - X;','Inhalativ (Juli - Oktober);','Pollen;','Iva ciliata','Asteraceae',null,null,7,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (72,2,'w 17','Aster, China','Aster chinensis; summer aster;','Reaching a height of up to 10 - 80 cm , this is an annual herb with entire alternate leaves and up to 40 - 80 mm wide, single, terminal, double (depending on the type) capitula; entomogamous; flowering season : VIII - X; ornamental plant, with numerous  types and variations of color. (white, cream, pink, red and violet);','Inhalative (August - October);','Pollen;','Aster, Garten-','Aster chinensis;\nSommeraster;','10 - 80 cm hoch werdendes, einjähriges Kraut mit ungeteilten, wechselständigen Blättern und 40 - 80 mm breiten, einzelnen, endständigen, je nach Sorte auch gefüllten Blütenköpfchen; entomogam; Blütezeit: VIII - X; Zierpflanze, in zahlreichen Sorten und Farbvarianten (Weiß, Creme, Rosa, Rot u. Violett);','Inhalativ (August - Oktober);','Pollen;','Callistephus chinensis (L.) Nees','Asteraceae',null,null,8,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (73,2,'w 18','Dock, curly; sorrel., garden; s., sheep','to 2: Acetosa pratensis Mill.; to 3: Acetosella vulgaris (Koch) Fourr.;','Perennial plant reaching a height of 5 - 100 cm, with alternate, entire, heart-shaped to lanceolar leaves, with a tunicate fistula (ochrea) enclosing the base; leaves taste sour because of the oxalic acid they contain; flowers relatively inconspicuous, small, white to reddish in terminal, seed-head like inflorescence; anemogamous; flowering seasons: V - VIII; fruit three-cornered (cf. buckwheat);  sometimes vegetable and soup plant; extraction of potassium oxolate for the removal of blood and rust stains.','Inhalative (May - August);','Pollen, approx. 20 - 35 µm;','Sauerampfer, krauser; S., großer; S., kleiner','Zu 2: Acetosa pratensis Mill.;\nZu 3: Acetosella vulgaris (Koch) Fourr.;\nAmpfer;','5 - 100 cm hoch werdende, mehrjährige Pflanze mit wechselständigen, ungeteilten, herzförmigen bis spießförmigen Blättern, die am Grunde eine stängelumfassende, häutige Röhre (Ochrea) besitzen; Blätter durch die enthaltene Oxalsäure sauer schmeckend; Blüten relativ unscheinbar, klein, weiß bis rötlich in endständigen, ährig zusammengesetzten Blütenständen; anemogam; Blütezeit: V - VIII; Früchte dreikantig (vgl. Buchweizen); gelegentlich Gemüse und Suppenpflanze; Gewinnung von Kaliumoxalat zur Blut- und Rostfleckenentfernung.','Inhalativ (Mai - August);','Pollen, ca. 20 - 35 µm;','Rumex crispus L., R. acetosa L., R. acetosella L.','Polygonaceae',null,null,5,8,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (74,2,'w 19','Parietaria','Parietaria erecta Mert. & Koch;','Reaching a height of 20 -100 cm , this sparsely branching perennial plant has alternate, large, longish to egg-shaped leaves with a glass-like shine; flowers in inconspicuous seed balls; anemogamous; flowering season  VI - IX; used to be officinal (Herba parietariae) as a divretic agent, wound healing, rheumatism and cough remedy;','Inhalative (June - September);','Pollen, 12 - 17 µm;','Glaskraut, aufrechtes','Parietaria erecta Mert. & Koch;','20 -100 cm hoch werdende, spärlich verzweigte, mehrjährige Pflanze mit wechselständigen, großen, länglichen bis eiförmigen Blättern, die glasartig glänzen; Blüten unscheinbar, knäuelig gehäuft; anemogam; Blütezeit VI - IX; früher offizinell (Herba parietariae) als Diureticum, Wundheil-, Rheuma- und Hustenmittel;','Inhalativ (Juni - September);','Pollen, 12 - 17 µm;','Parietaria officinalis L.','Urticaceae',null,null,6,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (75,2,'w 20','Nettle, stinging',null,'Reaching 0.5 - 2 m of height, this perennial plant with few branches is completely covered, and thus armed, with stings; it has largely (roughly) serrated leaves, running to a long tip (apiculated) and heart-formed at the base; flowers small and inconspicuous in hanging panicles; anemogamous; flowering season : VI - X; nitrogen or, in forests, humidity indicator; leaves are used as greens, medicinal tea and coloring agent; substitute fiber plant (stem);','Inhalative (June - October);','pollen, approx. 15 µm;','Brennessel, große',null,'0,5  - 2 m hoch werdende, mehrjährige, wenig verzweigte und im Ganzen mit Brennhaaren bewehrte Pflanze mit grob gesägten, lang zugespitzten und am Grunde herzförmigen Blättern; Blüten klein und unscheinbar, in hängenden Rispen; anemogam; Blütezeit: VI - X; Stickstoff- oder im Wald Feuchtigkeitszeiger; Blätter als Gemüse, Heiltee und Färbemittel; Ersatzfaserpflanze (Stängel);','Inhalativ (Juni - Oktober);','Pollen, um 15 µm;','Urtica dioica L.','Urticaceae',null,null,6,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (76,2,'w 21','Pellitory of the wall','Parietaria ramiflora Moench, Parietaria diffusa Mert. & Koch, Parietaria punctata Willd.;','A 5 - 30 cm tall, fairly decumbent, multi-branched, perennial plant with alternate, small, egg-shaped to roundish leaves; flowers in inconspicuous seed balls; anemogamous ; flowering season  V - X;','Inhalative (May - October);','Pollen, 12 - 17 µm;','Glaskraut, Mauer-','Parietaria ramiflora Moench, Parietaria diffusa Mert. & Koch, Parietaria punctata Willd.;','5 - 30 cm hohe mehr niederliegende stark verzweigte, mehrjährige Pflanze mit wechselständigen, kleinen, eiförmigen bis rundlichen Blättern; Blüten unscheinbar, knäuelig gehäuft; anemogam; Blütezeit V - X;','Inhalativ (Mai - Oktober);','Pollen, 12 - 17 µm;','Parietaria judaica L.','Urticaceae',null,null,5,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (77,2,'w 22','Chrysanthemum','Dendranthema indicum (L.) Desm., Chrysanthemum japonicum Thunb., Dendranthema x hortorum, Chrysanthemum x hortorum;','A semi-shrub, reaching up to 25 to 150 cm depending on the type, this perennial ornamental plant with grey-green, largely lobed leaves and multicolored, usually paniclly piled, double capitula with a diameter of up to 20 cm; flowering season in the wild IX - XII; the various types are categorized into different groups. One differentiates between the "indicum", the "koreanum" and the "rubellum group".','Inhalative outdoors in the open (September - December) or as cut flowers (i.e. all year around);','Pollen, approx. 35 µm;','Chrysantheme','Dendranthema indicum (L.) Desm., Chrysanthemum japonicum Thunb., Dendranthema x hortorum, Chrysanthemum x hortorum;','Halbstrauchige, je nach Sorte 25 bis 150 cm hoch werdende, mehrjährige Zierpflanze mit graugrünen, grob-gelappten Blättern und vielfarbigen, meist rispig gehäuften, gefüllten und bis 20 cm im Durchmesser großen Blütenköpfchen; Blütezeit im Freiland IX - XII;  Die einzelnen Sorten werden in verschiedene Gruppen eingeordnet. Man unterscheidet die "Indicum-", die "Koreanum-" und die "Rubellumgruppe".','Inhalativ im Freiland (September - Dezember) oder bei Schnittblumen (ggf. ganzjährig);','Pollen, ca. 35 µm;','Chrysanthemum indicum L. div. var.','Asteraceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (78,2,'w 23','Dahlia','Dahlia variabilis Hort.;','Depending on the type, this perennial ornamental plant reaches a height of 30 - 250 cm; leaves pinnatifid, with serrated sections; types with double or single flowers can reach a diameter up to 30 cm; flowering season : VII - XI; The various types are categorized into different groups. One differentiates between anemonen-flowered dahlia, "Halskraus" dahlia, cactus dahlia, "Mignon" dahlia, pompon dahlia and "Schmuck" dahlien (ornamental dahlia).','Inhalative in the open (July - November) or for cut flowers occasionally outside of this time period;','Pollen;','Dahlie','Dahlia variabilis Hort.;\nGeorgine;','Je nach Sorte 30 - 250 cm hoch werdende mehrjährige Zierpflanze; Blätter fiederspaltig, mit gezähnten Abschnitten;\nSorten mit gefüllten oder nicht gefüllten Blüten, die im Durchmesser bis zu 30 cm groß sein können; Blütezeit: VII - XI; Die einzelnen Sorten werden in verschiedene Gruppen eingeteilt. Man unterscheidet anemonenblütige Dahlien, Halskrausendahlien, Kaktusdahlien, Mignondahlien, Pompondahlien und Schmuckdahlien.','Inhalativ im Freiland (Juli  - November) oder bei Schnittblumen gelegentlich außerhalb dieses Zeitraums;','Pollen;','Dahlia x cultorum Thorsr. & Reis','Asteraceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (79,2,'w 24','Alfalfa, lucerne',null,'A 20 to 80 cm high, perennial  plant with odd-pinnated leaves; flowers about 1 cm long, blue or violett, sometimes also white-colored, greenish or yellowish; entomogamous  (bee pasture) and autogamous; flowering season: V - IX; the pods are curled up into a spiral in two to three loose bends; cultivated plant since early ancient times, originating from Near East; rich feed source; a nitrogen collector with roots reaching up to 5 m into the earth;','Inhalative (May - September);','Pollen, approx. 30 x 35 µm;','Luzerne',null,'20 bis 80 cm hohe, mehrjährige Pflanze mit unpaarig gefiederten Blätten; Blüten um 1 cm lang, blau oder violett, zuweilen auch weißlich, grünlich oder gelblich; entomogam (Bienenweide) und autogam; Blütezeit: V - IX; die Hülsenfrüchte sind mit zwei bis drei lockeren Windungen spiralich eingerollt; Kulturpflanze seit der frühen Antike, aus dem vorderen Orient stammend; wertvolle Futterpflanze; bis 5 m tief wurzelnder Stickstoffsammler;','Inhalativ (Mai - September);','Pollen, ca. 30 x 35 µm;','Medicago sativa L.','Fabaceae',null,null,5,9,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (80,2,'w 25','Chamomille, German','Matricaria chamomilla auct., non L., Chamomilla recutita (L.) Rausch.','Reaching a height of 15 - 40 cm, this annual herb has bipinnafid leaves with lineal pinnules; flower-head in the center with yellow tubular florets and a circle of white ligulate ray flowers around the edge; entomogamous (flies); flowering season  V - IX; a cultivated plant since the Neolithic period; old medicinal plant with a characteristic scent;','Inhalative out in the open (V - IX); inhalative via steam baths (= chamomille flower extract); ingestive (tea = chamomille flower extract);','Pollen;','Kamille, echte','Matricaria chamomilla auct., non L.,\nChamomilla recutita (L.) Rausch.','15 - 40 cm hohes, einjähriges Kraut mit doppelt gefiederten Blättern, Fiederchen lineal; Blütenköpfchen im Zentrum mit gelben Röhrenblüten und am Rande mit einem Kreis weißer Zungenblüten; entomogam (Fliegen); Blütezeit V - IX; Kulturbegleiter seit der Jungsteinzeit; alte Arzneipflanze mit charakteristischem Duft;','Inhalativ im Freiland (V - IX);\nInhalativ bei Dampfbädern (= Kamilleblütenextrakt);\nIngestiv (Tee = Kamilleblütenextrakt);','Pollen;','Matricaria recutita L.','Asteraceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (81,2,'w 26','Lent lily','Tenby daffodil;','Up to 15 - 30 cm high, bulbiferous shrub with baslilar, steeply rising, lanceolar and entire leaves; sulphur-yellow petals, spread in a star and with a cup-shaped, elongated corona; entomogamous  (bumble-bee flower); flowering season  III - V; ornamental plant; poisonous; plants occuring in the wild are protected;','Inhalative (March - May);','Pollen, approx. 30 x 60 µm;','Narzisse, gelbe','Osterglocke;','15 - 30 cm hohe Zwiebelstaude mit grundständigen, steil aufragenden, lanzettlichen und ganzrandigen Blättern; Blütenkronblätter schwefelgelb, sternförmig ausgebreitet und mit becherförmig verlängerter Nebenkrone; entomogam (Hummelblume); Blütezeit III - V; Zierpflanze; giftig; wild vorkommende Pflanzen sind geschützt;','Inhalativ (März - Mai);','Pollen, ca. 30 x 60 µm;','Narcissus pseudonarcissus L.','Amaryllidaceae',null,null,3,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (82,2,'w 28','Rose, Japanese',null,'Bushes usually no more than a meter in height with dense, bristly, odd-pinnated, very rugose leaves, tomentose underneath; flowers reddish to red, rarely white, usually single-flowered; flowering season V - VII; fruit (rosehips) large, suited for the production of jams and wine;','Inhalative (May - July); ingestive (mixed honeys);','Pollen;','Rose, Kartoffel-',null,'In der Regel nicht mehr als ein Meter hoch werdende Sträucher mit dicht stachelborstigen Zweigen, unpaarig gefiederten, stark runzeligen und unterseits filzigen Blättern; Blüten rötlich - rot, selten weiß, meist ungefüllt; Blütezeit V - VII; Früchte (Hagebutten) groß, zur Marmeladen- und Weinherstellung geeignet;','Inhalativ (Mai - Juli);\nIngestiv (Mischhonige);','Pollen;','Rosa rugosa Thunb.','Rosaceae',null,null,5,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (83,2,'w 29','Sunflower, common',null,'Reaching a height of up to 2.5 m, this annual plant has a  hirsute shoot axis with alternate, heart-shaped leaves; buttons up to  40 cm wide, with an outer circle of yellow ligulate ray flowers; entomogamous (bee pasture); flowering season VII - X; seeds important oil crop;','Inhalative (July - October); ingestive (sunflower honey, late summer mixed honeys);','Pollen, approx. 35 µm;','Sonnenblume, gewöhnliche',null,'Bis 2,5 m hoch werdende, einjährige Pflanze mit rauhhaariger Sprossachse; Blätter wechselständig, herzförmig; Blütenköpfe bis 40 cm breit, im äußeren Kreis gelbe Zungenblüten; entomogam (Bienenweide); Blütezeit VII - X; Samen wichtige Ölfrucht;','Inhalativ (Juli - Oktober);\nIngestiv (Sonnenblumenhonig, Spätsommer-Mischhonige);','Pollen, ca. 35 µm;','Helianthus annuus L.','Asteraceae',null,null,7,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (84,2,'w 30','Tulpip, garden',null,'Reaching a height of 30 to 60 cm, this is a buliferous, perennial shrub of great variety with basilar, errect, wide-lanceolar; petals calyx-shaped, blunt or pointed, sometimes fringed, in all colors except blue and black; entomogamous; flowering season  IV - V; diverse ornamental plant in many types;','Inhalative (April - May);','Pollen, approx. 40 µm;','Tulpe, Garten-',null,'30 bis 60 cm hoch werdende, sortenreiche Zwiebelstaude mit grundständigen, aufragenden, breit-lanzettlichen und ganzrandigen Blättern; Blütenblätter kelchförmig, stumpf oder spitzlich, zuweilen gefranst, mit Ausnahme von blau und schwarz in allen Farben; entomogam; Blütezeit IV - V; formenreiche Zierpflanze;','Inhalativ (April - Mai);','Pollen, ca. 40 µm;','Tulipa gesnerana L.','Liliaceae',null,null,4,5,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (85,2,'w 32','Rape, oilseed','Coleseed rape','Up to 2 m high, this annual to biennial herb becomes very patulous (widespreading) with age; it has smooth, blue-green pruinose leaves and yellow flowers in clusters; these commence to blossem from the bottom upwards, thus the buds project above the already blooming flowers; partly entomogamous (very good bee pasture); for seeding in the previous year flowering season: IV - V, when the seeding takes place in the spring: VIII - X; deep-rooting plant, important oil crop; source material for margarine; recently also used to produce fuel;','Inhalative (April - May and August - October); ingestive ( rape honey, mixed honeys);','Pollen, approx. 20 x 40 µm;','Raps',null,'Bis 2 m hohes und bei der Reife sehr sparriges, ein- bis zweijähriges Kraut mit glatten, blaugrün bereiften Blättern und goldgelben, traubig angeordneten Blüten; Trauben von unten nach oben hin aufblühend, daher Blütenknospen die bereits geöffneten Blüten überragend; teilweise entomogam (sehr gute Bienenweide); Blütezeit bei Aussaat im Vorjahr: IV - V, bei Aussaat im Frühjahr: VIII - X; Tiefwurzler; wichtige Ölfrucht; Margarinegrundstoff; heute auch zur Treibstoffgewinnung;','Inhalativ (April - Mai und August - Oktober);\nIngestiv (Rapshonig, Mischhonige);','Pollen, ca. 20 x 40 µm;','Brassica napus L. ssp. Napus','Brassicaceae',null,null,4,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (86,2,'w 35','Geranium, bedding','geranium, zonal pelargonium;','Up to approx. 50 cm in height, frost-sensitive semishrub with sinuated but undivided leaves; flowers in many colors, umbellarly heaped towards the end of the inflorescence stem; partly entomgomous ; flowering season : VI - X; main inhalation substance is geraniol – not to be confused with geranium oil, which is occasionally listed under the same name - , one of the most frequently used compounds in the perfume industry;','Inhalative (June - October);','Pollen, approx. 80 µm;','Geranie, gewöhnliche','Pelargonie;','Ca. 50 cm hoch werdender, frostempfindlicher Halbstrauch mit eingebuchteten aber ungeteilten Blättern; Blüten in vielen Farben, am Ende des Influreszenzstiels doldig gehäuft; teilweise entomogam; Blütezeit: VI - X; Hauptinhaltsstoff ist  Geraniol - nicht zu verwechseln mit Geraniumöl, das gelegentlich unter dem gleichen Namen geführt wird - , eine der meist verwendeten Verbindungen in der Parfümindustrie;','Inhalativ (Juni - Oktober);','Pollen, ca. 80 µm;','Pelargonium zonale (L.) L´Herit. ex Aiton','Geraniaceae',null,null,6,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (87,2,'w 36','Primrose','Schlüsselblume, Gartenaurikel;','Reaching a height of approx. 30 cm, this is a tenacious plant with more or less entire and rosette-like leaves; flowers in many colors clustered at the end of the inflorescence stem; entomogamous; flowering season: IV - VII;','Inhalative (April - July);','Pollen, approx. 25 x 35 µm;','Primel','Schlüsselblume, Gartenaurikel;','Ca. 30 cm hoch werdende, ausdauernde Pflanze mit mehr oder weniger ganzrandigen und rosettenartig angeordneten Blättern; Blüten in vielen Farben am Ende des Influreszenzstiels knäuelig gehäuft; entomogam; Blütezeit: IV - VII;','Inhalativ (April - Juli);','Pollen, ca. 25 x 35 µm;','Primula hortensis Wettst.','Primulaceae',null,null,4,7,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (88,2,'w 40','Hyazinth',null,'Reaching a height of approx. 20 to 30 cm, this is an intensely fragrant bulbiferous shrub with basilar, erect, lanceolar and entire leaves; inflorescense racemiform; flowers cup-shaped, originally dark blue – as of recently there are also white and red-colored types; entomogamous; flowering season  IV - VI; very aromatic ornamental shrub; the oil is employed in the perfume industry;','Inhalative (April - June); occasionally also at other times in the florist trade;','Pollen;','Hyazinthe',null,'Ca. 20 bis 30 cm hoch werdende, stark duftende Zwiebelstaude mit grundständigen, aufragenden, lanzettlichen und ganzrandigen Blättern; Influreszenz traubig; Blüten becherförmig, ursprünglich dunkelblau - neuerdings gibt es auch weiße und rötliche Sorten; entomogam; Blütezeit IV - VI; stark duftende Zierpflanze; Verwendung des Öls in der Parfümindustrie;','Inhalativ (April - Juni); im Floristikbereich gelegentlich auch zu anderer Zeit;','Pollen;','Hyacinthus orientalis L.','Liliaceae',null,null,4,6,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (89,9,'d 1','Dermatophagoides pteronyssinus; house dust mite','Mealia toxopei Oudemans, Visceroptes saitoi Sasa; European house dust mite, bed mite;','House dust mites are tiny, eight-legged arachnids from 0.2 to 0.4 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. Morphologically, there are only microscopic differences between the three Dermatophagoides species.','Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.','Excrement balls; patient.allergens in the finest dust','Dermatophagoides pteronyssinus; Hausstaubmilbe','Mealia toxopei Oudemans, Visceroptes saitoi Sasa;\nEuropäische Hausstaubmilbe, Bettmilbe;','Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,4 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Morphologisch bestehen nur mikroskopische Unterschiede zwischen den drei Dermatophagoidesarten.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.','Kotballen; Allergene im Feinstaub','Dermatophagoides pteronyssinus Trouessart','Pyroglyphidae','Acari, Milben',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (90,9,'d 2','Dermatophagoides farinae; house dust mite','Dermatophagoides culinae De Leon; American house dust mite, bed mite;','House dust mites are tiny, eight-legged arachnids from 0.2 to 0.4 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. Morphologically, there are only microscopic differences between the three Dermatophagoides species.','Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.','Excrement balls; patient.allergens in the finest dust','Dermatophagoides farinae; Hausstaubmilbe','Dermatophagoides culinae De Leon;\nAmerikanische Hausstaubmilbe, Bettmilbe;','Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,4 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Morphologisch bestehen nur mikroskopische Unterschiede zwischen den drei Dermatophagoidesarten.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.','Kotballen; Allergene im Feinstaub','Dermatophagoides farinae Hughes','Pyroglyphidae','Acari, Milben',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (91,9,'d 3','Dermatophagoides microceras; house dust mite','bed mite;','House dust mites are tiny, eight-legged arachnids from 0.2 to 0.4 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. Morphologically, there are only microscopic differences between the three Dermatophagoides species. Because of its very strong similarity to Dermatophagoides farinae Hughes, this species was first discovered in 1971 as a separate species and was previously probably often overlooked.','Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.','Excrement balls; patient.allergens in the finest dust','Dermatophagoides microceras; Hausstaubmilbe','Bettmilbe;','Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,4 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Morphologisch bestehen nur mikroskopische Unterschiede zwischen den drei Dermatophagoidesarten. Diese Art ist wegen ihrer starken Ähnlichkeit zu Dermatophagoides farinae Hughes erst 1971 als eigenständige Art beschrieben worden und ist wahrscheinlich bisher auch oft übersehen worden.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.','Kotballen; Allergene im Feinstaub','Dermatophagoides microceras Griffith & Cunnington','Pyroglyphidae','Acari, Milben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (92,9,'d 74','Euroglyphus maynei; house dust mite','Mealia maynei Cooreman; Dermatophagoides maynei Hughes;','House dust mites are tiny, eight-legged arachnids from 0.2 to 0.3 mm in length. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, you can recognize the plump, oval body that is not further articulated and only sparsely haired, as well as its slow and clumsy movement. The mandibles together with their feelers resemble tongs or tweezers. The morphologically most conspicuous difference with the three Dermatophagoides species is that there are no four long train hairs on the abdomen end.','Inhalation; the dried excrement eventually with time becomes dust and is driven into the air by all kinds of activities in the household.','Excrement balls; patient.allergens in the finest dust','Euroglyphus maynei; Hausstaubmilbe','Mealia maynei Cooreman; Dermatophagoides maynei Hughes;','Hausstaubmilben sind winzige, achtbeinige Spinnentierchen von 0,2 bis 0,3 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. Nur mit einer starken Lupe erkennt man den plumpen, ovalen, nicht weiter unterteilten und nur spärlich behaarten Körper sowie ihre eher langsamen Bewegungen. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette. Der morphologisch auffälligste Unterschied zu den drei Dermatophagoidesarten besteht darin, dass sich am Hinterleibsende keine vier langen Schlepphaare befinden.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei allen möglichen Aktivitäten im Haus aufgewirbelt.','Kotballen; Allergene im Feinstaub','Euroglyphus maynei Cooreman','Pyroglyphidae','Acari, Milben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (93,9,'d 70','Acarus siro; food mite','Acarus siro var. farinae L., Aleurobius farinae var. africana Oudemans; flour mite;','These food mites are tiny, eight-legged arachnids from 0.3 to 0.7 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can recognize on the back a body an incision between the second and third pair of legs. The males possess tarsal and anal suckers, the females a claw at the end of each foot. Furthermore, the males possess a clearly expressed hook-like extension at the thigh of the first leg pair. Both sexes possess four long dragged hairs on the back end. The body color is shining white; the mandibles and the legs, depending upon their nourishment, are colored yellow to brown. The mandibles together with their feelers resemble tongs or tweezers.','Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours','Probably proteins in the excrement;','Acarus siro; Vorratsmilbe','Acarus siro var. farinae L., Aleurobius farinae var. africana Oudemans;\nMehlmilbe;','Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,7 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man auf der Rückseite einen Körpereinschnitt zwischen dem zweiten und dritten Beinpaar. Die Männchen besitzen Tarsal- und Analsaugnäpfe, die Weibchen eine Kralle an jedem Fußende. Zusätzlich besitzen die Männchen am Schenkel des ersten Beinpaares unterseits einen deutlich ausgeprägten hakenförmigen Fortsatz. Beide Geschlechter besitzen am Hinterende vier lange Schlepphaare. \nDie Körperfarbe ist glänzend weiß; dagegen sind die Mundwerkzeuge und die Beine in Abhängigkeit von der Nahrung gelblich bis braun gefäbt. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen','Wahrscheinlich Proteine im Kot;','Acarus siro L.','Acaridae','Acari, Milben',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (94,9,'d 71','Lepidoglyphus destructor; food mite','Acarus destructor Schrank, Acarus spinipes Koch, Glycyphagus anglicus Hull, Lepidoglyphus cadaverum Türk & Türk, Glycyphagus destructor Hughes;','These food mites are tiny, eight-legged arachnids from 0.3 to 0.6 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can notice that the body has no incision between the second and the third leg pairs. The males possess no suction pads; by the females, a short copulation pipe is visible. For both sexes, the body bristles are very long and feathery. A certain way of distinguishing between Gylcyphagus domesticus De Geer is an inserted, elongated, and pointed scale on the end limb of the legs with short haired surface. Nevertheless, the scale is difficult to recognize if it is not spread out but laid out along the last leg limb.','Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours','Probably proteins in the excrement;','Lepidoglyphus destructor; Vorratsmilbe','Acarus destructor Schrank, Acarus spinipes Koch, Glycyphagus anglicus Hull, Lepidoglyphus cadaverum Türk & Türk, Glycyphagus destructor Hughes;','Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,6 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man, dass der Körper keinen Einschnitt zwischen dem zweiten und dritten Beinpaar besitzt. Die Männchen besitzen keine Saugnäpfe; bei den Weibchen ist eine kurze Kopulationsröhre sichtbar. Bei beiden Geschlechtern sind die Körperborsten sehr lang und gefiedert. Ein sicheres Unterscheidungsmerkmal zu Gylcyphagus domesticus De Geer ist eine am Endglied der Beine inserierende, längliche und spitz zulaufende Schuppe mit kurzhaariger Oberfläche. Allerdings ist die Schuppe schwer zu erkennen, wenn sie nicht abgespreitzt sondern dem letzten Fußglied angelegt ist.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen','Wahrscheinlich Proteine im Kot;','Lepidoglyphus destructor Schrank','Glycyphagidae','Acari, Milben',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (95,9,'d 72','Tyrophagus putrescentiae; food mite','Acarus putrescentiae Schrank, Tyrophagus longior var. castellanii Hirst, Tyrophagus noxius Zachvatkin, Tyrophagus brauni Türk & Türk;','These food mites are tiny, eight-legged arachnids from 0.3 to 0.5 mm in size. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can recognize on the back of the body an incision between the second and third pair of legs. The males possess strongly expressed tarsal suckers, but no hook-like extension on the thigh of the first pair of legs; the females possess a claw at the end of each foot. Both sexes clearly possess more than four long train hairs on the rear end. The body color is light. The mandibles together with their feelers resemble tongs or tweezers.','Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours','Probably proteins in the excrement;','Tyrophagus putrescentiae; Vorratsmilbe','Acarus putrescentiae Schrank, Tyrophagus longior var. castellanii Hirst, Tyrophagus noxius Zachvatkin, Tyrophagus brauni Türk & Türk;','Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,5 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man auf der Rückseite einen Körpereinschnitt zwischen dem zweiten und dritten Beinpaar. Die Männchen besitzen stark ausgeprägte Tarsalsaugnäpfe, jedoch keine hakenförmigen Fortsätze am Schenkel des ersten Beinpaares; die Weibchen besitzen eine Kralle an jedem Fußende. Beide Geschlechter besitzen am Hinterende deutlich mehr als vier lange Schlepphaare. \nDie Körperfarbe ist weißlich-hell. Die Kiefer gleichen mitsamt ihren Tastern einer Greifzange oder Pinzette.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen','Wahrscheinlich Proteine im Kot;','Tyrophagus putrescentiae Schrank','Acaridae','Acari, Milben',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (96,9,'d 73','Glycyphagus domesticus, food mite','Acarus domesticus De Geer, Oudemansium domesticum Zachvatkin;','These food mites are tiny, eight-legged arachnids from 0.3 to 0.8 mm in length. Using just the eyes and with good lighting conditions, they can just barely be seen. Using strong magnification, one can notice that the body has no incision between the second and the third leg pairs. The males possess no suction pads; by the females, a short copulation pipe is visible. For both sexes, the body bristles are very long and feathery. A certain way of distinguishing with Lepidoglyphus destructor Schrank is the lack of a scale on the end limb of the legs. Nonetheless, the scale is hard to identify if it is not spread out but rather lies along the last leg limb.','Inhalation; the dried excrement eventually with time becomes dust and is raised into the air when the supplies are handled. Nutritive; in flours','Probably proteins in the excrement;','Glycyphagus domesticus, Vorratsmilbe','Acarus domesticus De Geer, Oudemansium domesticum Zachvatkin;','Diese Vorratsmilben sind winzige, achtbeinige Spinnentierchen von 0,3 bis 0,8 mm Größe. Mit bloßem Auge sind sie bei günstigen Lichtverhältnissen so gerade eben noch zu erkennen. \nBei stärkerer Vergrößerung erkennt man, dass der Körper keinen Einschnitt zwischen dem zweiten und dritten Beinpaar besitzt. Die Männchen besitzen keine Saugnäpfe; bei den Weibchen ist eine kurze Kopulationsröhre sichtbar. Bei beiden Geschlechtern sind die Körperborsten sehr lang und gefiedert. Ein sicheres Unterscheidungsmerkmal zu Lepidoglyphus destructor Schrank ist eine am Endglied der Beine nicht vorhandene Schuppe. Allerdings ist die Schuppe schwer zu erkennen, wenn sie nicht abgespreitzt sondern dem letzten Fußglied angelegt ist.','Inhalativ; der ausgetrocknete Kot zerfällt mit der Zeit zu Staub und wird so bei der Handhabung der Vorräte aufgewirbelt.\nNutritiv; in Mehlen','Wahrscheinlich Proteine im Kot;','Glycyphagus domesticus De Geer','Glycyphagidae',' Acari, Milben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (97,9,'i 1','Bee poison',null,'Approx. 15 - 20 mm in length multi-winged insects with yellow to brown markings and hairy body; strong incision between breast and abdomen; occur in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; queen, only flies out one or two times for mating, stinging, fertile;','Sting, by which 50 - 100 µg protein enters the body; while in the case of the wasp sting, the stinger only remains lodged in the victim a certain small percent of the time, for the bee it is always the case.','Proteins of large molecular weight in the animal’s poison;','Bienengift',null,'Ca. 15 - 20 mm lange vierflügelige Insekten mit gelblich bis bräunlich gezeichnetem und behaartem Körper; starker Einschnitt zwischen Brust und Hinterleib; Auftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, fliegt nur ein- bis zweimal zur Begattung aus, stechend, fruchtbar;','Stich, bei dem 50 - 100 µg Protein in den Körper gelangen; während beim Wespenstich der Stachel nur in einem gewissen Prozentsatz der Fälle stecken bleibt, ist dies bei der Biene immer der Fall.','Hochmolekulare Proteine im Gift der Tiere;','Apis mellifera L.','Apidae',' Hymenoptera, Hautflügler',null,3,10,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (98,9,'i 6','Kitchen cockroach, German','Roach;','Approx. 10 to 13 mm in length, in the shape of a long oval, dorsal-ventrally flattened insect with feelers of more than body length, biting-chewing mandibles and of a brown color; Head hidden under the large head shield; easily distinguishable from beetles by two short tail bristles;','Inhalation as house dust component or sometimes ingested in polluted foodstuffs;','Body proteins from dead and decomposed roaches as well as proteins in the excrement;','Küchenschabe, deutsche','Kakerlake;','Ca. 10 bis 13 mm langes, im Umriss länglich ovales, dorsoventral abgeplattetes Insekt mit mehr als körperlangen Fühlern, beißend-kauenden Mundwerkzeugen und von bräunlicher Farbe; Kopf unter dem großen Halsschild verborgen; von Käfern durch zwei kurze Schwanzborsten gut zu unterscheiden;','Inhalativ als Hausstaubbestandteil oder ggf. ingestiv durch verunreinigte Lebensmittel;','Körperproteine abgestorbener und zerfallener Tiere sowie Proteine im Kot;','Blatella germanica (L.)','Blatellidae','Blattodea, Schaben',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (99,9,'i 8','Bumble-bee',null,'16 - 35 mm in length, furry and seemingly plump, multi-winged insects with one or numerous colored cross markings on the breast and abdomen; Occurs in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; queen, flies only in the springtime until enough workers are available to her, stinging, fertile;','Sting; while for the honeybee sting, the stinger stays in the victim, for the bumble-bee this is never the case.','Proteins of large molecular weight in the animal’s poison;','Hummel',null,'16 - 35 mm lange, pelzig behaarte und etwas plump wirkende, vierflügelige Insekten mit einem bis mehreren farbigen Querstreifen auf Brust und Hinterleib; Auftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, fliegt nur im Frühjahr bis ihr genügend Arbeiterinnen zur Seite stehen aus, stechend, fruchtbar;','Stich; während beim Bienenstich der Stachel immer stecken bleibt, ist dies bei der Hummel nie der Fall.','Hochmolekulare Proteine im Gift der Tiere;','Bombus (Latreille) div. spec.','Apidae','Hymenoptera, Hautflügler',null,3,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (100,9,'i 9','Rice flour beetle','American rice flour beetle;','Approx. 3 to 4 mm in length, narrow, dark brown colored beetle with feelers barely 1 mm in length;','Inhalation as part of the house dust or possibly ingested in polluted foodstuffs;','Body and excrement proteins;','Reismehlkäfer','Amerikanischer Reismehlkäfer;','Ca. 3 bis 4 mm langer, schmaler, dunkelbraun gefärbter Käfer mit knapp 1 mm langen Fühlern;','Inhalativ als Hausstaubbestandteil oder ggf. ingestiv durch verunreinigte Lebensmittel;','Körper- und Kotproteine;','Tribolium confusum Jacquelin-Duval','Tenebrionidae','Coleoptera, Käfer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (101,9,'i 71','Mosquito','Schnake;','Delicate mosquito of approx. 8 mm body length; The head when viewed from the side in one line with thorax and abdomen; mouth parts transformed into a stinging proboscis; males with feathery feelers, blossom seekers; females blood sucking; larvae aquatic;','Sting as well as inhalation (from particles of deceased individuals);','The sting of the female injects anti-clotting as well as other human-like substances which can result in allergic reactions.','Mücke','Schnake;','Zarte Mücke von etwa 8 mm Körperlänge; Kopf von der Seite betrachtet in einer Linie mit Thorax und Abdomen; Mundteile zu einem Stechrüssel umgewandelt; Männchen mit gefiederten Fühlern, Blütenbesucher; Weibchen Blutsauger; Larven aquatisch;','Stich und auch Inhalation (von Partikeln abgestorbener Tiere);','Beim Stich der Weibchen injizieren diese gerinnungshemmende und andere körpereigene Stoffe, auf die allergische Reaktionen erfolgen können.','Culex pipiens L.','Culicidae','Diptera, Zweiflügler',null,3,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (102,9,'i 73','Red mosquito larva','Feather mosquitos, swarm mosquitos;','Very delicate mosquito of approx. 8 mm body length; from a side view with noticeably hunchbacked thorax, which covers the head when viewed from the top; mouth parts not formed to a stinging proboscis; feelers of the males strongly plumed; red, larvae up to 2 cm long and thin;','Inhalation;','Hemoglobin which is freed on the disintegration of deceased and dried out larvae, but also released  by chrysalis and imagines;','Rote Mückenlarve','Federmücken, Schwarmmücken;','Sehr zarte Mücke von etwa 8 mm Körperlänge; in Seitenansicht mit auffallend buckligem Thorax, der den Kopf von oben betrachtet verdeckt; Mundteile nicht zu einem Stechrüssel umgewandelt; Fühler der Männchen stark gefiedert; Larven rot, bis 2 cm lang und dünn;','Inhalativ;','Hämoglobine, die beim Zerfall abgestorbener und ausgetrockneter Larven, aber auch Puppen und Imagines frei werden;','Chironomus thummi','Chironomidae','Diptera, Zweiflügler',null,3,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (103,9,'i 76','Museum beetle',null,'Brown marbling and elongated oval beetle with a body length of 3 - 4 mm, in the case of danger it can fold its legs and feelers in the respective furrow and body indentations. Most commonly one confronts the beetle as a larvae or chrysalis of approx. 5 mm in length.','Inhalation and contact;','Body and excrement proteins of the individuals as well as the chemicals of the arrow hairs','Museumskäfer',null,'Bräunlich marmorierter und länglich-ovaler Käfer mit einer Körperlänge von 3 - 4 mm, der bei Gefahr seine Beine und Fühler in entsprechende Rinnen und Körpervertiefungen versenken kann. Meist trifft man den Käfer als etwa 5 mm lange Larve oder Puppe an.','Inhalation und Berührung;','Körper- und Kotproteine der Tiere sowie die Chemikalien der Pfeilhaare','Trogoderma angustum','Dermestidae','Coleoptera, Käfer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (104,9,'i 75','Hornet poison',null,'Approx. 19 - 35 mm in length, multi-winged insects with contrasting black and yellow markings on the abdomen, red-brown colored head region and breast section and hairless body; between breast and abdomen there is the so-called wasp waist; Occur in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; queen, free flying only when establishing the nest, stinging, fertile;','Sting, for the approx. 100 µg protein can enter the body; while in the case of the bee the stinger always sticks in the victim and this is sometimes the case for the wasp, this never takes place for the hornet sting.','Proteins of large molecular weight in the animal’s poison;','Hornissengift',null,'Ca. 19 - 35 mm lange, vierflügelige Insekten mit kontrastreich schwarz-gelb gezeichnetem Hinterleib, rötlich-bräunlich gefärbtem Hinterkopfbereich und Brustabschnitt und unbehaartem Körper; zwischen Brust und Hinterleib befindet sich die sogenannte Wespentaille;\nAuftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; Königin, freifliegend nur bis zur Nestgründung, stechend, fruchtbar;','Stich, bei dem ca. 100 µg protein in den Körper gelangen; während bei der Biene der Stachel immer stecken bleibt und dies bei der Wespe manchmal der Fall ist, kommt dies beim Hornissenstich nicht vor.','Hochmolekulare Proteine im Gift der Tiere;','Vespa crabro L.','Vespidae','Hymenoptera, Hautflügler',null,4,10,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (105,9,'i 201','Horse fly','Stomach assel;','brown colored fly of 12 - 15 mm length and sharply tapered abdomen;',null,'Body and excrement proteins of the larvae','Pferdefliege','Magendassel;','Bräunlich gefärbte Fliege von 12 - 15 mm Länge und spitz zulaufendem Hinterleib;',null,'Körper- und Kotproteine der Larven','Gasterophilus intestinalis','Gasterophilidae','Diptera, Zweiflügler',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (106,9,'i 202','Grain beetle, weevil','Calandra granaria L.;','Dark brown, long oval beetle with a 2,3 - 3,5 mm body length and a snout-like extended head and stunted flight wings. The neck shield is relatively large and hardly shorter than the abdomen. The wing covers and the neck shield are deep and densely dotted.','Ingestion with contaminated flour products; sometimes also through the inhaling of dust in mills and storage places;','Body and excrement proteins of the beetle; secondary consideration is also fungus proteins, since in attacked substrates it can easily lead to a fungus attack.','Kornkäfer, Rüsselkäfer','Calandra granaria L.; \nKrebsel, Klander, Kornreuter;','Dunkelbrauner, länglich-ovaler Käfer von 2,3 - 3,5 mm Körperlänge und einem rüsselartig ausgezogenen Kopf und verkümmerten Flugflügeln. Der Halsschid ist relativ groß und kaum kürzer als der Hinterleib. Die Flügeldecken und der Halsschild sind tief und dicht punktiert.','Ingestiv mit verunreinigten Mehlprodukten; ggf. auch inhalativ durch Stäube in Mühlen und Speichern;','Körper- und Kotproteine der Käfer; Sekundär kommen auch Pilzproteine in Frage, da es in befallenen Substraten leicht zu Pilzbefall kommt.','Sitophilus granarius','Curculionidae','Coleoptera, Käfer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (107,9,'i 203','Flour moth',null,'Small nondescript butterfly of 10 - 12 mm body length and 20 - 22 mm wingspan. The basic color of the front wings is of blue-gray or red-gray tone; th latter are unclearly zigzag-shaped cross bands.','Ingestion by polluted foodstuffs;','Probably excrement proteins of the caterpillar;','Mehlmotte',null,'Kleiner unscheinbarer Schmetterling von 10 - 12 mm Körperlänge und 20 - 22 mm Flügelspannweite. Die Grundfarbe der Vorderflügel ist von blaugrauem oder rötlich grauem Ton; letztere sind undeutlich zickzackförmig quergebändert.','Ingestiv durch verunreinigte Lebensmittel;','Wahrscheinlich Kotproteine der Raupe;','Ephestia keuhniella Zeller','Pyralidae','Lepidoptera, Schmetterlinge',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (108,9,'i 901','Pigeon tick',null,'Coarse skinned, in fully bloated state - for females - up to 9 mm in length, red-brown, shield-like tick with mandibles on the bottom side which cannot be seen from the top; eight legged, since it belongs to the arachnids;','Sting;','The sting of the female injects anti-clotting as well as other human-like substances which can result in allergic reactions.','Taubenzecke',null,'Derbhäutige, in vollgesogenem Zustand - nur Weibchen - bis 9 mm große, rötlich-braune, schildförmige Zecke mit von oben unsichtbaren, auf der Bauchseite liegenden Mundwerkzeugen; achtbeinig, da zu den Spinnentieren gehörig;','Stich;','Beim Stich der Weibchen injizieren diese gerinnungshemmende und andere körpereigene Stoffe, auf die allergische Reaktionen erfolgen können.','Argas reflexus F.','Argasidae',' Acari, Milben',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (109,9,'i 902','Cloths moth',null,'Inconspicuous, totally gray-brown small butterfly with 10 - 16 mm wingspan; body brown; feelers relatively long and then; sucking beak only slightly developed;','Inhalation as house dust component;','Body and excrement proteins of the caterpillar and butterfly;','Kleidermotte',null,'Unauffälliger, einheitlich graubrauner Kleinschmetterling mit 10 - 16 mm Flügelspannweite; Körper braun; Fühler relativ lang und dünn; Saugrüssel nur schwach entwickelt;','Inhalativ als Hausstaubbestandteil;','Körper- und Kotproteine von Raupe und Schmetterling;','Tineola bisselliella Hummel','Tineidae','Lepidoptera, Schmetterlinge',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (110,9,'i 904','Polistes','Paper wasp, yellow jackets; only in American usage','Approx. 12 -18 mm in length, multi-winged insects with a generally black head and breast region and a yellow-black abdomen; strong incision between breast and abdomen; conspicuous during the flight are the long down-hanging rear legs; Occurs in three casts: workers, free flying, stinging, unfertile; males, free flying, non stinging, fertile; one or a number of queens pro population; they fly in numbers only during the period of nest building, stinging, fertile;','Sting; in the case of the honey bee the stinger always stays and for German and common wasp it sometimes stays in the victim, for the polistes this never is the case.','Proteins of large molecular weight in the animal’s poison;','Feldwespe','Papierwespe (Paperwasp), nur im bzw. durch den amerikanischen Sprachgebrauch;','Ca. 12 -18 mm lange, vierflügelige Insekten mit weitestgehend schwarzem Kopf- und Brustbereich und gelbschwarzem Hinterleib; starker Einschnitt zwischen Brust und Hinterleib; auffällig sind die während des Fluges lang herabhängenden Hinterbeine; Auftreten in drei Kasten: Arbeiterinnen, freifliegend, stechend, unfruchtbar; Männchen, freifliegend, nicht stechend, fruchtbar; eine bis mehrere Königinnen pro Volk; diese fliegen vermehrt nur während der Zeit des Nestbaus, stechend, fruchtbar;','Stich; während bei der Biene der Stachel immer und bei Deutscher und Gewöhnlicher Wespe manchmal stecken bleibt, ist dies beim Stich der Feldwespe nie der Fall.','Hochmolekulare Proteine im Gift der Tiere;','Polistes Latreille spec.','Vespidae','Hymenoptera, Hautflügler',null,4,10,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (111,3,'e 1 (Epithelien)','Cat, domestic',null,'The domestic cat is approx. 40 - 50 cm long and 25 cm tall at the shoulder; the tail measures 20 - 30 cm. The coloring is similar to the Lybian wildcat (Felis silvestris libyca), the basic form of the domestic cat, light gray with dark gray to black spots and stripes; aside from this coloring, however, there are also black, white and reddish marked animals with all conceivable transitions between the colors and markings. In addition, selective breeding has led to the emergence of very special breeds. Especially well known are the long-haired gray Angoras and the short-haired Siamese cats with their prominent dark markings.','Inhalative;','Allergy-triggering proteins could be detected in the skin, hair, saliva, serum and in the urine; therefore fundamentally it is possible to test for specific antibodies against serum, urine, and skin scale (on demand) or skin and hair proteins inclusive saliva proteins (e1).','Katze, Haus-',null,'Die Hauskatze ist ca. 40 - 50 cm lang und an der Schulter 25 cm hoch; der Schwanz misst 20 - 30 cm. Die Färbung ist in Anlehnung an die Falbkatze (Felis silvestris libyca), die Stammform der Hauskatze, hellgrau mit dunkelgrauen bis schwarzen Flecken und Streifen; daneben kommen jedoch auch schwarz, weiß und rötlich gezeichnete Tiere mit allen denkbaren Übergängen vor. Zusätzlich haben gezielte Züchtungen zur Herausbildung spezieller Rassen geführt. Bekannt sind vor allem die langhaarigen, grauen Angorakatzen und die kurzhaarigen, dunkel gezeichneten Siamkatzen.','Inhalativ;','Allergieauslösende Proteine konnten in der Haut, in den Haaren, im Speichel, im Serum und im Urin nachgewiesen werden;\nGrundsätzlich wird daher die Möglichkeit geboten, auf spezifische Antikörper gegen Serum-, Urin-, Hautschuppenproteine (jeweils auf Anfrage) oder Haut- und Haarproteine inklusive Speichelproteine (e 1) zu testen.','Felis domestica','Felidae','Carnivora, Reißtiere',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (112,3,'e 2 (Epithelien), e 5 (Schuppen)','Dog, domestic',null,'Mankind has domesticated the wolf (Canis lupus L.) ever since the remote Stone Age approx. 12 000 years ago. Extremely diverse breeds of dogs have developed since those ancient times, allowing for no one uniform description of the animal. The spectrum ranges from the size of a rabbit (Chihuahua) to that of a young foal (Great Dane), from almost hairless (Mexican hairless) to extremely long and thick fur (Puli), from long-legged (Greyhound) to very short-legged (Dachshund), from narrow, elongated head forms (Borsoi) to  flat-nosed head forms (Boxer), and from an extremely slender body shape (Italian whippet) to a heavily massive form (Bulldog).','Inhalative;','Allergy-triggering proteins can be detected in the skin, in the hair, in saliva, in serum and in the urine; basically it is therefore possible to test for specific antibodies against serum, urine, (each case on request) skin scale proteins (e 5) or skin and hair proteins inclusive saliva proteins (e 2).','Hund, Haus-',null,'Seit der jüngeren Altsteinzeit, vor ca. 12 000 Jahren, hat der Mensch den Wolf (Canis lupus L.) zum Hund domestiziert; dabei sind durch den langen Zeitraum so verschiedengestaltige Rassen entstanden, dass keine einheitliche Beschreibung möglich erscheint. Das Spektrum reicht von der Größe eines Kaninchens (Chihuahua) bis zu der eines Fohlens (Dogge), von fast völlig unbehaart (Nackthund) bis extrem lang und dicht behaart (Puli), von hochbeinig (Windhund) bis sehr kurzbeinig (Dackel), von schmalen und lang gestreckten Kopfformen (Borsoi) bis zu plattschnauzigen Kopfformen (Boxer) und von sehr schlanker Körpergestalt (Italienisches Windspiel) bis zu sehr massiger Gestalt (Bulldogge).','Inhalativ;','Allergieauslösende Proteine konnten in der Haut, in den Haaren, im Speichel, im Serum und im Urin nachgewiesen werden;\nGrundsätzlich wird daher die Möglichkeit geboten, auf spezifische Antikörper gegen Serum-, Urin-, (jeweils auf Anfrage) Hautschuppenproteine (e 5) oder Haut- und Haarproteine inklusive Speichelproteine  (e 2) zu testen.','Canis familiaris L.','Canidae','Carnivora, Reißtiere',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (113,3,'e 3 (Epithelien), e 205 (Serum), vgl. f 59','Horse',null,'The domestic horse, often also simply designated Equus caballus L., is descended from the Eurasian wild horse (Equus przewalskii Poljakov), which was originally widespread in several species from East Asia to Western Europe. The domestication process began approx. 6,000 years ago. A great many different breeds have developed since that time, so that no one uniform description is possible. A basic distinction is made between the very powerful and heavy, quiet "Kaltblut" horses comprising the main breeds of Belgium, Norik and Schleswig; the especially noble thoroughbreds primarily used as racing horses, with the main breeds Arabian thoroughbred and English thoroughbred; the robust and good-natured ponies (up to 148 cm at the shoulder) with the breeds Shetland, Skiro, Exmoore, Island and Welsh-Mountain, and the half-breeds, diverse breeds and types which cannot be distinctly assigned to any of the previous categories. Horses are described according to color: chestnuts with reddish-brown coat and the same color mane and tail, bays with black mane and tail, whites, grays, blacks and dappled. Horses are long-legged, fast-running (up to 90 km/h) ungulate (hooved) mammals who feed on green forage; all their toes have receded with the exception of the middle toe, which is extended to form a hoof (the toenail; ungulates walk "on tiptoe"). Only a tiny remnant of the second and fourth toe remain (pastern). Another characteristic is the set of typical herbivore teeth with high-crowned molars (grinders) and hard enamel folds in the chewing surface. The canine teeth are stunted in stallions and lacking altogether in mares.','Inhalative or ingestive;','The allergy-triggering proteins have been able to be detected in the skin, dander and in the hair; horse serum also apparently contains related patient.allergens; horsemeat and mare''s milk likewise are responsible for specific proteins.','Pferd',null,'Das Hauspferd, oft auch nur als Equus caballus L. bezeichnet, stammt vom Eurasischen Wildpferd (Equus przewalskii Poljakov) ab, welches ursprünglich in mehreren Rassen von Ostasien bis nach Westeuropa verbreitet war. Der Domestikationsprozess hatte vor ca. 6 000 Jahren begonnen.\nSeit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass keine einheitliche Beschreibung möglich ist. Man teilt ein in die sehr kräftigen und schweren und ruhigen Kaltblüter mit den Hauptrassen Belgier, Noriker und Schleswiger; in die besonders edlen, vor allem als Rennpferde eingesetzten Vollblüter mit den Hauptrassen Arabisches Vollblut und Englisches Vollblut; in die bis 148 cm Schulterhöhe großen, robusten und gutartigen Ponys mit den Rassen Shetland, Skiro, Exmoore, Island und Welsh-Mountain und in die Halbblutrassen, unterschiedliche Pferderassen und -schläge, die nicht eindeutig einer der vorangegangenen Gruppen zugeordnet werden können. Nach der Farbe teilt man ein in Füchse mit rotbraunem Haar und gleichfarbiger Mähne und Schweif, in Braune dagegen mit schwarzer Mähne und Schweif, in Schimmel, Rappen und Schecken. \nPferde sind hochbeinige, schnelllaufende (bis 90 km/h), Grünfutter fressende Säugetiere, bei denen alle Zehen mit Ausnahme der stark verlängerten und in einem Huf (Zehennagel; Zehenspitzengänger) endenden Mittelzehe, zurückgebildet sind. Von der zweiten und vierten Zehe sind nur winzige Reste (Griffelbeine) erhalten geblieben. Ein weiteres Kennzeichen ist das typische Pflanzenfressergebiss mit hochkronigen Backenzähnen und harten Schmelzfalten auf der Kaufläche. Die Eckzähne sind bei den Hengsten verkümmert und fehlen bei den Stuten ganz.','Inhalativ bzw. ingestiv;','Die allergieauslösenden Proteine konnten in der Haut, in den Hautschuppen und in den Haaren nachgewiesen werden; auch das Pferdeserum beinhaltet offensichtlich damit verwandte Allergene; im Pferdefleisch und in der Stutenmilch sind ebenfalls spezifische Proteine verantwortlich.','Equus przewalskii f. caballus L.','Equidae','Perissodactyla, Unpaarhufer',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (114,3,'e 4 (Epithelien), vgl. f 27  u. Milchprodukte','Cattle',null,'Bovine cattle, often also designated only as Bos taurus L., is descended from the original Aurochs (Bos primigenius Bojanus), which became extinct over 300 years ago. The domestication process for this most important animal for humans began over 8,000 years ago. Since that time many diverse breeds have developed, so that a uniform description has to be kept relatively general. The torso of  bovine cattle is massive, especially the stomach of a well-fed animal is noticeably rounded, increasing its plump appearance. An adult cow weighs 500 to 700 kg, strong bulls attain over 1,000 kg. In the case of the bull, its stocky neck and head and the two horns on its broad forehead are especially striking. In both sexes the horns consist of unbranched sheaths of the frontal bone cone. The horns are not shed. The horns can have very different shapes and in some breeds also take on enormous proportions. The legs are relatively short and powerful and emphasize the overall stocky impression. A fold of skin called the dewlap runs from the neck down to the front legs. Cattle can reach a height of 150 to 160 cm measured at the withers.The long tail ends in a tassle of hair which serves as an effective flyswatter. The skin is relatively thick, but soft and elastic, covered with a thick coat of soft hair. Bovine cattle are cloven-hoof ungulates with two developed toes and two stunted so-called spurious toes. The main breeds of middle Europe are divided into the highland cattle with white patches, largely colored reddish-brown and in the lowland cattle which generally occur in black-white variations.','Inhalative, epicutan or ingestive;','With regard to epithelia the allergy-triggering proteins have been able to be detected in the skin, in the dander and in the hairs; also the meat, milk and related milk products contain specific proteins which could trigger allergies.','Rind',null,'Das Hausrind, oft auch nur als Bos taurus L. bezeichnet, stammt vom Ur oder Auerochsen (Bos primigenius Bojanus) ab, der vor über 300 Jahren ausgestorben ist. Der Domestikationsprozess für dieses wichtigste Haustier des Menschen setzte vor über 8 000 Jahren ein. Seit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass eine einheitliche Beschreibung relativ allgemein gehalten werden muss.\nDer Körper des Rindes ist massig, besonders der Bauch ist bei einem gesättigten Tier seitlich stark aufgetrieben, was das plumpe Aussehen verstärkt. Eine ausgewachsene Kuh wiegt 500 bis 700 kg, starke Stiere erreichen über 1 000 kg. Bei ihnen fallen besonders der gedrungene Hals und Kopf auf, welcher an der breiten Stirn zwei Hörner trägt. Diese bestehen bei beiden Geschlechtern aus unverzweigten Uberzügen des Stirnbeinzapfens. Die Hörner werden nicht abgeworfen. Die Hörner können sehr verschieden geformt sein und bei manchen Rassen gewaltige Ausmaße annehmen. Die Beine sind relativ kurz und kräftig und unterstreichen den gedrungenen Gesamteindruck. Vom Hals zu den Vorderbeinen verläuft eine Hautfalte, die Wamme. Am Widerrist erreicht das Rind eine Höhe von 150 bis 160 cm.Der lange Schwanz endigt in einer Haarquaste und dient als wirksamer Fliegenwedel. Die Haut ist verhältnismäßig dick, aber weich und dehnbar und ganz von weichen, dichten Haaren bedeckt. \nDas Rind ist ein Zehenspitzengänger mit zwei ausgebildeten Zehen und zwei verkümmerten sogenannten Afterzehen. Die Hauptrassen Mitteleuropas werden gegliedert in Höhenfleckvieh mit überwiegend rot-bräunlicher Färbung und in Niederungs- oder Tieflandvieh, welches hauptsächlich in Schwarz-Weiß-Varianten auftritt.','Inhalativ, epicutan bzw. ingestiv;','Bezüglich der Epithelien konnten die allergieauslösenden Proteine in der Haut, in den Hautschuppen und in den Haaren nachgewiesen werden; auch im Fleisch, in der Milch und in den aus ihr gewonnenen Produkten befinden sich spezifische Eiweiße, die Allergien auslösen können.','Bos primigenius f. taurus L.','Bovidae','Artiodactyla, Paarhufer',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (115,3,'e 6 (Epithelien);','Guinea pig',null,'The Guinea pig, often designated just Cavia porcellus, is a relatively compact-looking rodent about 18 - 25 cm long, with short legs, small ears and the tiny residue of a tail. It is descended from the Peruvian Guinea pig, Cavia aperea. The fur can vary extremely in structure and color. It is either uniformly colored or mottled. The colors include white, black, gray, rust-brown and yellowish. The animals are very tame and are therefore easily kept as a live children''s toy, but also as experimental animal in labs. The advanced ancient civilizations in South America kept Guinea pigs as sacrificial animal due to their tasty meat.','Inhalative;','Epithel and urine;','Meerschweinchen',null,'Das Meerschweinchen, oft auch nur als Cavia porcellus bezeichnet, ist ein relativ kompakt wirkendes Nagetier von 18 - 25 cm Länge mit kurzen Beinen, kleinen Ohren und dem winzigen Rest eines Schwanzes. Es stammt vom peruanischen Meerschweinchen, Cavia aperea, ab. Das Fell kann in Struktur und Farbe außerordentlich stark variieren. Es ist entweder einheitlich gefärbt oder gefleckt. Als Farben kommen vor: weiß, schwarz, grau, rostbraun und gelblich. Die Tiere sind sehr zahm und werden daher gerne als lebendiges Kinderspielzeug aber auch als Versuchstiere gehalten. In den südamerikanischen Hochkulturen wurden bereits Meerschweinchen wegen ihres wohlschmeckenden Fleisches und als Opfertiere gehalten.','Inhalativ;','Epithel und Urin;','Cavia aperea f. porcellus','Caviidae','Rodentia, Nagetiere',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (116,3,'e 9 (Federn)','Canary (Serinus canarius)',null,'About 12 cm long, in its wild form a greenish bird with short, sharp and powerful beak. Its domestication began after the Spanish conquest of the Canary Islands at the end of the 15th century. The practice of keeping canaries spread further over Italy and Austria, and bird strains of numerous color variations as well as extraordinary singers developed. The main breed froms include the Harzer Roller (plain yellow; especially good singer), the orange Red Canary (Serinus canarius) and the crested canary with its particular head plumage).','Inhalation;','Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens','Kanarienvogel',null,'Etwa 12 cm langer, in der Wildform grünlicher Vogel mit kurzem, spitzem und kräftigem Schnabel. Die Domestikation setzte nach der spanischen Eroberung der Kanarischen Inseln am Ende des 15. Jahrhunderts ein. Über Italien und Österreich breitete sich die Haltung weiter aus und es entstanden sowohl zahlreiche Farbvarianten als auch hervorragende Sänger. Die Hauptzuchtformen sind der Harzer Roller (einfarbig gelb; besonders gute Sänger), der Rote Kanarienvogel (orangefarbig) und der Haubenkanarienvogel (mit besonderer Kopfbefiederung).','Inhalation;','Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert.','Serinus canaria L.','Fringillidae','Passeriformes, Sperlingsvögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (117,3,'e 10 (Federn)','Parrot, African gray (Psittacus erithacus)',null,'Approx. 40 cm long bird with gray body plumage, conspicuous short, red tail and whitish-gray, bare area around the eyes. The very powerful beak is black and is curved. The foot has two toes pointed forwards and two pointed backwards, which act as climbing or climbing/grasping claw.','Inhalation;','Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens.','Papagei, Grau-',null,'Ca. 40 cm langer Vogel mit grauem Körpergefieder, auffallend kurzem, rotem Schwanz und weißlich-gauer, nackter Augenumgebung. Der sehr kräftige Schnabel ist schwarz und nach Papageienart gekrümmt. Der Fuß ist mit zwei nach vorne und zwei nach hinten gerichten Zehen als Kletter- oder Greiffuß ausgebildet.','Inhalation;','Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allergene diskutiert.','Psittacus erithacus L.','Psittacidae','Psittaciformes, Papageienartige',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (118,3,'e 7 (Taubenkot), e 11 (Taubenfedern)','Dove, pigeon',null,null,null,null,'Taube',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (119,3,'e 50 (Federn)','Finch, domestic',null,null,null,null,'Zierfinken',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (120,3,'e 70 (Federn), e 96 (Daunen), vgl. f 58 (Fleisch)','Goose, domestic',null,'The domestic goose is descended from the gray goose (Anser anser (L.)). As a rule it is pure white, approx. 70 to 90 cm long and weighs 3 to 5 kg. The head tops a long thickish neck. The tip of the upper beak is formed as a powerful downward-turning nail, designed for better pulling out and plucking up grasses, leaves, and stems. When folded, the wings stretch to the tip of the short tail. The feet are large and powerful; the front toes are webbed. While flying, a goose extends its head and neck out forwards. As a flock geese fly in v-form.','Inhalative or ingestive;','Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens. Likewise, specific proteins in the meat and in the eggs could trigger allergic reactions.','Gans, Haus-',null,'Die Hausgans stammt von der Graugans, (Anser anser (L.)), ab. Sie ist in der Regel rein weiß, ca. 70 bis 90 cm lang und drei bis 5 kg schwer. Der Kopf sitzt auf einem langen dicklichen Hals. Die Oberschnabelspitze ist als kräftiger, nach unten gebogener Nagel gestaltet, der zum besseren Abrupfen und -zupfen von Gräsern, Blättern und Halmen dient. Die Flügel reichen zusammengelegt bis zur Spitze des kurzen Schwanzes. Die Füße sind groß und kräftig; die Vorderzehen sind durch Schwimmhäute miteinander verbunden. Im Flug werden Kopf und Hals vorgestreckt. Im Verband fliegen Gänse in Keilform.','Inhalativ bzw. ingestiv;','Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert. Ebenso können im Fleisch und in den Eiern spezifische Proteine allergische Reaktionen auslösen.','Anser anser f. domestica (L.)','Anseridae','Anseriformes, Gänse- u. Entenartige Vögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (121,3,'e 86 (Federn), e 95 (Daunen), vgl. f 57 (Fleisch)','Duck, domestic',null,'The domestic duck is descended from the mallard duck (Anas platyrhynchos (L.)). It is pure white or also black-and-white, approx. 60 cm long and weighs 1-2 kg depending on the breed. The head tops a long neck, which is however shorter than the neck of a goose. The relatively short legs emerge far behind the middle of the body and clearly qualify the duck more for swimming than walking (waddle stride). The feet are large and powerful; the front toes are webbed. While flying, the duck extends its head and neck out forwards. As a flock ducks fly in a row or in pairs, with the female out in front. However domestic ducks are often unable to fly at all due to their excessive weight.','Inhalative or ingestive;','Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens. Likewise, specific proteins in the meat and in the eggs could trigger allergic reactions.','Ente, Haus-',null,'Die Hausente stammt von der Stockente (Anas platyrhynchos (L.)), ab. Sie ist rein weiß oder auch schwarz-weiß, ca. 60 cm lang und je nach Zuchtform ein bis zwei kg schwer. Der Kopf sitzt auf einem langen Hals, der allerdings kürzer ist als bei der Gans. Die relativ kurzen Beine inserieren weit hinter der Körpermitte und befähigen die Ente eindeutig mehr zum Schwimmen als zum laufen (Watschelgang). Die Füße sind groß und kräftig; die Vorderzehen sind durch Schwimmhäute miteinander verbunden. Im Flug werden Kopf und Hals vorgestreckt. Im Verband fliegen Enten in einer Reihe oder paarweise mit dem Weibchen voran. Allerdings sind die Hausenten auf Grund ihres hohen Gewichtes oft flugunfähig.','Inhalativ bzw. ingestiv;','Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert. Ebenso können im Fleisch und in den Eiern spezifische Proteine allergische Reaktionen auslösen.','Anas platyrhynchos f. domestica (L.)','Anatidae','Anseriformes, Gänse- und Entenartige Vögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (122,3,'e 85 (Federn), vgl. f 83, f1,67,68,74,75','Hen, domestic',null,'The domestic hen is descended from the Indian Bankiva hen (Gallus gallus f. bankiva Temm.). Approximately 150 breeds developed in the course of domestication, which do not permit any uniform description. Fundamentally the hen has a stocky, massive torso, and its elongated neck carries a relatively small head. The two powerful, as a rule unfeathered running legs each have a foot with three toes pointing outwards and one pointing backwards. The cock (rooster) has a sharp, powerful spur positioned above the back toe. The cocks are also larger than the hens, have a large comb as well as a big wattle and their plumage is more colorful. The cockle-doodle-doo call of the rooster is well-known everywhere; the hens only cackle or cluck. A distinction is made between five different types of strains: 1. Laying strains which produce over 300 eggs per hen a year (Rebhuhnfarbige Italiener, Weisses Leghuhn); 2. Dual strains for the production of both eggs and meat (Deutsche Sperber, Andalusier); 3. Meat strains which yield up to to 6 kg in weight (Brahma, Deutsche Langschan); 4. Ornamental hens for collectors (dwarf hens, crestnhuhn (crested hen?), Barthuhn (bearded hen?) and Nackthalshen (hairless neck hen?), Phoenix; 5. Fighting hens for cockfighting;','Inhalative or Ingestiv;','Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens. Likewise, specific proteins in the meat and in the eggs could trigger allergic reactions. Such components of the egg are the ovalbumin (f 67) and the ovomucoid (f68).','Huhn, Haus-',null,'Das Haushuhn stammt vom indischen Bankivahuhn (Gallus gallus f. bankiva Temm.) ab. Durch die Domestikation sind etwa 150 Rassen entstanden, die keine einheitliche Beschreibung erlauben. Grundsätzlich hat das Huhn einen gedrungenen, massigen Rumpf und der gestreckte Hals trägt einen verhältnismäßig kleinen Kopf. Die kräftigen, in der Regel unbefiederten Laufbeine tragen einen Fuß mit drei nach vorne und einer nach hinten gerichteten Zehe. Über der Hinterzehe besitzen die Hähne einen spitzen, kräftigen Sporn. Ferner sind sie größer als die Hennen, tragen einen großen Kamm sowie große Kehllappen und ihr Gefieder ist farbenprächtiger. Allseits bekannt ist der Kikeriki-ruf der Hähne; die Hennen gackern oder glucken nur. Man unterscheidet fünf Zuchtrichtungen:\n1. Legerassen mit über 300 Eiern pro Huhn im Jahr (Rebhuhnfarbige Italiener, Weißes Leghuhn);\n2. Zwierassen zur Eier und Fleischnutzung (Deutsche Sperber, Andalusier);\n3. Fleischrassen mit bis zu 6 kg Gewicht (Brahma, Deutsch Langschan);\n4. Zierhühner für Liebhaberzwecke (Zwerghühner, Hauben-, Bart- und Nackthalshühner, Phoenixhühner);\n5. Kampfhühner für Hahnenkämpfe;','Inhalativ bzw. Ingestiv;','Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert. Ebenso können im Fleisch und in den Eiern spezifische Proteine allergische Reaktionen auslösen. Solche Eibestandteile sind das Ovalbumin (f 67) und das Ovomucoid (f68).','Gallus gallus f. gallus L.','Phasianidae','Galliformes, Hühner',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (123,3,'e 71, e 88 (Epithelien), e 72 (Urin), e 76 (Serum)','Mouse, domestic',null,'Rodent with a body length of 70 to 110 mm and a tail of 60 to 105 mm. The ears are 11 -15 mm long and the body weight is 12 to 30 g. An unambiguous recognition characteristic is a notch on the back edge of the upper incisors. The Eastern sub-family M. m. musculus L., cereal mouse, is grayish-brown on the upper side and has a distinctly lighter underside. The western form M. m. domesticus Rutty is gray on top and underneath only a slightly bit lighter. There is no absolutely clear demarcation between the two. The domestic mouse is also the basic form of the laboratory mouse, which is bred as cream-colored and albino.','Epicutan and inhalative;','dander, hair and proteins in the urine and in serum','Maus, Haus-',null,'Nagetier mit einer Körperlänge von 70 bis 110 mm und einem 60 bis 105 mm langen Schwanz. Die Ohren sind 11 -15 mm lang und das Körpergewicht beträgt 12 bis 30 g. Ein eindeutiges Erkennungsmerkmal ist eine Einkerbung am Hinterrand der oberen Schneidezähne. Die östliche Unterart M. m. musculus L., Ährenmaus, ist oberseits graubraun und besitzt eine deutlich heller abgesetzte Unterseite. Die westliche Form, M. m. domesticus Rutty ist oben grau und unterseits nur wenig heller. Es existiert keine deutliche Trennungslinie. Die Hausmaus ist auch die Stammform der Labormaus, welche in cremefarbener Form und in Albinoform gezüchtet wird.','Epicutan und inhalativ;','Hautschuppen, Haare und Proteine im Urin und im Serum','Mus musculus L.','Muridae','Rodentia, Nagetiere',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (124,3,'e 73, e 87 (Epithelien), e 74 (Urin), e 90 (Kot)','Rat, laboratory (Norway rat)',null,'Light to dark gray, sometimes also brownish or almost black rodent with a body length of 18 to 28 cm and a 13 - 23 cm long tail. The ears are 18 - 23 mm long and the body weight between 200 to 500 g. The Norway rat (also known as brown rat or sewer rat) is also the basic form of the laboratory rat which is usually bred in its albino form.','Epicutan and inhalative;','dander, hair and proteins in the urine, in the feces and in serum','Ratte, Labor-',null,'Hell- bis dunkelgraues, bisweilen auch bräunliches oder fast schwarzes Nagetier mit einer Körperlänge von 18 bis 28 cm und einem 13 bis 23 cm langen Schwanz. Die Ohren sind 18 - 23 mm lang und das Körpergewicht beträgt 200 bis 500 g. Die Wanderratte ist auch die Stammform der Laborratte, welche meist in der Albinoform gezüchtet wird.','Epicutan und inhalativ;','Hautschuppen, Haare und Proteine im Urin, im Kot und im Serum','Rattus norvegicus (Berkenhout)','Muridae','Rodentia, Nagetiere',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (125,3,'e 81(Epithelien), vgl. f 88 (Lammfleisch)','Sheep, domestic',null,'The domestic sheep, often also only designated as Ovis aries L., is descended from the mouflon (Ovis ammon L.), which still occurs in the wild in the Mediterranean area. The domestication process for this important domestic animal began over 8,000 years ago. Since that time selective breeding has produced specific breeds for meat, milk, wool and fat extraction. Depending on the breed, sheep attain a body length of 110 to 200 cm and a shoulder height of 60 to 125 cm. The tail is only 5 to 10 cm long. In some breeds the male sheep have a strongly curved set of horns. Aside from the feet and ears, a sheep''s entire body is covered with thick wooly fur, which in the case of wool sheep is shorn each year in April/May. The sheep is a cloven-hoof ungulate with two developed toes.','Inhalative, epicutan or ingestive;','dander and hair. Specific proteins which can trigger allergies are also found in the meat, milk and related products.','Schaf, Haus-',null,'Das Hausschaf, oft auch nur als Ovis aries L. bezeichnet, stammt vom Mufflon (Ovis ammon L.) ab, welches im Mittelmeerraum stellenweise noch wild vorkommt. Der Domestikationsprozess für dieses wichtige Haustier setzte vor über 8 000 Jahren ein. Seit dieser Zeit sind mehrere Rassen zur Fleisch-, Milch-, Woll- und Fettgewinnung gezüchtet worden.\nDas Schaf erreicht je nach Rasse eine Körperlänge von 110 bis 200 cm und eine Schulterhöhe von 60 bis 125 cm. Der Schwanz ist nur 5 bis 10 cm lang. Bei manchen Rassen tragen die männlichen Schafe ein stark gewundenes Gehörn. Außer den Füßen und den Ohren ist der ganze Körper von einem dichten Fell bedeckt, das bei den Wollschafen im April/Mai geschoren wird. Das Schaf ist ein Zehenspitzengänger mit zwei ausgebildeten Zehen.','Inhalativ, epicutan bzw. ingestiv;','Hautschuppen und Haare. Auch im Fleisch, in der Milch und in den aus ihr gewonnenen Produkten befinden sich spezifische Eiweiße, die Allergien auslösen können.','Ovis ammon f. aries L.','Bovidae','Artiodactyla, Paarhufer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (126,3,'e 82 (Epithelien), e 211 (Urin), vgl. f 213','Rabbit',null,'The domestic rabbit (often erroneously called hare or hutch hare) has been bred from the wild rabbit since the early Middle Ages. A great diversity of breeds has developed since that time; hence the further description refers to the wild rabbit. This gets to be 40 to 50 cm long and weighs from 1.5 to 2.5 kg, with a yellowish-brown coat. Due to an increase in wooly hairs, the winter coat appears more gray in color. The wild rabbit has a short white stumpy tail and long ears about 8 cm in length. Its typical posture is sitting, with a curved back. The 5 toes of the front paws and 4 toes of the back paws have powerful claws. The teeth differ from rodents teeth in that there are so-called crown teeth located behind the upper incisors. The domestic breeds are in some ways far removed from this original form. A few examples are in particular the Belgische Riesen ("Belgian Giant"), Deutsche Widder ("German Ram"), Blaue and Weisse Wiener (Blue & White Viennese), angora rabbits, and large and small silver rabbits. Rabbits are also kept as laboratory and experimental animals, among other things for the production of special antibodies.','Inhalative, epicutan or ingestive;','Dander and hair; in urine and meat there are specific proteins which can trigger the allergies.','Kaninchen',null,'Das Hauskaninchen (fälschlicherweise oft Hase oder Stallhase genannt) wurde seit dem frühen Mittelalter aus dem Wildkaninchen gezüchtet. Seit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass die weitere Beschreibung auf das Wildkaninchen Bezug nimmt. Diese wird 40 bis 50 cm lang, 1,5 bis 2,5 kg schwer und ist von gelblich-brauner Färbung. Das Winterkleid wirkt in Folge der Vermehrung der Wollhaare mehr grau. Das Wildkaninchen besitzt einen kurzen, weißen Stummelschwanz und bis zu 8 cm lange Ohren. Die typische Körperhaltung ist sitzend, mit gekrümmtem Rücken. Die 5  Zehen der Vorderpfoten und die 4 Zehen der Hinterpfoten tragen kräftige Krallen. Das Gebiss unterscheidet sich von dem der Nagetiere dadurch, dass sich hinter den oberen Schneidezähnen noch sogenannte Stiftzähne befinden.\nDie Hausrassen haben sich von dieser Form teilweise sehr weit entfernt. Zu nennen sind vor allem Belgische Riesen, Deutsche Widder, Blaue und Weiße Wiener, Angorakaninchen, Groß- und Kleinsilber.\nKaninchen werden auch als Labor- und Versuchstiere gehalten; u.a. zur Produktion spezieller Antikörper.','Inhalativ, epicutan bzw. ingestiv;','Hautschuppen und Haare; Im Urin und im Fleisch befinden sich spezifische Eiweiße, die Allergien auslösen können.','Oryctolagus cuniculus (L.)','Leporidae','Lagomorpha, Hasenartige',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (127,3,'e 83 (Epithelien), e 204 (Serumalbumin), vgl. f 26','Pig, domestic',null,'The domestic pig is descended from the wild pig, Sus scrofa L.. The domestication process for this very important domestic animal began over 8,000 years ago. Since that time extremely diverse breeds have developed, so that a uniform description has to be kept relatively general. The body of the domestic pig is clearly lower and longer than the wild pig. This gives it a plump and ponderous appearance. The pig has a trunk-like extended snout which ends in a flat noseplate. From the elongated tail of the wild pig, selective breeding has created a curly corkscrew tail, and floppy ears out of upright ears. Hair growth is considerably more scanty than on a wild pig. In contrast to the wild pig, the canine teeth are strongly stunted; in the case of the sow they are not even visible when her mouth is closed. A domestic pig attains a slaughter weight of about 100 kg after approx. 8 months. The pig is an ungulate with two fully developed and two only weakly developed toes. The German names of major swine breeds in central Europe are Deutsches Sattelschwein, Deutsche Landrasse, Deutsches Weideschwein, Deutsches weisses [white] Edelschwein and Rotbuntes [red] Schwein. Domestic pigs have an enormous economic value as provider of meat, fat, leather, and bristle. Due to its physiological similarity with mankind, the pig is also often used as an experimental and laboratory animal;','Inhalative, epicutan or ingestive;','dander and hair; specific proteins which can trigger allergies are found in the urine, serum and in meat.','Schwein, Haus-',null,'Das Hausschwein stammt vom Wildschwein, Sus scrofa L. ab. Der Domestikationsprozess für dieses sehr wichtige Haustier des Menschen setzte vor über 8 000 Jahren ein. Seit dieser Zeit sind sehr verschiedengestaltige Rassen entstanden, so dass eine einheitliche Beschreibung relativ allgemein gehalten werden muss.\nDer Körper des Hausschweins ist deutlich niedriger und länger gebaut als der des Wildschweins. Dadurch wirkt es plump und schwerfällig. Es besitzt eine rüsselartig verlängerte Schnauze, die in einer Nasenscheibe endet. Aus dem gestreckten Schwanz des Wildschweins wurde durch die Züchtung ein Ringelschwänzchen und aus den aufrecht stehenden Ohrmuscheln sind Schlappohren geworden. Die Behaarung ist wesentlich spärlicher als beim Wildschwein. Im Gegensatz zum Wildschwein sind auch die Eckzähne stark zurückgebildet; bei der Sau sind sie bei geschlossenem Maul nicht mehr sichtbar. \n Ein Hausschwein erreicht nach ca. 8 Monaten ein Schlachtgewicht von 100 kg. Das Schwein ist ein Zehenspitzengänger mit zwei voll ausgebildeten und zwei sehr schwach ausgebildeten Zehen. Die Hauptrassen Mitteleuropas sind Deutsches Sattelschwein, Deutsche Landrasse, Deutsches Weideschwein, Deutsches weißes Edelschwein und Rotbuntes Schwein. Hausschweine sind von größter wirtschaftlicher Bedeutung als Fleisch, Fett, Leder- und Borstenlieferant. Auf Grund seiner physiologischen Ähnlichkeit zum Menschen ist das Schwein auch Versuchs- und Labortier;','Inhalativ, epicutan bzw. ingestiv;','Hautschuppen und Haare; Im Urin, Serum und im Fleisch befinden sich spezifische Eiweiße, die Allergien auslösen können.','Sus scrofa f. domestica L.','Suidae','Artiodactyla, Paarhufer',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (128,3,'e 84','Goldhamster epithelia',null,'Approx. 18 cm long rodent with short, about 1.5 cm long tail, short but nimble legs and pronounced cheek pockets. The thick fur is gray to golden-brown on the top. The fur on the stomach is whitish. On the throat and neck the fur is lighter.','Inhalative;','skin, hair and possibly saliva','Goldhamsterepithelien',null,'Ca. 18 cm langer Nager mit kurzem, etwa 1,5 cm langem Schwanz, kurzen aber behenden Beinen und ausgeprägten Backentaschen. Das dichte Fell ist oberseits grau bis goldbraun. Die Bauchseite ist weißlich. An der Kehle und den Halsseiten ist das Fell hell gezeichnet.','Inhalativ;','Haut, Haare und möglicherweise Speichel','Mesocricetus auratus','Cricetidae','Rodentia Nagetiere',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (129,3,'e 203','Chinchilla epithelia',null,null,null,null,'Chinchillaepithelien',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (130,3,'e 207','Parakeet (Nymphicus hollandicus) feathers',null,'Approx. 32 cm long, slender bird with largely gray plumage. Wings have a white, wedge-shaped spot. Head yellowish with white feathers and an orange spot just below the eye. The coloring is stronger in some of the males. A long extended pointed crest on the top of the head. In addition there are also white and mottled breeds. The very powerful beak has a meaty to gray hue and is bent like a parrot''s beak. The foot has two toes pointed forwards and two pointed backwards, which act as climbing or climbing/grasping claw.','Inhalative;','Proteins in the feather construction and the feathers themselves; furthermore saliva proteins and uropygial gland secretions which reach the surface in the course of a bird''s preening and feather cleaning routines are being discussed as patient.allergens.','Nymphensittichfedern',null,'Ca. 32 cm langer, schlanker Vogel mit überwiegend grauem Gefieder. Flügel mit weißem, keilförmigen Fleck. Kopf gelblich, weiß befiedert und mit einem orangenen Fleck unterhalb des Auges. Die Färbung ist bei den Männchen kräftiger. Oberkopf mit lang ausgezogener spitzer Haube. Zusätzlich gibt es weiße und scheckige Zuchtformen. Der sehr kräftige Schnabel ist fleischfarben bis grau und nach Papageienart gekrümmt. Der Fuß ist mit zwei nach vorne und zwei nach hinten gerichten Zehen als Kletter- oder Greiffuß ausgebildet.','Inhalativ;','Proteine der am Federaufbau beteiligten Strukturen und der Federn selbst; ferner werden Speichelproteine und Bürzeldrüsensekrete, die bei der Gefiederpflege auf die Oberfläche gelangen, als Allegene diskutiert.','Nymphicus hollandicus Kerr.','Psittacidae','Psittaciformes, Papageienartige Vögel',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (131,7,'c 1','Penicillin G','Benzylpenicillin, (6R)-6-(2-Phenylacetamido)penicillansäure;',null,null,null,'Penicillin G','Benzylpenicillin, (6R)-6-(2-Phenylacetamido)penicillansäure;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (132,7,'c 2','Penicillin V','Phenoxymethylpenicillin; (6R)-6-(2-Phenoxyacetamido)penicillan-säure;',null,null,null,'Penicillin V','Phenoxymethylpenicillin; (6R)-6-(2-Phenoxyacetamido)penicillan-säure;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (133,7,'c 201','Cephalosporins','The different cephalosporins appear under the following more or less trivial trade names: Cefaclor, Cefadroxil, Cefalexin, Cefamandol, Cefazolin, Cefepim, Cefetamet, Cefixim, Cefmenoxim, Cefodizim, Cefoperazon, Cefotaxim, Cefotiam, Cefoxitin, Cefpodoxim, Cefsulodin, Ceftazidim, Cefdibuten, Ceftizoxim, Ceftriaxon, Cefuroxim;',null,null,null,'Cephalosporine','Die verschiedenen Cephalosporine treten unter folgenden Trivialnamen auf: Cefaclor, Cefadroxil, Cefalexin, Cefamandol, Cefazolin, Cefepim, Cefetamet, Cefixim, Cefmenoxim, Cefodizim, Cefoperazon, Cefotaxim, Cefotiam, Cefoxitin, Cefpodoxim, Cefsulodin, Ceftazidim, Cefdibuten, Ceftizoxim, Ceftriaxon, Cefuroxim;',null,null,null,null,null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (134,7,'c 205','Ampicillin','D-(-)-(alpha-aminobenzyl)penicillin;',null,null,null,'Ampicillin','D-(-)-(alpha-aminobenzyl)penicillin;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (135,7,'c 207','Acetylsalicylic acid','2-Acetoxybenzoic acid;',null,null,null,'Acetylsalicylsäure','2-Acetoxybenzoesäure;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (136,7,'c 214','Amoxicillin','alpha-Amino-4-hydroxybenzylpenicillin;',null,null,null,'Amoxicillin','alpha-Amino-4-hydroxybenzylpenicillin;',null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (137,4,'f 2','Cow milk protein',null,null,null,null,'Kuhmilcheiweiß',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (138,4,'f 60','Camembert',null,null,null,null,'Camembert',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (139,4,'f 70','Swiss cheese',null,null,null,null,'Schweizer Käse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (140,4,'f 76','Alpha-lactalbumin',null,null,null,null,'Alpha-Lactalbumin',null,null,null,null,null,null,null,1,1,9,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (141,4,'f 77','Beta-lactoglobulin',null,null,null,null,'ß-Lactoglobulin',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (142,4,'f 78','Casein',null,null,null,null,'Casein',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (143,4,'f 81','Cheddar cheese',null,null,null,null,'Cheddarkäse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (144,4,'f 82','Mould cheese',null,null,null,null,'Schimmelkäse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (145,4,'f 150','Edamer cheese',null,null,null,null,'Edamer Käse',null,null,null,null,null,null,null,1,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (146,4,'f 201','Gouda cheese',null,null,null,null,'Gouda Käse',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (147,4,'f 203','Milk, boiled',null,null,null,null,'Milch, gekocht',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (148,4,'f 205','Yogurt',null,null,null,null,'Joghurt',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (149,4,'f 206','Kefir',null,null,null,null,'Kefir',null,null,null,null,null,null,null,1,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (150,4,'f 286','Mare''s milk',null,null,null,null,'Stutenmilch',null,null,null,null,null,null,null,1,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (151,4,'f 26','Pork',null,null,null,null,'Schweinefleisch',null,null,null,null,null,null,null,2,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (152,4,'f 27','Beef, raw',null,null,null,null,'Rindfleisch, roh',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (153,4,'f 57','Duck',null,null,null,null,'Entenfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (154,4,'f 58','Goose',null,null,null,null,'Gänsefleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (155,4,'f 59','Horsemeat',null,null,null,null,'Pferdefleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (156,4,'f 83','Chicken',null,null,null,null,'Hühnerfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (157,4,'f 88','Lamb/Mutton',null,null,null,null,'Lamm-/Hammelfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (158,4,'f 130','Turkey',null,null,null,null,'Putenfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (159,4,'f 213','Rabbit',null,null,null,null,'Kaninchenfleisch',null,null,null,null,null,null,null,2,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (160,4,'f 1, f 67 Ovalbumin, f 68 Ovomucoid, f 74 Gesamthü','Chicken egg',null,null,null,null,'Hühnerei',null,null,null,null,null,null,null,3,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (161,4,'f 12','Pea',null,null,null,null,'Erbse',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (162,4,'f 14','Soy bean',null,null,null,null,'Sojabohne',null,null,null,null,null,null,null,4,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (163,4,'f 15','Bean, white',null,null,null,null,'Bohne, weiße',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (164,4,'f 25','Tomato',null,null,null,null,'Tomate',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (165,4,'f 31','Carrots',null,null,null,null,'Karotte',null,null,null,null,null,null,null,4,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (166,4,'f 35','Potatoes',null,null,null,null,'Kartoffel',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (167,4,'f 38','Spinach',null,null,null,null,'Spinat',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (168,4,'f 39','Cabbage',null,null,null,null,'Kohl',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (169,4,'f 46','Paprika, sweet',null,null,null,null,'Paprika, Gemüse-',null,null,null,null,null,null,null,4,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (170,4,'f 47','Garlic',null,null,null,null,'Knoblauch',null,null,null,null,null,null,null,4,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (171,4,'f 48','Onions',null,null,null,null,'Zwiebel',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (172,4,'f 54','Sweet potato (Batate)',null,null,null,null,'Süßkartoffel (Batate)',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (173,4,'f 61','Cauliflower, cooked',null,null,null,null,'Blumenkohl, gekocht',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (174,4,'f 65','Lentil',null,null,null,null,'Linse',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (175,4,'f 66','Leeks',null,null,null,null,'Porree',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (176,4,'f 86','Parsley',null,null,null,null,'Petersilie',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (177,4,'f 96','Avocado',null,null,null,null,'Avokado',null,null,null,null,null,null,null,4,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (178,4,'f 100','Head lettuce',null,null,null,null,'Kopfsalat',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (179,4,'f 127','Mushroom',null,null,null,null,'Champignon',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (180,4,'f 132','Beans, green',null,null,null,null,'Bohnen, grüne',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (181,4,'f 133','Cucumber',null,null,null,null,'Gurke',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (182,4,'f 134','Broccoli',null,null,null,null,'Brokkoli',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (183,4,'f 137','Asparagus',null,null,null,null,'Spargel',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (184,4,'f 287','Bean, red',null,null,null,null,'Bohne, rot',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (185,4,'f 301','Eggplant',null,null,null,null,'Aubergine',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (186,4,'f 309','Radishes',null,null,null,null,'Radieschen',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (187,4,'f 311','Brussels sprouts',null,null,null,null,'Rosenkohl',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (188,4,'f 318','Zucchini',null,null,null,null,'Zucchini',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (189,4,'f 901','Pepperoni',null,null,null,null,'Peperoni',null,null,null,null,null,null,null,4,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (190,8,'m 1','Penicillium chrysogenum Thom','Penicillium notatum Westling;','Colonies auf Czapek agar (CzA) at 25° C 2.5-4 cm in 10 days (faster growing on malt agar MEA), satin-like to flaky, often a light yellow exudate is released; rear side yellow, seldom uncolored; conidiophore smooth-walled, 200-300 µm long; penicilli usually have three to four levels of  branching; metulae short 8-12 µm long; bottle-shaped phialides usually 7-10 x 2-2.5 µm; conidia smooth-walled, ellipsoid, 2.5-4 µm long, blue or blue-green.','Inhalation, ingestion;',null,'Penicillium chrysogenum Thom','Penicillium notatum Westling;','Kolonien auf Czapek-Agar (CzA) bei 25° C 2.5-4 cm in 10 Tagen (auf Malzagar MEA schneller wachsend), samtig bis flockig, häufig ein hellgelbes Exudat freisetzend; Rückseite gelb, selten ungefärbt;\nKonidienträger glattwandig, 200-300 µm lang; Penicilli gewöhnlich drei- bis vierstufig verzeigt; Metulae kurz 8-12 µm lang; flaschenförmige Phialiden meist 7-10 x 2-2.5 µm;   Konidien glattwandig, ellipsoid, 2,5-4 µm lang, blau oder blaugrün.','Inhalativ, ingestiv;',null,'Penicillium chrysogenum Thom',null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (191,8,'m 2','Cladosporium herbarum (Pers.) Link ex Gray','Cladosporium entoxylinum, Corda, Dematium herbarum Pers. ex Schleich, Dematium graminum Pers., Cladosporium graminum (Pers.) Link, Dematium epiphyllum Pers. ex Hook, Cladosporium epiphyllum (Pers. ex Hook.) Nees ex Fr.;','Colonies on malt agar (MEA 2%) with moderate growth, satin-like, olive green to olive brown, rear side olive black; conidiophore lateral or sometimes terminal on the hyphen, to 250 µm long, 3-6 µm wide, with terminal and intercalar swellings as well as extensions, pale to mid-dark olive-brown or brown, smooth-walled, with distinct protruding brown scars; conidia ellipsoid to cylindrical with rounded ends, rough as well with distinct protruding brown scars, often two or more celled, single-celled conidia 5.5-13 x 3.8-6 µm; the conidia in their turn again become conidiogen cells, so that often ramified chains are generated.','Inhalation, ingestion;',null,'Cladosporium herbarum (Pers.) Link ex Gray','Cladosporium entoxylinum, Corda, Dematium herbarum Pers. ex Schleich, Dematium graminum Pers., Cladosporium graminum (Pers.) Link, Dematium epiphyllum Pers. ex Hook, Cladosporium epiphyllum (Pers. ex Hook.) Nees  ex Fr.;','Kolonien auf Malzagar (MEA 2%) mit moderatem Wachstum, samtig, olivgrün bis olivbraun, Rückseite olivschwarz;\nKonidienträger lateral oder manchmal terminal auf den Hyphen, bis 250 µm lang, 3-6 µm breit, mit terminalen und intercalaren Schwellungen sowie Verlängerungen, blaß bis mittelstark olivbraun oder braun, glattwandig, mit deutlich hervorstehenden braunen Narben; Konidien ellipsoid bis zylindrisch mit abgerundeten Enden, rauh ebenfalls mit deutlich hervorstehenden braunen Narben, oft 2- oder mehrzellig, einzellige Konidien 5,5-13 x 3.8-6 µm;\nDie Konidien werden ihrerseits wieder zu konidiogenen Zellen, so dass häufig verzweigte Ketten entstehen.','Inhalativ, ingestiv;',null,'Cladosporium herbarum (Pers.) Link ex Gray',null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (192,8,'m 3','Aspergillus fumigatus Fres.','Aspergillus phialiseptus Kwon-Chung, Aspergillus anomalus Mosseray, Aspergillus cellulosae Hopffe;','Colonies on Czapek agar (CzA) at 25 °C 3-5 cm in 7 days, dark blue-green, consisting of a dense fur of short conidiophores, intertwined with air hypha; the colonies grow faster and produce more spores on malt agar. The conidiophore stems are smooth-walled, often green in the upper regions; conidia heads consist of single-rowed parallel conidia chains; vesicle wide club-shaped, 20-30 µm wide; conidia rough-walled, spherical (to elliptical), 2.5-3 µm diameter.','Inhalation or ingestion;',null,'Aspergillus fumigatus Fres.','Aspergillus phialiseptus Kwon-Chung, Aspergillus anomalus Mosseray, Aspergillus cellulosae Hopffe;','Kolonien auf Czapekagar (CzA) bei 25 °C 3-5 cm in 7 Tagen, dunkel blaugrün, bestehend aus einem dichten Pelz aus kurzen Kondienträgern, durchflochten mit Lufthyphen; die Kolonien wachsen auf Malzagar schneller und sporulieren stärker. Kondienträgerstiele glattwandig, oft grün im oberen Bereich; Konidienköpfe bestehend aus einreihigen parallelen Konidienketten; Vesikel breit keulenförmig, 20-30 µm breit; Konidien rauhwandig, kugelig (bis elliptisch), 2.5-3 µm Durchmesser.','Inhalativ oder ingestiv;',null,'Aspergillus fumigatus Fres.',null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (193,8,'m 4','Mucor racemosus Fres. f. racemosus','Clamydomucor racemosus (Fres.) Bref., Mucor dimorphosporus Lendner, Mucor christianensis Hagem, Mucor varians Pispek;','Colonies grow rapidly, light gray-brown; sporangiophores hyaline, up to 20 mm x 24-17 µm, monopodially as well as sympodially ramified, short branchings are often bent over; sporangies brown, up to 80(-90) µm diameter; Columellar round to pear-shaped, often with flattened base, light-brown with collars; sporangiophores smooth-walled, round to wide ellipsoid, up to 8-10 µm diameter; chlamydospore  in sporangiophores; zygospores up to 110 µm diameter, brown, short thorned; suspensors equally or almost equally large; heterothallic.','Inhalation and ingestion;',null,'Mucor racemosus Fres. f. racemosus','Clamydomucor racemosus (Fres.) Bref., Mucor dimorphosporus Lendner, Mucor christianensis Hagem, Mucor varians Pispek;','Kolonien schnellwachsend, hell graubraun; Sporangiophoren hyalin, bis zu 20 mm x 24-17 µm, sowohl monopodial als auch sympodial verzweigt, kurze Verzweigungen oft eingekrümmt; Sporangien braun, bis zu 80(-90) µm Durchmesser; Columellar rundlich bis birnenförmig, oft mit abgeflachter Basis, hellbraun mit Kragen; Sporangiophoren glattwandig, rund bis breit ellipsoid, bis zu 8-10 µm Durchmesser; Chlamydosporen in Sporangiophoren; Zygosporen bis zu 110 µm Durchmesser, braun, kurzstachelig; Suspensoren gleich oder beinahe gleich groß; heterothallisch.','Inhalativ und ingestiv;',null,'Mucor racemosus Fres. f. racemosus','Mucoraceae','Mucorales',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (194,8,'m 6','Alternaria alternata (Fr.) Keissl','Alternaria tenuis Nees., Torula alternata Fr., Macrosporium tomato Cooke;','Colonies on malt agar (MEA) at 25 °C with a diameter of 6 cm in 7 days, black-gray to olive green. Conidiophore, 1-3 celled, usually unbranched, with one or only a few stigma (conidiogenesis), up to 50 µm long, 3-6 µm wide; conidia slightly club-shaped to ellipsoid, with a short cylindrical beak shape, 23-56 x 8-17 µm; brown, wall-shaped septa, a stigma at the end, usually arranged in unbranched chains of 10 or more;','Inhalation and ingestion;',null,'Alternaria alternata (Fr.) Keissl','Alternaria tenuis Nees., Torula alternata Fr., Macrosporium tomato Cooke;','Kolonien auf Malzagar (MEA) bei 25 °C mit einem Durchmesser von 6 cm in 7 Tagen, schwarzgrau bis olivgrün. Konidienträger 1-3-zellig, meist unverzweigt, mit einer oder wenigen Narben (Konidiogenese), bis zu 50 µm lang, 3-6 µm breit; Konidien schwach keulenförmig bis ellipsoid, mit einem kurzen zylindrischen Schnabel, 23-56 x 8-17 µm; braun, mauerförmig septiert, am Ende mit einer Narbe, meist in unverzweigten Ketten von 10 oder mehr angeordnet;','Inhalativ und ingestiv;',null,'Alternaria alternata (Fr.) Keissl','Dematiaceae',null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (195,8,'m 7','Botrytis cinerea Pers.','Sclerotium durum Pers. ex St.-Am., Haplaria grisea Link ex Leman, Phymadeadrichum gemellum Bonord., Botrytis fuckeliana Buchw.;','Colonies grow rapidly, on oat agar (OA) at 20 °C and reach a diameter of at least 6 cm in 10 days, at first transparent, then becoming light to dark gray; black Sclerotine as well as on ground and also on natural substrates, very variable in size and form; condiophores erect, often 2mm long and 16-30 µm wide, septate, in the lower regions colored brown and smooth-walled, with a head composed of branchings at the end; the conidiogen cells swollen at the ends produce simultaneously numerous blasto-conids on small denticels. Conidia oval 8-14 x 6-9 µm, pale brown, hydrophobic, smooth-walled; Myrioconium state: phialidische microconida on sporodochia 2.5-3 µm diameter;','Inhalation or ingestion, especially on the consumption or when handling wine grapes, wine and other fruits;',null,'Botrytis cinerea Pers.','Sclerotium durum Pers. ex St.-Am., Haplaria grisea Link ex Leman, Phymatotrichum gemellum Bonord., Botrytis fuckeliana Buchw.;','Kolonien schnellwachsend, auf Haferagar (OA) bei 20 °C einen Durchmesser von mindestens 6 cm in 10 Tagen erreichend, zunächst durchscheinend, dann hell bis dunkelgrau werdend; Schwarze Sclerotien sowohl auf Nährboden als auch auf  natürlichen Substraten, sehr variabel in Größe und Form; Kondiophoren aufrecht, häufig 2mm lang und 16-30 µm breit, septiert, im unteren Bereich braun, glattwandig, mit einem Kopf aus Verzweigungen am Ende; die am Ende geschwollenen konidiogenen Zellen produzieren simultan zahlreiche Blastokoniden auf kleinen Dentikeln. Konidien oval 8-14 x 6-9 µm, blaßbraun, hydophob, glattwandig; \nMyrioconium Stadium: phialidische Mikrokonidien auf Sporodochien 2.5-3 µm Durchmesser;','Inhalativ oder ingestiv, besonders bei Verzehr oder im Umgang mit Weitrauben, Wein und anderen Früchten;',null,'Botrytis cinerea Pers.','Moniliaceae',null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (196,8,'m 8','Exserohilum rostratum (Drechsler) Leonard & Suggs','Helminthosporium halodes Drechsler, Drechslera halodes (Drechsler) Subramanian & Jain, Drechslera rostrata (Drechsler) Richardson & Fraser, Helminthosporium rostratum Drechsler;','Conidiophores and phragmoconidies dark, distoseptate;','Inhalation;',null,'Exserohilum rostratum (Drechsler) Leonard & Suggs','Helminthosporium halodes Drechsler, Drechslera halodes (Drechsler) Subramanian & Jain, Drechslera rostrata (Drechsler) Richardson & Fraser, Helminthosporium rostratum Drechsler;','Konidiophoren und Phragmokonidien dunkel, distoseptiert;','Inhalativ;',null,'Exserohilum rostratum (Drechsler) Leonard & Suggs','Dematiaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (197,8,'m 9','Fusarium verticillioides (Sacc.) Nirenberg;','Fusarium moniliforme Sheldon;','Colonies on oat agar (OA) very rapid-growing (4.6 cm/ 4 d), with much air mycelia, white to pink or violet, often discrete or as amorphous orange sporodoches, conidiophores on the side of the air mycelia, seldom ramified; conidiogene cells strictly monophialidic; macroconidies sickle-shaped to almost straight, 3-5 septate, 31-58 x 2.7-3.6 µm, sometimes only a few; microconida often oval to sickle-shaped, in chains, 7-10 x 2.5-3.2 µm; scleroties can be extant, dark blue, give the colony a blue tinge;','Inhalation, ingestion or by contact;',null,'Fusarium verticillioides (Sacc.) Nirenberg;','Fusarium moniliforme Sheldon;','Kolonien auf Haferagar (OA) sehr schnell wachsend (4.6 cm/ 4 d), mit viel Luftmycel, weiß bis rosa bzw. violett, häufig diskrete oder verschmelzende orangene Sporodochen vorhanden,  Konidiophoren seitlich auf dem Luftmycel, selten verzweigt; Konidiogene Zellen streng monophialidisch; Makrokonidien sichelförmig  bis fast gerade, 3-5 septiert, 31-58 x 2.7-3.6 µm, manchmal nur wenige; Mikrokonidien häufig oval bis sichelförmig, in Ketten, 7-10 x 2.5-3.2 µm; Sklerotien können vorhanden sein, dunkelblau, geben der Kolonie ein bläuliches Aussehen;','Inhalativ, ingestiv oder durch Kontakt;',null,'Fusarium verticillioides (Sacc.) Nirenberg;','Tuberculariaceae',null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (198,8,'m 10','Stemphylium botryosum Wallroth 1833',null,'Colonies thick, gray, condiogene cells and conidia dark, Kondidien muriform, spherical to egg-shaped; double walled ascus with 8 spores in one or two longitudinal rows; ascosporea gold-brown, attitudinally and longitudinally septate;','Inhalation, nutritive;',null,'Stemphylium botryosum Wallroth 1833',null,'Kolonien dicht, grau, Kondiogene Zellen und Konidien dunkel, Kondidien muriform, kugelig bis eiförmig; \ndoppelwandiger Ascus mit 8 Sporen in einer oder zwei Längsreihen; Ascosporen goldbraun, quer und längs septiert;','Inhalativ, nutritiv;',null,'Stemphylium botryosum Wallroth 1833','Dematiaceae','Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (199,8,'m 11','Rhizopus stolonifer (Ehrenb. ex Link) Lind 1913','Mucor stolonifer Ehrenb. 1818 ex Link 1824: Fr. 1832, Rhizopus nigricans Ehrenb. 1820 ex Corda 1838;','Colonies grow rapidly on malt agar (MEA), white, sporangies carrier grouped 1-3 (sometimes more), brown, up to 2 mm high and 20 µm thick; well developed ramified rhizoide; sporangies are black, round, diameter up to 275 µm, Columella conical up to 140 µm high; sporangiospore  irregular, variable, of bent, round to ellipsoid, up to 13 µm long, striped; none chlamydospore ; zygospore  black, warty, up to 200 µm diameter, between unequally large suspensors, heterothallic;','Inhalation, nutritive;',null,'Rhizopus stolonifer (Ehrenb. ex Link) Lind 1913','Mucor stolonifer Ehrenb. 1818 ex Link 1824: Fr. 1832,\nRhizopus nigricans Ehrenb. 1820 ex Corda 1838;','Kolonien auf Malzagar (MEA) schnellwachsend, weißlich, Sporangienträger zu 1-3 (manchmal mehr) gruppiert, bräunlich, bis zu 2 mm hoch und 20 µm dick; gut entwickelte verzweigte Rhizoide; Sporangien schwarz, rund, Durchmesser bis zu 275 µm, Columella konisch bis zu 140 µm hoch; Sporangiosporen unregelmäßig, variabel, von gekrümmt, rundlich bis ellipsoid, bis zu 13 µm lang, gestreift; keine Chlamydosporen;\nZygosporen schwarz, warzig, bis zu 200 µm Durchmesser, zwischen ungleich großen Suspensoren, heterothallisch;','Inhalativ, nutritiv;',null,'Rhizopus stolonifer (Ehrenb. ex Link) Lind 1913','Mucoraceae','Mucorales',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (200,8,'m 13','Phoma betae Frank',null,'Colonies at first white, later darkening; builds thin-walled pyknidies with oval, hyaline, single-celled conidia;','Inhalation, on contact, nutritive;',null,'Phoma betae Frank',null,'Kolonien erst weiß, später nachdunkelnd; bildet dünnwandige Pyknidien mit ovalen, hyalinen, einzelligen Konidien;','Inhalativ, kontaktiv, nutritiv;',null,'Phoma betae Frank','Phomaceae','Sphaeropsidales',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (201,8,'m 14','Epicoccum nigrum Link ex Link 1825','Epicoccum purpurascens Ehrenb. ex Schlecht; Toruloidea tobaica of Szilvinyi; Epicoccum granulatum Penzig; Epicoccum humicola (Buchanan) Saccardo; Thyrococcum humicola Buchanan; Epicoccum neglectum Desmazières; Epicoccum mezzetti, Goidánich; Epicoccum oryza, S. Ito & Iwadare; Epicoccum vulgare Corda;','Colonies on malt (MEA) or oat agar (OA) at 20°C reach a diameter of at least 6 cm in 10 days, yellow-orange, red or brown, sometimes greenish. On the bottom side they are often more intensively colored. Alter 8-10 days, visible sporodochia (clustered conidiophores) appear as black dots, diameter 100-2000 µm. Conidiophores, straight or more or less bent; individually formed blasto-conidis, round to pear-shaped, often 15-25 µm, with a funnel-shaped base and wide base scar, dark gold-brown, rough, builds septs, which divide the conidia into up to 15 cells; the spores are actively catapulted away. Frequently, sterile cultures can be  induced to sporulation by means of UV light.','Inhalation, nutritive;',null,'Epicoccum nigrum Link ex Link 1825','Epicoccum purpurascens Ehrenb. ex Schlecht;\nToruloidea tobaica von Szilvinyi;\nEpicoccum granulatum Penzig;\nEpicoccum humicola (Buchanan) Saccardo;\nThyrococcum humicola Buchanan;\nEpicoccum neglectum Desmazières;\nEpicoccum mezzetti, Goidánich;\nEpicoccum oryza, S. Ito & Iwadare;\nEpicoccum vulgare Corda;','Kolonien auf Malz- (MEA) oder Haferagar (OA) erreichen bei 20°C einen Durchmesser von mindestens 6 cm in 10 Tagen, gelborange, rot oder braun, manchmal grünlich. Auf der Unterseite sind sie oft intensiver gefärbt. Nach 8-10 Tagen erscheinen als schwarze Punkte sichtbare Sporodochien (geclusterte Konidiophoren), Durchmesser 100-2000 µm. Konidiophoren, gerade oder mehr oder weniger gekrümmt; einzeln gebildete Blastokonidien, rund bis birnenförmig, häufig 15-25 µm, mit einer trichterförmigen Basis und breiter Ansatznarbe, dunkel goldbraun, rauh, bildet Septen, welche die Konidien in bis zu 15 Zellen teilen; die Sporen werden aktiv weggeschleudert.\nHäufig sterile Kulturen können mittels UV-Licht zur Sporulation angeregt werden.','Inhalativ, nutritiv;',null,'Epicoccum nigrum Link ex Link 1825','Tuberculariaceae','Hyphomycetes',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (202,8,'m 15','Trichoderma viride Pers. ex Gray 1821','Trichoderma lignorum (Tode) Harz; Eidamia viridescens Horne & Williamson;','Colonies on oat agar (OA) at 20°C can reach a diameter of 4.5-7.5(-9) cm in 5 days; at first more or less hyaline, later becoming white-green with bush-like blue-green conidia regions; rear side colorless; conidiophores pyramidal ramified; phialids are in groups of 2-4 and long and often bent (6-)8-14(-20) x 2,4-3.0 µm; conidia round, sometimes a rather wide ellipsoid, 3,6-4.5(-4,8) µm, rough-walled; chlamydospores usually extant in the mycelia of older cultures, intercalar, sometimes terminal, usually round, hyaline, smooth-walled;','Inhalation, nutritive;',null,'Trichoderma viride Pers. ex Gray 1821','Trichoderma lignorum (Tode) Harz;\nEidamia viridescens Horne & Williamson;','Kolonien auf Haferagar (OA) erreichen bei 20°C einen Durchmesser von 4,5-7,5(-9) cm in  5 Tagen; zunächst mehr oder weniger hyalin, später weißlich-grün werdend mit büscheligen bläugrünen Konidienregionen; Rückseite farblos; Konidiophoren pyramidal verzweigt; Phialiden in Gruppen von 2-4 lang und oft gebogen (6-)8-14(-20) x 2,4-3,0 µm; Konidien rundlich, manchmal eher breit ellipsoid, 3,6-4,5(-4,8) µm, rauhwandig; Chlamydosporen meist vorhanden im Mycel älterer Kulturen, intercalar, manchmal terminal, meist rund, hyalin, glattwandig;','Inhalativ, nutritiv;',null,'Trichoderma viride Pers. ex Gray 1821','Moniliaceae Familie: Moniliaceae','Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (203,8,'m 16','Curvularia lunata (Wakker) Boedijn 1933; as var. aeria and var. Lunata','Malustela aeria Batista et al. Acrothecium lunatum Wakker 1898, Helminthosporium curvulum Saccardo 1916, Curvularia lycoperci Tandon & Kakkar 1964;','Dark brown colonies on oat agar (OA) achieve a diameter of 6 cm in 5 days at 25 °C. conidiophores variable, individually or in groups, ramified or unbranched, straight or bent, sometimes bent over, brown, pale for the point, on natural substrate up to 650 µm (smaller in cultures), 5-9 µm wide on the base; Poroconidies three-fold septate, third cell bent, often darker, 20-30 x 9-15 µm; acomata black, 410-700 µm high, with distinct beaked opening, asci cylindrical or club-shaped, unitunicate; spores string-shaped, twisted in the ascus, narrowing somewhat at the end, 6-15-fold septate, 130-270 x 3,8-6.5 µm;','Inhalation; nutritive',null,'Curvularia lunata (Wakker) Boedijn 1933','Malustela aeria Batista et al. \nAcrothecium lunatum Wakker 1898, Helminthosporium curvulum Saccardo 1916, Curvularia lycoperci Tandon & Kakkar 1964;','Dunkelbraune Kolonien erreichen auf Haferagar (OA) einen Durchmesser von 6 cm in 5 Tagen bei 25 °C. Konidiophoren variabel, einzeln oder in Gruppen, verzweigt oder unverzweigt, gerade oder gekrümmt, manchmal geknickt, braun, blasser zur Spitze, auf natürlichem Substrat bis zu 650 µm (in Kultur kleiner), an der Basis 5-9 µm breit; Porokonidien dreifach septiert, dritte Zelle gekrümmt, oft dunklert, 20-30 x 9-15 µm; \nAcomata schwarz, 410-700 µm hoch, mit deutlich geschnäbelter Öffnung, Asci zylindrisch oder keulenförmig, unitunicat; Sporen fadenförmig, im Ascus verdreht, zum Ende sich etwas verjüngend,  6-15-fach septiert, 130-270 x 3,8-6,5 µm;','Inhalativ; nutritiv',null,'Curvularia lunata (Wakker) Boedijn 1933; als var. aeria und var. lunata','Dematiaceae','Hyphomycetes',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (204,8,'m 19','Aspergillus versicolor (Vuill.) Tiraboschi 1926','Aspergillus amoenus Roberg, Sterigmatocystis versicolor Vuill 1903;','Colonies on Czapek agar (CZ) can reach a diameter of 1.0-1.5 cm in 7 days. Within two weeks spores form; either tightly standing conidiophores, or conidiophores on thickly woven mycelia; color at first white, then changing to yellow, orange-yellow to yellow-green, often mixed with flesh or pink colors; conidiophores hyaline or lightly pigmented, smooth-walled; vesicle round to ellipsoid, diameter 12-16 µm; phialids 5.5-8.0 x 2.5-3.0 µm on metulae 5.0-7.5 x 2.0-2.5 µm; conidia round, diameter 2-3.5 µm, thorned; Hull cells sometimes extant, colonies on malt agar are faster growing and with less air mycelium; colors are then in darker shades of gray;','Inhalation or nutritive;',null,'Aspergillus versicolor (Vuill.) Tiraboschi 1926','Aspergillus amoenus Roberg, Sterigmatocystis versicolor Vuill 1903;','Kolonien erreichen auf Czapekagar (CZ) einen Durchmesser von 1,0-1,5 cm in 7 Tagen. Innerhalb von zwei Wochen sporulierend; entweder dichtstehende Konidiophoren, oder Konidiophoren auf dicht verwobenem Mycel; Farbe erst weiß, dann sich verändernd über gelb, orangelb bis gelbgrün, oft fleisch- oder pinkfarben untermischt; Konidiophoren hyalin oder leicht pigmentiert, glattwandig; Vesikel rundlich bis ellipsoid, Durchmesser 12-16 µm; Phialiden 5,5-8,0 x 2,5-3,0 µm auf Metulae 5,0-7,5 x 2,0-2,5 µm; Konidien rund, Durchmesser 2-3,5 µm, stachelig; Hüllzellen manchmal vorhanden, Kolonien auf Malzagar schneller wachsend und mit weniger Luftmyzel; Farben dann in dunkleren Grauschattierungen;','Inhalativ oder nutritiv;',null,'Aspergillus versicolor (Vuill.) Tiraboschi 1926','Moniliaceae Familie: Moniliaceae','Hyphomycetes Familie: Moniliaceae',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (205,8,'m 20','Mucor mucedo Mich. ex St.-Am 1821;','Mucor griseo-ochraceus Naumov 1915, Mucor murorum Naumov 1915, Mucor coprophilus Povah 1917;','Colonies in darkness up to 25 mm high, yellow-gray, in the light on natural substrate very long (up to 15 cm) consisting of a sparse layer of high, seldom ramified sporangiophores and a well-developed layer of short often ramified sporangiophores; sporangies diameter 80-200 µm, at first yellow then yellow-gray, with prickly light blurred wall, Columella oval or in reverse egg-shaped to cylindrical; sporangiospores ellipsoid 6-12 x 8-9 µm; zygospores  round or pressed between the suspensors up to 200 x 250 µm with warty appendages of up to 15 µm long; suspensors similar to the zygospore , swollen, yellow to brown;','Inhalation and nutritive;',null,'Mucor mucedo Mich. ex St.-Am 1821;','Mucor griseo-ochraceus Naumov 1915, Mucor murorum Naumov 1915, Mucor coprophilus Povah 1917;','Kolonien im Dunkeln bis zu 25 mm hoch, gelblichgrau, im Hellen auf natürlichem Substrat sehr lang (bis zu 15 cm) bestehend aus einer spärlichen Schicht hoher, selten verzweigter Sporangiophoren und einer gut entwickelten Schicht von kurzen häufig verzweigten Sporangiophoren; Sporangiendurchmesser 80-200 µm, zunächst gelb dann gelbgrau, mit stacheliger leicht zerfließender Wand, Columella oval oder umgekehrt eiförmig bis zylindrisch; Sporangiosporen ellipsoid 6-12 x 8-9 µm;\nZygosporen rund oder eingepresst zwischen den Suspensoren bis zu 200 x 250 µm mit warzigen Anhängseln bis zu 15 µm lang; Suspensoren ähnlich wie die Zygosporen, geschwollen, gelblich bis bräunlich;','Inhalativ und nutritiv;',null,'Mucor mucedo Mich. ex St.-Am 1821;','Mucoraceae','Mucorales',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (206,8,'m 21','Aspergillus clavatus Desm. 1834',null,'Colonies on Czapek agar (CZ) attain a diameter of 2.5-3.5 cm in 7 days; mostly consisting of a dense coat of blue-green long conidiophores; conidia heads club-shaped, usually splitting up from each other in separate rows; conidiophores 1.5-3.0 mm long, hyaline, smooth-walled; vesicle club-shaped, usually 40-60 µm wide; phialids standing directly on the vesicle, of variable size, (2.5)7-(3.5)8 x 2-3 µm.  Conidia ellipsoid, 3.0-4.5 x 2.5-4.5 µm, greenish, smooth-walled;','Inhalation or nutritive;',null,'Aspergillus clavatus Desm. 1834',null,'Kolonien auf Czapekagar (CZ) erreichen einen Durchmesser von 2,5-3,5 cm in 7 Tagen; meist bestehend aus einem dichten Fell blaugrüner langer Konidiophoren; Konidienköpfe keulenförmig, gewöhnlich sich aufspaltend in von einander abstehenden Reihen; Konidiophoren 1,5-3,0 mm lang, hyalin, glattwandig; Vesikel keulenförmig, meist 40-60 µm breitM; Phialiden stehen direkt auf dem Vesikel, von variabler Größe, (2,5)7-(3,5)8 x 2-3 µm. Konidien ellipsoid, 3,0-4,5 x 2,5-4,5 µm, grünlich, glattwandig;','Inhalativ oder nutritiv;',null,'Aspergillus clavatus Desm. 1834','Moniliaceae','Hyphomycetes',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (207,8,'m 32','Cladosporium cladosporioides (Fres.) de Vries 1952','Monilia humicola Oudemans, Cladosporium pisicola Snyder (Synonym of Cladosporium cladosporioides f. pisicola); Black fungus;','Colonies on malt agar (MEA) at 18-20 °C can reach a diameter of (1.5)3-4 cm in 10 days. They are satin-like, become powdery during the production of spores and are olive brown or gray-green. The rear side is greenish-black. Conidiophores sometimes emerge from the side terminal on the hyphen, and are up to 350 µm long, but usually shorter and 2-6 µm wide. They carry ramified conidiacettes and are pale to olive brown, smooth-walled or warty. Ramoconidies on the base of the chains, 0-1(-2) septate, more or less cylindrical, to 30 x 3.5 µm, brown or green-brown, smooth-walled or sometimes with tiny warts; conidia in the acropetalen chains usually single-celled, ellipsoid to lemon-shaped, 3-7(-11) x 2-4(5) µm, brown or green-brown, usually smooth-walled, sometimes warty;','Inhalation and nutritive;',null,'Cladosporium cladosporioides (Fres.) de Vries 1952','Monilia humicola Oudemans, Cladosporium pisicola Snyder (Synonym von Cladosporium cladosporioides f. pisicola);\nSchwärzepilz;','Kolonien erreichen auf Malzagar (MEA) bei 18-20 °C einen Durchmesser von (1,5)3-4 cm in 10 Tagen. Sie sind samtig, werden durch die Produktion von Konidien pudrig und sind olivbraun oder graugrün. Die Rückseite ist grünlichschwarz. Konidiophoren entstehen seitlich manchmal terminal auf den Hyphen, sind bis zu 350 µm lang, meist jedoch kürzer und 2-6 µm breit. Sie tragen verzweigte Konidienketten und sind blaß bis olivbraun, glattwandig oder warzig. Ramokonidien an der Basis der Ketten, 0-1(-2) septiert, mehr oder weniger zylindrisch, bis zu 30 x 3,5 µm, braun oder grünbraun, glattwandig oder manchmal mit winzigen Warzen; Konidien in den akropetalen Ketten meist einzellig, ellipsoid bis zitronenförmig, 3-7(-11) x 2-4(5) µm, braun oder grünbraun, meist glattwandig, manchmal warzig;','Inhalativ und nutritiv;',null,'Cladosporium cladosporioides (Fres.) de Vries 1952','Moniliaceae','Hyphomycetes',null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (208,8,'m 36','Aspergillus terreus Thom',null,'On Czapek agar (CZ) at 25°C, the colonies can reach a diameter of 3.5-5.0 cm in 7 days and consist usually of a thick layer of yellow-brown conidiophores, which become darker with age. Little conidia heads are compact, rod-shaped, usually 150-500 x 30-50 µm; conidiophores hyaline, smooth-walled; round vesicle, 10-20 µm in diameter; phialides 5-7 x 2.0-2.5 µm on standing metulae; round to ellipsoid conidia, 1.5-2.5 µm diameter, hyaline to light yellow, smooth;','Inhalation and nutritive;',null,'Aspergillus terreus Thom',null,'Die Kolonien erreichen auf Czapekagar (CZ) bei 25°C einen Durchmesser von 3,5-5,0 cm in 7 Tagen und bestehen meist aus einem dichten Filz von gelbbraunen Konidiophoren, die mit dem Alter dunkler werden. Konidienköpfchen kompakt, säulenförmig, meist 150-500 x 30-50 µm; Konidiophoren hyalin, glattwandig; Vesikel rundlich, 10-20 µm im Durchmesser; Phialiden 5-7 x 2,0-2,5 µm auf Metulae stehend; Konidien rund bis ellipsoid, 1,5-2,5 µm Durchmesser, hyalin bis leicht gelblich, glatt;','Inhalativ und nutritiv;',null,'Aspergillus terreus Thom','Moniliaceae','Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (209,8,'m 40','Aspergillus hollandicus Gams & Samson','Aspergillus amstelodami (Mangin) Thom & Church, Aspergillus vitis Novobranova;','Member of the Aspergillus glaucus group; colonies inhibited on Czapek agar (CZ), grow rapidly auf Agar with 20% saccharose, yellow to matt yellow-gray; little conidia heads radially to loose rod-shaped, olive green; condidiophores smooth-walled, 275-350 µm long; vesicle ball-shaped, 18-25 µm diameter; condiogene cells unseriate, 5-8 x 3,4-5 µm, cover at least the upper two thirds of the vesicles; conidia more or less ball-shaped, finely roughed to thickly thorned, 3-5 µm diameter. Ascomata (Cleisdeadhecien), spherical 120-160 µm, clustered, form a thick layer; Asci 8 spores,  round, 10-12 µm; Ascospore  pale, rough-walled, with a V-shaped equatorial fissure, lens-shaped 4.5-6 x 3.5-4 µm;','Inhalation and nutritive;',null,'Aspergillus hollandicus Gams & Samson','Aspergillus amstelodami (Mangin) Thom & Church,\nAspergillus vitis Novobranova;','Angehöriger der Aspergillus glaucus Gruppe; Kolonien auf Czapekagar (CZ) gehemmt, schnellwachsend auf Agar mit 20% Saccharose, gelb bis matt gelbgrau; Konidienköpfchen radiär bis locker säulenförmig, olivgrün; Konidiophoren glattwandig, 275-350 µm lang; Vesikel kugelförmig, 18-25 µm Durchmesser; Konidiogene Zellen unseriat, 5-8 x 3,4-5 µm, bedecken mindestens die oberen zwei Drittel des Vesikels; Konidien mehr oder weniger kugelförmig, fein angerauht bis dichtstachelig, 3-5 µm Durchmesser. Ascomata (Cleistothecien), kugelig 120-160 µm, geclustert, bilden eine dichte Schicht; Asci 8 sporig, rund oder rundlich, 10-12 µm; Ascosporen blaß, rauhwandig, mit einer V-förmigen äquatorialen Furche, linsenförmig 4,5-6 x 3,5-4 µm;','Inhalativ und nutritiv;',null,'Aspergillus hollandicus Gams & Samson','Moniliaceae','Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (210,8,'m 42','Wheat blight',null,'In cultivation, only one yeast stage is formed. In the host plant, the fungus grows unobtrusively up to the ripening of the blight spore .','Inhalation;',null,'Weizenbrand',null,'In Kultur wird nur ein Hefestadium gebildet. In der Wirtspflanze wächst der Pilz unscheinbar bis zur Ausbildung der Brandsporen.','Inhalativ;',null,'Ustilago tritici (Persoon : Persoon) Rostrup','Ustilaginaceae','Ustilaginales',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (211,8,'m 43','Brewer’s yeast','Saccharomyces boulardii Seguela et al., Saccharomyces chodatii Steiner, Saccharomyces cordubensis Santa María, Saccharomyces coreanus Saito, Saccharomyces diastaticus Andrews & Gilliland ex van der Walt, Saccharomyces ellipsoideus Reess var. ellipsoideus, Saccharomyces steineri Lodder & Kreger-van Rij, Saccharomyces gaditensis Santa María, Saccharomyces hienipiensis Santa María, Saccharomyces hispalensis Santa María, Saccharomyces hispanica Santa María, Saccharomyces lindneri Guilliermond, Saccharomyces logos Van Laer ex A. Jörgensen, Saccharomyces norbensis Santa María, Saccharomyces oleaceus Santa María, Saccharomyces oleaginosus Santa María, Saccharomyces onubensis Santa María, Saccharomyces prostoserdovii Kudryavtsev, Saccharomyces odessa Schnegg & Oehlkers, Saccharomyces italicus Castelli var.iItalicus, Saccharomyces willianus Saccardo, Saccharomyces aceti Santa María, Saccharomyces beticus Marcilla ex Santa María, Saccharomyces capensis van der Walt & Tscheuschner, Saccharomyces brasiliensis Lindner, Candida robusta Diddens & Lodder; brewer’s yeast, backer’s yeast;','Colonies slow growing, cream colored, damp; budding cells wide ellipsoid, buds multilateral; sometimes exist pseudomycel; ascospore  form in 1-4 in budded cells, round to wide ellipsoid, smooth-walled;','Nutritive;',null,'Brauereihefe','Saccharomyces boulardii Seguela et al.,\nSaccharomyces chodatii Steiner,\nSaccharomyces cordubensis Santa María,\nSaccharomyces coreanus Saito,\nSaccharomyces diastaticus Andrews & Gilliland ex van der Walt,\nSaccharomyces ellipsoideus Reess var. ellipsoideus,\nSaccharomyces steineri Lodder & Kreger-van Rij,\nSaccharomyces gaditensis Santa María,\nSaccharomyces hienipiensis Santa María,\nSaccharomyces hispalensis Santa María,\nSaccharomyces hispanica Santa María,\nSaccharomyces lindneri Guilliermond,\nSaccharomyces logos Van Laer ex A. Jörgensen,\nSaccharomyces norbensis Santa María,\nSaccharomyces oleaceus Santa María,\nSaccharomyces oleaginosus Santa María,\nSaccharomyces onubensis Santa María,\nSaccharomyces prostoserdovii Kudryavtsev,\nSaccharomyces odessa Schnegg & Oehlkers,\nSaccharomyces italicus Castelli var.iItalicus,\nSaccharomyces willianus Saccardo,\nSaccharomyces aceti Santa María,\nSaccharomyces beticus Marcilla ex Santa María,\nSaccharomyces capensis van der Walt & Tscheuschner,\nSaccharomyces brasiliensis Lindner,\nCandida robusta Diddens & Lodder;\nBrauhefe, Bäckerhefe;','Kolonien langsam wachsend, cremefarben, feucht; Knospende Zellen breit ellipsoid, Knospung multilateral; manchmal Pseudomycel vorhanden; Ascosporen werden zu 1-4 in geknospten Zellen gebildet, rund bis breit ellipsoid, glattwandig;','Nutritiv;',null,'Saccharomyces cerevisiae Meyen ex Hansen','Saccharomycetaceae','Endomycetales',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (212,8,'m 45','Chaetomium globosum Kunze ex Steud. 1824','Chaetomidium barbatum Traaen, Chaetomium coarctatum Sergejeva, Chaetomium fibripilium Ames, Chaetomium mollipilium Ames, Chaetomium ochraceum Tschudy, Chaetomium olivaceum Cooke & Ellis, Chaetomium rectum Sergejeva, Chaetomium spiculipilium Ames, Chaetomium subglobosum Sergejeva, Chaetomium subterraneum Swift & Povah, Chaetomium lusitanicum M. Gomes, Chaetomium affine Corda, Chaetomium globosum var. affine Tschudy, Chaetomium kunzeanum Zopf, Chaetomium kunzeanum var. chlorina Saccardo, Chaetomium spirale Zopf;','Colonies on oat agar (OA) grow rapidly, with pale or olive-colored air mycelium, often with yellow, gray-green, green or red exudates; Ascomata (perithezies) spherical to oval 175-280 µm diameter, wall (Peridium) brown; ascomata with numerous hairs, these are usually unbranched, bent or twisted, septate, brownish to 500 µm long; asci 8-spores, club-shaped, 30-40 x 11-16 µm; ascospore  lemon-shaped, flattened on the side, usually brownish, 9-12 x 8-10 x 6-8 µm with an apical seed pore;','Inhalation and nutritive;',null,'Chaetomium globosum Kunze ex Steud. 1824','Chaetomidium barbatum Traaen,\nChaetomium coarctatum Sergejeva,\nChaetomium fibripilium Ames,\nChaetomium mollipilium Ames,\nChaetomium ochraceum Tschudy,\nChaetomium olivaceum Cooke & Ellis,\nChaetomium rectum Sergejeva,\nChaetomium spiculipilium Ames,\nChaetomium subglobosum Sergejeva,\nChaetomium subterraneum Swift & Povah,\nChaetomium lusitanicum M. Gomes,\nChaetomium affine Corda,\nChaetomium globosum var. affine Tschudy,\nChaetomium kunzeanum Zopf,\nChaetomium kunzeanum var. chlorina Saccardo,\nChaetomium spirale Zopf;','Kolonien auf Haferagar (OA) schnellwachsend, mit blassem oder olivfarbenem Luftmyzel, häufig mit gelben, graugrünen, grünen oder roten Exudaten; Ascomata (Perithezien) kugelig bis oval 175-280 µm Durchmesser, Wand (Peridium) braun; Ascomata mit zahlreichen Haaren, diese gewöhnlich unverzweigt, gebogen oder sich windend, septiert, bräunlich bis 500 µm lang; Asci 8-sporig, keulenförmig, 30-40 x 11-16 µm; Ascosporen zitronenförmig, seitlich abgeflacht, gewöhnlich bräunlich, 9-12 x 8-10 x 6-8 µm mit einer apikalen Keimpore;','Inhalativ und nutritiv;',null,'Chaetomium globosum Kunze ex Steud. 1824','Chaetomiaceae','Sordariales',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (213,8,'m 47','Aspergillius nidulans (Eidam) Winter',null,'The Aspergillus nidulans group provides the name; colonies on Czapek agar (CZ) grow rapidly, green, cream-leather colored or honey yellow, back side dark purple; conidia heads short and pillar-shaped, up to 80 µm long; conidophore stems brown, 60-130 x 2.5-3 µm; vesicle hemispheric, 8-10 µm diameter; conidiogene cells biserrate, 5,9 x 2-3 µm; metulae 5-6 x 2,3 µm; conidia spherical, with wrinkled surface, almost hyaline, greenish when in great amounts, 3-4 µm; ascomata spherical, purplish, 100-200 µm, surrounded by a yellowish to cinnamon-colored layer of fungal threads surrounded by dense aggregations of pale yellow, thick-walled roundish peridium cells; 8-spore asci, round to roundish, 7-12 µm; ascospores  purplish-red, smooth-walled, with two equatorial ridges (crista), lentil-shaped, 3.8-4.5 x 3.5-4 µm (excluding the ridges (crista);','Inhalation;',null,'Aspergillius nidulans (Eidam) Winter',null,'Der Aspergillus nidulans Gruppe den Namen gebend;\nKolonien auf Czapekagar (CZ) schnellwachsend, grün, crème-lederfarben oder honiggelb, Rückseite dunkelpurpurn;\nKonidienköpfe kurz, säulenförmig, bis zu 80 µm lang; Konidophorenstiele braun, 60-130 x 2,5-3 µm; Vesikel halbkugelig, 8-10 µm Durchmesser; Konidiogene Zellen biseriat, 5,9 x 2-3 µm; Metulae 5-6 x 2,3 µm; Konidien kugelig, mit faltiger Oberfläche, fast hyalin, in Massen grünlich, 3-4 µm;\nAscomata kugelig, purpurn, 100-200 µm, umgeben von einer gelblichen bis zimtfarbenen Schicht Hyphen, welche dichte Aggregationen  blassgelber, dickwandiger, rundlicher Hüllzellen umgeben;  Asci 8-sporig, rund bis rundlich, 7-12 µm; Ascosporen purpurrot, glattwandig, mit zwei äquatorialen Kämmen, linsenförmig, 3,8-4,5 x 3,5-4 µm (ausschließlich der Kämme);','Inhalativ;',null,'Aspergillius nidulans (Eidam) Winter','Moniliaceae','Hyphomycetes',null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (214,8,'m 902','Pullularia pullulans (de Bary) Berkh.','Hormonema pullulans (de Bary) Robak; Aureobasidium pullulans (de Bary) Arn.','colonies auf malt agar (MEA) grow rapidly, smooth, soon covered with a slimy extrusion, cream colored or pink, later usually becoming brown or black; vegetative hyphen 3-12 µm wide, hyaline, locally changing into black-brown, thick-walled chlamydospores; expanding hyphen with irregular dichotomic branchings; undifferentiated conidiogene cells, usually intercalar in hyaline hyphen; conidia are produced in thick groups synchronal on small denticles. Later new ones are developed there. The Conidia remain in slimy heads, conidia hyaline, ellipsoid, very variable in form and size, (7.5)9-11(-16) x (3.5-)4-5.5(-7) µm, single-celled, often with a inconspicuous scar; buds open, endoconides open in intercalaral cells;','Inhalation and nutritive;',null,'Pullularia pullulans (de Bary) Berkh.','Hormonema pullulans (de Bary) Robak;\nAureobasidium pullulans (de Bary) Arn.','Kolonien auf Malzagar (MEA) schnellwachsend, glatt, bald mit einem schleimigen Exudat bedeckt, crèmefarben oder pink, später meist braun oder schwarz werdend; vegetative Hyphen 3-12 µm breit, hyalin, lokal sich in schwarzbraune, dickwandige Chlamydosporen umwandelnd; expandierende Hyphen mit unregelmäßig dichotomen Verzweigungen; konidiogene Zellen undifferenziert, meist interkalar in hyalinen Hyphen; Konidien werden in dichten Gruppen synchron auf kleinen Dentikeln produziert. Später werden dort neue gebildet. Die Konidien verbleiben in schleimigen Köpfen. Konidien hyalin, ellipsoid, sehr variabel in Form und Größe, (7,5)9-11(-16) x (3,5-)4-5,5(-7) µm, 1-zellig, oft mit einer unscheinbaren Narbe; Knospung häufig, Endokonidien oft in interkalaren Zellen;','Inhalativ und nutritiv;',null,'Pullularia pullulans (de Bary) Berkh.',null,'Hyphomycetes',null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (215,4,'f 84','Kiwi',null,null,null,null,'Kiwi',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (216,4,'f 122','Plum',null,null,null,null,'Pflaume',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (217,4,'f 91','Mango',null,null,null,null,'Mango',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (218,4,'f 292','Guava fruit',null,null,null,null,'Guave',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (219,4,'f 4','Wheat flour',null,null,null,null,'Weizenmehl',null,null,null,null,null,null,null,6,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (220,4,'f 6','Barley flour',null,null,null,null,'Gerstenmehl',null,null,null,null,null,null,null,6,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (221,4,'f 7','Oat flour',null,null,null,null,'Hafermehl',null,null,null,null,null,null,null,6,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (222,4,'f 5','Rye flour',null,null,null,null,'Roggenmehl',null,null,null,null,null,null,null,6,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (223,4,'f 9','Rice',null,null,null,null,'Reis',null,null,null,null,null,null,null,6,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (224,4,'f 92','Banana',null,null,null,null,'Banane',null,null,null,null,null,null,null,5,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (225,4,'f 293','Papaya',null,null,null,null,'Papaya',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (226,6,'s 2','Curry',null,null,null,null,'Curry',null,null,null,null,null,null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (227,6,'s 6','Paprika, condiment',null,null,null,null,'Paprika, Gewürz-',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (228,6,'f 263','Pepper',null,null,null,null,'Pfeffer, Grüner',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (229,6,'s 7','Pepper',null,null,null,null,'Pfeffer',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (230,4,'f 13','Peanut',null,null,null,null,'Erdnuss',null,null,null,null,null,null,null,7,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (231,1,'k 82','Latex','Natural caoutchouc, paracaoutchouc;','Natural latex is the milk sap emulsion of certain (mostly tropical) plants. The most important source for rubber production is the caoutchouc tree, Hevea brasiliensis (Willd.) Muell. Arg., belonging to the spurge (wolf''s-milk) family. Latex is extracted from the strictly tropical species indigenous to the Amazon basin by scratching the secondary bark. Latex contains an average of 65% water, 33% rubber (caoutchouc; cis-1-4-Isopren), up to 2% resin and 1.8% allergologically relevant protein. After harvesting, a premature coagulation is inhibited by adding  ammonia, or acids are directly added to coagulate the substance into raw caoutchouc. This is later vulcanized for the manufacture of rubber, i.e.  kneaded with sulphur and fillers at 140°C. A sulphur content of 4 – 5% produces a soft, elastic rubber and a content of 25 – 30% produces hard rubber.','Contactive, inhalative;','The proteins contained in the milk sap;','Latex','Naturkautschuk, Parakautschuk;','Naturlatex ist die Milchsaftemulsion bestimmter, meist tropischer Pflanzen. Wichtigster Lieferant für die Gummiproduktion ist der Parakautschukbaum,  Hevea brasiliensis (Willd.) Muell. Arg., ein Wolfsmilchgewächs.\nDie aus dem Amazonasbecken stammende, streng tropische Art erlaubt die Latexgewinnung durch Anritzen der sekundären Rinde. Latex enthält im Mittel neben 65% Wasser 33% Kautschuk (cis-1-4-Isopren), bis 2% Harz und 1,8% allergologisch relevantes Eiweiß.\nNach der Ernte verhindert man vorzeitiges Gerinnen durch Ammoniakzusatz oder er wird direkt durch Zusatz von Säuren zu Rohkautschuk koaguliert. Zur Gummiherstellung wird dieser später vulkanisiert, d. h. bei 140°C mit Schwefel und Füllstoffen verknetet. Dabei führt ein Schwefelgehalt von 4 – 5% zu weichem, elastischem Gummi und ein Gehalt von 25 – 30% zu Hartgummi.  \n','Kontaktiv, inhalativ;','Die im Milchsaft enthaltenen Proteine;',null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (232,4,'f 49','Apple',null,null,null,null,'Apfel',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (233,4,'f 94','Pear',null,null,null,null,'Birne',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (234,4,'f 95','Peach',null,null,null,null,'Pfirsich',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (235,4,'f 271','Apricot',null,null,null,null,'Aprikose',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (236,4,null,'Lychee',null,null,null,null,'Lychee',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (237,4,'f 33','Orange',null,null,null,null,'Orange',null,null,null,null,null,null,null,5,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (238,6,'s 901','Celery',null,null,null,null,'Sellerie',null,null,null,null,null,null,null,null,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (239,6,'s 11','Dill',null,null,null,null,'Dill',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (240,6,'s 3','Caraway seed',null,null,null,null,'Kümmel',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (241,6,'s 202','Coriander',null,null,null,null,'Koriander',null,null,null,null,null,null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (242,4,'f 19','Edible chestnut',null,null,null,null,'Esskastanie',null,null,null,null,null,null,null,7,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (243,4,null,'Poppy seeds',null,null,null,null,'Mohnsamen',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (244,4,'f 908','Pig gelatine',null,null,null,null,'Gelatine, Schweine-',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (245,4,'f 909','gelatine, beef',null,null,null,null,'Gelatine, Rinder-',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (246,4,'f 801','Fruit gums',null,null,null,null,'Gummibärchen',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (247,1,null,'Ficus benjamini (Tropic Laurel, Weeping Fig)',null,'The ornamental fig Ficus benjamina L. is indigenous in the greater East Asian-Indian-Australian area. The plant has a dense foliage of oval-pointed leathery leaves, and is a small-growing, often bush-like tree of the mulberry plant family, with overhanging branches. The genus Ficus includes more than 1,000 different species. In indigenous areas the plant is used as a host tree for lac insects, from whose secretions shellac is extracted, and it also serves as a latex supplier for the manufacture of rubber. In Europe the Tropic Laurel has grown to become one of the most popular decorative plants for living rooms and businesses. Such species do not blossom. Likewise kept as indoor plants are the rubber plant, Ficus elastica, the fiddle leaf fig, Ficus lyrata, the clown fig, Ficus aspera, the mistletoe fig, Ficus deltoidea as well as Ficus cannonii, Ficus rubiginosa, Ficus sagittata, Ficus montana, Ficus pumila and Ficus villosa.','Inhalative and contactive;','The proteins in the milk sap. The patient.allergens also make their way to the leaf surface and bind themselves to dust particles there. This way they are also present in house dust.','Ficus benjamini (Birkenfeige)',null,'Die Zierfeige Ficus benjamina L. ist im Ostasiatisch-Indisch-Australischen Raum beheimatet. Es handelt sich um einen dicht mit oval zugespitzten, ledrigen Blättern belaubten, kleinwüchsigen, oft strauchartigen Baum mit überhängenden Zweigen aus der Familie der Maulbeerbaumgewächse. Die Gattung Ficus fasst über 1000 verschiedene Arten zusammen. \nIn ihrer Heimat dient die Pflanze zum einen als Wirtsbaum für Lackschildläuse, aus deren Sekreten Schelllack gewonnen wird und zum anderen als Latexlieferant zur Herstellung von Kautschuk. \nIn Europa zählt die Birkenfeige mittlerweile zu den populärsten Dekorationspflanzen in Wohn- und Geschäftsräumen. Als solche gelangt die Art nicht zur Blüte.\nEbenfalls als Zimmerpflanzen gehalten werden der Gummibaum, Ficus elastica, die Geigenfeige, Ficus lyrata, die Clownfeige, Ficus aspera, die Mistelfeige, Ficus deltoidea sowie Ficus cannonii, Ficus rubiginosa, Ficus sagittata, Ficus montana, Ficus pumila und Ficus villosa.\n','Inhalativ und kontaktiv;','Die im Milchsaft enthaltenen Proteine. Die Allergene gelangen auch an die Blattoberfläche und binden sich dort an Staubpartikel. So sind sie im Anschluss auch im Hausstaub präsent.  ','Ficus benjamina L.','Moraceae',null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (248,4,'f 87','Melon',null,null,null,null,'Melone',null,null,null,null,null,null,null,5,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (249,4,'f17','Hazelnut',null,null,null,null,'Haselnuss',null,null,null,null,null,null,null,7,1,12,3,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (250,4,'f16','Walnut',null,null,null,null,'Walnuss',null,null,null,null,null,null,null,7,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (251,4,'f51','Soy meal',null,null,null,null,'Sojaschrot',null,null,null,null,null,null,null,8,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (252,4,'f219','Fennel seed',null,null,null,null,'Fenchelsamen',null,null,null,null,null,null,null,10,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (253,4,'f73','Cherry',null,null,null,null,'Kirsche',null,null,null,null,null,null,null,5,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (254,9,null,'Blomia tropicalis',null,null,'Inhalation; the dead individuals and their dried out excrement eventually with time turn to dust. This is lifted into the air by handling the supplies or by activities in the house.','Probably body and excrement proteins','Blomia tropicalis',null,null,'Inhalativ; die abgestorbenen Tiere und deren ausgetrockneter Kot zerfallen mit der Zeit zu Staub. Dieser wird bei der Handhabung der Vorräte oder bei Aktivitäten im Haus aufgewirbelt.','Wahrscheinlich Körper- und Kotproteine','Blomia tropicalis; Glycyphagidae; Acari, Milben',null,null,null,1,12,2,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (255,9,null,'Silverfish','Zuckergast',null,'Inhalation; dead individuals and their remains turn to dust in time and then can enter the breathing air. In house dust samples, up to 0.01% silverfish protein has been detected.','Probably body and excrement proteins','Silberfischchen','Zuckergast',null,'Inhalativ; tote Tiere und deren Hinterlassenschaften zerfallen mit der Zeit zu Staub und können so schließlich in die Atemluft gelangen. In Hausstaubproben konnte bereits 0,01% Silberfischprotein nachgewiesen werden. ','Wahrscheinlich Körper- und Kotproteine','Lepisma saccharina L., Lepismatidae, Fischchen; Thysanura, Borstenschwänze',null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (256,4,'f23','Shrimp',null,null,null,null,'Garnele',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (257,4,'f80','Lobster',null,null,null,null,'Hummer',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (258,4,'f234','Crab',null,null,null,null,'Krabbe',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (259,4,'f71','Crayfish',null,null,null,null,'Languste',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (260,4,'f24','Scampi',null,null,null,null,'Scampi',null,null,null,null,null,null,null,9,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (261,8,null,'Pityrosporum, oval','Cryptococcus malassezi (Sabouraud) Benedek; Cryptococcus ovalis Vuillemin; Cryptococcus psoriasis Rivolta; Dermatophyton malassez Dold; Malassezia ovalis (Bizzozero) Acton & Panja; Malassezia tropica (Castellani) Schmitter; Microsporon furfur C.E. Robin; Monilia furfur (C.E. Robin) Vuillemin; Oidium furfur (C.E. Robin) Zopf; Pityrosporum orbiculare Gordon; Pityrosporum ovale (Bizzozero) Castellani & Chalmers; Saccharomyces capillitii Oudemans & Pekelharing; Saccharomyces ovalis Bizzozero; Saccharomyces sphaericus Bizzozero; Sporotrichum furfur (C.E. Robin) Saccardo; Torulopsis ovalis (Bizzozero) de Almeida','The species requires an oil-rich substrate for growth; i.e. Sabouraud Dextroseagar covered with olive oil. They build cream-colored to yellow yeast colonies which are smooth or slightly folded, shining or matte, smooth edged or serrated. After 3 days at 37 °C, two forms can appear: 1. An oval form with predominantly ovoid, ellipsoid to cylindrical cells of 2.0-6.0 x 1.5-4.5 µm diameter and 2. a ball-like form with predominantly round cells of 2.5-4.5 µm diameter. The buds are monopolar with a wide base. On the skin the species behaves dimorphic, that is, in addition to the yeast cells they also build hyphen.','Skin contact',null,'Pityrosporum ovale','Cryptococcus malassezi (Sabouraud) Benedek; \nCryptococcus ovalis Vuillemin; \nCryptococcus psoriasis Rivolta; \nDermatophyton malassez Dold; \nMalassezia ovalis (Bizzozero) Acton & Panja; \nMalassezia tropica (Castellani) Schmitter; \nMicrosporon furfur C.E. Robin; \nMonilia furfur (C.E. Robin) Vuillemin; \nOidium furfur (C.E. Robin) Zopf; \nPityrosporum orbiculare Gordon; \nPityrosporum ovale (Bizzozero) Castellani & Chalmers; \nSaccharomyces capillitii Oudemans & Pekelharing; \nSaccharomyces ovalis Bizzozero; \nSaccharomyces sphaericus Bizzozero; \nSporotrichum furfur (C.E. Robin) Saccardo; \nTorulopsis ovalis (Bizzozero) de Almeida \n','Die Art benötigt zum Wachstum ein ölhaltiges Substrat; z.B. mit Olivenöl überschichteter Sabouraud Dextroseagar. Sie bildet cremefarbige bis gelbliche Hefekolonien, die glatt bis leicht gefaltet, glänzend oder matt, ganzrandig oder eingebuchtet sind.\nNach 3 Tagen bei 37 °C können zwei Formen auftreten: 1. Eine ovale Form mit überwiegend ovoiden, ellipsoiden bis zylindrischen Zellen von 2,0-6.0 x 1,5-4,5 µm Durchmesser und 2. eine kugelige Form mit überwiegend runden Zellen von 2,5-4,5 µm Durchmesser.\nDie Knospung erfolgt monopolar mit breiter Basis.\nAuf der Haut verhält sich die Art dimorph, d.h. sie bildet zusätzlich zu den Hefezellen auch Hyphen.\n','Hautkontakt',null,'Pityrosporum ovale',null,null,null,1,12,1,2);
INSERT INTO patient.allergens (id,groupid,code,name_en,synonyms_en,description_en,invasion_en,trigger_en,name_de,synonyms_de,description_de,invasion_de,trigger_de,name_latin,family_latin,order_latin,food_typeid,exposition_from,exposition_to,clinical_relevance,datasource) VALUES (262,2,null,'Red Fescue',null,'20 cm to 60 cm high, runner-forming, grassy meadow grasses with greenish to red ears and 1 mm to 2 mm long grains; perennial; leaves 3 mm wide at most; the base leaves in fact are bristly; flowering time: VI - VII; average  fodder grass; eight minor species or subspecies have  been described.','Inhalation (June – July);','Pollen','Roter Schwingel',null,'20 cm bis 60 cm hohes, Ausläufer bildendes, lockerrasiges Rispengras mit grünlichen bis rötlichen Ährchen und 1 mm bis 2 mm langen Grannen; mehrjährig; Blätter höchstens 3 mm breit; die Grundblätter sogar nur borstlich;\nBlütezeit: VI - VII; mittelwertiges Futtergras; es wurden 8 Kleinarten bzw. Unterarten beschrieben.\n','Inhalativ (Juni – Juli);','Pollen','Festuca rubra L.','Poaceae',null,null,6,7,2,2);
