/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.statistics;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

import lu.tudor.santec.gecamed.core.ejb.session.beans.TemplateManagerBean;
import lu.tudor.santec.gecamed.core.ejb.session.interfaces.TemplateManagerInterface;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.ErrorDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.PrintPreviewDialog;
import lu.tudor.santec.gecamed.core.utils.JasperTemplateBean;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientIncidentStatisticStub;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.PatientAdminBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientAdminInterface;
import lu.tudor.santec.i18n.Translatrix;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


/**
 * 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientIncidentStatisticsPrinter.java,v $
 * <br>Revision 1.6  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.5  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.4  2013-01-22 14:21:38  ferring
 * <br>iReport templates will now be compiled only once until the server is stopped
 * <br>
 * <br>Revision 1.3  2010-04-08 14:57:14  hermen
 * <br>jasper templates are now compiled on demand from the jrxml files
 * <br>
 * <br>Revision 1.2  2009-10-06 14:16:13  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.1  2009-03-16 14:17:27  hermen
 * <br>added patient incident statistics
 * <br>
 *
 */
public class PatientIncidentStatisticsPrinter
{
	
	static PatientIncidentStatisticsDialog	dialog	= new PatientIncidentStatisticsDialog();
	private static Date						dateFrom;
	private static Date						dateTo;
	private static Integer					siteID;
	
	/**
	 * static logger for this class
	 */
	private static Logger					logger	= Logger.getLogger(PatientIncidentStatisticsPrinter.class.getName());
	
	
	public static void printStatistic()
	{
		
		if (dialog.showDialog())
		{
			dateFrom = dialog.getFromDate();
			dateTo = dialog.getToDate();
			siteID = dialog.getSiteID();
			
			new Thread()
			{
				private JasperReport	report;
				
				
				public void run()
				{
					try
					{
						
						MainFrame.getInstance().setWaitCursor(true);
						
						PatientAdminInterface patientAdmin = (PatientAdminInterface) ManagerFactory.getRemote(PatientAdminBean.class);
						
						Collection<PatientIncidentStatisticStub> c = patientAdmin.getPatientIncidentStatistics(siteID, dateFrom, dateTo);
						
						for (PatientIncidentStatisticStub pis : c)
						{
							if (pis.getPatientTitle() != null)
								pis.setPatientTitle(Translatrix.getTranslationString("Title." + pis.getPatientTitle()));
						}
						
						JRDataSource dataSource = new JRBeanCollectionDataSource(c);
						
						
						if (report == null)
						{
							try
							{
								TemplateManagerInterface templateManager = (TemplateManagerInterface) ManagerFactory.getRemote(TemplateManagerBean.class);
//								JasperDesign design = (JasperDesign) JRXmlLoader.load(PatientManagerModule.class.getResourceAsStream("templates/patient_incident_list.jrxml"));
//								report = templateManager.compileReport(design);
								report = templateManager.findTemplate(JasperTemplateBean.PATIENT_INCIDENTS);
							}
							catch (Exception e)
							{
								logger.log(Level.WARN, "error getting templateManager", e);
							}
						}
						
						
						HashMap<String, Object> parameters = new HashMap<String, Object>();
						parameters.put("dateFrom", dateFrom);
						parameters.put("dateTo", dateTo);
						
						JasperPrint jp = JasperFillManager.fillReport(report, parameters, dataSource);
						
						PrintPreviewDialog ppDialog = new PrintPreviewDialog();
						ppDialog.doPrint(jp);
						
						
					}
					catch (Exception e1)
					{
						ErrorDialog.showErrorDialog(MainFrame.getInstance(), e1);
						e1.printStackTrace();
					}
					MainFrame.getInstance().setWaitCursor(false);
				}
			}.start();
			
		}
	}
	
	
}
