/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.statistics;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Site;
import lu.tudor.santec.i18n.Translatrix;
import bizcal.util.DateUtil;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

/**
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientIncidentStatisticsDialog.java,v $
 * <br>Revision 1.2  2013-02-19 12:07:34  ferring
 * <br>GECAMedLists changed. Will now automatically load list of all beans
 * <br>
 * <br>Revision 1.1  2009-03-16 14:17:27  hermen
 * <br>added patient incident statistics
 * <br>
 *
 */
public class PatientIncidentStatisticsDialog extends JDialog implements ActionListener, ComponentListener {

	private static final long serialVersionUID = 1L;

	private JDateChooser dateFromChooser;
	private JDateChooser dateToChooser;
	private JButton okButton;
	private JButton cancelButton;
	private boolean retVal;
	private JComboBox cbSites;
	private DefaultComboBoxModel cbModell;

	public PatientIncidentStatisticsDialog() {
		super(MainFrame.getInstance(), Translatrix.getTranslationString("PatientIncidentStatisticsDialog.createStatistics"), true);
		this.setLayout(new FormLayout(
				"2dlu, pref, 2dlu, fill:pref:grow",
				"2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref:grow, 2dlu, pref, 2dlu"));
		
		this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
		
		this.addComponentListener(this);
		
		CellConstraints cc = new CellConstraints();

		Calendar now = new GregorianCalendar();
		
		this.add(new JLabel(Translatrix.getTranslationString("PatientIncidentStatisticsDialog.from")), cc.xy(2,6));
		dateToChooser = GECAMedGuiUtils.getDateChooser(false);
		dateToChooser.setDate(now.getTime());
		this.add(dateToChooser, cc.xy(4,6));
		
		now.add(Calendar.MONTH, -1);
		
		this.add(new JLabel(Translatrix.getTranslationString("PatientIncidentStatisticsDialog.to")), cc.xy(2,4));
		dateFromChooser = GECAMedGuiUtils.getDateChooser(false);
		dateFromChooser.setDate(now.getTime());
		this.add(dateFromChooser, cc.xy(4,4));
		
		this.cbModell = new DefaultComboBoxModel();
		this.cbSites = new JComboBox(cbModell);
		this.add(new JLabel(Translatrix.getTranslationString("PatientIncidentStatisticsDialog.site")), cc.xy(2,8));
		this.add(cbSites, cc.xy(4,8));
		
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGlue();
		cancelButton = new JButton(Translatrix.getTranslationString("core.cancel"));
		cancelButton.addActionListener(this);
		bb.addGridded(cancelButton);
		bb.addRelatedGap();
		okButton = new JButton(Translatrix.getTranslationString("core.ok"));
		okButton.addActionListener(this);
		okButton.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_ENTER) {
					retVal = true;
					setVisible(false);
				}
			}
		});
		bb.addGridded(okButton);
		
		JPanel bPanel = bb.getPanel();
		bPanel.setOpaque(false);
		this.add(bPanel, cc.xyw(2,10,3));

		this.setSize(300, 170);
	}
	
	/**
	 * initializes and shows the dialog.
	 * @return
	 */
	public boolean showDialog() {
		retVal = false;
		
		cbModell.removeAllElements();
		Site s = new Site();
		s.setName(Translatrix.getTranslationString("PatientIncidentStatisticsDialog.allSites"));
		
		
		cbModell.addElement(s);
		cbSites.setSelectedIndex(0);
		
		List<Site> sites = GECAMedLists.getListReference(Site.class);
		if (sites != null) {
    		for (Site site : sites) {
    		    cbModell.addElement(site);
    		}
		}
		
		this.setLocationRelativeTo(MainFrame.getInstance());
		this.setVisible(true);
		return retVal;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.cancelButton)) {
			this.setVisible(false);
		} else if (e.getSource().equals(this.okButton)) {
			retVal = true;
			setVisible(false);
		}
	}
	
	/**
	 * returns the choosen date
	 * @return
	 */
	public Date getFromDate() {
		return DateUtil.move2Morning(dateFromChooser.getDate());
	}
	
	/**
	 * returns the choosen date
	 * @return
	 */
	public Date getToDate() {
		return DateUtil.move2Midnight(dateToChooser.getDate());
	}

	public void componentHidden(ComponentEvent e) {}
	public void componentMoved(ComponentEvent e) {}
	public void componentResized(ComponentEvent e) {}
	public void componentShown(ComponentEvent e) {
		this.okButton.requestFocusInWindow();
	}

	public Integer getSiteID() {
	    try {
		return ((Site)cbSites.getSelectedItem()).getId();
	    } catch (Exception e) {
		return null;
	    }
	}
	
}

