/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * I18nListPlugin.java
 *
 * Created on July 11, 2005, 3:02 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package lu.tudor.santec.gecamed.patient.gui.simpleview;

import java.awt.BorderLayout;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import com.jgoodies.forms.builder.ButtonBarBuilder;



/**
 * Settings plugin to select wether to use the old style two-column patient view or the
 * new style 3-row patient view with the nice gradient panels.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.10.2007
 * 10:20:25
 *
 *
 * @version
 * <br>$Log: SimpleViewSettingsPlugin.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.1  2007-10-22 09:58:14  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class SimpleViewSettingsPlugin extends SettingsPlugin {
	private static final long serialVersionUID = 1L;
	
	public static final String NAME = "simpleViewSettings";

	
	public static final String DEFAULT_PATIENT_VIEW = "defaultPatientView";
	
	
	public static final Integer ROW_VIEW = 1;
	public static final Integer COL_VIEW = 2;
	
	
	private JPanel selectViewPanel;

	private JLabel selectViewLabel;

	private JToggleButton rowViewButton;

	private JToggleButton colViewButton;


	public SimpleViewSettingsPlugin() {
		super(NAME);
		this.setStationaryValues();
		buildPanel();
	}

	public SimpleViewSettingsPlugin(String p_Name) {
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
	}

	@SuppressWarnings("unchecked")
	private void buildPanel() {
		/* ================================================== */

		setLabel(Translatrix.getTranslationString("pm.simple.setting.menu"));

		this.selectViewPanel = createSubPanel(Translatrix
				.getTranslationString("pm.simple.setting.select"));
		
		this.selectViewLabel = new JLabel(Translatrix.getTranslationString("pm.simple.setting.selectText"));
		/* ------------------------------------------------------- */
		// create the main selection panel
		this.rowViewButton = new JToggleButton(PatientManagerModule.getIcon(PatientManagerModule.VIEW_ROW));
		this.colViewButton = new JToggleButton(PatientManagerModule.getIcon(PatientManagerModule.VIEW_COLUMN));
		
		ButtonGroup bg = new ButtonGroup();
		bg.add(rowViewButton);
		bg.add(colViewButton);
		
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addUnrelatedGap();
		bb.addGridded(rowViewButton);
		bb.addUnrelatedGap();
		bb.addGridded(colViewButton);
		bb.addUnrelatedGap();
		bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		/* ------------------------------------------------------- */
		
		selectViewPanel.setLayout(new BorderLayout());
		
		selectViewPanel.add(selectViewLabel, BorderLayout.NORTH);
		selectViewPanel.add(bb.getPanel(), BorderLayout.CENTER);
		
		addSubPanel(selectViewPanel);

// #####################################################

		setIcon(GECAMedModule.getIcon(GECAMedIconNames.SETTINGS));
		/* ================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#revertToDefaults()
	 */
	public void revertToDefaults() {
		/* ================================================== */
//		this.openPatientModule.setSelectedItem((String) getDefault(OPEN_PATIENT_IN_MODULE));
//		this.inTabs.setSelected((Boolean) getDefault(OPEN_PATIENT_IN_NEW_TAB));
//
//		try {
//			this.charSpinner.setValue((Integer) getDefault(MIN_SEARCH_CHARS));
//			this.delaySlider.setValue((Integer) getDefault(SEARCH_DELAY));
//		} catch (Exception e) {}
		Integer select = (Integer) getDefault(DEFAULT_PATIENT_VIEW);
		if (ROW_VIEW.equals(select))
			this.rowViewButton.setSelected(true);
		if (COL_VIEW.equals(select))
			this.colViewButton.setSelected(true);
		
		reflectSettings();
		
		super.revertToDefaults();
		/* ================================================== */
	}

	public void updateSettings() {
		/* ================================================== */
		Integer select = COL_VIEW;
		if (colViewButton.isSelected())
			select = COL_VIEW;
		if (rowViewButton.isSelected())
			select = ROW_VIEW;
		/* ------------------------------------------------------- */
		setValue(DEFAULT_PATIENT_VIEW, select);
		
//		setValue(OPEN_PATIENT_IN_MODULE, (String) this.openPatientModule.getSelectedItem());
//		setValue(OPEN_PATIENT_IN_NEW_TAB, (Boolean) this.inTabs.isSelected());
//
//		setValue(MIN_SEARCH_CHARS, (Integer) charSpinner.getValue());
//		setValue(SEARCH_DELAY, (Integer) delaySlider.getValue() );

		super.updateSettings();
		/* ================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		/* ================================================== */
		super.reflectSettings();
		
		Integer select = (Integer) getValue(DEFAULT_PATIENT_VIEW);
		
		if (ROW_VIEW.equals(select))
			this.rowViewButton.setSelected(true);
		if (COL_VIEW.equals(select))
			this.colViewButton.setSelected(true);
		/* ================================================== */
		
//		this.openPatientModule.setSelectedItem((String) getValue(OPEN_PATIENT_IN_MODULE));
//		this.inTabs.setSelected((Boolean) getValue(OPEN_PATIENT_IN_NEW_TAB));
//
//		try {
//			this.charSpinner.setValue((Integer) getValue(MIN_SEARCH_CHARS));
//			this.delaySlider.setValue((Integer) getValue(SEARCH_DELAY));
//		} catch (Exception e) {}
	}

	public void relocalize() {
		/* ================================================== */
		super.relocalize();

		setLabel(Translatrix.getTranslationString("pm.simple.setting.menu"));
		setSubPanelTitle(this.selectViewPanel, Translatrix
				.getTranslationString("pm.simple.setting.select"));
		selectViewLabel.setText(Translatrix.getTranslationString("pm.simple.setting.selectText"));
		/* ================================================== */
	}

	public void setStationaryValues() {
		/* ================================================== */
		setStationary(DEFAULT_PATIENT_VIEW, ROW_VIEW);
		/* ================================================== */
	}


}
