package lu.tudor.santec.gecamed.patient.gui.settings;

import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;

public class InsurancesRenderer implements ListCellRenderer // extends DefaultListCellRenderer
{
	@SuppressWarnings("unchecked")
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus)
	{
		Map<TextAttribute, Object>	attributes;
		
		Insurance		insurance	= (Insurance) value;
		StringBuilder	text		= new StringBuilder("<html>");
		JLabel			label		= new JLabel();
		
		
		if (insurance != null)
		{
			if (insurance.getDisbanded())
				text.append("<font color=\"#C0C0C0\">");
			else if (insurance.getPrimary())
				text.append("<b>");
			
			text.append(insurance.toString());
		}
		
		attributes	= (Map<TextAttribute, Object>) label.getFont().getAttributes();
		attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
		label.setFont(new Font(attributes));
		label.setText(text.toString());
		
		return label;
	}
}
