package lu.tudor.santec.gecamed.patient.gui.settings;

/**
 * Class for the important data panel settings.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ImportantDataPanelConfig.java,v $
 * <br>Revision 1.3  2013-11-06 11:15:33  troth
 * <br>Remove the name of the ImportantData in the settings.
 * <br>
 * <br>Revision 1.2  2013-09-11 13:11:55  troth
 * <br>Code cleanup.
 * <br>
 * <br>Revision 1.1  2013-09-11 11:00:28  troth
 * <br>Add global settings for the ImportantDataPanel to enable / disable and set the position of a Panel.
 * <br>
 */
public class ImportantDataPanelConfig
{
	private String id;
	private boolean enabled;
	private int position;
	private String valueString;
	private static final String DELIMITER = ";";
	
	public ImportantDataPanelConfig(String id, boolean enabled, int position)
	{
		this.id = id;
		this.enabled = enabled;
		this.position = position;
		this.valueString = createSaveValue(id, enabled, position);
	}
	
	public ImportantDataPanelConfig(String value)
	{
		setAllAttributes(value);
	}
	
	public String getId()
	{
		return this.id;
	}
	
	
	public boolean getEnabled()
	{
		return this.enabled;
	}
	
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	public boolean isEnabled() {
		return this.enabled;
	}
	
	public int getPosition()
	{
		return this.position;
	}
	
	public void setPosition(int position)
	{
		this.position = position;
	}
	
	public String createSaveValue(String id, boolean enabled, int position)
	{
		this.valueString = id + DELIMITER + enabled + DELIMITER + position;
		return this.valueString;
	}
	
	public String createSaveValue()
	{
		this.valueString = this.id + DELIMITER + this.enabled + DELIMITER + this.position;
		return this.valueString;
	}
	
	public void setAllAttributes(String value)
	{
		if (value == null)
		{
			this.id = null;
			return;
		}
		
		String[] splitResult = value.split(DELIMITER);
		if(splitResult.length == 3)
		{
			this.id = splitResult[0];
			this.enabled = Boolean.parseBoolean(splitResult[1]);
			this.position = Integer.parseInt(splitResult[2]);
			this.valueString = value;
		}else{
			this.id = null;
		}
	}
}
