package lu.tudor.santec.gecamed.patient.gui.settings;

import lu.tudor.santec.i18n.Translatrix;

public class HistoryTabEntryConfig {
	private String id;
	private boolean enabled;
	private int position;
	private String filters="";
	private String valueString;
	private static final String DELIMITER = ";";
	
	public HistoryTabEntryConfig(String id, boolean enabled, int position)
	{
		this.id = id;
		this.enabled = enabled;
		this.position = position;
		this.filters= "";
		this.valueString = createSaveValue(id, enabled, position);
	}
	
	public HistoryTabEntryConfig(String id, boolean enabled, int position,String filters)
	{
		this.id = id;
		this.enabled = enabled;
		this.position = position;
		this.filters= filters;
		this.valueString = createSaveValue(id, enabled, position);
	}
	
	public HistoryTabEntryConfig(String value)
	{
		setSettings(value);
	}
	
	public String getFilters()
	{
		return this.filters;
	}
	
	public void setFilters(String filters)
	{
		this.filters=filters;
	}
	
	public String getId()
	{
		return this.id;
	}
	
	public void setId(String id)
	{
		this.id=id;
	}
	
	
	public boolean getEnabled()
	{
		return this.enabled;
	}
	
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	public boolean isEnabled() {
		return this.enabled;
	}
	
	public int getPosition()
	{
		return this.position;
	}
	
	public void setPosition(int position)
	{
		this.position = position;
	}
	
	public String createSaveValue(String id, boolean enabled, int position)
	{
		this.valueString = id + DELIMITER + enabled + DELIMITER + position;
		return this.valueString;
	}
	
	public String createSaveValue()
	{
		this.valueString = this.id + DELIMITER + this.enabled + DELIMITER + this.position;
		return this.valueString;
	}
	
	public void setAllAttributes(String value)
	{
		if (value == null)
		{
			this.id = null;
			return;
		}
		
		String[] splitResult = value.split(DELIMITER);
		if(splitResult.length == 4)
		{
    				
    		if(splitResult[0].equals("full_view"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.full");
    		}
    		else if(splitResult[0].equals("diagnosis"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.diagnosis");
    		}
    		else if(splitResult[0].equals("letters"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.letters");
    		}
    		else if(splitResult[0].equals("files"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.files");
    		}
    		else if(splitResult[0].equals("prescriptions"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.prescriptions");
    		}
    		else if(splitResult[0].equals("forms"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.forms");
    		}
    		else if(splitResult[0].equals("cda"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.cda");
    		}
    		else
    		{
    			this.id = splitResult[0];
    		}
    				
    				
			
			this.enabled = Boolean.parseBoolean(splitResult[1]);
			this.position = Integer.parseInt(splitResult[2]);
			this.filters = splitResult[3];
			this.valueString = value;
		}else{
			this.id = null;
		}
	}
	
	public void setSettings(String value) {
		if (value == null)
		{
			this.id = null;
			return;
		}
		
		String[] splitResult = value.split(DELIMITER);
		
		if(splitResult.length == 3)
		{
			if(splitResult[0].equals("full_view"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.full");
    		}
    		else if(splitResult[0].equals("diagnosis"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.diagnosis");
    		}
    		else if(splitResult[0].equals("letters"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.letters");
    		}
    		else if(splitResult[0].equals("files"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.files");
    		}
    		else if(splitResult[0].equals("prescriptions"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.prescriptions");
    		}
    		else if(splitResult[0].equals("forms"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.forms");
    		}
    		else if(splitResult[0].equals("cda"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.cda");
    		}
    		else
    		{
    			this.id = splitResult[0];
    		}
			
			this.enabled = Boolean.parseBoolean(splitResult[1]);
			this.position = Integer.parseInt(splitResult[2]);
			this.valueString = value;
		}
		else if(splitResult.length == 4)
		{
			if(splitResult[0].equals("full_view"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.full");
    		}
    		else if(splitResult[0].equals("diagnosis"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.diagnosis");
    		}
    		else if(splitResult[0].equals("letters"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.letters");
    		}
    		else if(splitResult[0].equals("files"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.files");
    		}
    		else if(splitResult[0].equals("prescriptions"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.prescriptions");
    		}
    		else if(splitResult[0].equals("forms"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.forms");
    		}
    		else if(splitResult[0].equals("cda"))
    		{
    			this.id = Translatrix.getTranslationString("patient.history.cda");
    		}
    		else
    		{
    			this.id = splitResult[0];
    		}
			this.enabled = Boolean.parseBoolean(splitResult[1]);
			this.position = Integer.parseInt(splitResult[2]);
			this.filters = splitResult[3];
			this.valueString = value;
		}else{
			this.id = null;
		}
	}
	
 
	public String getSettings() {
		this.valueString = this.id + DELIMITER + this.enabled + DELIMITER + this.position + DELIMITER + this.filters;
		return this.valueString;
	}
}


