package lu.tudor.santec.gecamed.patient.gui.settings;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntryType;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ConsultationConfigDialog.java,v $
 * <br>Revision 1.11  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.10  2013-12-03 16:29:45  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.9  2013-11-29 15:16:17  troth
 * <br>Fix some bugs:
 * <br>Consultation view if first panel is empty
 * <br>History view sickleave date
 * <br>
 * <br>Revision 1.8  2013-11-29 08:20:22  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.7  2013-11-08 09:48:07  troth
 * <br>Fix Bug: Text content field of entry now can be disable.
 * <br>
 * <br>Revision 1.6  2013-10-30 15:01:03  troth
 * <br>Code clear up.
 * <br>
 * <br>Revision 1.5  2013-10-29 09:45:27  troth
 * <br>The new consultation view with more entries and the sickleave version 3 fix several bugs.
 * <br>
 * <br>Revision 1.4  2013-09-12 14:29:32  troth
 * <br>Add the global 'Measurment Value settings' the ConsultationConfigDialog.
 * <br>
 * <br>Revision 1.3  2013-07-25 14:31:55  troth
 * <br>Now the global settings panel for consultation entries save the data in the setting table of the database.
 * <br>
 * <br>Revision 1.2  2013-07-24 09:12:38  troth
 * <br>Add final version of settings for the consultation config panel.
 * <br>
 */
public class HistoryTabConfigDialog extends GECAMedBaseDialogImpl implements ActionListener, DocumentListener
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	//Types internes (comme dans la bd) -> PatientEntryTypes 
		Collection<IncidentEntryType> entryTypes;
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private JTextField		nameField;
	
	private JTextField		textSearchField;
	
	private boolean 		actionOk = false;
	
	private HistoryTabEntryConfig historytab;
	
	private Vector<JToggleButton> buttonsList;
	
	private String[] enabledTypesID;
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public HistoryTabConfigDialog()
	{
		super(MainFrame.getInstance(), "", OK_CANCEL_BUTTON_MODE);
		buildPanel();
	}
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	private void buildPanel()
	{
		entryTypes = IncidentManagerBean.getInstance().getAllEntryTypes();
		
		IncidentEntryType accEntry= new IncidentEntryType();
		accEntry.setName("Ac");
		
		entryTypes.add(accEntry);
		
		buttonsList=new Vector<JToggleButton>();
		
		JLabel			label;
		CellConstraints	cc		= new CellConstraints();
		int				row		= 0;
		
		
		this.mainPanel.setLayout(new FormLayout("5px, 60dlu, 5px, 60dlu ,5px , 60dlu, 5px,60dlu, 5px", 
				"5px,fill:pref," + // id
				"5px,fill:pref," + // acronym
				"5px,fill:pref," + // name
				"5px,fill:pref," + // code + code field
				"5px,fill:pref," + // color button
				"5px,fill:pref," + // content field
				"5px,fill:pref," + // position
				"5px,fill:pref," + // measurementPanel
				"5px"));
		
		// name
		label = new JLabel(Translatrix.getTranslationString("patient.settings.HistoryTabConfigDialog.nameLabel"));
		label.setOpaque(false);
		this.nameField = new LimitTextField(50);
		this.nameField.getDocument().addDocumentListener(this);
		this.mainPanel.add(label,				cc.xy(2, row+=2));
		this.mainPanel.add(this.nameField,		cc.xyw(4, row, 5));
		
		label=new JLabel(Translatrix.getTranslationString("patient.settings.HistoryTabConfigDialog.searchText"));
		
		this.textSearchField = new LimitTextField(50);
		this.textSearchField.getDocument().addDocumentListener(this);
		
		this.mainPanel.add(label,				cc.xy(2, row+=2));
		this.mainPanel.add(this.textSearchField,		cc.xyw(4, row, 5));
		
		
		label = new JLabel(Translatrix.getTranslationString("patient.settings.HistoryTabConfigDialog.type"));
		this.mainPanel.add(label,				cc.xy(2, row+=2));
		
		int col=2;
	//	row+=2;
		for (IncidentEntryType type : entryTypes) 
		{
			if(!type.getName().equals(""))
			{
				PatientModuleSettings patientGlobalSettings = PatientManagerModule.getInstance().patientSettings;

				String name = type.getName();
				ConsultationEntryConfig entryConfig = new ConsultationEntryConfig((String) patientGlobalSettings.getValue(name));

				if (entryConfig.getId() != null)
					name = entryConfig.getAcronym();
				else {
					if (name.equals("letter"))
						name = IncidentEntryType.LETTERS;
					else if (name.equals("prescription"))
						name = IncidentEntryType.PRESCRIPTIONS;
					else if (name.equals("file"))
						name = IncidentEntryType.FILES;
					else if (name.equals("form"))
						name = IncidentEntryType.FORM;
					else if (name.equals("dicom"))
						name = IncidentEntryType.DICOM;
					else if (name.equals("labo.result"))
						name = IncidentEntryType.LAB;
					else if (name.equals("cda"))
						name = IncidentEntryType.CDA;
						
				}

				final JToggleButton button = new JToggleButton(name);
				button.setMargin(new Insets(0, 0, 0, 0));
				button.setActionCommand(type.getName());
				button.setToolTipText(type.getName());
								
				if (entryConfig.getId() != null) {
					button.setToolTipText(entryConfig.getTranslatedName() + " ["+type.getName()+"]");				
				} else if (! ("IncidentEntryType." + type.getName()).equals(Translatrix.getTranslationString("IncidentEntryType." + type.getName()))) {
					button.setToolTipText(Translatrix.getTranslationString("IncidentEntryType." + type.getName())+ " ["+type.getName()+"]");
				}else {
					button.setToolTipText(type.getName());
				}
				
				buttonsList.add(button);
				
				
				this.mainPanel.add(button,cc.xy(col+=2, row ));
				if(col%8==0)
					{
						row+=2;
						col=2;
					}
				
			}
		}

	}
	
	
	public HistoryTabEntryConfig showDialog(HistoryTabEntryConfig hte)
	{
		historytab=hte;
		setTitle(Translatrix.getTranslationString("patient.settings.HistoryTabConfigDialog.title"));
		this.pack();
		this.setLocationRelativeTo(getOwner());
		iniDialog(historytab);
		
		
		if(!hte.getFilters().equals(""))
		{
			enabledTypesID = hte.getFilters().split(":");
			
			for(JToggleButton but : buttonsList)
			{
				for(String tmp : enabledTypesID)
				{
					if(tmp.charAt(0)==' ' && tmp.charAt(1)==' ')
					{
						tmp.trim();
						this.textSearchField.setText(tmp);
					}
					else if (tmp.equals(but.getActionCommand()))
					{
						but.setSelected(true);
						break;
					}
				}
			}
		}
		
		this.setVisible(true);
		
		
		
	
	 	
    	
		if(this.actionOk)
		{
			//When dialog disapears
			if(!this.nameField.getText().equals(""))
			{
				historytab.setId(this.nameField.getText());
				
				StringBuffer sb = new StringBuffer();
				if(!this.textSearchField.getText().equals(""))
				{
					//Double space to detect it's a string, not a type
					sb.append("  "+this.textSearchField.getText()+":");
				}
		    	for (JToggleButton but : buttonsList) {
		    		
		    		if(but.isSelected())
		    		{
		    			sb.append(but.getActionCommand()+":");
		    		//	System.err.println(sb);
		    		}
		    			
				}
		    	String tmp=sb.toString();
		    	 if (tmp != null && tmp.length() > 0 && tmp.charAt(tmp.length()-1)==':') {
		    		 tmp = tmp.substring(0, tmp.length()-1);
		    	    }
		    	
		    	historytab.setFilters(sb.toString());
				
			}
			return historytab;
		}
		
		return null;
	}
	
	private void iniDialog(HistoryTabEntryConfig hte)
	{
		
		this.nameField.setText(hte.getId());
		enableOkButton();
	
	}
	
	
	@Override
	public void okActionCalled()
	{
		
		
		actionOk = true;
		super.okActionCalled();
	}
	
	public void actionPerformed(ActionEvent ae)
	{
	
	}
	
	public void enableOkButton()
	{
					this.okAction.setEnabled(true);
	}

	public void changedUpdate(DocumentEvent pce)
	{
		documentChange(pce);
	}

	public void insertUpdate(DocumentEvent pce)
	{
		documentChange(pce);
	}

	public void removeUpdate(DocumentEvent pce)
	{
		documentChange(pce);
	}
	
	public void documentChange(DocumentEvent pce)
	{
	
	}
}
