package lu.tudor.santec.gecamed.patient.gui.settings;

import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ConsultationEntryConfig.java,v $
 * <br>Revision 1.9  2013-12-13 15:26:27  troth
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.8  2013-12-03 16:29:45  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.7  2013-11-29 15:16:17  troth
 * <br>Fix some bugs:
 * <br>Consultation view if first panel is empty
 * <br>History view sickleave date
 * <br>
 * <br>Revision 1.6  2013-11-29 09:16:31  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.5  2013-11-29 08:20:22  troth
 * <br>Redesign consultation config dialog.
 * <br>
 * <br>Revision 1.4  2013-07-30 14:18:07  troth
 * <br>Fix bug: the default values was not set if not set in DB.
 * <br>
 * <br>Revision 1.3  2013-07-29 07:51:22  ferring
 * <br>Handling null value in settings
 * <br>
 * <br>Revision 1.2  2013-07-25 14:31:55  troth
 * <br>Now the global settings panel for consultation entries save the data in the setting table of the database.
 * <br>
 * <br>Revision 1.1  2013-07-24 09:12:38  troth
 * <br>Add final version of settings for the consultation config panel.
 * <br>
 */
public class ConsultationEntryConfig
{
	private static final String DELIMITER = ";";
	private static final String TRANSLATION_PREFIX = "patient.incident.";
	 
	private String id;
	private String acronym;
	private String name;
	private String translatedName;
	private String codeLabel;
	private int color;
	private boolean contentField;
	private boolean codeField;
	private boolean enabled;
	private int position;
	private String valueString;
	
	public ConsultationEntryConfig(String id, String acronym, String name, String codeLabel, int color, boolean contentField, boolean codeField, boolean enabled, int position)
	{
		this.id = id;
		this.acronym = acronym;
		this.name = name;
		this.codeLabel = codeLabel;
		this.color = color;
		this.contentField = contentField;
		this.codeField = codeField;
		this.enabled = enabled;
		this.position = position;
		this.valueString = createSaveValue(id, acronym, name, codeLabel, color, contentField, codeField, enabled, position);
	}
	
	
	public ConsultationEntryConfig (String value)
	{
		if (value == null)
			return;
		
		String[] splitResult = value.split(DELIMITER);
		
		if (splitResult.length == 9)
		{
			this.id = splitResult[0];
			this.acronym = splitResult[1];
			this.name = splitResult[2];
			this.codeLabel = splitResult[3];
			this.color = Integer.parseInt(splitResult[4]);
			this.contentField = Boolean.parseBoolean(splitResult[5]);
			this.codeField = Boolean.parseBoolean(splitResult[6]);
			this.enabled = Boolean.parseBoolean(splitResult[7]);
			this.position = Integer.parseInt(splitResult[8]);
			this.valueString = value;
			
			if (name.equals(""))
			{
				setAllAttributesToDefault();
			}
			else if (!id.equals(PatientModuleSettings.NEW_COLUMN))
			{
				if (acronym.equals(""))
					setAllAttributesToDefault();
			}
			else if (!id.equals(IncidentManager.MEASUREMENT) && !id.equals(PatientModuleSettings.NEW_COLUMN))
			{
				if (!contentField && !codeField)
					setAllAttributesToDefault();
			}
		}
		else
		{
			id = null;
			return;
		}
	}
	
	public String getId()
	{
		return this.id;
	}
	
	public String getName() {
		return this.name;
	}
	
	public String getTranslatedName ()
	{
		if (translatedName == null)
		{
			if (id != null && id.equals(name))
			{
				// translate the default names
				String translationKey = new StringBuilder(
								TRANSLATION_PREFIX.length() + id.length())
						.append(TRANSLATION_PREFIX)
						.append(id)
						.toString();
				translatedName = Translatrix.getTranslationString(translationKey);
				if (translatedName == null || translatedName.equals(translationKey))
					translatedName = name;
			}
			else
			{
				translatedName = name;
			}
		}
		
		return translatedName;
	}
	
	public String getAcronym()
	{
		return this.acronym;
	}
	
	public String getCodeLabel()
	{
		return this.codeLabel;
	}
	
	public int getColor()
	{
		return this.color;
	}
	
	public boolean getContentField()
	{
		return this.contentField;
	}
	
	public boolean getCodeField()
	{
		return this.codeField;
	}
	
	public boolean getEnabled()
	{
		return this.enabled;
	}
	
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	public boolean isEnabled() {
		return this.enabled;
	}
	
	public int getPosition()
	{
		return this.position;
	}
	
	public void setPosition(int position)
	{
		this.position = position;
	}
	
	public String createSaveValue(String id, String acronym, String name, String codeLabel, int color, boolean contentField, boolean codeField, boolean enabled, int position)
	{
		this.valueString = id + DELIMITER + acronym + DELIMITER + name + DELIMITER + codeLabel + DELIMITER + color + DELIMITER + contentField + DELIMITER + codeField + DELIMITER + enabled + DELIMITER + position;
		return this.valueString;
	}
	
	public String createSaveValue()
	{
		this.valueString = this.id + DELIMITER + this.acronym + DELIMITER + this.name + DELIMITER + this.codeLabel + DELIMITER + this.color + DELIMITER + this.contentField + DELIMITER + this.codeField + DELIMITER + this.enabled + DELIMITER + this.position;
		return this.valueString;
	}
	
	public void setAllAttributesToDefault()
	{
		PatientModuleSettings.setDefaultPosition = true;
		
		String defaultAttributes = null;
		
		if(this.id.equals(IncidentManager.SOAP_S)) defaultAttributes = PatientModuleSettings.SOAPS_DEFAULTS;
		
		if(this.id.equals(IncidentManager.SOAP_O)) defaultAttributes = PatientModuleSettings.SOAPO_DEFAULTS;
		
		if(this.id.equals(IncidentManager.SOAP_A)) defaultAttributes = PatientModuleSettings.SOAPA_DEFAULTS;
		
		if(this.id.equals(IncidentManager.SOAP_P)) defaultAttributes = PatientModuleSettings.SOAPP_DEFAULTS;
		
		if(this.id.equals(IncidentManager.CONS_1)) defaultAttributes = PatientModuleSettings.CONS1_DEFAULTS;
		
		if(this.id.equals(IncidentManager.CONS_2)) defaultAttributes = PatientModuleSettings.CONS2_DEFAULTS;
		
		if(this.id.equals(IncidentManager.CONS_3)) defaultAttributes = PatientModuleSettings.CONS3_DEFAULTS;
				
		if(this.id.equals(IncidentManager.MEASUREMENT)) defaultAttributes = PatientModuleSettings.MEASUREMENT_DEFAULTS;
				
		if(this.id.equals(IncidentManager.SICK_LEAVE)) defaultAttributes = PatientModuleSettings.SICKLEAVE_DEFAULTS;
		
		String[] splitResult = defaultAttributes.split(DELIMITER);
		if(splitResult.length == 9)
		{
			this.id = splitResult[0];
			this.acronym = splitResult[1];
			this.name = splitResult[2];
			this.codeLabel = splitResult[3];
			this.color = Integer.parseInt(splitResult[4]);
			this.contentField = Boolean.parseBoolean(splitResult[5]);
			this.codeField = Boolean.parseBoolean(splitResult[6]);
			this.enabled = Boolean.parseBoolean(splitResult[7]);
			this.position = Integer.parseInt(splitResult[8]);
			this.valueString = defaultAttributes;
		}
	}
}
