/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.reports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.utils.PrintUtilities;
import lu.tudor.santec.gecamed.core.gui.widgets.ModuleHeader;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Dialog to view HTML reports.
 * used in the hospital version only.
 * RTF reports need to be convertet to html before using the RTFReportTranslator
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: ReportViewer.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-21 15:14:16  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class ReportViewer extends JDialog implements ActionListener {

	private static final long serialVersionUID = 1L;
	private ModuleHeader titlePanel;
	private JEditorPane editor;
	private int height = 600;
	private String title = Translatrix.getTranslationString("Report.Title");
	private JButton printButton;

	public ReportViewer() {
		initViewer();
	}
	
	public ReportViewer(JFrame parent) {
		super(parent);
		initViewer();
	}
		
	/**
	 * initializes the panel
	 */
	private void initViewer() {
		setTitle(title);

		this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		
		this.setLayout(new BorderLayout());

		this.titlePanel = new ModuleHeader(title, PatientManagerModule.getIcon(PatientManagerModule.HOSP_REPORT), new Color(180,255,180));
		this.add(titlePanel, BorderLayout.NORTH);
		
		this.editor = new JEditorPane();
		this.editor.setEditable(false);
		this.editor.setEditorKit(new HTMLEditorKit());
		
		this.add(new JScrollPane(this.editor), BorderLayout.CENTER);
		
		height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 60;
		this.setLocation(30,30);

		printButton = new JButton(
				GECAMedModule.getMediumIcon(GECAMedIconNames.PRINT));
		printButton.setOpaque(false);
		printButton.addActionListener(this);
		
		this.titlePanel.addButton(printButton);

		this.setSize((int)(height/1.4142),  height);
		
	};
	
	
	/**
	 * shows the given html document
	 * @param doc
	 */
	public void showDocument(String doc) {
		this.editor.setText(doc.replaceAll("<META.*>",""));
		this.setVisible(true);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.Component#setVisible(boolean)
	 */
	@Override
	public void setVisible(boolean b) {
		if (!b) {
			showDocument("");
		}
		super.setVisible(b);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.printButton)) {
			PrintUtilities.printComponent(this.editor);
		}
	}

}
