/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.incident;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.usermanagement.gui.settings.UserSettingsPlugin;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Dialog to select an accident number of a specific patient.<br>
 * use showDialog to set visible!
 *
 *
 * @author martin.heinemann@tudor.lu
 * 16.04.2007
 * 15:31:06
 *
 *
 * @version
 * <br>$Log: AccidentRelationDialog.java,v $
 * <br>Revision 1.10  2010-11-16 16:50:49  troth
 * <br>Complete - # 211: create nicer accident list dialog
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/211
 * <br>And Ticket #355 - http://santec.tudor.lu/trac/gecamed/ticket/355
 * <br>
 * <br>Revision 1.9  2010-08-31 13:35:56  troth
 * <br>Incomplete - # 495: Mehrere Unstimmigkeiten mit Unfallnummer (auch #529)
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/495
 * <br>and Tickets 529, 613
 * <br>and new/redesign of AccidentPanel
 * <br>
 * <br>Revision 1.8  2009-10-05 12:22:15  hermen
 * <br>-added marital state cohabit
 * <br>-added option to disable accident-chooser dialog
 * <br>
 * <br>Revision 1.7  2008-10-21 09:53:34  hermen
 * <br>fixed patient slot bug
 * <br>enhanced logging
 * <br>code cleanup
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-08-19 10:25:08  heinemann
 * <br>cleanup
 * <br>
 * <br>Revision 1.4  2007/06/18 11:31:37  hermen
 * <br>cleanup of old stuff and moved some beans
 * <br>
 * <br>Revision 1.3  2007/04/24 13:48:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007/04/20 11:36:08  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/04/17 14:51:25  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class AccidentRelationDialog extends JDialog implements ActionListener, ListSelectionListener, MouseListener {

	private static final long serialVersionUID = 1L;

	public static AccidentRelationDialog instance = new AccidentRelationDialog();

	private JLabel infoLabel;

	private JButton okButton;

	private JButton cancelButton;

	private JPanel expandableCenterPanel;

	private JPanel expNorthPanel;

	private JLabel accidentLabel;

	private CellConstraints cc;

	private JButton expandButton;

	private JPanel expCenterPanel;

	private JList accidentList;

	private Incident firstAccident;

	private List<Incident> otherAccidents;

	private AccidentListModel listModel;

	private Incident selectedAccident;

	public static final int TYPE_CONSULTATION = 1;
	
	public static final int TYPE_INVOICE = 2;

	private static final int FIRST_STATE = 0;
	
	private static final int OTHER_STATE = 1;
	
	private static final int CANCEL_STATE = 2;

	private static int STATE = FIRST_STATE;

	private DateFormat dateFormater = DateFormat.getDateInstance(
			DateFormat.SHORT, Translatrix.getLocale());

	private JCheckBox notShowAgainBox;

	public static boolean NOT_SHOW_AGAIN;


	private AccidentRelationDialog() {
		/* ================================================== */
		super(MainFrame.getInstance(), true);
		this.cc = new CellConstraints();
		Translatrix.addBundle("lu.tudor.santec.gecamed.patient.gui.resources.Translatrix");
		
		this.addWindowListener(new WindowListener() {
			public void windowOpened(WindowEvent e) {}
			public void windowIconified(WindowEvent e) {}
			public void windowDeiconified(WindowEvent e) {}
			public void windowDeactivated(WindowEvent e) {}
			
			public void windowClosing(WindowEvent e) {
				selectedAccident = null;
			}
			
			public void windowClosed(WindowEvent e) {}
			public void windowActivated(WindowEvent e) {}
		});
		initComponent();
		initAction();
		/* ================================================== */
	}

	public static AccidentRelationDialog getInstance()  {
		/* ================================================== */
		return instance;
		/* ================================================== */
	}

	/**
	 * @return
	 */
	public Incident getSelectedAccident() {
		/* ================================================== */
		return this.selectedAccident;
		/* ================================================== */
	}

	private void initComponent() {
		/* ====================================================== */
		this.setLayout(new BorderLayout(0, 10));
		this.getContentPane().setBackground(Color.WHITE);
		/* ------------------------------------------------------- */
		this.setTitle(Translatrix.getTranslationString("AccidentRelationDialog.title"));
		// in the north --> info label
		this.infoLabel = new JLabel();
		infoLabel.setIcon(GECAMedModule.getMediumIcon(GECAMedIconNames.WARNING));
		infoLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
		infoLabel.setFont(new Font(infoLabel.getFont().getName(), infoLabel.getFont().getStyle(), 15));
		infoLabel.setText(Translatrix.getTranslationString("patient.incident.accident.relationQuestion"));
		infoLabel.setOpaque(false);

		/* ------------------------------------------------------- */
		this.add(infoLabel, BorderLayout.NORTH);
		/* ------------------------------------------------------- */
		// in the south --> Buttons
		this.notShowAgainBox = new JCheckBox(Translatrix.getTranslationString("AccidentRelationDialog.notShowAgain"));
		this.notShowAgainBox.setOpaque(false);
		this.notShowAgainBox.setSelected(!(Boolean) MainFrame.getInstance().userSettings.getValue(UserSettingsPlugin.SHOW_ACCIDENT_RELATION_ENABLED));
		
		this.okButton = new JButton(Translatrix.getTranslationString("patient.yes"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.OK));
		this.cancelButton = new JButton(Translatrix.getTranslationString("patient.no"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));

		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addFixed(this.notShowAgainBox);
		bb.addGlue();
		bb.addGridded(okButton);
		bb.addRelatedGap();
		bb.addGridded(cancelButton);
		bb.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		// a panel to make a gap between the dialog border and the buttons
		JPanel gapPanel = new JPanel(new BorderLayout(5,5));
		gapPanel.setOpaque(false);
		gapPanel.add(bb.getPanel(), BorderLayout.CENTER);
		gapPanel.add(new JLabel(""), BorderLayout.SOUTH);
		gapPanel.add(new JLabel(""), BorderLayout.EAST);
		/* ------------------------------------------------------- */
		this.add(gapPanel, BorderLayout.SOUTH);
		/* ------------------------------------------------------- */


		/* ------------------------------------------------------- */
		// in the center --> expandable panel
		this.expandableCenterPanel = new JPanel(new BorderLayout());
		this.expandableCenterPanel.setOpaque(false);
		this.expandableCenterPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
		/* ------------------------------------------------------- */
		// in the north, a panel with a Label and a expand button
		this.expNorthPanel = new JPanel();
		this.expNorthPanel.setLayout(new FormLayout(
				// cols
				"3dlu, fill:pref:grow,3dlu",
				// rows
				"3dlu," +
				"fill:pref," +
				"4dlu," +
				"fill:pref," +
				"3dlu"));
		this.expNorthPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		this.accidentLabel = new JLabel("U2007/12409485908");
		this.accidentLabel.setBorder(BorderFactory.createLineBorder(Color.RED, 5));
		/* ------------------------------------------------------- */

		/* ------------------------------------------------------- */
		// the expand button
		this.expandButton = new JButton(
				Translatrix.getTranslationString("patient.incident.accident.other"));
		this.expandButton.setIcon(IconFetcher.getMiniIcon(
			PatientManagerModule.class, PatientManagerModule.ARROW_DOUBLE_DOWN));
		/* ------------------------------------------------------- */
		ButtonBarBuilder bb2 = new ButtonBarBuilder();
		bb2.addGlue();
		bb2.addGridded(expandButton);
		bb2.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		// assemble northpanel
		this.expNorthPanel.add(this.accidentLabel, cc.xy(2, 2));
		this.expNorthPanel.add(bb2.getPanel(), cc.xy(2, 4));
		/* ------------------------------------------------------- */
		// a JList in the centerpanel
		this.expCenterPanel = new JPanel(new BorderLayout());
		this.expCenterPanel.setOpaque(false);
		this.accidentList = new JList();

		/* ------------------------------------------------------- */
		// listmodel
		this.listModel = new AccidentListModel();
		accidentList.setModel(listModel);
		/* ------------------------------------------------------- */
		JScrollPane scroll = new JScrollPane(this.accidentList);
		scroll.getViewport().setOpaque(false);
		scroll.setOpaque(false);
		scroll.setBorder(BorderFactory.createTitledBorder(
				Translatrix.getTranslationString("patient.incident.accident.otherAccidents")));
		/* ------------------------------------------------------- */
		this.expCenterPanel.add(scroll, BorderLayout.CENTER);

		/* ------------------------------------------------------- */
		/* ------------------------------------------------------- */
		// assemble the parent centerpanel
		this.expandableCenterPanel.add(this.expNorthPanel, BorderLayout.NORTH);
		// the expCenterPanel will be shown when the expButton has been pressed
		this.add(this.expandableCenterPanel, BorderLayout.CENTER);
		/* ====================================================== */
	}



	/**
	 * Init action for buttons and list
	 */
	private void initAction() {
		/* ================================================== */
		// the expand button
		this.expandButton.addActionListener(this);
		/* ------------------------------------------------------- */
		// the ok button
		this.notShowAgainBox.addActionListener(this);
		/* ------------------------------------------------------- */
		// the ok button
		this.okButton.addActionListener(this);
		/* ------------------------------------------------------- */
		// the cancelbutton
		this.cancelButton.addActionListener(this);
		/* ------------------------------------------------------- */
		// the JList
		this.accidentList.addListSelectionListener(this);
		this.accidentList.addMouseListener(this);
		this.accidentList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		/* ------------------------------------------------------- */

		Action cancelAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				if (STATE == OTHER_STATE) {
					/* ------------------------------------------------------- */
					// change state and set selected to first
					expandButton.doClick();
					expandButton.requestFocus();
					/* ------------------------------------------------------- */
				} else {
					/* ------------------------------------------------------- */
					AccidentRelationDialog.this.selectedAccident = null;
					AccidentRelationDialog.this.hideDialog();
					/* ------------------------------------------------------- */
				}
				/* ====================================================== */
			}
		};
		/* ------------------------------------------------------- */
		Action okAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
					if (okButton.isEnabled())
						AccidentRelationDialog.this.hideDialog();
				/* ====================================================== */
			}
		};



		/* ------------------------------------------------------- */
		// define dialog wide key mappings
		KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeEsc, "cancel");
		((JPanel) this.getContentPane()).getActionMap().put("cancel", cancelAction);


		KeyStroke strokeEnter = KeyStroke.getKeyStroke("ENTER");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeEnter, "ok");
		((JPanel) this.getContentPane()).getActionMap().put("ok", okAction);

		/* ================================================== */
	}

	public void actionPerformed(ActionEvent e) {
		/* ====================================================== */
		/* ------------------------------------------------------- */
		// the expand Button
		if (e.getSource().equals(this.expandButton)) {
			if (FIRST_STATE == STATE) {
				/* ------------------------------------------------------- */
				// show the centerpanel
				STATE = OTHER_STATE;
				/* ------------------------------------------------------- */
				this.expandableCenterPanel.add(this.expCenterPanel, BorderLayout.CENTER);
				/* ------------------------------------------------------- */
				// first accident grey
				this.accidentLabel.setForeground(Color.LIGHT_GRAY);
				// disable ok button
//				this.okButton.setEnabled(false);
				/* ------------------------------------------------------- */
				// change the arrows
				this.expandButton.setIcon(IconFetcher.getMiniIcon(
					PatientManagerModule.class, PatientManagerModule.ARROW_DOUBLE_UP));
				/* ------------------------------------------------------- */
				// focus to list
				accidentList.requestFocus();
				if (listModel.getSize() > 0) {
					accidentList.setSelectedIndex(0);
				}
				/* ------------------------------------------------------- */
			} else {
				/* ------------------------------------------------------- */
				STATE = FIRST_STATE;
				// hide the centerpanel
				try {
					this.expandableCenterPanel.remove(this.expCenterPanel);
				} catch (Exception e1) {
					e1.printStackTrace();
				}
				/* ------------------------------------------------------- */
				// first accident black
				this.accidentLabel.setForeground(Color.BLACK);
				// enable ok button
				this.okButton.setEnabled(true);
				/* ------------------------------------------------------- */
				// change the arrows
				this.expandButton.setIcon(IconFetcher.getMiniIcon(
					PatientManagerModule.class, PatientManagerModule.ARROW_DOUBLE_DOWN));
				/* ------------------------------------------------------- */
				// set the first accident as selected
				this.selectedAccident = this.firstAccident;
				/* ------------------------------------------------------- */
			}
			this.expandableCenterPanel.validate();
			this.expandableCenterPanel.updateUI();
			this.validate();
			this.pack();
		}
		/* ------------------------------------------------------- */
		// the okButton
		if (e.getSource().equals(okButton)) {
			/* ------------------------------------------------------- */
			hideDialog();
			/* ------------------------------------------------------- */
		}
		/* ------------------------------------------------------- */
		// the cancel button
		if (e.getSource().equals(cancelButton)) {
			/* ------------------------------------------------------- */
			STATE = CANCEL_STATE;
			hideDialog();
			/* ------------------------------------------------------- */
		}
		// the notShowAgainBox
		if (e.getSource().equals(notShowAgainBox)) {
			/* ------------------------------------------------------- */
			NOT_SHOW_AGAIN = notShowAgainBox.isSelected();
			MainFrame.getInstance().userSettings.setValueAndSave(UserSettingsPlugin.SHOW_ACCIDENT_RELATION_ENABLED,!notShowAgainBox.isSelected());
			/* ------------------------------------------------------- */
		}


		/* ====================================================== */
	}


	public void valueChanged(ListSelectionEvent e) {
		/* ====================================================== */
		if (e.getFirstIndex() < 0) {
			// disbale ok button
			this.okButton.setEnabled(false);
		} else {
			okButton.setEnabled(true);
		}
		/* ====================================================== */
	}

	public void mouseClicked(MouseEvent e) {
		/* ====================================================== */
		if (SwingUtilities.isLeftMouseButton(e)
				&& e.getClickCount() == 2
				&& accidentList.getSelectedIndex() > -1) {
//			// select the accident and close
//			this.selectedAccident = listModel.getIncidentAt(accidentList.getSelectedIndex());
			hideDialog();
		}
		/* ====================================================== */
	}

	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}



	/**
	 * Shows the editor with only one accident nummber
	 *
	 * @param incident
	 */
	public void showDialog(Incident incident) {
		/* ================================================== */
		this.showDialog(incident, null);
		/* ================================================== */
	}


	/**
	 * @param first
	 * @param others
	 * @param expanded
	 * @param type
	 */
	public void showDialog(Incident first, List<Incident> others, boolean expanded, int type) {
		/* ================================================== */
		if (first == null)
			return;
		/* ------------------------------------------------------- */
		this.firstAccident = first;
		this.selectedAccident = this.firstAccident;
		if (others == null || others.size() < 1) {
			/* ------------------------------------------------------- */
			this.expandButton.setEnabled(false);
			/* ------------------------------------------------------- */
		} else
			this.expandButton.setEnabled(true);
		this.otherAccidents = others;
		/* ------------------------------------------------------- */
		// remove the first from the others
		if (this.otherAccidents != null) {
			List<Incident> oTemp = new ArrayList<Incident>();
			oTemp.addAll(this.otherAccidents);
			oTemp.remove(this.firstAccident);
			this.otherAccidents = oTemp;
		}
		/* ------------------------------------------------------- */
		// set the labels
		this.accidentLabel.setText(constructAccidentString(this.firstAccident));
		if (TYPE_CONSULTATION == type)
			infoLabel.setText(Translatrix.getTranslationString("patient.incident.accident.relationQuestion"));
		else
			infoLabel.setText(Translatrix.getTranslationString("patient.incident.accident.relationInvoiceQuestion"));
		/* ------------------------------------------------------- */
		// fill the list

		if (this.otherAccidents != null) {
			/* ------------------------------------------------------- */
			listModel.setData(otherAccidents);
			/* ------------------------------------------------------- */
		}
		/* ------------------------------------------------------- */
		// reset the dialog
		if (expanded) {
			STATE = FIRST_STATE;
		} else
			STATE = OTHER_STATE;
		expandButton.doClick();

		this.notShowAgainBox.setSelected(!(Boolean) MainFrame.getInstance().userSettings.getValue(UserSettingsPlugin.SHOW_ACCIDENT_RELATION_ENABLED));
		this.pack();
		MainFrame.showDialogCentered(this);
		/* ================================================== */
	}

	/**
	 * Shows the dialog with the first and fills
	 * the selection list
	 *
	 * @param first
	 * @param others
	 */
	public void showDialog(Incident first, List<Incident> others) {
		/* ================================================== */
		this.showDialog(first, others, false, TYPE_CONSULTATION);
		/* ================================================== */
	}

	private void hideDialog() {
		/* ================================================== */
		if (STATE == FIRST_STATE) {
			this.selectedAccident = this.firstAccident;
		} else if (STATE == OTHER_STATE && accidentList.getSelectedIndex() > -1) {
			this.selectedAccident = listModel.getIncidentAt(accidentList.getSelectedIndex());
		} else
			this.selectedAccident = null;

		this.setVisible(false);
		/* ================================================== */
	}

	/**
	 * @param in
	 * @return
	 */
	private String constructAccidentString(Incident in) {
		/* ================================================== */
		if (in == null)
			return null;
		/* ------------------------------------------------------- */
		String nr = (in.getAccidentNr() != null ? in.getAccidentNr() : "");
		String date = (in.getAccidentDate() != null
				? dateFormater.format(in.getAccidentDate())
				  : "");
		/* ------------------------------------------------------- */
		String s = "";
		if ("".equals(nr) && "".equals(date))
			s = Translatrix.getTranslationString("patient.incident.accident.emptySet")
								+ dateFormater.format(in.getIncidentDate());
		else
			s = ""+nr+"      "+date;

		return s.trim();
		/* ================================================== */
	}



	/**
	 * @author martin.heinemann@tudor.lu
	 * 17.04.2007
	 * 13:38:38
	 *
	 *
	 * @version
	 * <br>$Log: AccidentRelationDialog.java,v $
	 * <br>Revision 1.10  2010-11-16 16:50:49  troth
	 * <br>Complete - # 211: create nicer accident list dialog
	 * <br>http://santec.tudor.lu/trac/gecamed/ticket/211
	 * <br>And Ticket #355 - http://santec.tudor.lu/trac/gecamed/ticket/355
	 * <br>
	 * <br>Revision 1.9  2010-08-31 13:35:56  troth
	 * <br>Incomplete - # 495: Mehrere Unstimmigkeiten mit Unfallnummer (auch #529)
	 * <br>http://santec.tudor.lu/trac/gecamed/ticket/495
	 * <br>and Tickets 529, 613
	 * <br>and new/redesign of AccidentPanel
	 * <br>
	 * <br>Revision 1.8  2009-10-05 12:22:15  hermen
	 * <br>-added marital state cohabit
	 * <br>-added option to disable accident-chooser dialog
	 * <br>
	 * <br>Revision 1.7  2008-10-21 09:53:34  hermen
	 * <br>fixed patient slot bug
	 * <br>enhanced logging
	 * <br>code cleanup
	 * <br>
	 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
	 * <br>fixed copyrights
	 * <br>
	 * <br>Revision 1.5  2008-08-19 10:25:08  heinemann
	 * <br>cleanup
	 * <br>
	 * <br>Revision 1.4  2007/06/18 11:31:37  hermen
	 * <br>cleanup of old stuff and moved some beans
	 * <br>
	 * <br>Revision 1.3  2007/04/24 13:48:43  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.2  2007/04/20 11:36:08  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.1  2007/04/17 14:51:25  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 *
	 */
	class AccidentListModel extends AbstractListModel {

		private static final long serialVersionUID = 1L;

		private ArrayList<Incident> accidents;

		public AccidentListModel() {
			/* ================================================== */
			accidents = new ArrayList<Incident>();
			/* ================================================== */
		}


		public void setData(List<Incident> data) {
			/* ================================================== */
			accidents.clear();
			
			accidents.addAll(data);
			fireContentsChanged(this, 0, data.size());
			/* ================================================== */
		}


		public Object getElementAt(int index) {
			/* ====================================================== */
			return constructAccidentString(accidents.get(index));
			/* ====================================================== */
		}

		public int getSize() {
			/* ====================================================== */
			return accidents.size();
			/* ====================================================== */
		}

		public Incident getIncidentAt(int index) {
			/* ================================================== */
			if (accidents == null || accidents.size() < 0)
				return firstAccident;
			else
				return accidents.get(index);
			/* ================================================== */
		}

	}


}
