/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.table.filter;

import java.util.Vector;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.TableFilter;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntryType;

/**
 * @author martin.heinemann@tudor.lu
 * 27.06.2008
 * 10:18:59
 *
 *
 * @version
 * <br>$Log: HistoryTypeFilter.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class HistoryTypeFilter implements TableFilter{

	private String searchText = "";
	private Vector<String> filters = new Vector<String>();

	public boolean accept(Object p_Value) {
		/* ====================================================== */
		if (p_Value instanceof IncidentEntry) {
			/* ------------------------------------------------------- */
			IncidentEntry entry 	= (IncidentEntry) p_Value;
			IncidentEntryType type  = entry.getEntryType();
			/* ------------------------------------------------------- */
			for (String filter : filters) {
				if (filter.equals(type.getName()))
					return true;				
			}
			/* ------------------------------------------------------- */
		}
		return false;
		/* ====================================================== */
	}

	public void compile() {
		/* ====================================================== */
		
		/* ====================================================== */
	}

	public boolean isFiltering() {
		/* ====================================================== */
		return true;
		/* ====================================================== */
	}
 
	public void setFilter(Object p_FilterValue) {
		/* ====================================================== */
		clearFilters();
		addFilter(p_FilterValue);
		/* ====================================================== */
	}
	
	public void addFilter(Object p_FilterValue) {
		/* ====================================================== */
		if (p_FilterValue instanceof String) 
			this.filters.add((String) p_FilterValue);
		/* ====================================================== */
	}
	
	public void clearFilters() {
		filters.clear();
	}
	
	public void removeFilter(String filterValue)
	{
		this.filters.remove(filterValue);
	}

	public int size()
	{
		return this.filters.size();
	}
	
	public String getElementAt(int index)
	{
		return this.filters.elementAt(index);
	}
	
	public void setElementAt(int index,String elem)
	{
		this.filters.setElementAt(elem, index);
	}
	
	public void removeElementAt(int index)
	{
		this.filters.removeElementAt(index);
	}
}
