package lu.tudor.santec.gecamed.patient.gui.history.table;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
	 * @author martin.heinemann@tudor.lu
	 * 10.03.2008
	 * 10:01:31
	 *
	 *
	 * @version
	 * <br>$Log: HistRow.java,v $
	 * <br>Revision 1.2  2012-03-13 12:11:22  ferring
	 * <br>Form types are now separated by the code column in of the table incident_entry
	 * <br>
	 * <br>Revision 1.1  2010-10-19 09:54:29  troth
	 * <br>change structure of updating history views to make the loading of patient faster
	 * <br>
	 * <br>Revision 1.30  2010-10-13 15:02:53  troth
	 * <br>Add new dialog to the main menu bar for delete the incidents how have no incident entries.
	 * <br>
	 * <br>Revision 1.29  2010-10-07 12:50:43  troth
	 * <br>Complete - # 617: Can't search for prescription text in history view
	 * <br>http://santec.tudor.lu/trac/gecamed/ticket/617
	 * <br>
	 * <br>Revision 1.28  2010-08-24 12:49:40  troth
	 * <br>fix small bug - to open consultation over the accident entry in the patient history
	 * <br>
	 * <br>Revision 1.27  2010-06-15 07:57:36  troth
	 * <br>bug fix - if last entry in table was deleted there was one null-line rendered
	 * <br>
	 * <br>Revision 1.26  2010-04-26 16:40:00  troth
	 * <br>Redesign of the prescription view
	 * <br>
	 * <br>Revision 1.25  2009-12-14 15:34:31  hermen
	 * <br>fixed NULL entries in history
	 * <br>
	 * <br>Revision 1.24  2009-06-03 09:23:40  hermen
	 * <br>fixed npe on empty physician name
	 * <br>
	 * <br>Revision 1.23  2008-10-01 13:15:29  heinemann
	 * <br>fixed possible nullpointer when the physician id of an incident is null
	 * <br>
	 * <br>Revision 1.22  2008-09-25 09:43:08  heinemann
	 * <br>fixed copyrights
	 * <br>
	 * <br>Revision 1.21  2008-07-03 11:59:57  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.20  2008-06-11 13:13:43  hermen
	 * <br>fixed getHistoryData
	 * <br>
	 * <br>Revision 1.19  2008-06-03 12:59:11  weitz
	 * <br>*letter package, release candidate
	 * <br>
	 * <br>Revision 1.18  2008-05-13 08:23:28  heinemann
	 * <br>bug fix. Open consultation did not function very well in the case that an incident does not have any entries.
	 * <br>
	 * <br>Revision 1.17  2008-04-11 14:47:41  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.16  2008-04-09 14:47:05  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.15  2008-04-09 12:53:59  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.14  2008-04-09 09:39:43  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.13  2008-03-20 16:08:14  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.12  2008-03-10 12:37:52  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 *   
	 */
	public class HistRow {
		
		private static final DateFormat df = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss");
		
		private Date date;
		private String docMnemonic;
		private IncidentEntry entry;
		
		
		/**
		 * @param date
		 * @param doc
		 * @param entry
		 */
		public HistRow(Date date, String doc, IncidentEntry entry) {
			/* ================================================== */
			this.date = date;
			this.docMnemonic = doc;
			this.entry = entry;
			/* ================================================== */
		}
		
		
		/**
		 * @return
		 */
		public Date getCol0() {
			/* ================================================== */
			return date;
			/* ================================================== */
		}
		
		/**
		 * @return
		 */
		public String getCol1() {
			/* ================================================== */
			return docMnemonic;
			/* ================================================== */
		}
		
		/**
		 * @return
		 */
		public IncidentEntry getCol2() {
			/* ================================================== */
			return entry;
			/* ================================================== */
		}
		
		/**
		 * @return
		 */
		public IncidentEntry getCol3() {
			/* ================================================== */
			return entry;
			/* ================================================== */
		}
		
		
		public String getCol4 ()
		{
			return entry.getCode();
		}


		public IncidentEntry getEntry() {
			/* ================================================== */
			return entry;
			/* ================================================== */
		}


		public void setEntry(IncidentEntry entry) {
			/* ================================================== */
			this.entry = entry;
			/* ================================================== */
		}
		
		public String toString() {
			try {
				String text = this.entry.getTextContent();
				if (text == null || text.length() == 0) text = ""+this.entry.getFileName();
				if (text.length() > 30) text = text.substring(0, 29).replaceAll("\n", " ")+"...";
				return df.format(this.date) + "\t" + this.docMnemonic + "\t"+ this.entry.getIncidentId() + "\t" + this.entry.getId() + "\t" + text;
			} catch (Exception e) {
				return df.format(this.date) + "\t" + e.getMessage();
			}
		}
		
	}