package lu.tudor.santec.gecamed.patient.gui.history.contextmenu;

import java.awt.event.ActionEvent;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ChangeIncidentAction.java,v $
 * <br>Revision 1.5  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.4  2013-07-15 06:18:38  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2013-02-13 14:01:58  ferring
 * <br>history will not always be reloaded completely
 * <br>
 * <br>Revision 1.2  2013-02-13 10:51:09  ferring
 * <br>create new incident button added
 * <br>
 * <br>Revision 1.1  2013-02-08 15:27:17  ferring
 * <br>Option added for files and letters to attach them to another incident
 * <br>
 */

public class ChangeIncidentAction extends AEntryAction
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static ChangeIncidentAction	instance;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(ChangeIncidentAction.class.getName());
	
	
	private ChangeIncidentDialog	dialog;
	
	private IncidentManager			manager;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	private ChangeIncidentAction()
	{
		super(Translatrix.getTranslationString("History.changeIncident"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.CHANGE_FOLDER));
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public static ChangeIncidentAction getInstance ()
	{
		if (instance == null)
			instance	= new ChangeIncidentAction();
		
		return instance;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		Incident	incident;
		MainFrame	mainFrame	= MainFrame.getInstance();
		
		
		if (dialog == null)
			dialog = new ChangeIncidentDialog();
		
		incident	= dialog.showDialog(entry2work);
		
		if (incident != null)
		{
			if (manager == null)
				manager = (IncidentManager)ManagerFactory.getRemote(IncidentManagerBean.class);
			
			mainFrame.setWaitCursor(true);
			try
			{
				manager.moveIncidentEntry(entry2work, incident);
				Integer emptyIncidents = manager.deleteNullIncident(incident.getPatientId());
				
				// remove empty incidents, as this move might has produced one
				if (emptyIncidents != null && emptyIncidents.intValue() > 1)
					logger.info(emptyIncidents.intValue() + " empty incidents found and deleted.");
				
				PatientManagerModule.getInstance().getPatientPanel().reloadHistory();
			}
			catch (Exception t)
			{
				logger.log(Level.ERROR, t.getMessage(), t);
			}
			finally
			{
				mainFrame.setWaitCursor(false);
			}
		}
	}
}
