/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history.antecedents;

import java.awt.Component;
import java.awt.Font;
import java.text.DateFormat;

import javax.swing.JList;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorListRenderer;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Antecedents;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.LoginBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;

/**
 * Renderer for the AntecedentsList in the AntecedentsViewDialog
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AntecedentsViewDialogRenderer.java,v $
 * <br>Revision 1.3  2011-10-06 12:02:32  ferring
 * <br>System.out.println removed and imports organised
 * <br>
 * <br>Revision 1.2  2011-10-04 14:12:20  troth
 * <br>fixed Ticket #903 - Copy-paste Mglichkeit fr Antezedenzen.
 * <br>
 * <br>Revision 1.1  2010-03-23 15:12:31  troth
 * <br>Redesign of the patient view history -
 * <br>Create renderer for the antecedents list the AntecedentsViewDialog
 * <br>
 */

public class AntecedentsViewDialogRenderer extends LineColorListRenderer {

	private static final long serialVersionUID = 1L;
	
	private LoginInterface loginManager;
	
	private DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT );
    
	private String createdInfo = "";
	
	private String description = "";
	
	private Antecedents ant;
	
	
	/**
	 * 
	 */
	public AntecedentsViewDialogRenderer()
	{
		super();
		loginManager = (LoginInterface) ManagerFactory.getRemote(LoginBean.class);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.LineColorListRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
	 */
	public Component getListCellRendererComponent(
	       JList list,
	       Object value,            // value to display
	       int index,               // cell index
	       boolean isSelected,      // is the cell selected
	       boolean cellHasFocus)    // the list and the cell have the focus
    {
    	
    	ant = (Antecedents) value;
	    
	    try {
	    	createdInfo = df.format(ant.getCreated()) + " - " + loginManager.getUser(ant.getCreatedBy()).getLogin();
	    } catch (Exception e) {
		}
		
		try {
			description = ant.getDescription().replaceAll("<head>","");
			description = description.replaceAll("</head>","");	
			description = description.replaceAll("<html>","");
			description = description.replaceAll("</html>","");
			description = description.replaceAll("<body>","");
			description = description.replaceAll("</body>","");
		} catch (Exception e) {
		}
	    Component renderComponent = super.getListCellRendererComponent(list, 
				"<html><b>" +  ant.getShortcut() + "</b><hr>" + description + "<hr><p><small>" + createdInfo + "</small></p></html>", 
				index, isSelected, cellHasFocus);
	    renderComponent.setFont(renderComponent.getFont().deriveFont(Font.PLAIN));
		return renderComponent;
	}
}