/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.listener.IEntryPrintRenderer;
import lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler;
import lu.tudor.santec.gecamed.core.gui.plugin.filehandler.DefaultEntryDeleteAction;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: SickLeaveHandler.java,v $
 * <br>Revision 1.2  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.1  2013-09-04 15:33:26  troth
 * <br>The new consultation view with more entries and the sickleave version 2 history view work now.
 * <br>
 */
public class SickLeaveHandler implements IEntryTypeHandler {

	private DefaultEntryDeleteAction deleteAction;

	public SickLeaveHandler()
	{
		this.deleteAction = new DefaultEntryDeleteAction(
				Translatrix.getTranslationString("patient.incident.soap.buttons.delete"),
				Translatrix.getTranslationString("patient.incident.soap.deleteDialog.title"),
				Translatrix.getTranslationString("patient.incident.soap.deleteDialog.text")
				);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getRenderer
	 * (java.lang.String)
	 */
	public TableCellRenderer getRenderer(String entryType)
	{
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getSpecialEntries
	 * (java.lang.String, java.lang.Integer)
	 */
	public HashMap<Integer, Object> getSpecialEntries(String entryType, Integer patientId)
	{
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getActions
	 * (lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry)
	 */
	public Collection<Action> getActions(IncidentEntry entry)
	{
		List<Action> actions = new ArrayList<Action>();
		this.deleteAction.setEntry(entry);
		actions.add(this.deleteAction);
		return actions;
	}
	
	
	public JPopupMenu getPopup(IncidentEntry entry)
	{
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#openEntry
	 * (lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry)
	 */
	public boolean openEntry(IncidentEntry entry)
	{
		PatientManagerModule.getInstance().getPatientPanel().openConsultation(entry);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getPrintRenderer
	 * (java.lang.String)
	 */
	public IEntryPrintRenderer getPrintRenderer(String entryType)
	{
		return null;
	}
}
