/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.undo.UndoManager;

import lu.tudor.santec.gecamed.core.gui.GECAMedFonts;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.utils.UndoTextArea;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponentVariable;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.history.antecedents.AntecedentsListRenderer;
import lu.tudor.santec.gecamed.patient.gui.settings.ImportantDataPanelConfig;
import lu.tudor.santec.gecamed.patient.gui.settings.PatientModuleSettings;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletionTextComponent;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Panel to show the important patient data in the visit and medical history.
 * Panel consists of 4 html panels that are able to show text and links
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 */
public class ImportantDataPanel extends HeaderedPanel  {

	private static final long serialVersionUID = 1L;

	public static final String ALLERGY = "allergy";
	public static final String ANTECEDANTS = "antecedants";

	public static final Color TITLE_COLOR = Color.RED;
	public static final Color TEXT_COLOR = Color.BLACK;

	public UndoTextArea problemActiveField;
	protected JEditorPane allergyField;
	protected UndoTextArea chronicalTreatmentsField;
		
	private JScrollPane problemActiveScroller;
	private JScrollPane allergyScroller;
	protected JList antecedantsList;
	private JScrollPane antecedantsScroller;
	private JScrollPane chronicalTreatmentsScroller;
	protected JButton allergyButton;
	protected JButton antecedantsButton;

	private ImportantDataModel model;



	public ImportantDataPanel(boolean shortPanel, ImportantDataModel model) {
		this.model = model;
		buildPanel(shortPanel);
	}

	private void buildPanel(boolean shortPanel) {
		
		
		// get the ImportantDataPanel settings
		PatientModuleSettings patientGlobalSettings = PatientManagerModule.getInstance().patientSettings;
		ImportantDataPanelConfig[] importantDataConfig = new ImportantDataPanelConfig[4]; 
		
		String cols = "";
		
		for (int i = 0; i < importantDataConfig.length; i++)
		{
			importantDataConfig[i] = patientGlobalSettings.importantDataConfig[i];
			if(importantDataConfig[i].getEnabled()) cols = cols + "3dlu,110dlu:grow,";  
		}
		
//		this.mainPanel = new JPanel(new GridLayout(1, 4, 3, 0));
		
		JPanel mainPanel = new JPanel(new FormLayout(
				cols,
				"fill:pref:grow"
				));
		
		CellConstraints	cc	= new CellConstraints();
		
		initComponents();

		this.setLayout(new BorderLayout());
		
		setHeader(Translatrix.getTranslationString("patient.incident.important"));
		
		this.setOpaque(false);
		mainPanel.setOpaque(false);
		// elements of the importantPanel on top
		int col = 0;
		for (int i = 0; i < importantDataConfig.length; i++)
		{
			if(importantDataConfig[i].getId().equals(IncidentManager.ACTIVE_PROBLEMS) && importantDataConfig[i].getEnabled())
				mainPanel.add(new NamedComponentVariable(
						Translatrix.getTranslationString("patient.activeproblems"),
						TITLE_COLOR,
						problemActiveScroller),cc.xy(col+=2, 1));
			if(importantDataConfig[i].getId().equals(IncidentManager.ALLERGIES) && importantDataConfig[i].getEnabled())
				mainPanel.add(new NamedComponentVariable(
						Translatrix.getTranslationString("patient.allergy.allergies"),
						TITLE_COLOR,
						allergyScroller, this.allergyButton),cc.xy(col+=2, 1));
			if(importantDataConfig[i].getId().equals(IncidentManager.ANTECEDENTS) && importantDataConfig[i].getEnabled())
				if (! shortPanel)
					mainPanel.add(new NamedComponentVariable(
							Translatrix.getTranslationString("patient.antecedents"),
							TITLE_COLOR,
							antecedantsScroller, this.antecedantsButton),cc.xy(col+=2, 1));
			if(importantDataConfig[i].getId().equals(IncidentManager.CHRONICAL_TREATMENTS) && importantDataConfig[i].getEnabled())
				mainPanel.add(new NamedComponentVariable(
						Translatrix.getTranslationString("patient.cronicaltreatment"),
						TITLE_COLOR,
						chronicalTreatmentsScroller),cc.xy(col+=2, 1));

		}
		this.setBorder(BorderFactory.createTitledBorder(""));

		this.add(mainPanel, BorderLayout.CENTER);
	}

	private void initComponents() 
	{
		AutoCompletionTextComponent actc;
		
		// elements of the importantPanel on top
		problemActiveField = new UndoTextArea(this.model.getProblemActiveDocument(), new UndoManager());
		actc = new AutoCompletionTextComponent(problemActiveField, "active_problems");
		actc.enableScrollPane(true);
		problemActiveScroller = actc.getScrollPane();
		problemActiveScroller.setOpaque(false);
		problemActiveScroller.getViewport().setOpaque(false);
		problemActiveScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		problemActiveScroller.setPreferredSize(new Dimension(200, 1));
		
		allergyField = createTextBox();
		allergyField.setEditable(false);
		allergyScroller = new JScrollPane(allergyField);
		allergyScroller.setOpaque(false);
		allergyScroller.getViewport().setOpaque(false);
		allergyScroller.setPreferredSize(new Dimension(200, 1));
		
		allergyButton = ButtonFactory.createNarrowButton(GECAMedModule.getMiniIcon(GECAMedModule.ADD_LINE));
		allergyButton.setToolTipText(Translatrix.getTranslationString("patient.allergy.addAllergy"));
		allergyButton.setActionCommand(ALLERGY);
		allergyButton.setMargin(new java.awt.Insets(0,0,0,0));

		antecedantsList = new JList();
		antecedantsList.setCellRenderer(new AntecedentsListRenderer());
		antecedantsScroller = new JScrollPane(antecedantsList);
		antecedantsScroller.setOpaque(false);
		antecedantsScroller.getViewport().setOpaque(false);
		antecedantsScroller.setPreferredSize(new Dimension(200, 1));
		
		antecedantsButton = ButtonFactory.createNarrowButton(GECAMedModule.getMiniIcon(GECAMedModule.ADD_LINE));
		antecedantsButton.setToolTipText(Translatrix.getTranslationString("patient.addAntecedents"));
		antecedantsButton.setActionCommand(ANTECEDANTS);
		antecedantsButton.setMargin(new java.awt.Insets(0,0,0,0));
		
		chronicalTreatmentsField = new UndoTextArea(this.model.getChronicalTreatmentsDocument(), new UndoManager());
		actc = new AutoCompletionTextComponent(chronicalTreatmentsField, "chronical_treatments");
		actc.enableScrollPane(true);
		chronicalTreatmentsScroller = actc.getScrollPane();
		chronicalTreatmentsScroller.setOpaque(false);
		chronicalTreatmentsScroller.getViewport().setOpaque(false);
		chronicalTreatmentsScroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		chronicalTreatmentsScroller.setPreferredSize(new Dimension(200, 1));
		
	}

	private JEditorPane createTextBox() {
		JEditorPane pane = new JEditorPane();
		pane.setFont(GECAMedFonts.TEXTFIELD_FONT);
		pane.setForeground(TEXT_COLOR);
		return pane;
	}

}
