/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.listener.IEntryPrintRenderer;
import lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Handler for the Accidents Incidents
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 * 
 * @version <br>
 *          $Log: AccidentHandler.java,v $
 *          Revision 1.3  2013-12-27 18:09:25  donak
 *          Cleanup of imports
 *
 *          Revision 1.2  2013-02-05 13:15:18  ferring
 *          letter status added
 *
 *          Revision 1.1  2010-09-28 16:12:29  troth
 *          Complete - # 663: Accident entry can not be individually deleted from the history view.
 *          http://santec.tudor.lu/trac/gecamed/ticket/663
 *
 */
public class AccidentHandler implements IEntryTypeHandler { // ,
															// IEntryPrintRenderer{

	public static final String ACCIDENT = "Ac";

	private AccidentEntryDeleteAction deleteAction;

	public AccidentHandler() {
		this.deleteAction = new AccidentEntryDeleteAction(
				Translatrix.getTranslationString("patient.incident.accident.buttons.delete"),
				Translatrix.getTranslationString("patient.incident.accident.deleteDialog.title"),
				Translatrix.getTranslationString("patient.incident.accident.deleteDialog.text"));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getRenderer
	 * (java.lang.String)
	 */
	public TableCellRenderer getRenderer(String entryType) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getSpecialEntries
	 * (java.lang.String, java.lang.Integer)
	 */
	public HashMap<Integer, Object> getSpecialEntries(String entryType,
			Integer patientId) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getActions
	 * (lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry)
	 */
	public Collection<Action> getActions(IncidentEntry entry) {
		List<Action> actions = new ArrayList<Action>();
		this.deleteAction.setEntry(entry);
		actions.add(this.deleteAction);
		return actions;
	}
	
	
	public JPopupMenu getPopup(IncidentEntry entry)
	{
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#openEntry
	 * (lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry)
	 */
	public boolean openEntry(IncidentEntry entry) {
		PatientManagerModule.getInstance().getPatientPanel().openConsultation(entry);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler#getPrintRenderer
	 * (java.lang.String)
	 */
	public IEntryPrintRenderer getPrintRenderer(String entryType) {
		return null;
	}
}
