/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.history;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedOptionPane;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * button action delete for accident incident in the right-click-popup of HistoryView
 *  
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 * 
 * @version
 * <br>$Log: AccidentEntryDeleteAction.java,v $
 * <br>Revision 1.2  2010-10-01 12:14:57  troth
 * <br>translations for accident delete dialog
 * <br>
 * <br>Revision 1.1  2010-09-28 16:12:29  troth
 * <br>Complete - # 663: Accident entry can not be individually deleted from the history view.
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/663
 * <br>
 */
public class AccidentEntryDeleteAction extends AEntryAction {

	private static final long serialVersionUID = 1L;

	private IncidentEntry entry2Delete;

	private String dialogTitle;

	private String dialogQuestion;
	
	public AccidentEntryDeleteAction() {
		super(Translatrix.getTranslationString("patient.incident.accident.buttons.delete"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
		
		this.dialogTitle = Translatrix.getTranslationString("patient.incident.accident.deleteDialog.title");
		this.dialogQuestion = Translatrix.getTranslationString("patient.incident.accident.deleteDialog.text");
		
	}
	
	/**
	 * constructor to label the delete-popupitem and to set the dialog title and question.
	 * 
	 * @param labelname the label of popupitem
	 * @param dialogTitle the title of the delete dialog
	 * @param dialogQuestion the question of the delete dialog
	 */
	public AccidentEntryDeleteAction(String labelname, String dialogTitle, String dialogQuestion) {
	
		super(labelname, GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
		
		this.dialogTitle = dialogTitle;
		this.dialogQuestion = dialogQuestion;
	
	}
	
	/**
	 * set the incident entry to delete
	 * 
	 * @param entry the incident entry to delete
	 */
	public void setEntry(IncidentEntry entry) {
		this.entry2Delete = entry;
	}

	public void actionPerformed(ActionEvent e) {
		
		// show delete "Delete-Really"-Dialog 
		int reply = GECAMedOptionPane.showOptionDialog(
				MainFrame.getInstance(),
				dialogTitle,
				dialogQuestion,
				JOptionPane.YES_NO_OPTION);
		
		if (reply == JOptionPane.YES_OPTION) {
			// delete the accident incident
			try {
				// get IncidentManagerBean
				IncidentManager incidentManager = (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
				// get incident id
				Integer incidentId = this.entry2Delete.getIncidentId();
				
				PatientManagerModule.getInstance().getPatientPanel().incidentEntryDeleted(this.entry2Delete);
				// set accident data of Incident to false and delete Incident if it have no entries
				incidentManager.deleteAccidentIncident(incidentId);
				// update history view
				PatientManagerModule.getInstance().getPatientPanel().reloadHistory();
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}
}
