/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import java.util.Date;

import org.jdom.Element;

/**
 * class that represents an Kmehr transaction object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmTransaction.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmTransaction  implements KmConstants{

	private static final String TRANSACTION = "transaction";
	private static final String AUTHOR = "author";
	private static final String ISCOMPLETE = "iscomplete";
	private static final String ISVALID = "isvalid";
	
	private Element transaction;
	private static int transactionNr = 1;
	
	public KmTransaction(String type, Element hcpartyAuthor, boolean isComplete, boolean isValid) {
		transaction = new Element(TRANSACTION);
	    transaction.addContent(KmID.create(KmID.ID_KMEHR, transactionNr  +""));
	    transaction.addContent(KmCD.create(CD_TRANSACTION, type));
	    transaction.addContent(KmDate.create(new Date()));
	    transaction.addContent(KmTime.create(new Date()));
	    
	    Element author = new Element(AUTHOR);
	    	author.setContent(hcpartyAuthor);
	    transaction.addContent(author);	
	    
	    Element iscomplete = new Element(ISCOMPLETE);
	    iscomplete.setText(isComplete + "");
	    transaction.addContent(iscomplete);
	    
	    Element isvalid = new Element(ISVALID);
	    isvalid.setText(isValid + "");
	    transaction.addContent(isvalid);
	    
	    transactionNr++;
	    
	}
	
	/**
	 * returns the Kmehr xml element
	 * @return
	 */
	public Element getElement() {
		return transaction;
	}
	
	public void addItem(Element item) {
		transaction.addContent(item);
	}
	
	public static void resetTransactionNr() {
		transactionNr = 1;
	}
	
}

