/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import org.jdom.Element;

/**
 * class that represents an Kmehr standart object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmStandart.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:22  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmStandart  implements KmConstants{

	private static final String STANDARD = "standard";
	private static final String S = "S";
	private static final String SV = "SV";
	
	/**
	 * creates the Kmehr xml element
	 * @return
	 */
	public static Element create() {
		return create("20030909");
	}
	
	/**
	 * creates the Kmehr xml element
	 * @param value
	 * @return
	 */
	public static Element create(String value) {
		Element standard = new Element(STANDARD);
		standard.setAttribute(S, CD_STANDARD);
		standard.setAttribute(SV, VERSION);
	    if (value != null) 
	    	standard.setText(value);
	    return standard;
	}
	
}

