/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.AddressType;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Country;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientAddress;

import org.jdom.Element;

/**
 * class that represents an Kmehr address object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmAddress.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:22  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmAddress implements KmConstants{

	private static final String ADDRESS = "address";
	private static final String COUNTRY = "country";
	private static final String ZIP = "zip";
	private static final String CITY = "city";
	private static final String STREET = "street";
	private static final String HOUSENR = "housenumber";
	
	private static final String HOME = "home";
	private static final String OTHER = "other";
	private static final String WORK = "work";
	

	/**
	 * creates the Kmehr xml element
	 * @param pa
	 * @return
	 */
	public static Element create(PatientAddress pa) {
		Element address = new Element(ADDRESS);
	    address.addContent(KmCD.create(CD_ADDRESS, matchType(pa.getType())));
		
	    Element country = new Element(COUNTRY);
	    country.addContent(KmCD.create(CD_COUNTRY, matchCountry(pa.getCountry())));
	    address.addContent(country);
		
	    Element zip = new Element(ZIP);
	    zip.setText(pa.getZip());
	    address.addContent(zip);
	    
	    Element city = new Element(CITY);
	    city.setText(pa.getLocality());
	    address.addContent(city);
	    
	    Element street = new Element(STREET);
	    street.setText(pa.getStreetName());
	    address.addContent(street);
	    
	    Element housenr = new Element(HOUSENR);
	    housenr.setText(pa.getStreetNumber());
	    address.addContent(housenr);
	    
	    return address;
	}
	
	private static String matchType(String type) {
		if (type == null) 
			return OTHER;
		if (type.equals(AddressType.PRIVATE))
			return HOME; 
		if (type.equals(AddressType.WORK))
			return WORK; 
		return HOME; 
	}
	
	private static String matchCountry(String country) {
		if (country == null) 
			return "";
		else if (country.equals(Country.ENGLAND))
			return "en"; 
		else if (country.equals(Country.LUXEMBOURG))
			return "lu"; 
		else if (country.equals(Country.FRANCE))
			return "fr"; 
		else if (country.equals(Country.GERMANY))
			return "de"; 
		try {
			return country.substring(0,2); 			
		} catch (Exception e) {
		}
		return "";
	}
	
	
	
}

