/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.connector;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

/**
 * interface to the erisk applications via Java Com Bridge jacob
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: IEriskInterface.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class IEriskInterface extends Dispatch {

	public static final String componentName = "pfizer_erisk_components.IEriskInterface";

	public IEriskInterface() {
		super(componentName);
	}

	/**
	* This constructor is used instead of a case operation to
	* turn a Dispatch object into a wider object - it must exist
	* in every wrapper class whose instances may be returned from
	* method calls wrapped in VT_DISPATCH Variants.
	*/
	public IEriskInterface(Dispatch d) {
		// take over the IDispatch pointer
		m_pDispatch = d.m_pDispatch;
		// null out the input's pointer
		d.m_pDispatch = 0;
	}

	public IEriskInterface(String compName) {
		super(compName);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param lastParam an input-parameter of type String
	 */
	public void startEriskCalculator(String lastParam) {
		Dispatch.call(this, "StartEriskCalculator", lastParam);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	public Variant findEriskCalculator() throws Throwable {
		return Dispatch.call(this, "FindEriskCalculator");
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param xml an input-parameter of type String
	 * @param lastParam an input-parameter of type String
	 */
	public void startEriskModule(String xml, String lastParam) {
		Dispatch.call(this, "StartEriskModule", xml, lastParam);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param lastParam an input-parameter of type String
	 * @return the result is of type int
	 */
	public Variant findEriskModule(String lastParam) {
		return Dispatch.call(this, "FindEriskModule", lastParam);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int getBatchType() {
		return Dispatch.get(this, "BatchType").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type String
	 */
	public String getModuleName() {
		return Dispatch.get(this, "ModuleName").toString();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int getBatchTotal() {
		return Dispatch.get(this, "BatchTotal").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param lastParam an input-parameter of type int
	 */
	public void setBatchTotal(int lastParam) {
		Dispatch.call(this, "BatchTotal", new Variant(lastParam));
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int getBatchAgeMin() {
		return Dispatch.get(this, "BatchAgeMin").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int getBatchAgeMax() {
		return Dispatch.get(this, "BatchAgeMax").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type String
	 */
	public String getBatchXml() {
		return Dispatch.get(this, "BatchXml").toString();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param lastParam an input-parameter of type String
	 */
	public void setBatchXml(String lastParam) {
		Dispatch.call(this, "BatchXml", lastParam);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int getBatchStatus() {
		return Dispatch.get(this, "BatchStatus").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param lastParam an input-parameter of type int
	 */
	public void setBatchStatus(int lastParam) {
		Dispatch.call(this, "BatchStatus", new Variant(lastParam));
	}

}
