/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.connector;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

/**
 * interface to the erisk applications via Java Com Bridge jacob
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: IEriskCalculation.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class IEriskCalculation extends Dispatch {

	public static final String componentName = "pfizer_erisk_components.IEriskCalculation";

	public IEriskCalculation() {
		super(componentName);
	}

	/**
	* This constructor is used instead of a case operation to
	* turn a Dispatch object into a wider object - it must exist
	* in every wrapper class whose instances may be returned from
	* method calls wrapped in VT_DISPATCH Variants.
	*/
	public IEriskCalculation(Dispatch d) {
		// take over the IDispatch pointer
		m_pDispatch = d.m_pDispatch;
		// null out the input's pointer
		d.m_pDispatch = 0;
	}

	public IEriskCalculation(String compName) {
		super(compName);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param key an input-parameter of type String
	 * @param sMO an input-parameter of type double
	 * @param dIA an input-parameter of type double
	 * @param sBP an input-parameter of type double
	 * @param tCH an input-parameter of type double
	 * @param hDL an input-parameter of type double
	 * @param sex an input-parameter of type double
	 * @param lastParam an input-parameter of type double
	 * @return the result is of type double
	 */
	@SuppressWarnings("deprecation")
	public double calculateRisk_Framingham(String key, double sMO, double dIA, double sBP, double tCH, double hDL, double sex, double lastParam) {
		return Dispatch.call(this, "CalculateRisk_Framingham", key, new Variant(sMO), new Variant(dIA), new Variant(sBP), new Variant(tCH), new Variant(hDL), new Variant(sex), new Variant(lastParam)).toDouble();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param key an input-parameter of type String
	 * @param sMO an input-parameter of type double
	 * @param sBP an input-parameter of type double
	 * @param tCH an input-parameter of type double
	 * @param sex an input-parameter of type double
	 * @param lastParam an input-parameter of type double
	 * @return the result is of type double
	 */
	@SuppressWarnings("deprecation")
	public double calculateRisk_Score(String key, double sMO, double sBP, double tCH, double sex, double lastParam) {
		return Dispatch.call(this, "CalculateRisk_Score", key, new Variant(sMO), new Variant(sBP), new Variant(tCH), new Variant(sex), new Variant(lastParam)).toDouble();
	}

}
