/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.connector;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.jacob.com.DispatchEvents;
import com.jacob.com.Variant;

/**
 * Test application for the erisk interface
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: EriskConnectorTest.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class EriskConnectorTest extends JFrame implements ActionListener {

	private static final long serialVersionUID = -7136906735856379323L;
	private JLabel statusLabel;
	private JButton startButton;
	private EriskInterface ie;
	private JTextArea xmlField;

	public EriskConnectorTest() {
		super("E-Kompas Test");
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		this.setLayout(new BorderLayout());
		
		startButton = new JButton("start");
		this.add(startButton, BorderLayout.NORTH);
		startButton.addActionListener(this);
		
		this.xmlField = new JTextArea();
		this.add(new JScrollPane(xmlField), BorderLayout.CENTER);
		
		this.statusLabel = new JLabel();
		this.add(statusLabel, BorderLayout.SOUTH);
		
		this.setSize(600, 600);
		this.setVisible(true);
	}

	public class ERiskEvents {
		
		public void OnLoading(Variant[] args) {
			statusLabel.setText("Status:\t loading");
			System.out.println("loading");
		}

		public void OnReady(Variant[] args) {
			statusLabel.setText("Status:\t ready");
			System.out.println("ready");
		}
		
		public void OnQuit(Variant[] args) {
			statusLabel.setText("Status:\t quit");
			System.out.println("quit");
			
		}
		
		public void OnError(Variant[] args) {
			statusLabel.setText("Status:\t Error");
			System.out.println("error");
		}
		
		public void OnConsultationSaved(Variant[] args) {
			Variant v = args[0];
			xmlField.setText(v.getString().replaceAll("<", "\n<"));
			
			statusLabel.setText("Status:\t saved");
			System.out.println("save");
		}
	}
	
	
	public String loadFile() {
		try {
			StringBuffer sb = new StringBuffer();
			String thisLine = null;
			BufferedReader in = new BufferedReader(new FileReader(
					"erisk.xml"));
			while ((thisLine = in.readLine()) != null) {
				sb.append(thisLine);
			}
			in.close();
			return sb.toString();
		} catch (IOException e) {
			System.out.println("Read error " + e);
		}
		return "";
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new EriskConnectorTest();
	}

	public void actionPerformed(ActionEvent arg0) {
		
		xmlField.setText("");
		statusLabel.setText("");
		
		ie = new EriskInterface();
		
		String xml = loadFile();

		System.out.println(xml);
		
		
		ie.startEriskModule(xml, "E-KOMPAS");
//		ie.startEriskModule(xml, "E-RISK");

		new DispatchEvents(ie,new ERiskEvents());
		
		ie.safeRelease();
	}

}
