/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.allergy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Dialog to add/edit the patients allergies
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: AllergyManagerDialog.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:08:58  hermen
 * <br>*** empty log message ***
 * <br>
 *
 */
public class AllergyManagerDialog extends JDialog implements ActionListener{

	private static final long serialVersionUID = 1L;
	private JButton okButton;
	private AllergyPanel allergyPanel;
	private AllergyTableModel allergyTableModel;

	public AllergyManagerDialog() {
		super(MainFrame.getInstance(), Translatrix.getTranslationString("patient.allergy.allergies"));
		this.setModal(true);
		this.setLayout(new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, fill:pref:grow, 3dlu, pref, 5dlu"));
		CellConstraints cc = new CellConstraints();
		
		this.setBackground(GECAMedColors.c_GECAMedBackground);
		this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
		
		this.okButton = new JButton(Translatrix.getTranslationString("core.close"));
		this.okButton.addActionListener(this);
		
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGlue();
		bb.addGridded(okButton);
		
		JPanel buttonPanel = bb.getPanel();
		buttonPanel.setOpaque(false);
		this.add(buttonPanel, cc.xy(2,4));

		this.allergyTableModel = new AllergyTableModel();
		this.allergyPanel = new AllergyPanel(allergyTableModel);
		this.add(this.allergyPanel, cc.xy(2,2));
		
		this.pack();
		this.setResizable(false);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.okButton)) {
			this.allergyPanel.stopEditing();
			this.setVisible(false);
		}
	}
	
	/**
	 * shows the dialog centeres on the screen
	 */
	public void showDialog() {
		MainFrame.showDialogCentered(this);
	}
	
	public AllergyTableModel getModel() {
		return allergyTableModel;
	}
	
	
	/**
	 * just for testing
	 * @param args
	 */
	public static void main(String[] args) {
		AllergyManagerDialog diag = new AllergyManagerDialog();
		diag.showDialog();
	}
}
