package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.PhoneType;
import lu.tudor.santec.gecamed.core.gui.widgets.EMailField;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientContact;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientPhone;
import lu.tudor.santec.gecamed.patient.gui.simpleview.OverviewPanel;
import lu.tudor.santec.i18n.Translatrix;

public class PatientRemarks extends HeaderedPanel implements KeyListener, IPatientDataPanel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Instance fields ========================================================


    private JTextField storageField;

    private JTextArea remarksField;

    HashMap<String, PatientPhone> phones = new HashMap<String, PatientPhone>();
    private PatientAdminPanel patientEditPanel;
	private boolean listenersActivated;
	private JPanel mainPanel;
	private CellConstraints cc;
	private Patient currentPatient;
	private boolean editable;
	
    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public PatientRemarks(PatientAdminPanel patientEditPanel)
    {
    	this.setOpaque(false);
    	this.patientEditPanel = patientEditPanel;
        this.buildPanel();
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient)
     */
    @SuppressWarnings("unchecked")
	public void getPatient(Patient patient) {
    	
    	System.out.println(patient.getStorage());
    	
    	patient.setStorage(this.storageField.getText());
    	patient.setRemarks(this.remarksField.getText());
    	/*
    	List<PatientPhone> phoneList = new ArrayList<PatientPhone>();
    	
    	
    	
    	if (!this.storageField.getText().equals("") )  {
    		PatientPhone p = new PatientPhone();
    		p.setType(PhoneType.MOBILE);
    		p.setNumber(this.storageField.getText());
        	phoneList.add(p);	
    	}
    	
    	if (!this.remarksField.getText().equals("") )  {
    		PatientPhone p = new PatientPhone();
    		p.setType(PhoneType.OFFICE);
    		p.setNumber(this.remarksField.getText());
        	phoneList.add(p);	
    	}
    	
    
    	patient.setPhones(new HashSet(phoneList));
    
        */
        
    }

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#setPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient, boolean)
     */
    public void setPatient(Patient patient, boolean editable) {
		this.editable = editable;
		try {
			this.currentPatient = (Patient) patient;
			this.storageField.setText(patient.getStorage());
			this.remarksField.setText(this.currentPatient.getRemarks());
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		this.listenersActivated=true;
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel() {
    	/* ================================================== */
    	this.setHeader(Translatrix.getTranslationString("pm.remarks")+":");
//    	this.setHeaderIcon(PatientManagerModule.getMediumIcon(PatientManagerModule.PHONE));
    	
    	this.enableAlpha(true);
    	this.cc = new CellConstraints();
    	
        initComponents();
        buildViewPanel();
        
        this.setLayout(new BorderLayout());
        this.add(mainPanel, BorderLayout.CENTER);
     
    }


    /**
     * build the gui of the panel
     */
    private void buildViewPanel() {
    	/* ================================================== */
    	
    	this.mainPanel = new JPanel(new FormLayout(
    										// cols
    										"right:pref,right:40dlu,5dlu,fill:40dlu:grow,3dlu",
    										// rows
    										"3dlu," +
    										"fill:pref," +
    										"center:5dlu," + // separator
    										"3dlu," +
    										"top:pref," +
    										"3dlu," +
    										"fill:40dlu:grow," +
    										"3dlu"
    										));
    	mainPanel.setOpaque(false);
    	/* ------------------------------------------------------- */
    	JLabel storageLabel = OverviewPanel.createLabel("pm.storage");
    	JLabel remarksLabel = OverviewPanel.createLabel("pm.remarks");

    	JScrollPane scrollPane = new JScrollPane( this.remarksField );
    	
    	/* ------------------------------------------------------- */
    	// place the labels
    //	mainPanel.add(telLabel, 		cc.xy(2, 2));
    //	mainPanel.add(new JSeparator(), cc.xyw(2, 3, 3));
    	
    	mainPanel.add(storageLabel,         cc.xy(2, 2));
    	mainPanel.add(new JSeparator(), cc.xyw(2, 3, 3));
    	mainPanel.add(remarksLabel, 		cc.xy(2, 5));
    	
    /*	mainPanel.add(new JSeparator(), cc.xyw(2, 8, 3));
    	mainPanel.add(faxLabel, 		cc.xy(2, 10));
    	mainPanel.add(mailLabel, 		cc.xy(2, 12));*/
    	/* ------------------------------------------------------- */
    	// place the fields
    	

    	mainPanel.add(this.storageField, cc.xy(4, 2));
    	mainPanel.add(scrollPane,   cc.xywh(4, 5,1,3));

		/* ================================================== */
    }
    
    
    
    /**
     * initializes the Components
     */
    private void initComponents()
    {
        
        this.storageField = new JTextField(30);
        this.storageField.addKeyListener(this);
        
        this.remarksField = new JTextArea(8,30);
        this.remarksField.setLineWrap(true);
        this.remarksField.setWrapStyleWord(false);
        Border border = BorderFactory.createLineBorder(Color.DARK_GRAY);

        //this.remarksField.setSize(400, 200);
        this.remarksField.setBorder(border);
        this.remarksField.addKeyListener(this);
        

    }

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
		if (listenersActivated )
			this.patientEditPanel.setModified(true);
	}
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
	}
	
	/**
	 * enables the panel to be edited
	 * @param editable
	 */
	private void setEditable(boolean editable) {

    	this.storageField.setEditable(editable);
    	this.remarksField.setEditable(editable);

	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getComponentsForFocus()
	 */
	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		List<Component> list = new ArrayList<Component>();
		/* ------------------------------------------------------- */

		list.add(storageField);
		list.add(remarksField);

		/* ------------------------------------------------------- */
		return list;
		/* ====================================================== */
	}
	
	public boolean isFilledOK() {
	    return true;
	}
}
