/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.AddressbookModule;
import lu.tudor.santec.gecamed.addressbook.gui.list.ContactSearchDialog;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;


/**
 * Panel to display and edit the patients other doctors
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientPhysiciansPanel.java,v $
 * <br>Revision 1.5  2012-11-26 07:56:14  ferring
 * <br>New placeholders are introduced to the letter module
 * <br>The replacement algorithm in Word- and WriterCotnroller has been changed
 * <br>Multicontacts are prepared, but not yet implemented
 * <br>
 * <br>Revision 1.4  2010-03-12 14:13:17  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.3  2009-10-12 08:48:54  hermen
 * <br>now triggers patient changed events
 * <br>
 * <br>Revision 1.2  2009-10-08 09:24:12  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2009-10-01 13:49:13  hermen
 * <br>added physician panel to patient
 * <br>select CNS as default for new patient
 * <br>
 *
 */
public class PatientPhysiciansPanel extends HeaderedPanel implements KeyListener, IPatientDataPanel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
    private static final String LINESPACE = "2dlu"; 
    private static final String COLUMNSPACE = "2dlu"; 

    //~ Instance fields ========================================================

    private JTextArea otherDoctors;
    private PatientAdminPanel patientEditPanel;
	private boolean listenersActivated;
	private JButton bContact;

    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public PatientPhysiciansPanel(PatientAdminPanel patientEditPanel)
    {
    	this.setOpaque(false);
    	this.patientEditPanel = patientEditPanel;
        this.buildPanel();
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient)
     */
    public void getPatient(Patient patient) {
    	
    	if (!this.otherDoctors.getText().equals("") )  {
    		patient.setOtherPhysicians(this.otherDoctors.getText());
    	} else {
    		patient.setOtherPhysicians(null);
    	}
    }


    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#setPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient, boolean)
     */
    public void setPatient(Patient patient, boolean editable)
    {
    	
    	setEditable(editable);
    	
    	this.listenersActivated = false;

    	this.otherDoctors.setText(patient.getOtherPhysicians() != null ? patient.getOtherPhysicians() : "");
     	
        this.listenersActivated = true;
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel()
    {
        initComponents();
        // build Layout
        FormLayout layout = new FormLayout(
        	"fill:pref:grow, " + LINESPACE + ", pref, " + LINESPACE,
                "fill:max(20dlu;pref), " + COLUMNSPACE); 
        this.setLayout(layout);
        
        this.setHeader(Translatrix.getTranslationString("pm.otherDoctors")+":");
//        this.setHeaderIcon(PatientManagerModule.getMediumIcon(PatientManagerModule.PHYSICIAN));
    	this.enableAlpha(true);

        CellConstraints cc = new CellConstraints();

        // line 1
        JScrollPane jsp = new JScrollPane(this.otherDoctors);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        this.add(jsp, cc.xy(1, 1));
        
        if (AddressbookModule.getInstance() != null)
            this.add(bContact, cc.xy(3,1));
    }

    /**
     * initializes the Components
     */
    private void initComponents()
    {
    	this.otherDoctors = new JTextArea();
    	this.otherDoctors.addKeyListener(this);
    	
    	this.bContact = ButtonFactory.createNarrowButton(IconFetcher.getMediumIcon(AddressbookModule.class, AddressbookModule.ICON_ADDRESSBOOK));
    	this.bContact.addActionListener(new ActionListener() {

	public void actionPerformed(ActionEvent e) {
		/* ================================================== */
		List<Contact>	contacts	= ContactSearchDialog.showDialog(
			Translatrix.getTranslationString("LetterTemplateModule.dialog.searchRecipient"),"",null,false);
		Contact			contact;
		
		if (contacts != null && !contacts.isEmpty()) 
		{
			contact	= contacts.get(0);
			otherDoctors.append(contact.toString() + " [" + contact.toAddressString() + " " + contact.toPhoneString() + "]\n");
			if (listenersActivated )
				patientEditPanel.setModified(true);
		}
		/* ================================================== */
	}
});
      
    }

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
		if (listenersActivated )
			this.patientEditPanel.setModified(true);
	}
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
	}
	
	private void setEditable(boolean editable) {
		this.otherDoctors.setEditable(editable);
	}

	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		return new ArrayList<Component>(0);
		/* ====================================================== */
	}
	
	public boolean isFilledOK() {
	    return true;
	}
}
