/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;


/**
 * Panel to display and edit the patients internal IDs, such as 
 * HIS, hospital etc. ID
 * mainly used in hospital version
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientIDInfo.java,v $
 * <br>Revision 1.12  2013-06-21 12:45:10  ferring
 * <br>GECAMed ID added
 * <br>
 * <br>Revision 1.11  2013-06-10 08:22:14  ferring
 * <br>eSante POC
 * <br>
 * <br>Revision 1.10  2013-01-03 09:32:52  ferring
 * <br>M�decin R�f�rent ID added
 * <br>
 * <br>Revision 1.9  2010-03-12 14:13:17  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.8  2009-05-29 13:51:21  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2009-01-06 14:48:08  hermen
 * <br>small bugfixes
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-04-16 14:24:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-01-21 14:03:27  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class PatientIDInfo extends HeaderedPanel implements IPatientDataPanel, ActionListener, DocumentListener
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
    private static final String LINESPACE = "pref, 2dlu"; 
    private static final String COLUMNSPACE = "2dlu"; 

    //~ Instance fields ========================================================

    private JTextField idGECAMedField;
    private JTextField idMRField;
    private JTextField idRISField;
    private JToggleButton editRIS;
    private JTextField idLuxembourgField;
    private JTextField idEuropeanField;
    private PatientAdminPanel patientEditPanel;
	private boolean listenersActivated;
	private Patient patient;

    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public PatientIDInfo(PatientAdminPanel patientEditPanel)
    {
    	this.setOpaque(false);
    	this.patientEditPanel = patientEditPanel;
        this.buildPanel();
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient)
     */
    public void getPatient(Patient patient) {
    	
    	if (!this.idMRField.getText().equals(""))
    		patient.setMrDeclarationNo(idMRField.getText());
    	else
    		patient.setMrDeclarationNo(null);
    	
    	if (editRIS.isSelected()) {    		
    		if (!this.idRISField.getText().equals("") )  {
    			patient.setIdRIS(this.idRISField.getText());
    		} else {
    			patient.setIdRIS(null);
    		}
    	}
    	
//    	if (!this.idLuxembourgField.getText().equals("") )  {
//    		patient.setIdLuxembourg(this.idLuxembourgField.getText());
//    	} else {
//    		patient.setIdLuxembourg(null);
//    	}
    	
    	if (!this.idEuropeanField.getText().equals("") )  {
    		patient.setIdEuropean(this.idEuropeanField.getText());
    	} else {
    		patient.setIdEuropean(null);
    	}
    }


    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#setPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient, boolean)
     */
    public void setPatient(Patient patient, boolean editable)
    {
    	this.patient = patient;
    	
    	setEditable(editable);
    	
    	this.listenersActivated = false;
    	
    	this.editRIS.setSelected(false);
    	this.idRISField.setEditable(false);

    	this.idGECAMedField.setText(patient.getId() == null ? "" : String.valueOf(patient.getId()));
    	this.idMRField.setText(patient.getMrDeclarationNo() != null ? patient.getMrDeclarationNo() : "");
    	this.idRISField.setText(patient.getIdRIS() != null ? patient.getIdRIS() : "");
     	this.idLuxembourgField.setText(patient.getIdLuxembourg() != null ? patient.getIdLuxembourg() : "");
     	this.idEuropeanField.setText(patient.getIdEuropean() != null ? patient.getIdEuropean() : "");
     	
        this.listenersActivated = true;
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel()
    {
        initComponents();
        // build Layout
        StringBuilder line = new StringBuilder(); 
        for (int i = 1; i <= 5; i++) {
        	if (i < 5)
        		line.append("f:50dlu:g,").append(LINESPACE).append(",");
        	else
        		line.append("f:50dlu:g");
        }
        FormLayout layout = new FormLayout(
        		line.toString(), 
        		"b:p," + COLUMNSPACE); 
        this.setLayout(layout);
        
        this.setHeader(Translatrix.getTranslationString("pm.id")+":");
//        this.setHeaderIcon(PatientManagerModule.getMediumIcon(PatientManagerModule.IDTAG));
    	this.enableAlpha(true);
        
        //this.setBorder(new GECAMedTitledBorder(Translatrix.getTranslationString("ID")+":")); 
        CellConstraints cc = new CellConstraints();
        
        // line 1
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.idGECAM"),	this.idGECAMedField),	cc.xy(1, 1));
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.idMR"),	this.idMRField),		cc.xy(4, 1));
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.idRIS"),	this.idRISField),		cc.xy(7, 1));
        this.add(this.editRIS,																				cc.xy(8, 1));
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.idLux"),	this.idLuxembourgField),cc.xy(10, 1)); 
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.idEurope"),this.idEuropeanField),	cc.xy(13, 1));
    }

    /**
     * initializes the Components
     */
    private void initComponents()
    {
    	this.idGECAMedField	= new JTextField();
    	this.idMRField = new JTextField(); // no limited, as the varchar in the DB is not limited
    	this.idMRField.getDocument().addDocumentListener(this);
    	this.idRISField = new LimitTextField(30);
    	this.idRISField.getDocument().addDocumentListener(this);
    	
    	this.editRIS = new JToggleButton(GECAMedModule.getSmallIcon(GECAMedIconNames.EDIT));
    	this.editRIS.addActionListener(this);
    	this.editRIS.setPreferredSize(new Dimension(20,20));
//    	this.editRIS.setContentAreaFilled(false);
    	this.editRIS.setSelected(false);
    	
        this.idEuropeanField = new LimitTextField(30);
        this.idEuropeanField.getDocument().addDocumentListener(this);
        this.idLuxembourgField = new JTextField();
//      this.idLuxembourgField.addKeyListener(this);
        
    	this.idEuropeanField.setEditable(false);
    	this.idLuxembourgField.setEditable(false);
    	this.idGECAMedField.setEditable(false);
    }
	
	private void setEditable(boolean editable) {
//		this.idGECAMedField.setEditable(editable);
		this.idMRField.setEditable(editable);
		this.editRIS.setEnabled(editable);
//    	this.idLuxembourgField.setEditable(editable);
//    	this.idEuropeanField.setEditable(editable);
	}

	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		return new ArrayList<Component>(0);
		/* ====================================================== */
	}
	
	public boolean isFilledOK() {
	    return true;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.editRIS)) {
			idRISField.setEditable(editRIS.isSelected());
			if (!editRIS.isSelected()) {
				// reset ID
				this.idRISField.setText(patient.getIdRIS() != null ? patient.getIdRIS() : "");
			}
		}
	}

	public void insertUpdate(DocumentEvent e) {
		if (listenersActivated )
			this.patientEditPanel.setModified(true);
	}

	public void removeUpdate(DocumentEvent e) {
		if (listenersActivated )
			this.patientEditPanel.setModified(true);
	}

	public void changedUpdate(DocumentEvent e) {
		if (listenersActivated )
			this.patientEditPanel.setModified(true);
	}
}
