/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.AddressType;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;

/** 
 * TableCellRenderer for addresses.
 * addresses are rendered with an Icon to show their type.
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: AddressTypeRenderer.java,v $
 * <br>Revision 1.7  2008-10-21 09:53:34  hermen
 * <br>fixed patient slot bug
 * <br>enhanced logging
 * <br>code cleanup
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-03-20 16:19:32  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-01-21 14:03:27  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class AddressTypeRenderer extends DefaultTableCellRenderer {

	private static final long serialVersionUID = 1L;
	
	/**
	 * Icon to mark private addresses
	 */
	public static final ImageIcon PRIVAT = IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.ADDRESS_PRIVAT);
	
	/**
	 * Icon to mark the work address
	 */
    public static final ImageIcon WORK = IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.ADDRESS_WORK);
    
	/**
	 * Icon to mark the billing address
	 */
    public static final ImageIcon BILLING = IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.ADDRESS_BILLING);
    
	/**
	 * Icon to mark addresses importet from the HIS
	 */
    public static final ImageIcon HIS = IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.ADDRESS_HIS);
    
    public AddressTypeRenderer() {
    }
	
	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
				row, column);
		try {
			if (value.toString().equals(AddressType.PRIVATE)) {
				this.setIcon(PRIVAT);
			} else if (value.toString().equals(AddressType.WORK)) {
				this.setIcon(WORK);
			} else if (value.toString().equals(AddressType.BILLING)) {
				this.setIcon(BILLING);
			} else if (value.toString().equals(AddressType.HIS)) {
				this.setIcon(HIS);
			}
		} catch (Exception e) {
			this.setIcon(null);
		}
		return this;
	}
}
