/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: SecurityQuestionDialog.java,v $
 * <br>Revision 1.9  2013-02-21 15:44:31  ferring
 * <br>Dialog de-Heinemannized
 * <br>
 * <br>Revision 1.8  2013-02-21 14:57:00  kutscheid
 * <br>create borders just once
 * <br>
 * <br>Revision 1.7  2013-02-21 14:14:22  ferring
 * <br>Improved the security dialog layout in order to fix it for linux
 * <br>
 * <br>Revision 1.6  2013-02-19 08:05:48  kutscheid
 * <br>fix a repainting issue
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.3  2007-09-18 13:57:51  heinemann
 * <br>changed secure code from random chars to just numbers
 * <br>
 * <br>Revision 1.2  2007/04/23 07:49:38  heinemann
 * <br>Title for SecurityQuestionDialog
 * <br>
 * <br>Revision 1.1  2007/04/20 11:35:48  heinemann
 * <br>new feature, delete a patient!
 * <br>
 *
 */
package lu.tudor.santec.gecamed.patient.gui;

import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * A dialog that demands a sequence of characters to
 * get in ok state.
 * The sequence is generated randomly each time the dialog
 * is shown. You can specify the amount of digits to enter. It will use only characters and numbers.
 *
 * @author martin.heinemann@tudor.lu
 * 20.04.2007
 * 09:57:58
 *
 *
 * @version
 * <br>$Log: SecurityQuestionDialog.java,v $
 * <br>Revision 1.9  2013-02-21 15:44:31  ferring
 * <br>Dialog de-Heinemannized
 * <br>
 * <br>Revision 1.8  2013-02-21 14:57:00  kutscheid
 * <br>create borders just once
 * <br>
 * <br>Revision 1.7  2013-02-21 14:14:22  ferring
 * <br>Improved the security dialog layout in order to fix it for linux
 * <br>
 * <br>Revision 1.6  2013-02-19 08:05:48  kutscheid
 * <br>fix a repainting issue
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.3  2007-09-18 13:57:51  heinemann
 * <br>changed secure code from random chars to just numbers
 * <br>
 * <br>Revision 1.2  2007/04/23 07:49:38  heinemann
 * <br>Title for SecurityQuestionDialog
 * <br>
 * <br>Revision 1.1  2007/04/20 11:35:48  heinemann
 * <br>new feature, delete a patient!
 * <br>
 *
 */
public class SecurityQuestionDialog extends GECAMedBaseDialogImpl 
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID		= 1L;
	
	private static final Border GRAY_LINE_BORDER	= BorderFactory.createLineBorder(Color.DARK_GRAY, 1);
	
	private static final Border RED_LINE_BORDER		= BorderFactory.createLineBorder(Color.RED, 2);
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static SecurityQuestionDialog instance = new SecurityQuestionDialog();
	
	
	private String		secureCode	= "";
	
	private boolean		state		= false;
	
	private JLabel		codeLabel;
	
	private JTextField	codeField;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	private SecurityQuestionDialog() 
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("pm.deletePatient"),
				OK_CANCEL_BUTTON_MODE);
		
		initComponent();
	}
	
	
	/**
	 * Get the singleton instance
	 *
	 * @return
	 */
	public static SecurityQuestionDialog getInstance() 
	{
		return instance;
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	/**
	 * Show the dialog.
	 * 
	 * @param title The title of the dialog
	 * @param headerText Text that describes the situation why this dialog is used. a.k.a. question
	 * @param digits number of digits to enter
	 * 
	 * @return true if code is ok, false if aborted or wrong input 
	 */
	public boolean showDialog () 
	{
		// show the dialog
		if (showCenteredDialog() == OK_OPTION)
			return state;
		else
			return false;
	}
	
	
	@Override
	public void prepareToShowUp()
	{
		// reset the typed code from last time
		codeField.setText("");
		codeField.setBorder(GRAY_LINE_BORDER);
		
		// generate and set a new code
		secureCode = generateCode(5);
		codeLabel.setText(
				"<html><b><font size=6>" + 
				secureCode + 
				"</font></b></html>");
		
		pack();
		super.prepareToShowUp();
	}
	
	
	@Override
	public void okActionCalled()
	{
		checkCode();
		
		if (state == false) 
		{
			// red frame
			codeField.setBorder(RED_LINE_BORDER);
		} 
		else 
		{
			super.okActionCalled();
		}
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private void initComponent() 
	{
		CellConstraints	cc = new CellConstraints();
		JLabel			warningLabel;
		JLabel			infoLabel;
		JLabel			codeFieldLabel;
		
		
		warningLabel	= new JLabel(
				Translatrix.getTranslationString("pm.deletePatientWarning"),
				GECAMedModule.getBigIcon(GECAMedIconNames.WARNING), 
				JLabel.LEFT);
		warningLabel.setOpaque(false);
		warningLabel.setBorder(GRAY_LINE_BORDER);
		
		infoLabel		= new JLabel(Translatrix.getTranslationString("pm.securityInfo"));
		infoLabel.setOpaque(false);
		
		codeLabel		= new JLabel();
		codeLabel.setOpaque(false);
		
		codeFieldLabel	= new JLabel(Translatrix.getTranslationString("pm.code"));
		codeFieldLabel.setOpaque(false);
		
		codeField		= new JTextField(15);
		
		mainPanel.setLayout(new FormLayout(
				// columns
				"5px, f:p, 5px, l:p:g, 5px", 
				// rows
				" 5px,f:p," +	// warning
				"20px,f:p," +	// info
				"10px,f:p," +	// code
				"30px,f:p," +	// code field
				"15px"));
		
		mainPanel.add(warningLabel,		cc.xyw(2, 2, 3));
		mainPanel.add(infoLabel,		cc.xyw(2, 4, 3));
		mainPanel.add(codeLabel,		cc.xyw(2, 6, 3, CellConstraints.CENTER, CellConstraints.TOP));
		mainPanel.add(codeFieldLabel,	cc.xy (2, 8));
		mainPanel.add(codeField,		cc.xy (4, 8));
	}
	
	
	/**
	 * Generate a code.
	 *
	 * @param digits
	 * @return
	 */
	private static String generateCode(int digits) 
	{
		int	pow	= (int) Math.pow(10, digits);
		int	r	= (int)(Math.random() * pow);
		
		
		if (r < pow / 10)
			r += pow / 10;
		
		return String.valueOf(r);
	}
	
	
	/**
	 * Checks the code
	 */
	private void checkCode() 
	{
		String entered = codeField.getText();
		
		
		if (entered == null)
			state = false;
		else if (entered.trim().equals(secureCode))
			state = true;
		else
			state = false;
	}
}


