/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;

import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.administrative.PatientAdminPanel;


/**
 * A dialog to create a patient. It use the class PatientAdminPanel how include all GUI components and panel to enter patient data.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientCreateDialog.java,v $
 * <br>Revision 1.3  2013-12-27 18:09:17  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.2  2010-12-21 13:58:44  troth
 * <br>Add propertyChangeListener to enable and disable ok button if need fields in the panel are filled.
 * <br>
 * <br>Revision 1.1  2010-08-18 13:58:21  troth
 * <br>Add a small patient create dialog to Agenda-, Waitingroom- module | Complete - # 608: Agenda/Waitingroom
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/608
 * <br>
 */
public class PatientCreateDialog extends GECAMedBaseDialog implements ActionListener, PropertyChangeListener {

	private static final long serialVersionUID = 1L;
	
	private PatientAdminPanel patientAdminPanel;
	
	private Patient currentPatient; 
	
	
	public PatientCreateDialog(String title, boolean createOkButton,
			boolean createCancelButton) {
		super(title, createOkButton, createCancelButton);
		initDialog();
	}
	
	/**
	 * Init the Dialog with all the panels.
	 */
	public void initDialog() {
		this.okButton.addActionListener(this);
		this.okButton.setEnabled(false);
		this.cancelButton.addActionListener(this);
		
		// init witch patient data panels are added
		String[] panels = {
				"lu.tudor.santec.gecamed.patient.gui.administrative.PatientBasicAdminInfoPanel",
				"lu.tudor.santec.gecamed.patient.gui.administrative.PatientPhoneInfo",
				"lu.tudor.santec.gecamed.patient.gui.administrative.PatientContactInfo"
		};
		this.patientAdminPanel = new PatientAdminPanel(panels);
		this.patientAdminPanel.addPropertyChangeListener(this);
		this.add(this.patientAdminPanel);
	}
	
	/**
	 * Open the create patient dialog
	 * 
	 * @return the new patient if it is created else it returns null.
	 */
	public Patient showDialog(HashMap<String, String> initialPatData) {
		this.patientAdminPanel.setPatient(new Patient(initialPatData));
//		pack();
		setSize(1000, 720);
		MainFrame.showDialogCentered(this);
		return this.currentPatient;
	}
	
	/**
	 * Open the create patient dialog
	 * 
	 * @return the new patient if it is created else it returns null.
	 */
	public Patient showDialog() {
		return showDialog(null);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 * 
	 * The actions for the ok and cancel button.
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.okButton)) {
			this.patientAdminPanel.saveData();
			this.currentPatient = this.patientAdminPanel.getPatient();
		}
		if (e.getSource().equals(this.cancelButton)) {
			this.currentPatient = null;	
		}
	}
	
	/* (non-Javadoc)
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 * 
	 * If the patientAdminPanel is filled right the ok-Button turn to enabled and the user can save the patient.
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		
		if(evt.getPropertyName().equals(GECAMedTab.DATA_CHANGED))
		{
			if(this.patientAdminPanel.isFilledOK())
			{
				this.okButton.setEnabled(true);
			}else{
				this.okButton.setEnabled(false);
				
			}
		}
	}

}
