/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui;

import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;


/**
 * a renderer for Insurance objects in comboboxes
 *
 * @author Nico MACK
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class InsuranceComboBoxRenderer extends DefaultComboBoxRenderer
{
	private boolean m_OnlyAcronym;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
    private static final long serialVersionUID = 1L;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public InsuranceComboBoxRenderer (boolean p_OnlyAcronym)
	{
	m_OnlyAcronym = p_OnlyAcronym;
 	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

protected String getRenderString (Object p_Object)
    {
    Insurance l_Insurance;
    
    if (p_Object instanceof Insurance)
    		{
    		l_Insurance = (Insurance) p_Object;
    
    		if (m_OnlyAcronym == true) return l_Insurance.getAcronym();
    							 else return l_Insurance.getName();
    		}
    return "";
    }

//---------------------------------------------------------------------------

protected String getToolTipString (Object p_Object)
    {
    Insurance l_Insurance;
    
    if (p_Object instanceof Insurance)
    		{
    		l_Insurance = (Insurance) p_Object;
    
    		return l_Insurance.getName();
    		}
    return "";
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
