/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.interfaces;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Allergens;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Allergies;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Antecedents;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientDatas;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* @author jhermen
* @created 06/07/03
*
*/

@Remote
public interface HistoryManager
	{

//	public Collection<HistoryElement> getPatientHistory (Integer patientID) throws Exception;
	@RolesAllowed("gecam")
	public Collection<Antecedents> getAntecedentsByPatientID (Integer patientID) throws Exception;
	
	@RolesAllowed("gecam")
	public Antecedents	saveAntecedents (Antecedents antecedents) throws Exception;
	
	@RolesAllowed("gecam")
	public void	deleteAntecedents (Antecedents antecedents) throws Exception;
	
	@RolesAllowed("gecam")
	public PatientDatas getPatientDatas(Integer id) throws Exception;
	
	@RolesAllowed("gecam")
	public PatientDatas savePatientDatas(PatientDatas data, boolean chronicalTreatmentsChanged, boolean problemActiveChanged) throws Exception;

	@RolesAllowed("gecam")
	public Collection<Allergens> getAllergens()  throws Exception;
	
	@RolesAllowed("gecam")
	public Vector<Allergies> getAllergies(Integer patientID)  throws Exception;
	
	@RolesAllowed("gecam")
	public Allergies	saveAllergie (Allergies allergy) throws Exception;
	
	@RolesAllowed("gecam")
	public void	deleteAllergie (Allergies allergy) throws Exception;
	
	@RolesAllowed("gecam")
	public List<Incident>fetchIncidents(Integer patientID);
	
	@RolesAllowed("gecam")
	public Incident mergeIncident(Incident incident);
	
	@RolesAllowed("gecam")
	public Collection<Incident> getPatientIncidents(Integer patientId);
	
	/**
	 * Returns the latest number incidents of the patient
	 * 
	 * @param patientId
	 * @return
	 */
	@RolesAllowed("gecam")
	public Collection<Incident> getLatestIncident(Integer patientId, int number);

	/**
	 * Returns the latest incidents of the patient since the startDate
	 * 
	 * @param patientId
	 * @return
	 */
	@RolesAllowed("gecam")
	public Collection<Incident> getPatientIncidents (Integer patientId, Calendar startDate, Calendar endDate);

//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
