/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientMemo;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IPatientPermissions;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Stateless
@Remote (PatientMemoInterface.class)
public class PatientMemoManagerBean implements PatientMemoInterface
	{
	private static final long serialVersionUID = 1L;

	@PersistenceContext (unitName="gecam")
	EntityManager m_EntityManager;

    @EJB
    LoginInterface login;

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//    getNumberOfPatientMemosForPatientIDAndAuthor
//---------------------------------------------------------------------------

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface#getMemoCountByPatientID(java.lang.Integer)
 */
public Long getMemoCountByPatientID(Integer p_ID) throws Exception {
	if (this.login.userHasPermission(IPatientPermissions.VIEW_ALL_MEMOS) ||
			this.login.userHasPermission(IPatientPermissions.EDIT_ALL_MEMOS)) {
		// fetch Nr. of all memos
		return (Long) m_EntityManager.createNamedQuery ("getNumberOfPatientMemosForPatientID")
							.setParameter ("patientID", p_ID)
							.getSingleResult();
	}  else if (this.login.userHasPermission(IPatientPermissions.VIEW_OWN_MEMOS) ||
			this.login.userHasPermission(IPatientPermissions.EDIT_OWN_MEMOS)) {
		// fetch only Nr. of the users memos
		return (Long) m_EntityManager.createNamedQuery ("getNumberOfPatientMemosForPatientID")
							.setParameter ("patientID", p_ID)
							.setParameter ("author", this.login.getCurrentUser())
							.getSingleResult();
	}
	//	 no rights, no memos
	return Long.valueOf(0);
}

//---------------------------------------------------------------------------

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface#getMemosByPatientID(java.lang.Integer)
 */
@SuppressWarnings("unchecked")
public Collection<PatientMemo> getMemosByPatientID (Integer patientID) throws Exception {
	List 	l_Memos = new ArrayList();

	if (this.login.userHasPermission(IPatientPermissions.VIEW_ALL_MEMOS) ||
			this.login.userHasPermission(IPatientPermissions.EDIT_ALL_MEMOS)) {
		// fetch all memos
		l_Memos = m_EntityManager.createNamedQuery ("getPatientMemosByPatientID")
		.setParameter ("patientID", patientID)
		.getResultList();
		return l_Memos;
	} else if (this.login.userHasPermission(IPatientPermissions.VIEW_OWN_MEMOS) ||
			this.login.userHasPermission(IPatientPermissions.EDIT_OWN_MEMOS)) {
		// fetch only the users memos
		l_Memos = m_EntityManager.createNamedQuery ("getPatientMemosByPatientIDAndAuthor")
		.setParameter ("patientID", patientID)
		.setParameter ("author", this.login.getCurrentUser())
		.getResultList();
		return l_Memos;
	}
	// no rights, no memos
	return l_Memos;
	}

//---------------------------------------------------------------------------

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface#getMemosByAuthor(lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser)
 */
@SuppressWarnings("unchecked")
public Collection<PatientMemo> getMemosByAuthor (GecamedUser author) throws Exception
	{
	Collection 	l_Memos;
	l_Memos = m_EntityManager.createNamedQuery ("getPatientMemosByAuthorID")
							.setParameter ("author", author)
							.getResultList();
	return l_Memos;
	}

//---------------------------------------------------------------------------

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface#saveMemo(lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientMemo)
 */
public PatientMemo saveMemo(PatientMemo p_Memo) throws Exception {
	if (p_Memo.isPersistent())
		m_EntityManager.merge (p_Memo);
	 else
		 m_EntityManager.persist (p_Memo);

	return m_EntityManager.find(PatientMemo.class, p_Memo.getId());
}

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface#deleteMemo(lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientMemo)
 */
public void deleteMemo(PatientMemo p_Memo) throws Exception {
	if (p_Memo.isPersistent()) {
		m_EntityManager.remove(
				m_EntityManager.find(PatientMemo.class, p_Memo.getId()));
	}
}

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.patient.ejb.session.interfaces.PatientMemoInterface#getWarningMemos(java.lang.Integer)
 */
@SuppressWarnings("unchecked")
public List<PatientMemo> getWarningMemos(Integer patientId) {
	/* ====================================================== */
	Query q = m_EntityManager.createQuery("SELECT Object(o) FROM PatientMemo o " +
											"WHERE o.patientID = :patientId " +
											"AND o.important = true");
	q.setParameter("patientId", patientId);
	try  {
		List<PatientMemo> result = q.getResultList();
		return result;
	} catch (Exception e) {
		return new ArrayList<PatientMemo>(0);
	}
	/* ====================================================== */
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
