/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.beans;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.InsurancePlan;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.InsuranceInterface;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Stateless
@Remote (InsuranceInterface.class)
public class InsuranceBean implements InsuranceInterface
	{
//	private static final long serialVersionUID = 1L;
	
	@PersistenceContext (unitName="gecam")
	EntityManager m_EntityManager;

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * The getArrayFromCollection converts the Result Lists returned by
 * queries into object arrays.
 * @param p_Collection specifies the Object Collection return by query
 * @return an object array holding the objects contained in p_Collection
 */
//---------------------------------------------------------------------------
		
private Insurance [] getArrayFromCollection (Collection p_Collection)	
	{
	Insurance[]  l_Array;
    Iterator		l_Iterator;
	int			l_Index;
	
	l_Array = new Insurance [p_Collection.size()];
	 
	l_Index = 0;
    
    for (l_Iterator = p_Collection.iterator(); l_Iterator.hasNext();) 
    		{
    		l_Array [l_Index++] = (Insurance)l_Iterator.next();
    		}
    
    return l_Array;
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public Insurance getInsuranceByID (Integer p_ID) throws Exception 
	{
	Insurance l_Insurance;
	
	l_Insurance = m_EntityManager.find(Insurance.class, p_ID);
	return l_Insurance;
	}

//---------------------------------------------------------------------------

public void setInsurance (Insurance p_Insurance) throws Exception 
	{
	m_EntityManager.persist (p_Insurance);
	}

//---------------------------------------------------------------------------

public void save (Insurance p_Insurance)
	{
	m_EntityManager.merge(p_Insurance);
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection <Insurance> getAllInsurances() throws Exception 
	{
	Collection 	l_Insurances;
	
	l_Insurances = m_EntityManager.createNamedQuery ("getAllInsurances").getResultList();
   
    return l_Insurances;
	}

//---------------------------------------------------------------------------
@SuppressWarnings("unchecked")
public Collection <Insurance> getPrimaryInsurances() throws Exception 
	{
	Collection 	l_Insurances;
	
	l_Insurances = m_EntityManager.createNamedQuery ("getPrimaryInsurances").getResultList();
   
    return l_Insurances;
	}

//---------------------------------------------------------------------------
@SuppressWarnings("unchecked")
public Collection <Insurance> getThirdPartyPayingInsurances() throws Exception 
	{
	Collection 	l_Insurances;
	
	l_Insurances = m_EntityManager.createNamedQuery ("getThirdPartyPayingInsurances").getResultList();
   
    return l_Insurances;
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection<Insurance> getPrivateInsurances() throws Exception 
	{
	Collection 	l_Insurances;
	
	l_Insurances = m_EntityManager.createNamedQuery ("getPrivateInsurances").getResultList();
   
    return l_Insurances;
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection<Insurance> getUCMAffiliatedInsurances() throws Exception 
	{
	Collection 	l_Insurances;
	
	l_Insurances = m_EntityManager.createNamedQuery ("getUCMAffiliatedInsurances").getResultList();
   
    return l_Insurances;
	}

@SuppressWarnings("unchecked")
public Collection<Insurance> getDisbandedInsurances ()
	{
	Collection<Insurance> 	l_Insurances;
	
	l_Insurances = m_EntityManager.createNamedQuery (Insurance.c_DisbandedInsurances).getResultList();
   
    return l_Insurances;
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection <InsurancePlan> getAllInsurancePlans() throws Exception 
	{
	Collection 		l_InsurancePlans;
	
	l_InsurancePlans = m_EntityManager.createNamedQuery ("getAllInsurancePlans").getResultList();
 
	return l_InsurancePlans;
	}

//---------------------------------------------------------------------------

public Insurance[] getAllInsurancesAsArray() throws Exception 
	{
    return this.getArrayFromCollection (this.getAllInsurances());
	}

//---------------------------------------------------------------------------

public Insurance[] getPrimaryInsurancesAsArray() throws Exception 
	{
    return this.getArrayFromCollection (this.getPrimaryInsurances());
	}

//---------------------------------------------------------------------------

public Insurance[] getThirdPartyPayingInsurancesAsArray() throws Exception 
	{
    return this.getArrayFromCollection (this.getThirdPartyPayingInsurances());
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public InsurancePlan[] getAllInsurancePlansAsArray() throws Exception 
	{
	Collection 		l_InsurancePlans;
	InsurancePlan[]  l_InsurancePlanArray = null;
	
	l_InsurancePlans = this.getAllInsurancePlans();
   
	if (l_InsurancePlans != null)
		{
		l_InsurancePlanArray = new InsurancePlan [l_InsurancePlans.size()];
		l_InsurancePlans.toArray(l_InsurancePlanArray);
		}
	
	return l_InsurancePlanArray;
	}

//---------------------------------------------------------------------------

	@SuppressWarnings("unchecked")
	public Collection<Insurance> findInsurancesByAcronym(String acronym) {
		return m_EntityManager.createNamedQuery(Insurance.c_InsurancesByAcronym).setParameter("acronym", acronym + "%").getResultList();
	}
	
	
	public Insurance getInsuranceByAcronym (String acronym)
	{
		return (Insurance) m_EntityManager.createQuery(
						"SELECT OBJECT(i) FROM Insurance i " + 
						"WHERE UPPER(acronym) = UPPER(:acronym)")
				.setParameter("acronym", acronym)
				.getSingleResult();
	}


//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
