/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>patient.patient_phone</b> table.
 * represents one single phone entry for a patient
 *
 * @version
 * <br>$Log: PatientPhone.java,v $
 * <br>Revision 1.7  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-07-16 09:08:49  hermen
 * <br>modified toString methods
 * <br>
 * <br>Revision 1.5  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllPatientPhone",
        query="SELECT OBJECT(o) FROM PatientPhone o"),
    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findAllPatientPhoneByPatientId",
        query="SELECT OBJECT(o) FROM PatientPhone o WHERE o.patientId = :patientId")
})

@Entity
@Table(name = "patient_phone", schema = "patient")
public class PatientPhone extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String number;
	private String type;
	private Integer patientId;
	
	/**
	 * Get the number.
	 *
	 * @return The number.
	 */
	@javax.persistence.Column(name = "number")
	public String  getNumber() {
		return number;
	}

	/**
	 * Set the number.
	 *
	 * @param data The number.
	 */
	public void setNumber(String number) {
		this.number = number;
	}
	
	/**
	 * Get the type.
	 *
	 * @return The type.
	 */
	@javax.persistence.Column(name = "type")
	public String  getType() {
		return type;
	}

	/**
	 * Set the number.
	 *
	 * @param data The number.
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Get the patientId.
	 *
	 * @return The patientId.
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientId() {
		return patientId;
	}

	/**
	 * Set the patientId.
	 *
	 * @param filename The patientId.
	 */
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}

	
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	
	public PatientPhone copy() {
		/* ====================================================== */
		PatientPhone p = new PatientPhone();
		
		p.setNumber(this.getNumber());
		p.setType(this.getType());
		
		return p;
		/* ====================================================== */
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
	    return getType() + ": " + getNumber();
	} 
	
}
