/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * Entity Bean that maps the <b>patient.patient_memo</b> table.
 * represents one single text memo that is attached to a patient
 *
 * @version
 * <br>$Log: PatientMemo.java,v $
 * <br>Revision 1.8  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@Entity
@Table(name = "patient_memo", schema = "patient")

@NamedQueries
	({
	@NamedQuery(name = "getPatientMemosByPatientID", query = "SELECT OBJECT(o) FROM PatientMemo o WHERE o.patientID = :patientID ORDER BY o.creationDate"),
	@NamedQuery(name = "getPatientMemosByPatientIDAndAuthor", query = "SELECT OBJECT(o) FROM PatientMemo o WHERE o.patientID = :patientID AND o.author = :author ORDER BY o.creationDate"),
	@NamedQuery(name = "getNumberOfPatientMemosForPatientID", query = "SELECT COUNT(o) FROM PatientMemo o WHERE o.patientID = :patientID"),
	@NamedQuery(name = "getNumberOfPatientMemosForPatientIDAndAuthor", query = "SELECT COUNT(o) FROM PatientMemo o WHERE o.patientID = :patientID AND o.author = :author"),
	@NamedQuery(name = "getPatientMemosByAuthor",  query = "SELECT OBJECT(o) FROM PatientMemo o WHERE o.author = :author ORDER BY o.creationDate")
	})

public class PatientMemo extends GECAMedEntityBean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		patientID;
	private Date			creationDate;
	private GecamedUser		author;
	private String		note;
	private Boolean	important;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public PatientMemo ()
	{
	creationDate = new Date ();
	note		  = "";
	}

//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * Returns the patientID this memo is owned by
 * @return the owning patientID of this memo
 */
//---------------------------------------------------------------------------

@Column (name ="patient_id")
public Integer getPatientID()
	{
	return this.patientID;
	}

//---------------------------------------------------------------------------
/**
 * Sets the patientID this memo is owned by
 * @param p_Invoice specifies the owner of this memo
 */
//---------------------------------------------------------------------------

public void setPatientID (Integer patientID)
	{
	this.patientID = patientID;
	}

//---------------------------------------------------------------------------
/**
 * Returns the creation date of this memo
 * @return memo creation date
 */
//---------------------------------------------------------------------------

@Column (name ="created")

public Date getCreationDate()
	{
	return this.creationDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the creation of this memo
 * @param p_CreationDate specifies the creation date of this memo
 */
//---------------------------------------------------------------------------

public void setCreationDate (Date creationDate)
	{
	this.creationDate = creationDate;
	}

//---------------------------------------------------------------------------
/**
 * Returns the author of this memo
 * @return The author who created this memo
 */
//---------------------------------------------------------------------------

@ManyToOne
@JoinColumn (name ="author_id")
public GecamedUser getAuthor()
	{
	return this.author;
	}

//---------------------------------------------------------------------------
/**
 * Sets the author of this memo
 * @param author specifies the user who created this memo
 */
//---------------------------------------------------------------------------

public void setAuthor (GecamedUser author)
	{
	this.author = author;
	}

//---------------------------------------------------------------------------
/**
 * Returns the actual text of this memo
 * @return memo text
 */
//---------------------------------------------------------------------------

@Column (name ="note")

public String getNote()
	{
	return note;
	}

//---------------------------------------------------------------------------
/**
 * Sets the actual text of this memo
 * @param p_CreationDate specifies the creation date of this memo
 */
//---------------------------------------------------------------------------

public void setNote (String p_Note)
	{
	note = p_Note;
	}
//---------------------------------------------------------------------------

/**
 * @return the important
 */
@Column(name="important")
public Boolean getImportant() {
	if (important == null)
		return false;
	return important;
}

/**
 * @param important the important to set
 */
public void setImportant(Boolean important) {
	this.important = important;
}





//***************************************************************************
//* End of Class															*
//***************************************************************************
}
