/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@javax.persistence.NamedQueries( {
		@NamedQuery(name = PatientIncidentStatisticStub.FIND_ALL_PATIENTINCIDENTSTATISTICS_BY_SITE_AND_DATE, query = "SELECT OBJECT(o) FROM PatientIncidentStatisticStub o " +
				"WHERE o.siteID = :siteID AND o.incidentDate >= :dateFrom AND o.incidentDate <= :dateTo ORDER BY o.siteID, o.incidentDate"),
		@NamedQuery(name = PatientIncidentStatisticStub.FIND_ALL_PATIENTINCIDENTSTATISTICS, query = "SELECT OBJECT(o) FROM PatientIncidentStatisticStub o " +
				"WHERE o.incidentDate >= :dateFrom AND o.incidentDate <= :dateTo ORDER BY o.siteID, o.incidentDate")
})
@Entity
@Table(name = "patient_incident_statistics", schema = "patient")
public class PatientIncidentStatisticStub extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	public static final String FIND_ALL_PATIENTINCIDENTSTATISTICS_BY_SITE_AND_DATE = "findAllPatientIncidentStatisticsBySiteIDandDate";
	public static final String FIND_ALL_PATIENTINCIDENTSTATISTICS = "findAllPatientIncidentStatistics";
	
	private String patientTitle;
	private String patientSurname;
	private String patientFirstname;
	private String patientSSN;
	private Date 	incidentDate;
	private String drTitle;
	private String drSurname;
	private String drFirstname;
	private String drUCMCode;
	private String siteName;
	private Integer siteID;
	
	/**
	 * @return the patientTitle
	 */
	@javax.persistence.Column(name = "patient_title")
	public String getPatientTitle() {
	    return patientTitle;
	}
	/**
	 * @param patientTitle the patientTitle to set
	 */
	public void setPatientTitle(String patientTitle) {
	    this.patientTitle = patientTitle;
	}
	
	
	/**
	 * @return the patientSurname
	 */
	@javax.persistence.Column(name = "patient_surname")
	public String getPatientSurname() {
	    return patientSurname;
	}
	/**
	 * @param patientSurname the patientSurname to set
	 */
	public void setPatientSurname(String patientSurname) {
	    this.patientSurname = patientSurname;
	}
	
	
	/**
	 * @return the patientFirstname
	 */
	@javax.persistence.Column(name = "patient_firstname")
	public String getPatientFirstname() {
	    return patientFirstname;
	}
	/**
	 * @param patientFirstname the patientFirstname to set
	 */
	public void setPatientFirstname(String patientFirstname) {
	    this.patientFirstname = patientFirstname;
	}
	
	
	/**
	 * @return the patientSSN
	 */
	@javax.persistence.Column(name = "patient_ssn")
	public String getPatientSSN() {
	    return patientSSN;
	}
	/**
	 * @param patientSSN the patientSSN to set
	 */
	public void setPatientSSN(String patientSSN) {
	    this.patientSSN = patientSSN;
	}
	
	
	/**
	 * @return the incidentDate
	 */
	@javax.persistence.Column(name = "incident_date")
	public Date getIncidentDate() {
	    return incidentDate;
	}
	/**
	 * @param incidentDate the incidentDate to set
	 */
	public void setIncidentDate(Date incidentDate) {
	    this.incidentDate = incidentDate;
	}
	
	
	/**
	 * @return the drTitle
	 */
	@javax.persistence.Column(name = "dr_title")
	public String getDrTitle() {
	    return drTitle;
	}
	/**
	 * @param drTitle the drTitle to set
	 */
	public void setDrTitle(String drTitle) {
	    this.drTitle = drTitle;
	}
	
	
	/**
	 * @return the drSurname
	 */
	@javax.persistence.Column(name = "dr_surname")
	public String getDrSurname() {
	    return drSurname;
	}
	/**
	 * @param drSurname the drSurname to set
	 */
	public void setDrSurname(String drSurname) {
	    this.drSurname = drSurname;
	}
	
	
	/**
	 * @return the drFirstname
	 */
	@javax.persistence.Column(name = "dr_firstname")
	public String getDrFirstname() {
	    return drFirstname;
	}
	/**
	 * @param drFirstname the drFirstname to set
	 */
	public void setDrFirstname(String drFirstname) {
	    this.drFirstname = drFirstname;
	}
	
	
	/**
	 * @return the drUCMCode
	 */
	@javax.persistence.Column(name = "dr_ucmcode")
	public String getDrUCMCode() {
	    return drUCMCode;
	}
	/**
	 * @param drUCMCode the drUCMCode to set
	 */
	public void setDrUCMCode(String drUCMCode) {
	    this.drUCMCode = drUCMCode;
	}
	
	
	/**
	 * @return the siteName
	 */
	@javax.persistence.Column(name = "site_name")
	public String getSiteName() {
	    return siteName;
	}
	/**
	 * @param siteName the siteName to set
	 */
	public void setSiteName(String siteName) {
	    this.siteName = siteName;
	}
	
	
	/**
	 * @return the siteID
	 */
	@javax.persistence.Column(name = "site_id")
	public Integer getSiteID() {
	    return siteID;
	}
	/**
	 * @param siteID the siteID to set
	 */
	public void setSiteID(Integer siteID) {
	    this.siteID = siteID;
	}

	
	
}
