/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;
// Generated 29.11.2006 13:18:07 by Hibernate Tools 3.1.0.beta5

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@javax.persistence.NamedQueries 
({
@NamedQuery(name = PatientDatas.GET_DATAS_BY_PATIENTID, query = "SELECT OBJECT(o) " +
		"FROM PatientDatas o " +
		"WHERE o.patientId = :patientID " +
		"ORDER BY o.id DESC")
})
/**
 * @author martin.heinemann@tudor.lu
 * 15.01.2008
 * 08:34:09
 *
 *
 * @version
 * <br>$Log: PatientDatas.java,v $
 * <br>Revision 1.5  2013-02-27 08:03:29  ferring
 * <br>Logging and handling of loading and saving PatientDatas improved
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:57:43  heinemann
 * <br>better documentation
 * <br>
 *   
 */
@Entity
@Table(name = "patient_datas", schema = "patient", uniqueConstraints = {})
public class PatientDatas extends GECAMedEntityBean implements java.io.Serializable {

	public static final String GET_DATAS_BY_PATIENTID = "GET_DATAS_BY_PATIENTID";
	private static final long serialVersionUID = 1L;
	private int patientId;
	private String activeProblem;
	private String chronicalTreatments;

	// Constructors

	/** default constructor */
	public PatientDatas() {
	}

	// Property accessors

	@Column(name = "patient_id", unique = true, nullable = false, insertable = true, updatable = true)
	public int getPatientId() {
		return this.patientId;
	}

	public void setPatientId(int patientId) {
		this.patientId = patientId;
	}

	@Column(name = "active_problem", unique = false, nullable = true, insertable = true, updatable = true)
	public String getActiveProblem() {
		return this.activeProblem;
	}

	public void setActiveProblem(String activeProblem) {
		this.activeProblem = activeProblem;
	}

	@Column(name = "chronical_treatments", unique = false, nullable = true, insertable = true, updatable = true)
	public String getChronicalTreatments() {
		return this.chronicalTreatments;
	}

	public void setChronicalTreatments(String chronicalTreatments) {
		this.chronicalTreatments = chronicalTreatments;
	}

}
