/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;

/**
 * Entity Bean that maps the <b>patient.patient_contact</b> table.
 * represents one single contact person with name and address for a patient
 *
 * @version
 * <br>$Log: PatientContact.java,v $
 * <br>Revision 1.7  2010-04-15 12:11:28  hermen
 * <br>now extends GECAMedAddressBean
 * <br>
 * <br>Revision 1.6  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-07-16 09:08:49  hermen
 * <br>modified toString methods
 * <br>
 * <br>Revision 1.3  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllPatientContact",
        query="SELECT OBJECT(o) FROM PatientContact o"),
    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findAllPatientContactByPatientId",
        query="SELECT OBJECT(o) FROM PatientContact o WHERE o.patientId = :patientId")
})

@Entity
@Table(name = "patient_contact", schema = "patient")
public class PatientContact extends GECAMedAddressBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String name;
	private Integer patientId;
	private Integer referedPatientId;
	
	/**
	 * @return Returns the name.
	 */
	@javax.persistence.Column(name = "name")
	public String getName() {
		return name;
	}

	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return Returns the referedPatientId.
	 */
	@javax.persistence.Column(name = "refered_patient_id")
	public Integer getReferedPatientId() {
		return referedPatientId;
	}

	/**
	 * @param referedPatientId The referedPatientId to set.
	 */
	public void setReferedPatientId(Integer referedPatientId) {
		this.referedPatientId = referedPatientId;
	}

	/**
	 * Get the patientId.
	 *
	 * @return The patientId.
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientId() {
		return patientId;
	}

	/**
	 * Set the patientId.
	 *
	 * @param filename The patientId.
	 */
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}

	public String toString() {
		return this.getName() + ": \t" +
			this.getType() + ": \t" +
			super.toString();
	}
	
}
