/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;

/**
 * Entity Bean that maps the <b>patient.patient_address</b> table.
 * represents one single address for a patient
 *
 * @version
 * <br>$Log: PatientAddress.java,v $
 * <br>Revision 1.13  2010-04-27 15:10:00  mack
 * <br>Now inherits also from GECAMedAddressBean
 * <br>
 * <br>Revision 1.12  2010-01-18 10:24:58  hermen
 * <br>removed countrycode from printing address
 * <br>
 * <br>Revision 1.11  2009-06-29 12:43:40  hermen
 * <br>changed getting Zipcode for Printing
 * <br>
 * <br>Revision 1.10  2008-12-18 13:07:11  mack
 * <br>Localities are to be printed in uppercase characters
 * <br>
 * <br>Revision 1.9  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.8  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllPatientAddress",
        query="SELECT OBJECT(o) FROM PatientAddress o"),
    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findAllPatientAddressByPatientId",
        query="SELECT OBJECT(o) FROM PatientAddress o WHERE o.patientId = :patientId")
})

@Entity
@Table(name = "patient_address", schema = "patient")
public class PatientAddress extends GECAMedAddressBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private Integer patientId;

	/**
	 * Get the patientId.
	 *
	 * @return The patientId.
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientId() {
		return patientId;
	}

	/**
	 * Set the patientId.
	 *
	 * @param filename The patientId.
	 */
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public PatientAddress copy() {
		/* ====================================================== */
		PatientAddress p = new PatientAddress();
		p.setCountry(this.getCountry());
		p.setDate(this.getDate());
		p.setLocalityId(this.getLocalityId());
		p.setLocality(this.getLocality());
		p.setStreetName(this.getStreetName());
		p.setStreetNumber(this.getStreetNumber());
		p.setType(this.getType());
		p.setZip(this.getZip());
		
		return p;
		/* ====================================================== */
	}
		
}
