/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * The Insurance class represents the available health insurances.
 * @author nmac
 * @created 06/04/26
 */

@Entity
@Table(name = "insurance_plan", schema = "patient")

@javax.persistence.NamedQueries 
({
@NamedQuery(name = "getAllInsurancePlans", 		query = "SELECT OBJECT(o) FROM InsurancePlan o"),
@NamedQuery(name = "getInsurancePlansByCompany", 	query = "SELECT OBJECT(o) FROM InsurancePlan o WHERE o.company = :companyid")
})

public class InsurancePlan extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private String		m_Name;
	private Insurance	m_Company;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
	
//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * @return Returns the full name of this insurance
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="name")

public String getName() 
	{
	return this.m_Name;
	}

//---------------------------------------------------------------------------
/**
 * Sets the full name of this insurance
 * @param p_Name specifies the new name for this insurance.
 */
//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	this.m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * @return Returns the full name of this insurance
 */
//---------------------------------------------------------------------------

@ManyToOne
@JoinColumn(name="insurance_id")

public Insurance getCompany() 
	{
	return m_Company;
	}

//---------------------------------------------------------------------------
/**
 * Sets the full name of this insurance
 * @param p_Name specifies the new name for this insurance.
 */
//---------------------------------------------------------------------------

public void setCompany (Insurance p_Company) 
	{
	m_Company = p_Company;
	}

//---------------------------------------------------------------------------

public String toString() 
	{
	if (getCompany() != null)
		return getCompany().getAcronym() + 
				(getCompany().getAcronym().equals(getName()) 
				? "" 
				:  "-" + getName());
	else
		return getName ();
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
