/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>patient.hospital_report</b> table
 * and represents a rtf hospital report 
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @version
 * <br>$Log$
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 15:11:43  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
@Entity
@Table(name="hospital_report", schema="patient")
public class HospitalReport  extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private Integer  hospitalPrescriptionID;
	private Date     date;
	private Integer  interpreterID;
	private byte[]   data;

	
	/**
	 * @return the date
	 */
	@Column(name="date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the id of the interpreter (physician)
	 */
	@Column(name="interpreter_id")
	public Integer getInterpreterID() {
		return interpreterID;
	}

	/**
	 * @param interpreter the interpreter to set
	 */
	public void setInterpreterID(Integer interpreterID) {
		this.interpreterID = interpreterID;
	}

	/**
	 * @return Returns the orderID.
	 */
	@Column(name="hospprescription_id")
	public Integer getHospitalPrescriptionID() {
		return this.hospitalPrescriptionID;
	}
	
	/**
	 * @param orderID The orderID to set.
	 */
	public void setHospitalPrescriptionID(Integer hospitalPrescriptionID) {
		this.hospitalPrescriptionID = hospitalPrescriptionID;
	}

	/**
	 * @return the scan
	 */
//	@Lob
	@Basic(fetch=FetchType.LAZY)
	@Column(name="data")
	public byte[] getData() {
		return data;
	}

	/**
	 * @param scan the scan to set
	 */
	public void setData(byte[] scan) {
		this.data = scan;
	}

}
