/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name="hospital_prescription_page", schema="patient")

/**
 * Entity Bean that maps the <b>patient.hospital_prescription_page</b> table 
 * and represents one page of a scanned prescription.
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @version
 * <br>$Log$
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-15 15:11:43  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
public class HospitalPrescriptionPage extends GECAMedEntityBean implements Serializable
{
	private Integer   hospitalPrescriptionId;
	private String    scanNumber;
	private Integer   pageNumber;
	private byte[]	  content;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * @return Returns the ID of the hospital prescription this page belongs to.
	 */
	@Column(name="hospprescription_id")
	public Integer getHospitalPrescriptionId() {
		return this.hospitalPrescriptionId;
	}
	
	/**
	 * @param HospitalPrescriptionId specifies the ID of the hospital prescription this
	 * page belongs to
	 */
	public void setHospitalPrescriptionId(Integer hospitalPrescriptionId) {
		this.hospitalPrescriptionId = hospitalPrescriptionId;
	}

	/**
	 * @return Returns the scan number of this page.
	 */

	@Column(name="scan_number")
	public String getScanNumber() {
		return this.scanNumber;
	}
	
	/**
	 * @param pageNumber specifies the new scan number for this page
	 */

	public void setScanNumber (String scanNumber) {
		this.scanNumber = scanNumber;
	}
	/**
	 * @return Returns the page number of this page.
	 */

	@Column(name="page_number")
	public Integer getPageNumber() {
		return this.pageNumber;
	}
	
	/**
	 * @param pageNumber specifies the new page number for this page
	 */

	public void setPageNumber (Integer pageNumber) {
		this.pageNumber = pageNumber;
	}
	
	/**
	 * @return the (scanned) content of this page
	 */
//	@Lob
	@Basic(fetch=FetchType.LAZY)
	@Column(name="content")
	public byte[] getContent() {
		return content;
	}

	/**
	 * @param content specifies the new (scanned) content for this page
	 */
	public void setContent(byte[] content) {
		this.content = content;
	}
	
	


}
