/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name="hospital_prescription", schema="patient")
@NamedQueries ({
		@NamedQuery(name=HospitalPrescription.GET_BY_HOSPITALISATION_PERIOD,
				query="SELECT OBJECT(o) FROM HospitalPrescription o WHERE o.hospperiodId = :hospperiodId"),
		@NamedQuery(name=HospitalPrescription.GET_BY_ORDER_NUMBER,
				query="SELECT OBJECT(o) FROM HospitalPrescription o WHERE o.orderNumber = :orderNumber")
})

/**
 * Entity Bean that maps the <b>patient.hospital_prescription</b> table 
 * and represents a scanned prescription
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @version
 * <br>$Log$
 * <br>Revision 1.9  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.8  2010-04-27 15:09:04  mack
 * <br>Removed obsolete code
 * <br>
 * <br>Revision 1.7  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-01-15 15:11:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
public class HospitalPrescription  extends GECAMedEntityBean implements Serializable {

	public static final String GET_BY_ORDER_NUMBER 				= "getHospitalPrescriptionsByOrderNumber";
	public static final String GET_BY_HOSPITALISATION_PERIOD 	= "getHospitalPrescriptionsByHospitalisationPeriod";

	public static final String NOT_AVAILABLE					= "n/a";
	
	private static final long serialVersionUID = 1L;

	private Integer   						hospperiodId;
	private String    						orderNumber;
	private Date     						date;
	private Set<HospitalReport> 			reports;
	private Set<HospitalPrescriptionPage>	pages;	
	/**
	 * @return the date
	 */
	@Column(name="date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return Returns the hospperiodID.
	 */
	@Column(name="hospperiod_id")
	public Integer getHospperiodId() {
		return this.hospperiodId;
	}
	
	/**
	 * @param hospperiodID The hospperiodID to set.
	 */
	public void setHospperiodId(Integer hospperiodId) {
		this.hospperiodId = hospperiodId;
	}
		
	/**
	 * @return Returns the reports.
	 */
	@OneToMany(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "hospprescription_id")
	@OrderBy("date DESC")
	public Set<HospitalReport> getReports() {
		return reports;
	}

	/**
	 * @param reports The reports to set.
	 */
	public void setReports(Set<HospitalReport> reports) {
		this.reports = reports;
	}

	/**
	 * @return Returns the prescription pages.
	 */
	@OneToMany(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.LAZY)
	@JoinColumn(name = "hospprescription_id")
	@OrderBy("pageNumber ASC")
	public Set<HospitalPrescriptionPage> getPages() {
		return pages;
	}

	/**
	 * @param reports The reports to set.
	 */
	public void setPages(Set<HospitalPrescriptionPage> pages) {
		this.pages = pages;
	}

	
	
	/**
	 * @return the orderNumber
	 */
	@Column(name="order_number")
	public String getOrderNumber() {
		return orderNumber;
	}

	/**
	 * @param orderNumber the orderNumber to set
	 */
	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}

}
