/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.gui.sitemanagement;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Site;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * JPanel to edit the Site Data
 * parent panel for sites addresses, phones and general data
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: SitePanel.java,v $
 * <br>Revision 1.1  2009-02-11 14:05:53  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 *
 */
public class SitePanel extends GECAMedTab {
	
	private static final long serialVersionUID = 1L;
	
	private SiteGeneralPanel siteGeneralPanel;
	private SiteAddressPanel siteAddressPanel;


	public SitePanel() {
		this.setOpaque(false);
		Translatrix.addBundle("lu.tudor.santec.gecamed.office.gui.resources.WidgetResources");
		this.setTitle(Translatrix.getTranslationString("office.office"));
		this.setIcon(GECAMedModule.getIcon(GECAMedIconNames.OFFICE));
		buildPanel();
	}
	
	/**
     * adds the components to the panel
     */
    private void buildPanel()
    {

        FormLayout layout = new FormLayout("3dlu, fill:pref:grow, 3dlu, pref", "pref, 3dlu, pref, 3dlu");
        CellConstraints cc = new CellConstraints();
	this.setLayout(layout);

	siteGeneralPanel = new SiteGeneralPanel(this);
	this.add(siteGeneralPanel, cc.xy(2,1));
	siteAddressPanel = new SiteAddressPanel(this);
	this.add(siteAddressPanel, cc.xy(2,3));
    }

    
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedTab#preparetoShowup()
	 */
	@Override
	public void preparetoShowup() {
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedTab#preparetoHide()
	 */
	@Override
	public void preparetoHide() {
	}

	public void setSite(Site site) {
	    	this.siteGeneralPanel.setSite(site);
	    	this.siteAddressPanel.setSite(site);
	}

	public void getSite(Site site) {
	        // collect values from panels
	        this.siteGeneralPanel.getData(site);
	        this.siteAddressPanel.getData(site);
	}

	public void setEditable(boolean b) {
		this.siteGeneralPanel.setEnabled(b);
		this.siteAddressPanel.setEnabled(b);
	}

	public void setUnsavedChanges(boolean b) {
	    
	}
	
}
